/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.servlet;

import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.HttpServletContextMap;
import org.springframework.webflow.context.servlet.HttpServletRequestMap;
import org.springframework.webflow.context.servlet.HttpServletRequestParameterMap;
import org.springframework.webflow.context.servlet.HttpSessionMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.LocalParameterMap;
import org.springframework.webflow.core.collection.LocalSharedAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.core.collection.SharedAttributeMap;

public class ServletExternalContext
implements ExternalContext {
    private ServletContext context;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ParameterMap requestParameterMap;
    private MutableAttributeMap requestMap;
    private SharedAttributeMap sessionMap;
    private SharedAttributeMap applicationMap;

    public ServletExternalContext(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        this.context = context;
        this.request = request;
        this.response = response;
        this.requestParameterMap = new LocalParameterMap((Map)((Object)new HttpServletRequestParameterMap(request)));
        this.requestMap = new LocalAttributeMap((Map)((Object)new HttpServletRequestMap(request)));
        this.sessionMap = new LocalSharedAttributeMap(new HttpSessionMap(request));
        this.applicationMap = new LocalSharedAttributeMap(new HttpServletContextMap(context));
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getDispatcherPath() {
        return this.request.getServletPath();
    }

    public String getRequestPathInfo() {
        return this.request.getPathInfo();
    }

    public ParameterMap getRequestParameterMap() {
        return this.requestParameterMap;
    }

    public MutableAttributeMap getRequestMap() {
        return this.requestMap;
    }

    public SharedAttributeMap getSessionMap() {
        return this.sessionMap;
    }

    public SharedAttributeMap getGlobalSessionMap() {
        return this.getSessionMap();
    }

    public SharedAttributeMap getApplicationMap() {
        return this.applicationMap;
    }

    public ServletContext getContext() {
        return this.context;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("requestParameterMap", (Object)this.getRequestParameterMap()).toString();
    }
}

