/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.core;

import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.ParserException;
import org.springframework.binding.expression.SettableExpression;
import org.springframework.webflow.core.WebFlowOgnlExpressionParser;

public final class DefaultExpressionParserFactory {
    private static ExpressionParser INSTANCE;

    private DefaultExpressionParserFactory() {
    }

    public static synchronized ExpressionParser getExpressionParser() {
        return new ExpressionParser(){

            public boolean isDelimitedExpression(String expressionString) {
                return DefaultExpressionParserFactory.getDefaultExpressionParser().isDelimitedExpression(expressionString);
            }

            public Expression parseExpression(String expressionString) throws ParserException {
                return DefaultExpressionParserFactory.getDefaultExpressionParser().parseExpression(expressionString);
            }

            public SettableExpression parseSettableExpression(String expressionString) throws ParserException, UnsupportedOperationException {
                return DefaultExpressionParserFactory.getDefaultExpressionParser().parseSettableExpression(expressionString);
            }
        };
    }

    private static synchronized ExpressionParser getDefaultExpressionParser() {
        if (INSTANCE == null) {
            INSTANCE = DefaultExpressionParserFactory.createDefaultExpressionParser();
        }
        return INSTANCE;
    }

    private static ExpressionParser createDefaultExpressionParser() {
        try {
            Class.forName("ognl.Ognl");
            return new WebFlowOgnlExpressionParser();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load the default expression parser: OGNL could not be found in the classpath.  Please add OGNL 2.x to your classpath or set the default ExpressionParser instance to something that is in the classpath.  Details: " + e.getMessage());
        }
        catch (NoClassDefFoundError e) {
            throw new IllegalStateException("Unable to construct the default expression parser: ognl.Ognl could not be instantiated.  Please add OGNL 2.x to your classpath or set the default ExpressionParser instance to something that is in the classpath.  Details: " + e);
        }
    }
}

