/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.definition.registry;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.core.io.Resource;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.definition.registry.FlowDefinitionHolder;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistrar;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.definition.registry.FlowDefinitionResource;

public abstract class ExternalizedFlowDefinitionRegistrar
implements FlowDefinitionRegistrar {
    private Set locations = new HashSet();
    private Set resources = new HashSet();

    public void setLocations(Resource[] locations) {
        this.locations = new HashSet<Resource>(Arrays.asList(locations));
    }

    public void setResources(FlowDefinitionResource[] resources) {
        this.resources = new HashSet<FlowDefinitionResource>(Arrays.asList(resources));
    }

    public boolean addLocation(Resource location) {
        return this.locations.add(location);
    }

    public boolean addLocations(Resource[] locations) {
        if (locations == null) {
            return false;
        }
        return this.locations.addAll(Arrays.asList(locations));
    }

    public boolean addResource(FlowDefinitionResource resource) {
        return this.resources.add(resource);
    }

    public boolean addResources(FlowDefinitionResource[] resources) {
        if (resources == null) {
            return false;
        }
        return this.resources.addAll(Arrays.asList(resources));
    }

    public void registerFlowDefinitions(FlowDefinitionRegistry registry) {
        this.processLocations(registry);
        this.processResources(registry);
    }

    private void processLocations(FlowDefinitionRegistry registry) {
        Iterator it = this.locations.iterator();
        while (it.hasNext()) {
            Resource location = (Resource)it.next();
            if (!this.isFlowDefinitionResource(location)) continue;
            FlowDefinitionResource resource = this.createFlowDefinitionResource(location);
            this.register(resource, registry);
        }
    }

    private void processResources(FlowDefinitionRegistry registry) {
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            FlowDefinitionResource resource = (FlowDefinitionResource)it.next();
            this.register(resource, registry);
        }
    }

    protected final void register(FlowDefinitionResource resource, FlowDefinitionRegistry registry) {
        registry.registerFlowDefinition(this.createFlowDefinitionHolder(resource));
    }

    protected boolean isFlowDefinitionResource(Resource resource) {
        return true;
    }

    protected FlowDefinitionResource createFlowDefinitionResource(Resource location) {
        return new FlowDefinitionResource(location);
    }

    protected abstract FlowDefinitionHolder createFlowDefinitionHolder(FlowDefinitionResource var1);

    public String toString() {
        return new ToStringCreator((Object)this).append("locations", (Object)this.locations).append("resources", (Object)this.resources).toString();
    }
}

