/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.engine.ActionList;
import org.springframework.webflow.engine.AnnotatedObject;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.FlowExecutionExceptionHandlerSet;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.ViewSelection;

public abstract class State
extends AnnotatedObject
implements StateDefinition {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Flow flow;
    private String id;
    private ActionList entryActionList = new ActionList();
    private FlowExecutionExceptionHandlerSet exceptionHandlerSet = new FlowExecutionExceptionHandlerSet();

    protected State(Flow flow, String id) throws IllegalArgumentException {
        this.setId(id);
        this.setFlow(flow);
    }

    public FlowDefinition getOwner() {
        return this.flow;
    }

    public String getId() {
        return this.id;
    }

    public Flow getFlow() {
        return this.flow;
    }

    private void setFlow(Flow flow) throws IllegalArgumentException {
        Assert.hasText((String)this.getId(), (String)"The id of the state should be set before adding the state to a flow");
        Assert.notNull((Object)flow, (String)"The owning flow is required");
        this.flow = flow;
        flow.add(this);
    }

    private void setId(String id) {
        Assert.hasText((String)id, (String)"This state must have a valid identifier");
        this.id = id;
    }

    public ActionList getEntryActionList() {
        return this.entryActionList;
    }

    public FlowExecutionExceptionHandlerSet getExceptionHandlerSet() {
        return this.exceptionHandlerSet;
    }

    public boolean isStartState() {
        return this.flow.getStartState() == this;
    }

    public boolean equals(Object o) {
        if (!(o instanceof State)) {
            return false;
        }
        State other = (State)o;
        return this.id.equals(other.id) && this.flow.equals(other.flow);
    }

    public int hashCode() {
        return this.id.hashCode() + this.flow.hashCode();
    }

    public final ViewSelection enter(RequestControlContext context) throws FlowExecutionException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entering state '" + this.getId() + "' of flow '" + this.getFlow().getId() + "'"));
        }
        context.setCurrentState(this);
        this.entryActionList.execute(context);
        return this.doEnter(context);
    }

    protected abstract ViewSelection doEnter(RequestControlContext var1) throws FlowExecutionException;

    public ViewSelection handleException(FlowExecutionException exception, RequestControlContext context) {
        return this.getExceptionHandlerSet().handleException(exception, context);
    }

    public String toString() {
        String flowName = this.flow == null ? "<not set>" : this.flow.getId();
        ToStringCreator creator = new ToStringCreator((Object)this).append("id", (Object)this.getId()).append("flow", (Object)flowName).append("entryActionList", (Object)this.entryActionList).append("exceptionHandlerSet", (Object)this.exceptionHandlerSet);
        this.appendToString(creator);
        return creator.toString();
    }

    protected void appendToString(ToStringCreator creator) {
    }
}

