/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder.xml;

import java.util.Stack;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.core.io.ResourceLoader;
import org.springframework.webflow.action.BeanInvokingActionFactory;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.FlowAttributeMapper;
import org.springframework.webflow.engine.FlowExecutionExceptionHandler;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.TransitionCriteria;
import org.springframework.webflow.engine.ViewSelector;
import org.springframework.webflow.engine.builder.FlowArtifactFactory;
import org.springframework.webflow.engine.builder.FlowArtifactLookupException;
import org.springframework.webflow.engine.builder.FlowServiceLocator;
import org.springframework.webflow.engine.builder.xml.LocalFlowServiceRegistry;
import org.springframework.webflow.execution.Action;

class LocalFlowServiceLocator
implements FlowServiceLocator {
    private Stack localRegistries = new Stack();
    private FlowServiceLocator parent;
    static /* synthetic */ Class class$org$springframework$webflow$execution$Action;
    static /* synthetic */ Class class$org$springframework$webflow$engine$FlowAttributeMapper;
    static /* synthetic */ Class class$org$springframework$webflow$engine$TransitionCriteria;
    static /* synthetic */ Class class$org$springframework$webflow$engine$TargetStateResolver;
    static /* synthetic */ Class class$org$springframework$webflow$engine$ViewSelector;
    static /* synthetic */ Class class$org$springframework$webflow$engine$FlowExecutionExceptionHandler;

    public LocalFlowServiceLocator(FlowServiceLocator parent) {
        this.parent = parent;
    }

    public void push(LocalFlowServiceRegistry registry) {
        this.localRegistries.push(registry);
    }

    public void diposeOfAnyRegistries() {
        while (!this.localRegistries.isEmpty()) {
            this.pop();
        }
    }

    public LocalFlowServiceRegistry pop() {
        return (LocalFlowServiceRegistry)this.localRegistries.pop();
    }

    public LocalFlowServiceRegistry top() {
        return (LocalFlowServiceRegistry)this.localRegistries.peek();
    }

    public boolean isEmpty() {
        return this.localRegistries.isEmpty();
    }

    public Flow getSubflow(String id) throws FlowArtifactLookupException {
        Flow currentFlow = this.getCurrentFlow();
        if (currentFlow.getId().equals(id)) {
            return currentFlow;
        }
        if (currentFlow.containsInlineFlow(id)) {
            return currentFlow.getInlineFlow(id);
        }
        return this.parent.getSubflow(id);
    }

    public Action getAction(String id) throws FlowArtifactLookupException {
        if (this.containsBean(id)) {
            return (Action)this.getBean(id, class$org$springframework$webflow$execution$Action == null ? (class$org$springframework$webflow$execution$Action = LocalFlowServiceLocator.class$("org.springframework.webflow.execution.Action")) : class$org$springframework$webflow$execution$Action);
        }
        return this.parent.getAction(id);
    }

    public FlowAttributeMapper getAttributeMapper(String id) throws FlowArtifactLookupException {
        if (this.containsBean(id)) {
            return (FlowAttributeMapper)this.getBean(id, class$org$springframework$webflow$engine$FlowAttributeMapper == null ? (class$org$springframework$webflow$engine$FlowAttributeMapper = LocalFlowServiceLocator.class$("org.springframework.webflow.engine.FlowAttributeMapper")) : class$org$springframework$webflow$engine$FlowAttributeMapper);
        }
        return this.parent.getAttributeMapper(id);
    }

    public TransitionCriteria getTransitionCriteria(String id) throws FlowArtifactLookupException {
        if (this.containsBean(id)) {
            return (TransitionCriteria)this.getBean(id, class$org$springframework$webflow$engine$TransitionCriteria == null ? (class$org$springframework$webflow$engine$TransitionCriteria = LocalFlowServiceLocator.class$("org.springframework.webflow.engine.TransitionCriteria")) : class$org$springframework$webflow$engine$TransitionCriteria);
        }
        return this.parent.getTransitionCriteria(id);
    }

    public TargetStateResolver getTargetStateResolver(String id) throws FlowArtifactLookupException {
        if (this.containsBean(id)) {
            return (TargetStateResolver)this.getBean(id, class$org$springframework$webflow$engine$TargetStateResolver == null ? (class$org$springframework$webflow$engine$TargetStateResolver = LocalFlowServiceLocator.class$("org.springframework.webflow.engine.TargetStateResolver")) : class$org$springframework$webflow$engine$TargetStateResolver);
        }
        return this.parent.getTargetStateResolver(id);
    }

    public ViewSelector getViewSelector(String id) throws FlowArtifactLookupException {
        if (this.containsBean(id)) {
            return (ViewSelector)this.getBean(id, class$org$springframework$webflow$engine$ViewSelector == null ? (class$org$springframework$webflow$engine$ViewSelector = LocalFlowServiceLocator.class$("org.springframework.webflow.engine.ViewSelector")) : class$org$springframework$webflow$engine$ViewSelector);
        }
        return this.parent.getViewSelector(id);
    }

    public FlowExecutionExceptionHandler getExceptionHandler(String id) throws FlowArtifactLookupException {
        if (this.containsBean(id)) {
            return (FlowExecutionExceptionHandler)this.getBean(id, class$org$springframework$webflow$engine$FlowExecutionExceptionHandler == null ? (class$org$springframework$webflow$engine$FlowExecutionExceptionHandler = LocalFlowServiceLocator.class$("org.springframework.webflow.engine.FlowExecutionExceptionHandler")) : class$org$springframework$webflow$engine$FlowExecutionExceptionHandler);
        }
        return this.parent.getExceptionHandler(id);
    }

    public FlowArtifactFactory getFlowArtifactFactory() {
        return this.parent.getFlowArtifactFactory();
    }

    public BeanInvokingActionFactory getBeanInvokingActionFactory() {
        return this.parent.getBeanInvokingActionFactory();
    }

    public BeanFactory getBeanFactory() {
        return this.top().getBeanFactory();
    }

    public ResourceLoader getResourceLoader() {
        return this.parent.getResourceLoader();
    }

    public ExpressionParser getExpressionParser() {
        return this.parent.getExpressionParser();
    }

    public ConversionService getConversionService() {
        return this.parent.getConversionService();
    }

    protected Flow getCurrentFlow() {
        return this.top().getFlow();
    }

    protected boolean containsBean(String id) {
        if (this.localRegistries.isEmpty()) {
            return false;
        }
        return this.getBeanFactory().containsBean(id);
    }

    protected Object getBean(String id, Class artifactType) throws FlowArtifactLookupException {
        try {
            return this.getBeanFactory().getBean(id, artifactType);
        }
        catch (BeansException e) {
            throw new FlowArtifactLookupException(id, artifactType, e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

