/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.support;

import java.lang.reflect.Modifier;
import org.springframework.beans.BeanUtils;
import org.springframework.util.Assert;
import org.springframework.webflow.engine.FlowVariable;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class SimpleFlowVariable
extends FlowVariable {
    private Class variableClass;

    public SimpleFlowVariable(String name, Class variableClass, ScopeType scope) {
        super(name, scope);
        Assert.notNull((Object)variableClass, (String)"The variable class is required");
        Assert.isTrue((!variableClass.isInterface() ? 1 : 0) != 0, (String)"The variable class cannot be an interface");
        Assert.isTrue((!Modifier.isAbstract(variableClass.getModifiers()) ? 1 : 0) != 0, (String)"The variable class cannot be abstract");
        this.variableClass = variableClass;
    }

    public Class getVariableClass() {
        return this.variableClass;
    }

    protected Object createVariableValue(RequestContext context) {
        return BeanUtils.instantiateClass((Class)this.variableClass);
    }
}

