/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution;

import java.util.EventObject;
import org.springframework.util.Assert;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.CollectionUtils;

public class Event
extends EventObject {
    private final String id;
    private final long timestamp = System.currentTimeMillis();
    private final AttributeMap attributes;

    public Event(Object source, String id) {
        this(source, id, null);
    }

    public Event(Object source, String id, AttributeMap attributes) {
        super(source);
        Assert.hasText((String)id, (String)"The event id is required: please set this event's id to a non-blank string identifier");
        this.id = id;
        this.attributes = attributes != null ? attributes : CollectionUtils.EMPTY_ATTRIBUTE_MAP;
    }

    public String getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public AttributeMap getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return this.getId();
    }
}

