/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.jsf;

import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.FlowExecutionAccessException;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionLock;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.executor.jsf.FlowExecutionHolder;
import org.springframework.webflow.executor.jsf.FlowExecutionHolderUtils;
import org.springframework.webflow.executor.jsf.FlowFacesUtils;
import org.springframework.webflow.executor.jsf.JsfExternalContext;

public class FlowExecutionKeyStateHolder
extends UIComponentBase {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String COMPONENT_FAMILY = "javax.faces.Parameter";
    public static final String COMPONENT_ID = "FlowExecutionKeyStateHolder";
    private String flowExecutionKey;
    private boolean transientValue;

    public String getId() {
        return COMPONENT_ID;
    }

    public void setId(String id) {
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public Renderer getRenderer() {
        return null;
    }

    public String getFlowExecutionKey() {
        return this.flowExecutionKey;
    }

    public void setFlowExecutionKey(String flowExecutionKey) {
        this.flowExecutionKey = flowExecutionKey;
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.flowExecutionKey = (String)values[0];
        this.restoreFlowExecution(context);
    }

    private void restoreFlowExecution(FacesContext facesContext) {
        JsfExternalContext context = new JsfExternalContext(facesContext);
        if (StringUtils.hasText((String)this.flowExecutionKey) && !FlowExecutionHolderUtils.isFlowExecutionRestored(facesContext)) {
            FlowExecutionRepository repository = this.getRepository(context);
            FlowExecutionKey key = repository.parseFlowExecutionKey(this.flowExecutionKey);
            try {
                FlowExecutionLock lock = repository.getLock(key);
                lock.lock();
                try {
                    FlowExecution flowExecution = repository.getFlowExecution(key);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Loaded existing flow execution with key '" + this.flowExecutionKey + "' as part of component restoration [triggered via an action event like a button click]"));
                    }
                    FlowExecutionHolderUtils.setFlowExecutionHolder(new FlowExecutionHolder(key, flowExecution, lock), facesContext);
                }
                catch (RuntimeException e) {
                    lock.unlock();
                    throw e;
                }
                catch (Error e) {
                    lock.unlock();
                    throw e;
                }
            }
            catch (FlowExecutionAccessException e) {
                this.handleFlowExecutionAccessException(e, facesContext);
            }
        }
    }

    protected void handleFlowExecutionAccessException(FlowExecutionAccessException e, FacesContext context) {
        throw e;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.flowExecutionKey};
        return values;
    }

    public String getClientId(FacesContext context) {
        return COMPONENT_ID;
    }

    private FlowExecutionRepository getRepository(JsfExternalContext context) {
        return FlowFacesUtils.getExecutionRepository(context.getFacesContext());
    }
}

