/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.ldap;

import java.util.ArrayList;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import org.inspektr.common.ioc.annotation.IsIn;
import org.jasig.cas.adaptors.ldap.AbstractLdapUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;
import org.jasig.cas.util.LdapUtils;
import org.springframework.ldap.core.NameClassPairCallbackHandler;
import org.springframework.ldap.core.SearchExecutor;

public class BindLdapAuthenticationHandler
extends AbstractLdapUsernamePasswordAuthenticationHandler {
    private static final int DEFAULT_MAX_NUMBER_OF_RESULTS = 1000;
    private static final int DEFAULT_TIMEOUT = 1000;
    private String searchBase;
    @IsIn(value={0, 1, 2})
    private int scope = 2;
    private int maxNumberResults = 1000;
    private int timeout = 1000;
    private boolean allowMultipleAccounts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected final boolean authenticateUsernamePasswordInternal(final UsernamePasswordCredentials credentials) throws AuthenticationException {
        final ArrayList cns = new ArrayList();
        final SearchControls searchControls = this.getSearchControls();
        final String base = this.searchBase;
        this.getLdapTemplate().search(new SearchExecutor(){

            public NamingEnumeration executeSearch(DirContext context) throws NamingException {
                return context.search(base, LdapUtils.getFilterWithValues((String)BindLdapAuthenticationHandler.this.getFilter(), (String)credentials.getUsername()), searchControls);
            }
        }, new NameClassPairCallbackHandler(){

            public void handleNameClassPair(NameClassPair nameClassPair) {
                cns.add(nameClassPair.getNameInNamespace());
            }
        });
        if (cns.isEmpty() || cns.size() > 1 && !this.allowMultipleAccounts) {
            System.out.println("List was empty.");
            return false;
        }
        for (String dn : cns) {
            DirContext test;
            block6: {
                boolean bl;
                test = null;
                String finalDn = this.composeCompleteDnToCheck(dn, credentials);
                try {
                    test = this.getContextSource().getContext(finalDn, credentials.getPassword());
                    if (test == null) break block6;
                    bl = true;
                }
                catch (Exception e) {
                    LdapUtils.closeContext(test);
                    continue;
                    catch (Throwable throwable) {
                        LdapUtils.closeContext(test);
                        throw throwable;
                    }
                }
                LdapUtils.closeContext((DirContext)test);
                return bl;
            }
            LdapUtils.closeContext((DirContext)test);
        }
        return false;
    }

    protected String composeCompleteDnToCheck(String dn, UsernamePasswordCredentials credentials) {
        return dn;
    }

    private final SearchControls getSearchControls() {
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(this.scope);
        constraints.setReturningAttributes(new String[0]);
        constraints.setTimeLimit(this.timeout);
        constraints.setCountLimit(this.maxNumberResults);
        return constraints;
    }

    protected boolean isAllowMultipleAccounts() {
        return this.allowMultipleAccounts;
    }

    protected int getMaxNumberResults() {
        return this.maxNumberResults;
    }

    protected int getScope() {
        return this.scope;
    }

    protected String getSearchBase() {
        return this.searchBase;
    }

    protected int getTimeout() {
        return this.timeout;
    }

    public final void setScope(int scope) {
        this.scope = scope;
    }

    public void setAllowMultipleAccounts(boolean allowMultipleAccounts) {
        this.allowMultipleAccounts = allowMultipleAccounts;
    }

    public final void setMaxNumberResults(int maxNumberResults) {
        this.maxNumberResults = maxNumberResults;
    }

    public final void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public final void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

