/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.support;

import org.springframework.binding.convert.ConversionContext;
import org.springframework.binding.convert.ConversionException;
import org.springframework.binding.convert.Converter;

public abstract class AbstractConverter
implements Converter {
    public Object convert(Object source) throws ConversionException {
        return this.convert(source, this.getTargetClasses()[0], null);
    }

    public Object convert(Object source, Class targetClass) throws ConversionException {
        return this.convert(source, targetClass, null);
    }

    public Object convert(Object source, ConversionContext context) throws ConversionException {
        return this.convert(source, this.getTargetClasses()[0], context);
    }

    public Object convert(Object source, Class targetClass, ConversionContext context) throws ConversionException {
        try {
            return this.doConvert(source, targetClass, context);
        }
        catch (ConversionException e) {
            throw e;
        }
        catch (Throwable e) {
            if (targetClass == null) {
                targetClass = this.getTargetClasses()[0];
            }
            throw new ConversionException(source, targetClass, e);
        }
    }

    protected abstract Object doConvert(Object var1, Class var2, ConversionContext var3) throws Exception;
}

