/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang.Validate;
import org.jasig.services.persondir.support.MultivaluedPersonAttributeUtils;
import org.jasig.services.persondir.support.jdbc.AbstractJdbcPersonAttributeDao;
import org.springframework.jdbc.BadSqlGrammarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiRowJdbcPersonAttributeDao
extends AbstractJdbcPersonAttributeDao {
    private Map<String, Set<String>> attributeNameMappings = Collections.emptyMap();
    private Map<String, Set<String>> nameValueColumnMappings = null;
    private Set<String> userAttributes = Collections.emptySet();

    public MultiRowJdbcPersonAttributeDao(DataSource ds, List<String> attrList, String sql) {
        super(ds, sql);
        this.setQueryAttributes(attrList);
    }

    @Override
    protected Map<String, List<Object>> parseAttributeMapFromResults(List<Map<String, Object>> queryResults) {
        HashMap<String, List<Object>> results = new HashMap<String, List<Object>>();
        for (Map<String, Object> rowResult : queryResults) {
            for (Map.Entry<String, Set<String>> columnMapping : this.nameValueColumnMappings.entrySet()) {
                String keyColumn = columnMapping.getKey();
                Object attrNameObj = rowResult.get(keyColumn);
                if (attrNameObj == null && !rowResult.containsKey(keyColumn)) {
                    throw new BadSqlGrammarException("No column named '" + keyColumn + "' exists in result set", this.getSql(), null);
                }
                String attrName = String.valueOf(attrNameObj);
                Set<String> valueColumns = columnMapping.getValue();
                ArrayList<Object> attrValues = new ArrayList<Object>(valueColumns.size());
                for (String valueColumn : valueColumns) {
                    Object attrValue = rowResult.get(valueColumn);
                    if (attrValue == null && !rowResult.containsKey(valueColumn)) {
                        throw new BadSqlGrammarException("No column named '" + valueColumn + "' exists in result set", this.getSql(), null);
                    }
                    attrValues.add(attrValue);
                }
                Set<String> mappedNames = this.attributeNameMappings.get(attrName);
                if (mappedNames == null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Adding un-mapped attribute '" + attrName + "'"));
                    }
                    MultivaluedPersonAttributeUtils.addResult(results, attrName, attrValues);
                    continue;
                }
                for (String portalAttrName : mappedNames) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Adding mapped attribute '" + portalAttrName + "' for source attribute '" + attrName + "'"));
                    }
                    MultivaluedPersonAttributeUtils.addResult(results, portalAttrName, attrValues);
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Returning attribute Map '" + results + "' from query results '" + queryResults + "'"));
        }
        return results;
    }

    public Set<String> getPossibleUserAttributeNames() {
        return this.userAttributes;
    }

    public Map<String, Set<String>> getAttributeNameMappings() {
        return this.attributeNameMappings;
    }

    public void setAttributeNameMappings(Map<String, Object> attributeNameMap) {
        Validate.notNull(attributeNameMap, (String)"columnsToAttributesMap may not be null");
        this.attributeNameMappings = MultivaluedPersonAttributeUtils.parseAttributeToAttributeMapping(attributeNameMap);
        if (this.attributeNameMappings.containsKey("")) {
            throw new IllegalArgumentException("The map from attribute names to attributes must not have any empty keys.");
        }
        Collection userAttributeCol = MultivaluedPersonAttributeUtils.flattenCollection(this.attributeNameMappings.values());
        this.userAttributes = Collections.unmodifiableSet(new HashSet(userAttributeCol));
    }

    public Map<String, Set<String>> getNameValueColumnMappings() {
        return this.nameValueColumnMappings;
    }

    public void setNameValueColumnMappings(Map<String, ? extends Object> nameValueColumnMap) {
        if (nameValueColumnMap == null) {
            this.nameValueColumnMappings = null;
        } else {
            Map<String, Set<String>> mappings = MultivaluedPersonAttributeUtils.parseAttributeToAttributeMapping(nameValueColumnMap);
            if (mappings.containsValue(null)) {
                throw new IllegalArgumentException("nameValueColumnMap may not have null values");
            }
            this.nameValueColumnMappings = mappings;
        }
    }
}

