/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.util.HashMap;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LdapUtils {
    private static final Log logger = LogFactory.getLog(LdapUtils.class);

    private LdapUtils() {
    }

    public static String getFilterWithValues(String filter, String userName) {
        HashMap<String, String> properties = new HashMap<String, String>();
        String newFilter = filter;
        properties.put("%u", userName.replace("\\", "\\\\"));
        String[] userDomain = userName.split("@");
        properties.put("%U", userDomain[0]);
        if (userDomain.length > 1) {
            properties.put("%d", userDomain[1]);
            String[] dcArray = userDomain[1].split("\\.");
            for (int i = 0; i < dcArray.length; ++i) {
                properties.put("%" + (i + 1), dcArray[dcArray.length - 1 - i]);
            }
        }
        for (String key : properties.keySet()) {
            String value = (String)properties.get(key);
            newFilter = newFilter.replaceAll(key, value);
        }
        return newFilter;
    }

    public static void closeContext(DirContext context) {
        if (context != null) {
            try {
                context.close();
            }
            catch (NamingException ex) {
                logger.warn((Object)"Could not close context", (Throwable)ex);
            }
        }
    }
}

