/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import org.inspektr.common.ioc.annotation.NotNull;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.Resource;

public class PublicKeyFactoryBean
extends AbstractFactoryBean {
    @NotNull
    private Resource resource;
    @NotNull
    private String algorithm;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object createInstance() throws Exception {
        InputStream pubKey = this.resource.getInputStream();
        try {
            byte[] bytes = new byte[pubKey.available()];
            pubKey.read(bytes);
            X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(bytes);
            KeyFactory factory = KeyFactory.getInstance(this.algorithm);
            PublicKey publicKey = factory.generatePublic(pubSpec);
            return publicKey;
        }
        finally {
            pubKey.close();
        }
    }

    public Class getObjectType() {
        return PublicKey.class;
    }

    public void setLocation(Resource resource) {
        this.resource = resource;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }
}

