

# This file was autogenerated by some hot garbage in the `uniffi` crate.
# Trust me, you don't want to mess with it!

# Common helper code.
#
# Ideally this would live in a separate .py file where it can be unittested etc
# in isolation, and perhaps even published as a re-useable package.
#
# However, it's important that the details of how this helper code works (e.g. the
# way that different builtin types are passed across the FFI) exactly match what's
# expected by the rust code on the other side of the interface. In practice right
# now that means coming from the exact some version of `uniffi` that was used to
# compile the rust component. The easiest way to ensure this is to bundle the Python
# helpers directly inline like we're doing here.

import os
import sys
import ctypes
import enum
import struct
import contextlib
import datetime
import typing
import platform

# Used for default argument values
_DEFAULT = object()


class _UniffiRustBuffer(ctypes.Structure):
    _fields_ = [
        ("capacity", ctypes.c_int32),
        ("len", ctypes.c_int32),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    @staticmethod
    def alloc(size):
        return _rust_call(_UniffiLib.ffi_lwk_rustbuffer_alloc, size)

    @staticmethod
    def reserve(rbuf, additional):
        return _rust_call(_UniffiLib.ffi_lwk_rustbuffer_reserve, rbuf, additional)

    def free(self):
        return _rust_call(_UniffiLib.ffi_lwk_rustbuffer_free, self)

    def __str__(self):
        return "_UniffiRustBuffer(capacity={}, len={}, data={})".format(
            self.capacity,
            self.len,
            self.data[0:self.len]
        )

    @contextlib.contextmanager
    def alloc_with_builder(*args):
        """Context-manger to allocate a buffer using a _UniffiRustBufferBuilder.

        The allocated buffer will be automatically freed if an error occurs, ensuring that
        we don't accidentally leak it.
        """
        builder = _UniffiRustBufferBuilder()
        try:
            yield builder
        except:
            builder.discard()
            raise

    @contextlib.contextmanager
    def consume_with_stream(self):
        """Context-manager to consume a buffer using a _UniffiRustBufferStream.

        The _UniffiRustBuffer will be freed once the context-manager exits, ensuring that we don't
        leak it even if an error occurs.
        """
        try:
            s = _UniffiRustBufferStream.from_rust_buffer(self)
            yield s
            if s.remaining() != 0:
                raise RuntimeError("junk data left in buffer at end of consume_with_stream")
        finally:
            self.free()

    @contextlib.contextmanager
    def read_with_stream(self):
        """Context-manager to read a buffer using a _UniffiRustBufferStream.

        This is like consume_with_stream, but doesn't free the buffer afterwards.
        It should only be used with borrowed `_UniffiRustBuffer` data.
        """
        s = _UniffiRustBufferStream.from_rust_buffer(self)
        yield s
        if s.remaining() != 0:
            raise RuntimeError("junk data left in buffer at end of read_with_stream")

class _UniffiForeignBytes(ctypes.Structure):
    _fields_ = [
        ("len", ctypes.c_int32),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    def __str__(self):
        return "_UniffiForeignBytes(len={}, data={})".format(self.len, self.data[0:self.len])


class _UniffiRustBufferStream:
    """
    Helper for structured reading of bytes from a _UniffiRustBuffer
    """

    def __init__(self, data, len):
        self.data = data
        self.len = len
        self.offset = 0

    @classmethod
    def from_rust_buffer(cls, buf):
        return cls(buf.data, buf.len)

    def remaining(self):
        return self.len - self.offset

    def _unpack_from(self, size, format):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        value = struct.unpack(format, self.data[self.offset:self.offset+size])[0]
        self.offset += size
        return value

    def read(self, size):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        data = self.data[self.offset:self.offset+size]
        self.offset += size
        return data

    def read_i8(self):
        return self._unpack_from(1, ">b")

    def read_u8(self):
        return self._unpack_from(1, ">B")

    def read_i16(self):
        return self._unpack_from(2, ">h")

    def read_u16(self):
        return self._unpack_from(2, ">H")

    def read_i32(self):
        return self._unpack_from(4, ">i")

    def read_u32(self):
        return self._unpack_from(4, ">I")

    def read_i64(self):
        return self._unpack_from(8, ">q")

    def read_u64(self):
        return self._unpack_from(8, ">Q")

    def read_float(self):
        v = self._unpack_from(4, ">f")
        return v

    def read_double(self):
        return self._unpack_from(8, ">d")

    def read_c_size_t(self):
        return self._unpack_from(ctypes.sizeof(ctypes.c_size_t) , "@N")

class _UniffiRustBufferBuilder:
    """
    Helper for structured writing of bytes into a _UniffiRustBuffer.
    """

    def __init__(self):
        self.rbuf = _UniffiRustBuffer.alloc(16)
        self.rbuf.len = 0

    def finalize(self):
        rbuf = self.rbuf
        self.rbuf = None
        return rbuf

    def discard(self):
        if self.rbuf is not None:
            rbuf = self.finalize()
            rbuf.free()

    @contextlib.contextmanager
    def _reserve(self, num_bytes):
        if self.rbuf.len + num_bytes > self.rbuf.capacity:
            self.rbuf = _UniffiRustBuffer.reserve(self.rbuf, num_bytes)
        yield None
        self.rbuf.len += num_bytes

    def _pack_into(self, size, format, value):
        with self._reserve(size):
            # XXX TODO: I feel like I should be able to use `struct.pack_into` here but can't figure it out.
            for i, byte in enumerate(struct.pack(format, value)):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write(self, value):
        with self._reserve(len(value)):
            for i, byte in enumerate(value):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write_i8(self, v):
        self._pack_into(1, ">b", v)

    def write_u8(self, v):
        self._pack_into(1, ">B", v)

    def write_i16(self, v):
        self._pack_into(2, ">h", v)

    def write_u16(self, v):
        self._pack_into(2, ">H", v)

    def write_i32(self, v):
        self._pack_into(4, ">i", v)

    def write_u32(self, v):
        self._pack_into(4, ">I", v)

    def write_i64(self, v):
        self._pack_into(8, ">q", v)

    def write_u64(self, v):
        self._pack_into(8, ">Q", v)

    def write_float(self, v):
        self._pack_into(4, ">f", v)

    def write_double(self, v):
        self._pack_into(8, ">d", v)

    def write_c_size_t(self, v):
        self._pack_into(ctypes.sizeof(ctypes.c_size_t) , "@N", v)
# A handful of classes and functions to support the generated data structures.
# This would be a good candidate for isolating in its own ffi-support lib.

class InternalError(Exception):
    pass

class _UniffiRustCallStatus(ctypes.Structure):
    """
    Error runtime.
    """
    _fields_ = [
        ("code", ctypes.c_int8),
        ("error_buf", _UniffiRustBuffer),
    ]

    # These match the values from the uniffi::rustcalls module
    CALL_SUCCESS = 0
    CALL_ERROR = 1
    CALL_PANIC = 2

    def __str__(self):
        if self.code == _UniffiRustCallStatus.CALL_SUCCESS:
            return "_UniffiRustCallStatus(CALL_SUCCESS)"
        elif self.code == _UniffiRustCallStatus.CALL_ERROR:
            return "_UniffiRustCallStatus(CALL_ERROR)"
        elif self.code == _UniffiRustCallStatus.CALL_PANIC:
            return "_UniffiRustCallStatus(CALL_PANIC)"
        else:
            return "_UniffiRustCallStatus(<invalid code>)"

def _rust_call(fn, *args):
    # Call a rust function
    return _rust_call_with_error(None, fn, *args)

def _rust_call_with_error(error_ffi_converter, fn, *args):
    # Call a rust function and handle any errors
    #
    # This function is used for rust calls that return Result<> and therefore can set the CALL_ERROR status code.
    # error_ffi_converter must be set to the _UniffiConverter for the error class that corresponds to the result.
    call_status = _UniffiRustCallStatus(code=_UniffiRustCallStatus.CALL_SUCCESS, error_buf=_UniffiRustBuffer(0, 0, None))

    args_with_error = args + (ctypes.byref(call_status),)
    result = fn(*args_with_error)
    _uniffi_check_call_status(error_ffi_converter, call_status)
    return result

def _uniffi_check_call_status(error_ffi_converter, call_status):
    if call_status.code == _UniffiRustCallStatus.CALL_SUCCESS:
        pass
    elif call_status.code == _UniffiRustCallStatus.CALL_ERROR:
        if error_ffi_converter is None:
            call_status.error_buf.free()
            raise InternalError("_rust_call_with_error: CALL_ERROR, but error_ffi_converter is None")
        else:
            raise error_ffi_converter.lift(call_status.error_buf)
    elif call_status.code == _UniffiRustCallStatus.CALL_PANIC:
        # When the rust code sees a panic, it tries to construct a _UniffiRustBuffer
        # with the message.  But if that code panics, then it just sends back
        # an empty buffer.
        if call_status.error_buf.len > 0:
            msg = _UniffiConverterString.lift(call_status.error_buf)
        else:
            msg = "Unknown rust panic"
        raise InternalError(msg)
    else:
        raise InternalError("Invalid _UniffiRustCallStatus code: {}".format(
            call_status.code))

# A function pointer for a callback as defined by UniFFI.
# Rust definition `fn(handle: u64, method: u32, args: _UniffiRustBuffer, buf_ptr: *mut _UniffiRustBuffer) -> int`
_UNIFFI_FOREIGN_CALLBACK_T = ctypes.CFUNCTYPE(ctypes.c_int, ctypes.c_ulonglong, ctypes.c_ulong, ctypes.POINTER(ctypes.c_char), ctypes.c_int, ctypes.POINTER(_UniffiRustBuffer))

# UniFFI future continuation
_UNIFFI_FUTURE_CONTINUATION_T = ctypes.CFUNCTYPE(None, ctypes.c_size_t, ctypes.c_int8)

class _UniffiPointerManagerCPython:
    """
    Manage giving out pointers to Python objects on CPython

    This class is used to generate opaque pointers that reference Python objects to pass to Rust.
    It assumes a CPython platform.  See _UniffiPointerManagerGeneral for the alternative.
    """

    def new_pointer(self, obj):
        """
        Get a pointer for an object as a ctypes.c_size_t instance

        Each call to new_pointer() must be balanced with exactly one call to release_pointer()

        This returns a ctypes.c_size_t.  This is always the same size as a pointer and can be
        interchanged with pointers for FFI function arguments and return values.
        """
        # IncRef the object since we're going to pass a pointer to Rust
        ctypes.pythonapi.Py_IncRef(ctypes.py_object(obj))
        # id() is the object address on CPython
        # (https://docs.python.org/3/library/functions.html#id)
        return id(obj)

    def release_pointer(self, address):
        py_obj = ctypes.cast(address, ctypes.py_object)
        obj = py_obj.value
        ctypes.pythonapi.Py_DecRef(py_obj)
        return obj

    def lookup(self, address):
        return ctypes.cast(address, ctypes.py_object).value

class _UniffiPointerManagerGeneral:
    """
    Manage giving out pointers to Python objects on non-CPython platforms

    This has the same API as _UniffiPointerManagerCPython, but doesn't assume we're running on
    CPython and is slightly slower.

    Instead of using real pointers, it maps integer values to objects and returns the keys as
    c_size_t values.
    """

    def __init__(self):
        self._map = {}
        self._lock = threading.Lock()
        self._current_handle = 0

    def new_pointer(self, obj):
        with self._lock:
            handle = self._current_handle
            self._current_handle += 1
            self._map[handle] = obj
        return handle

    def release_pointer(self, handle):
        with self._lock:
            return self._map.pop(handle)

    def lookup(self, handle):
        with self._lock:
            return self._map[handle]

# Pick an pointer manager implementation based on the platform
if platform.python_implementation() == 'CPython':
    _UniffiPointerManager = _UniffiPointerManagerCPython # type: ignore
else:
    _UniffiPointerManager = _UniffiPointerManagerGeneral # type: ignore
# Types conforming to `_UniffiConverterPrimitive` pass themselves directly over the FFI.
class _UniffiConverterPrimitive:
    @classmethod
    def lift(cls, value):
        return value
 
    @classmethod
    def lower(cls, value):
        return value

class _UniffiConverterPrimitiveInt(_UniffiConverterPrimitive):
    @classmethod
    def check_lower(cls, value):
        try:
            value = value.__index__()
        except Exception:
            raise TypeError("'{}' object cannot be interpreted as an integer".format(type(value).__name__))
        if not isinstance(value, int):
            raise TypeError("__index__ returned non-int (type {})".format(type(value).__name__))
        if not cls.VALUE_MIN <= value < cls.VALUE_MAX:
            raise ValueError("{} requires {} <= value < {}".format(cls.CLASS_NAME, cls.VALUE_MIN, cls.VALUE_MAX))

class _UniffiConverterPrimitiveFloat(_UniffiConverterPrimitive):
    @classmethod
    def check_lower(cls, value):
        try:
            value = value.__float__()
        except Exception:
            raise TypeError("must be real number, not {}".format(type(value).__name__))
        if not isinstance(value, float):
            raise TypeError("__float__ returned non-float (type {})".format(type(value).__name__))

# Helper class for wrapper types that will always go through a _UniffiRustBuffer.
# Classes should inherit from this and implement the `read` and `write` static methods.
class _UniffiConverterRustBuffer:
    @classmethod
    def lift(cls, rbuf):
        with rbuf.consume_with_stream() as stream:
            return cls.read(stream)

    @classmethod
    def lower(cls, value):
        with _UniffiRustBuffer.alloc_with_builder() as builder:
            cls.write(value, builder)
            return builder.finalize()

# Contains loading, initialization code, and the FFI Function declarations.
# Define some ctypes FFI types that we use in the library

"""
Function pointer for a Rust task, which a callback function that takes a opaque pointer
"""
_UNIFFI_RUST_TASK = ctypes.CFUNCTYPE(None, ctypes.c_void_p, ctypes.c_int8)

def _uniffi_future_callback_t(return_type):
    """
    Factory function to create callback function types for async functions
    """
    return ctypes.CFUNCTYPE(None, ctypes.c_size_t, return_type, _UniffiRustCallStatus)

def _uniffi_load_indirect():
    """
    This is how we find and load the dynamic library provided by the component.
    For now we just look it up by name.
    """
    if sys.platform == "darwin":
        libname = "lib{}.dylib"
    elif sys.platform.startswith("win"):
        # As of python3.8, ctypes does not seem to search $PATH when loading DLLs.
        # We could use `os.add_dll_directory` to configure the search path, but
        # it doesn't feel right to mess with application-wide settings. Let's
        # assume that the `.dll` is next to the `.py` file and load by full path.
        libname = os.path.join(
            os.path.dirname(__file__),
            "{}.dll",
        )
    else:
        # Anything else must be an ELF platform - Linux, *BSD, Solaris/illumos
        libname = "lib{}.so"

    libname = libname.format("lwk")
    path = os.path.join(os.path.dirname(__file__), libname)
    lib = ctypes.cdll.LoadLibrary(path)
    return lib

def _uniffi_check_contract_api_version(lib):
    # Get the bindings contract version from our ComponentInterface
    bindings_contract_version = 25
    # Get the scaffolding contract version by calling the into the dylib
    scaffolding_contract_version = lib.ffi_lwk_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version:
        raise InternalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")

def _uniffi_check_api_checksums(lib):
    if lib.uniffi_lwk_checksum_method_address_is_blinded() != 34440:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_address_qr_code_text() != 34918:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_address_qr_code_uri() != 46341:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_address_script_pubkey() != 23569:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_address_to_unconfidential() != 28990:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_addressresult_address() != 57079:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_addressresult_index() != 6170:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_electrumclient_broadcast() != 61535:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_electrumclient_full_scan() != 1491:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_esploraclient_broadcast() != 4633:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_esploraclient_full_scan() != 13126:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_foreignpersister_get() != 22697:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_foreignpersister_push() != 13825:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_network_default_electrum_client() != 57493:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_network_default_esplora_client() != 30029:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_network_is_mainnet() != 38901:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_network_policy_asset() != 61043:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_network_tx_builder() != 62021:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_outpoint_txid() != 59660:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_outpoint_vout() != 56493:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_precision_sats_to_string() != 49608:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_precision_string_to_sats() != 10000:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_pset_extract_tx() != 24108:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_pset_issuance_asset() != 13932:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_pset_issuance_token() != 40519:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_script_asm() != 38627:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_script_bytes() != 31898:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_signer_sign() != 44640:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_signer_wpkh_slip77_descriptor() != 55215:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_testenv_electrum_url() != 37727:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_testenv_generate() != 17157:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_testenv_get_new_address() != 11090:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_testenv_height() != 18988:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_testenv_issue_asset() != 56901:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_testenv_send_to_address() != 49506:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_transaction_bytes() != 35387:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_transaction_fee() != 996:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_transaction_txid() != 8927:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txbuilder_add_burn() != 33429:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txbuilder_add_lbtc_recipient() != 34015:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txbuilder_add_recipient() != 39691:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txbuilder_drain_lbtc_to() != 40857:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txbuilder_drain_lbtc_wallet() != 46356:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txbuilder_fee_rate() != 18798:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txbuilder_finish() != 19714:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txbuilder_issue_asset() != 3477:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txbuilder_reissue_asset() != 36494:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txoutsecrets_asset() != 21742:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txoutsecrets_asset_bf() != 27606:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txoutsecrets_value() != 64117:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txoutsecrets_value_bf() != 4095:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txid_bytes() != 15950:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_update_serialize() != 9990:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettx_balance() != 44398:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettx_fee() != 39011:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettx_height() != 12656:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettx_inputs() != 3951:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettx_outputs() != 55588:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettx_timestamp() != 12633:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettx_tx() != 23689:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettx_txid() != 36652:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettx_type_() != 59416:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettx_unblinded_url() != 31574:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettxout_ext_int() != 60402:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettxout_height() != 50237:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettxout_outpoint() != 58785:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettxout_script_pubkey() != 50610:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettxout_unblinded() != 57421:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettxout_wildcard_index() != 49286:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wollet_address() != 2549:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wollet_apply_update() != 47160:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wollet_balance() != 6265:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wollet_descriptor() != 25068:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wollet_finalize() != 6068:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wollet_transactions() != 35692:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wollet_wait_for_tx() != 43566:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_address_new() != 10931:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_contract_new() != 48870:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_electrumclient_new() != 16620:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_esploraclient_new() != 20614:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_foreignpersisterlink_new() != 3785:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_mnemonic_new() != 22598:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_network_mainnet() != 46013:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_network_regtest() != 26624:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_network_regtest_default() != 22313:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_network_testnet() != 4834:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_outpoint_new() != 63211:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_precision_new() != 30874:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_pset_new() != 11455:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_script_new() != 2756:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_signer_new() != 63885:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_testenv_new() != 1727:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_transaction_new() != 1518:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_txbuilder_new() != 37947:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_txid_new() != 15999:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_update_new() != 14816:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_wollet_new() != 34562:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_wollet_with_custom_persister() != 20113:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_wolletdescriptor_new() != 28418:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")

# A ctypes library to expose the extern-C FFI definitions.
# This is an implementation detail which will be called internally by the public API.

_UniffiLib = _uniffi_load_indirect()
_UniffiLib.uniffi_lwk_fn_clone_address.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_address.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_address.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_address.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_address_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_address_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_address_is_blinded.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_address_is_blinded.restype = ctypes.c_int8
_UniffiLib.uniffi_lwk_fn_method_address_qr_code_text.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_address_qr_code_text.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_address_qr_code_uri.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_address_qr_code_uri.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_address_script_pubkey.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_address_script_pubkey.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_address_to_unconfidential.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_address_to_unconfidential.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_address_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_address_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_addressresult.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_addressresult.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_addressresult.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_addressresult.restype = None
_UniffiLib.uniffi_lwk_fn_method_addressresult_address.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_addressresult_address.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_addressresult_index.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_addressresult_index.restype = ctypes.c_uint32
_UniffiLib.uniffi_lwk_fn_clone_contract.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_contract.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_contract.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_contract.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_contract_new.argtypes = (
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.c_uint8,
    _UniffiRustBuffer,
    ctypes.c_uint8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_contract_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_contract_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_contract_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_electrumclient.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_electrumclient.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_electrumclient.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_electrumclient.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_electrumclient_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.c_int8,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_electrumclient_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_electrumclient_broadcast.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_electrumclient_broadcast.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_electrumclient_full_scan.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_electrumclient_full_scan.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_esploraclient.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_esploraclient.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_esploraclient.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_esploraclient.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_esploraclient_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_esploraclient_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_esploraclient_broadcast.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_esploraclient_broadcast.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_esploraclient_full_scan.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_esploraclient_full_scan.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_foreignpersister.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_foreignpersister.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_foreignpersister.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_foreignpersister.restype = None
_UniffiLib.uniffi_lwk_fn_init_callback_foreignpersister.argtypes = (
    _UNIFFI_FOREIGN_CALLBACK_T,
)
_UniffiLib.uniffi_lwk_fn_init_callback_foreignpersister.restype = None
_UniffiLib.uniffi_lwk_fn_method_foreignpersister_get.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_foreignpersister_get.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_foreignpersister_push.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_foreignpersister_push.restype = None
_UniffiLib.uniffi_lwk_fn_clone_foreignpersisterlink.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_foreignpersisterlink.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_foreignpersisterlink.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_foreignpersisterlink.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_foreignpersisterlink_new.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_foreignpersisterlink_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_clone_mnemonic.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_mnemonic.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_mnemonic.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_mnemonic.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_mnemonic_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_mnemonic_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_mnemonic_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_mnemonic_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_network.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_network.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_network.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_network.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_network_mainnet.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_network_mainnet.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_constructor_network_regtest.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_network_regtest.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_constructor_network_regtest_default.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_network_regtest_default.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_constructor_network_testnet.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_network_testnet.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_network_default_electrum_client.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_network_default_electrum_client.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_network_default_esplora_client.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_network_default_esplora_client.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_network_is_mainnet.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_network_is_mainnet.restype = ctypes.c_int8
_UniffiLib.uniffi_lwk_fn_method_network_policy_asset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_network_policy_asset.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_network_tx_builder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_network_tx_builder.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_network_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_network_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_outpoint.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_outpoint.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_outpoint.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_outpoint.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_outpoint_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_outpoint_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_outpoint_txid.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_outpoint_txid.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_outpoint_vout.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_outpoint_vout.restype = ctypes.c_uint32
_UniffiLib.uniffi_lwk_fn_method_outpoint_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_outpoint_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_precision.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_precision.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_precision.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_precision.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_precision_new.argtypes = (
    ctypes.c_uint8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_precision_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_precision_sats_to_string.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_precision_sats_to_string.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_precision_string_to_sats.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_precision_string_to_sats.restype = ctypes.c_int64
_UniffiLib.uniffi_lwk_fn_clone_pset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_pset.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_pset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_pset.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_pset_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_pset_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_pset_extract_tx.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_pset_extract_tx.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_pset_issuance_asset.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_pset_issuance_asset.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_pset_issuance_token.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_pset_issuance_token.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_pset_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_pset_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_script.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_script.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_script.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_script.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_script_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_script_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_script_asm.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_script_asm.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_script_bytes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_script_bytes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_script_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_script_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_signer.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_signer.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_signer.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_signer.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_signer_new.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_signer_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_signer_sign.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_signer_sign.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_signer_wpkh_slip77_descriptor.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_signer_wpkh_slip77_descriptor.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_clone_testenv.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_testenv.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_testenv.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_testenv.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_testenv_new.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_testenv_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_testenv_electrum_url.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_testenv_electrum_url.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_testenv_generate.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_testenv_generate.restype = None
_UniffiLib.uniffi_lwk_fn_method_testenv_get_new_address.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_testenv_get_new_address.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_testenv_height.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_testenv_height.restype = ctypes.c_uint64
_UniffiLib.uniffi_lwk_fn_method_testenv_issue_asset.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_testenv_issue_asset.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_testenv_send_to_address.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.c_uint64,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_testenv_send_to_address.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_clone_transaction.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_transaction.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_transaction.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_transaction.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_transaction_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_transaction_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_transaction_bytes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_transaction_bytes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_transaction_fee.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_transaction_fee.restype = ctypes.c_uint64
_UniffiLib.uniffi_lwk_fn_method_transaction_txid.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_transaction_txid.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_transaction_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_transaction_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_txbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_txbuilder.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_txbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_txbuilder.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_txbuilder_new.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_txbuilder_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_txbuilder_add_burn.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint64,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txbuilder_add_burn.restype = None
_UniffiLib.uniffi_lwk_fn_method_txbuilder_add_lbtc_recipient.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txbuilder_add_lbtc_recipient.restype = None
_UniffiLib.uniffi_lwk_fn_method_txbuilder_add_recipient.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.c_uint64,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txbuilder_add_recipient.restype = None
_UniffiLib.uniffi_lwk_fn_method_txbuilder_drain_lbtc_to.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txbuilder_drain_lbtc_to.restype = None
_UniffiLib.uniffi_lwk_fn_method_txbuilder_drain_lbtc_wallet.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txbuilder_drain_lbtc_wallet.restype = None
_UniffiLib.uniffi_lwk_fn_method_txbuilder_fee_rate.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txbuilder_fee_rate.restype = None
_UniffiLib.uniffi_lwk_fn_method_txbuilder_finish.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txbuilder_finish.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_txbuilder_issue_asset.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint64,
    _UniffiRustBuffer,
    ctypes.c_uint64,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txbuilder_issue_asset.restype = None
_UniffiLib.uniffi_lwk_fn_method_txbuilder_reissue_asset.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.c_uint64,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txbuilder_reissue_asset.restype = None
_UniffiLib.uniffi_lwk_fn_method_txbuilder_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txbuilder_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_txoutsecrets.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_txoutsecrets.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_txoutsecrets.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_txoutsecrets.restype = None
_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_asset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_asset.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_asset_bf.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_asset_bf.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_value.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_value.restype = ctypes.c_uint64
_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_value_bf.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_value_bf.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_txid.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_txid.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_txid.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_txid.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_txid_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_txid_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_txid_bytes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txid_bytes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_txid_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txid_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_update.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_update.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_update.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_update.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_update_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_update_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_update_serialize.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_update_serialize.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_wallettx.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_wallettx.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_wallettx.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_wallettx.restype = None
_UniffiLib.uniffi_lwk_fn_method_wallettx_balance.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettx_balance.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wallettx_fee.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettx_fee.restype = ctypes.c_uint64
_UniffiLib.uniffi_lwk_fn_method_wallettx_height.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettx_height.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wallettx_inputs.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettx_inputs.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wallettx_outputs.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettx_outputs.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wallettx_timestamp.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettx_timestamp.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wallettx_tx.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettx_tx.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_wallettx_txid.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettx_txid.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_wallettx_type_.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettx_type_.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wallettx_unblinded_url.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettx_unblinded_url.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_wallettxout.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_wallettxout.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_wallettxout.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_wallettxout.restype = None
_UniffiLib.uniffi_lwk_fn_method_wallettxout_ext_int.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettxout_ext_int.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wallettxout_height.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettxout_height.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wallettxout_outpoint.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettxout_outpoint.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_wallettxout_script_pubkey.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettxout_script_pubkey.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_wallettxout_unblinded.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettxout_unblinded.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_wallettxout_wildcard_index.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettxout_wildcard_index.restype = ctypes.c_uint32
_UniffiLib.uniffi_lwk_fn_clone_wollet.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_wollet.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_wollet.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_wollet.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_wollet_new.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_wollet_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_constructor_wollet_with_custom_persister.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_wollet_with_custom_persister.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_wollet_address.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wollet_address.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_wollet_apply_update.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wollet_apply_update.restype = None
_UniffiLib.uniffi_lwk_fn_method_wollet_balance.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wollet_balance.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wollet_descriptor.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wollet_descriptor.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_wollet_finalize.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wollet_finalize.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_wollet_transactions.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wollet_transactions.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wollet_wait_for_tx.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wollet_wait_for_tx.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_clone_wolletdescriptor.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_wolletdescriptor.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_wolletdescriptor.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_wolletdescriptor.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_wolletdescriptor_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_wolletdescriptor_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_wolletdescriptor_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wolletdescriptor_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.ffi_lwk_rustbuffer_alloc.argtypes = (
    ctypes.c_int32,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rustbuffer_alloc.restype = _UniffiRustBuffer
_UniffiLib.ffi_lwk_rustbuffer_from_bytes.argtypes = (
    _UniffiForeignBytes,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rustbuffer_from_bytes.restype = _UniffiRustBuffer
_UniffiLib.ffi_lwk_rustbuffer_free.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rustbuffer_free.restype = None
_UniffiLib.ffi_lwk_rustbuffer_reserve.argtypes = (
    _UniffiRustBuffer,
    ctypes.c_int32,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rustbuffer_reserve.restype = _UniffiRustBuffer
_UniffiLib.ffi_lwk_rust_future_poll_u8.argtypes = (
    ctypes.c_void_p,
    _UNIFFI_FUTURE_CONTINUATION_T,
    ctypes.c_size_t,
)
_UniffiLib.ffi_lwk_rust_future_poll_u8.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_u8.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_cancel_u8.restype = None
_UniffiLib.ffi_lwk_rust_future_free_u8.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_free_u8.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_u8.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_u8.restype = ctypes.c_uint8
_UniffiLib.ffi_lwk_rust_future_poll_i8.argtypes = (
    ctypes.c_void_p,
    _UNIFFI_FUTURE_CONTINUATION_T,
    ctypes.c_size_t,
)
_UniffiLib.ffi_lwk_rust_future_poll_i8.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_i8.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_cancel_i8.restype = None
_UniffiLib.ffi_lwk_rust_future_free_i8.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_free_i8.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_i8.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_i8.restype = ctypes.c_int8
_UniffiLib.ffi_lwk_rust_future_poll_u16.argtypes = (
    ctypes.c_void_p,
    _UNIFFI_FUTURE_CONTINUATION_T,
    ctypes.c_size_t,
)
_UniffiLib.ffi_lwk_rust_future_poll_u16.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_u16.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_cancel_u16.restype = None
_UniffiLib.ffi_lwk_rust_future_free_u16.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_free_u16.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_u16.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_u16.restype = ctypes.c_uint16
_UniffiLib.ffi_lwk_rust_future_poll_i16.argtypes = (
    ctypes.c_void_p,
    _UNIFFI_FUTURE_CONTINUATION_T,
    ctypes.c_size_t,
)
_UniffiLib.ffi_lwk_rust_future_poll_i16.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_i16.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_cancel_i16.restype = None
_UniffiLib.ffi_lwk_rust_future_free_i16.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_free_i16.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_i16.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_i16.restype = ctypes.c_int16
_UniffiLib.ffi_lwk_rust_future_poll_u32.argtypes = (
    ctypes.c_void_p,
    _UNIFFI_FUTURE_CONTINUATION_T,
    ctypes.c_size_t,
)
_UniffiLib.ffi_lwk_rust_future_poll_u32.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_u32.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_cancel_u32.restype = None
_UniffiLib.ffi_lwk_rust_future_free_u32.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_free_u32.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_u32.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_u32.restype = ctypes.c_uint32
_UniffiLib.ffi_lwk_rust_future_poll_i32.argtypes = (
    ctypes.c_void_p,
    _UNIFFI_FUTURE_CONTINUATION_T,
    ctypes.c_size_t,
)
_UniffiLib.ffi_lwk_rust_future_poll_i32.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_i32.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_cancel_i32.restype = None
_UniffiLib.ffi_lwk_rust_future_free_i32.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_free_i32.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_i32.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_i32.restype = ctypes.c_int32
_UniffiLib.ffi_lwk_rust_future_poll_u64.argtypes = (
    ctypes.c_void_p,
    _UNIFFI_FUTURE_CONTINUATION_T,
    ctypes.c_size_t,
)
_UniffiLib.ffi_lwk_rust_future_poll_u64.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_u64.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_cancel_u64.restype = None
_UniffiLib.ffi_lwk_rust_future_free_u64.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_free_u64.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_u64.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_u64.restype = ctypes.c_uint64
_UniffiLib.ffi_lwk_rust_future_poll_i64.argtypes = (
    ctypes.c_void_p,
    _UNIFFI_FUTURE_CONTINUATION_T,
    ctypes.c_size_t,
)
_UniffiLib.ffi_lwk_rust_future_poll_i64.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_i64.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_cancel_i64.restype = None
_UniffiLib.ffi_lwk_rust_future_free_i64.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_free_i64.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_i64.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_i64.restype = ctypes.c_int64
_UniffiLib.ffi_lwk_rust_future_poll_f32.argtypes = (
    ctypes.c_void_p,
    _UNIFFI_FUTURE_CONTINUATION_T,
    ctypes.c_size_t,
)
_UniffiLib.ffi_lwk_rust_future_poll_f32.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_f32.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_cancel_f32.restype = None
_UniffiLib.ffi_lwk_rust_future_free_f32.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_free_f32.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_f32.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_f32.restype = ctypes.c_float
_UniffiLib.ffi_lwk_rust_future_poll_f64.argtypes = (
    ctypes.c_void_p,
    _UNIFFI_FUTURE_CONTINUATION_T,
    ctypes.c_size_t,
)
_UniffiLib.ffi_lwk_rust_future_poll_f64.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_f64.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_cancel_f64.restype = None
_UniffiLib.ffi_lwk_rust_future_free_f64.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_free_f64.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_f64.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_f64.restype = ctypes.c_double
_UniffiLib.ffi_lwk_rust_future_poll_pointer.argtypes = (
    ctypes.c_void_p,
    _UNIFFI_FUTURE_CONTINUATION_T,
    ctypes.c_size_t,
)
_UniffiLib.ffi_lwk_rust_future_poll_pointer.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_pointer.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_cancel_pointer.restype = None
_UniffiLib.ffi_lwk_rust_future_free_pointer.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_free_pointer.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_pointer.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_pointer.restype = ctypes.c_void_p
_UniffiLib.ffi_lwk_rust_future_poll_rust_buffer.argtypes = (
    ctypes.c_void_p,
    _UNIFFI_FUTURE_CONTINUATION_T,
    ctypes.c_size_t,
)
_UniffiLib.ffi_lwk_rust_future_poll_rust_buffer.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_rust_buffer.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_cancel_rust_buffer.restype = None
_UniffiLib.ffi_lwk_rust_future_free_rust_buffer.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_free_rust_buffer.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_rust_buffer.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_rust_buffer.restype = _UniffiRustBuffer
_UniffiLib.ffi_lwk_rust_future_poll_void.argtypes = (
    ctypes.c_void_p,
    _UNIFFI_FUTURE_CONTINUATION_T,
    ctypes.c_size_t,
)
_UniffiLib.ffi_lwk_rust_future_poll_void.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_void.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_cancel_void.restype = None
_UniffiLib.ffi_lwk_rust_future_free_void.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_lwk_rust_future_free_void.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_void.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_void.restype = None
_UniffiLib.uniffi_lwk_checksum_method_address_is_blinded.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_address_is_blinded.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_address_qr_code_text.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_address_qr_code_text.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_address_qr_code_uri.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_address_qr_code_uri.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_address_script_pubkey.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_address_script_pubkey.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_address_to_unconfidential.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_address_to_unconfidential.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_addressresult_address.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_addressresult_address.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_addressresult_index.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_addressresult_index.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_electrumclient_broadcast.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_electrumclient_broadcast.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_electrumclient_full_scan.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_electrumclient_full_scan.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_esploraclient_broadcast.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_esploraclient_broadcast.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_esploraclient_full_scan.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_esploraclient_full_scan.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_foreignpersister_get.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_foreignpersister_get.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_foreignpersister_push.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_foreignpersister_push.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_network_default_electrum_client.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_network_default_electrum_client.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_network_default_esplora_client.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_network_default_esplora_client.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_network_is_mainnet.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_network_is_mainnet.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_network_policy_asset.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_network_policy_asset.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_network_tx_builder.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_network_tx_builder.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_outpoint_txid.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_outpoint_txid.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_outpoint_vout.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_outpoint_vout.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_precision_sats_to_string.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_precision_sats_to_string.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_precision_string_to_sats.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_precision_string_to_sats.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_pset_extract_tx.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_pset_extract_tx.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_pset_issuance_asset.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_pset_issuance_asset.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_pset_issuance_token.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_pset_issuance_token.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_script_asm.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_script_asm.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_script_bytes.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_script_bytes.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_signer_sign.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_signer_sign.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_signer_wpkh_slip77_descriptor.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_signer_wpkh_slip77_descriptor.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_testenv_electrum_url.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_testenv_electrum_url.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_testenv_generate.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_testenv_generate.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_testenv_get_new_address.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_testenv_get_new_address.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_testenv_height.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_testenv_height.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_testenv_issue_asset.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_testenv_issue_asset.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_testenv_send_to_address.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_testenv_send_to_address.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_transaction_bytes.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_transaction_bytes.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_transaction_fee.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_transaction_fee.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_transaction_txid.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_transaction_txid.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_add_burn.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_add_burn.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_add_lbtc_recipient.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_add_lbtc_recipient.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_add_recipient.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_add_recipient.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_drain_lbtc_to.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_drain_lbtc_to.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_drain_lbtc_wallet.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_drain_lbtc_wallet.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_fee_rate.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_fee_rate.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_finish.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_finish.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_issue_asset.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_issue_asset.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_reissue_asset.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_reissue_asset.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txoutsecrets_asset.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txoutsecrets_asset.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txoutsecrets_asset_bf.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txoutsecrets_asset_bf.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txoutsecrets_value.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txoutsecrets_value.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txoutsecrets_value_bf.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txoutsecrets_value_bf.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txid_bytes.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txid_bytes.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_update_serialize.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_update_serialize.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettx_balance.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettx_balance.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettx_fee.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettx_fee.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettx_height.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettx_height.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettx_inputs.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettx_inputs.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettx_outputs.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettx_outputs.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettx_timestamp.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettx_timestamp.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettx_tx.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettx_tx.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettx_txid.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettx_txid.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettx_type_.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettx_type_.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettx_unblinded_url.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettx_unblinded_url.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_ext_int.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_ext_int.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_height.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_height.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_outpoint.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_outpoint.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_script_pubkey.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_script_pubkey.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_unblinded.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_unblinded.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_wildcard_index.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_wildcard_index.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wollet_address.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wollet_address.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wollet_apply_update.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wollet_apply_update.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wollet_balance.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wollet_balance.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wollet_descriptor.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wollet_descriptor.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wollet_finalize.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wollet_finalize.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wollet_transactions.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wollet_transactions.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wollet_wait_for_tx.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wollet_wait_for_tx.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_address_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_address_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_contract_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_contract_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_electrumclient_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_electrumclient_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_esploraclient_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_esploraclient_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_foreignpersisterlink_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_foreignpersisterlink_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_mnemonic_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_mnemonic_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_network_mainnet.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_network_mainnet.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_network_regtest.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_network_regtest.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_network_regtest_default.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_network_regtest_default.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_network_testnet.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_network_testnet.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_outpoint_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_outpoint_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_precision_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_precision_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_pset_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_pset_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_script_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_script_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_signer_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_signer_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_testenv_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_testenv_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_transaction_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_transaction_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_txbuilder_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_txbuilder_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_txid_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_txid_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_update_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_update_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_wollet_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_wollet_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_wollet_with_custom_persister.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_wollet_with_custom_persister.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_wolletdescriptor_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_wolletdescriptor_new.restype = ctypes.c_uint16
_UniffiLib.ffi_lwk_uniffi_contract_version.argtypes = (
)
_UniffiLib.ffi_lwk_uniffi_contract_version.restype = ctypes.c_uint32
_uniffi_check_contract_api_version(_UniffiLib)
_uniffi_check_api_checksums(_UniffiLib)

# Async support

# Public interface members begin here.


class _UniffiConverterUInt8(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u8"
    VALUE_MIN = 0
    VALUE_MAX = 2**8

    @staticmethod
    def read(buf):
        return buf.read_u8()

    @staticmethod
    def write(value, buf):
        buf.write_u8(value)

class _UniffiConverterUInt32(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u32"
    VALUE_MIN = 0
    VALUE_MAX = 2**32

    @staticmethod
    def read(buf):
        return buf.read_u32()

    @staticmethod
    def write(value, buf):
        buf.write_u32(value)

class _UniffiConverterUInt64(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u64"
    VALUE_MIN = 0
    VALUE_MAX = 2**64

    @staticmethod
    def read(buf):
        return buf.read_u64()

    @staticmethod
    def write(value, buf):
        buf.write_u64(value)

class _UniffiConverterInt64(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "i64"
    VALUE_MIN = -2**63
    VALUE_MAX = 2**63

    @staticmethod
    def read(buf):
        return buf.read_i64()

    @staticmethod
    def write(value, buf):
        buf.write_i64(value)

class _UniffiConverterFloat(_UniffiConverterPrimitiveFloat):
    @staticmethod
    def read(buf):
        return buf.read_float()

    @staticmethod
    def write(value, buf):
        buf.write_float(value)

class _UniffiConverterBool:
    @classmethod
    def check_lower(cls, value):
        return not not value

    @classmethod
    def lower(cls, value):
        return 1 if value else 0

    @staticmethod
    def lift(value):
        return value != 0

    @classmethod
    def read(cls, buf):
        return cls.lift(buf.read_u8())

    @classmethod
    def write(cls, value, buf):
        buf.write_u8(value)

class _UniffiConverterString:
    @staticmethod
    def check_lower(value):
        if not isinstance(value, str):
            raise TypeError("argument must be str, not {}".format(type(value).__name__))
        return value

    @staticmethod
    def read(buf):
        size = buf.read_i32()
        if size < 0:
            raise InternalError("Unexpected negative string length")
        utf8_bytes = buf.read(size)
        return utf8_bytes.decode("utf-8")

    @staticmethod
    def write(value, buf):
        utf8_bytes = value.encode("utf-8")
        buf.write_i32(len(utf8_bytes))
        buf.write(utf8_bytes)

    @staticmethod
    def lift(buf):
        with buf.consume_with_stream() as stream:
            return stream.read(stream.remaining()).decode("utf-8")

    @staticmethod
    def lower(value):
        with _UniffiRustBuffer.alloc_with_builder() as builder:
            builder.write(value.encode("utf-8"))
            return builder.finalize()

class _UniffiConverterBytes(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        size = buf.read_i32()
        if size < 0:
            raise InternalError("Unexpected negative byte string length")
        return buf.read(size)

    @staticmethod
    def check_lower(value):
        try:
            memoryview(value)
        except TypeError:
            raise TypeError("a bytes-like object is required, not {!r}".format(type(value).__name__))

    @staticmethod
    def write(value, buf):
        buf.write_i32(len(value))
        buf.write(value)



class AddressProtocol(typing.Protocol):
    def is_blinded(self, ):
        raise NotImplementedError
    def qr_code_text(self, ):
        """
        Returns a string of the QR code printable in a terminal environment
        """

        raise NotImplementedError
    def qr_code_uri(self, pixel_per_module: "typing.Optional[int]"):
        """
        Returns a string encoding an image in a uri

        The string can be open in the browser or be used as `src` field in `img` in HTML

        For max efficiency we suggest to pass `None` to `pixel_per_module`, get a very small image
        and use styling to scale up the image in the browser. eg
        `style="image-rendering: pixelated; border: 20px solid white;"`
        """

        raise NotImplementedError
    def script_pubkey(self, ):
        raise NotImplementedError
    def to_unconfidential(self, ):
        raise NotImplementedError

class Address:

    _pointer: ctypes.c_void_p
    def __init__(self, s: "str"):
        """
        Construct an Address object
        """

        _UniffiConverterString.check_lower(s)
        
        self._pointer = _rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_address_new,
        _UniffiConverterString.lower(s))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_lwk_fn_free_address, pointer)

    def _uniffi_clone_pointer(self):
        return _rust_call(_UniffiLib.uniffi_lwk_fn_clone_address, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def is_blinded(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_address_is_blinded,self._uniffi_clone_pointer(),)
        )






    def qr_code_text(self, ) -> "str":
        """
        Returns a string of the QR code printable in a terminal environment
        """

        return _UniffiConverterString.lift(
            _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_address_qr_code_text,self._uniffi_clone_pointer(),)
        )






    def qr_code_uri(self, pixel_per_module: "typing.Optional[int]") -> "str":
        """
        Returns a string encoding an image in a uri

        The string can be open in the browser or be used as `src` field in `img` in HTML

        For max efficiency we suggest to pass `None` to `pixel_per_module`, get a very small image
        and use styling to scale up the image in the browser. eg
        `style="image-rendering: pixelated; border: 20px solid white;"`
        """

        _UniffiConverterOptionalUInt8.check_lower(pixel_per_module)
        
        return _UniffiConverterString.lift(
            _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_address_qr_code_uri,self._uniffi_clone_pointer(),
        _UniffiConverterOptionalUInt8.lower(pixel_per_module))
        )






    def script_pubkey(self, ) -> "Script":
        return _UniffiConverterTypeScript.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_address_script_pubkey,self._uniffi_clone_pointer(),)
        )






    def to_unconfidential(self, ) -> "Address":
        return _UniffiConverterTypeAddress.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_address_to_unconfidential,self._uniffi_clone_pointer(),)
        )






    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_address_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )





class _UniffiConverterTypeAddress:

    @staticmethod
    def lift(value: int):
        return Address._make_instance_(value)

    @staticmethod
    def check_lower(value: Address):
        if not isinstance(value, Address):
            raise TypeError("Expected Address instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: AddressProtocol):
        if not isinstance(value, Address):
            raise TypeError("Expected Address instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: AddressProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class AddressResultProtocol(typing.Protocol):
    def address(self, ):
        raise NotImplementedError
    def index(self, ):
        raise NotImplementedError

class AddressResult:

    _pointer: ctypes.c_void_p

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_lwk_fn_free_addressresult, pointer)

    def _uniffi_clone_pointer(self):
        return _rust_call(_UniffiLib.uniffi_lwk_fn_clone_addressresult, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def address(self, ) -> "Address":
        return _UniffiConverterTypeAddress.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_addressresult_address,self._uniffi_clone_pointer(),)
        )






    def index(self, ) -> "int":
        return _UniffiConverterUInt32.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_addressresult_index,self._uniffi_clone_pointer(),)
        )





class _UniffiConverterTypeAddressResult:

    @staticmethod
    def lift(value: int):
        return AddressResult._make_instance_(value)

    @staticmethod
    def check_lower(value: AddressResult):
        if not isinstance(value, AddressResult):
            raise TypeError("Expected AddressResult instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: AddressResultProtocol):
        if not isinstance(value, AddressResult):
            raise TypeError("Expected AddressResult instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: AddressResultProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class ContractProtocol(typing.Protocol):
    """
    Wrapper over [`lwk_wollet::Contract`]
    """

    pass

class Contract:
    """
    Wrapper over [`lwk_wollet::Contract`]
    """


    _pointer: ctypes.c_void_p
    def __init__(self, domain: "str",issuer_pubkey: "str",name: "str",precision: "int",ticker: "str",version: "int"):
        """
        Construct a Contract object
        """

        _UniffiConverterString.check_lower(domain)
        
        _UniffiConverterString.check_lower(issuer_pubkey)
        
        _UniffiConverterString.check_lower(name)
        
        _UniffiConverterUInt8.check_lower(precision)
        
        _UniffiConverterString.check_lower(ticker)
        
        _UniffiConverterUInt8.check_lower(version)
        
        self._pointer = _rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_contract_new,
        _UniffiConverterString.lower(domain),
        _UniffiConverterString.lower(issuer_pubkey),
        _UniffiConverterString.lower(name),
        _UniffiConverterUInt8.lower(precision),
        _UniffiConverterString.lower(ticker),
        _UniffiConverterUInt8.lower(version))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_lwk_fn_free_contract, pointer)

    def _uniffi_clone_pointer(self):
        return _rust_call(_UniffiLib.uniffi_lwk_fn_clone_contract, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_contract_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )





class _UniffiConverterTypeContract:

    @staticmethod
    def lift(value: int):
        return Contract._make_instance_(value)

    @staticmethod
    def check_lower(value: Contract):
        if not isinstance(value, Contract):
            raise TypeError("Expected Contract instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: ContractProtocol):
        if not isinstance(value, Contract):
            raise TypeError("Expected Contract instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: ContractProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class ElectrumClientProtocol(typing.Protocol):
    """
    Wrapper over [`lwk_wollet::ElectrumClient`]
    """

    def broadcast(self, tx: "Transaction"):
        raise NotImplementedError
    def full_scan(self, wollet: "Wollet"):
        raise NotImplementedError

class ElectrumClient:
    """
    Wrapper over [`lwk_wollet::ElectrumClient`]
    """


    _pointer: ctypes.c_void_p
    def __init__(self, electrum_url: "str",tls: "bool",validate_domain: "bool"):
        """
        Construct an Electrum client
        """

        _UniffiConverterString.check_lower(electrum_url)
        
        _UniffiConverterBool.check_lower(tls)
        
        _UniffiConverterBool.check_lower(validate_domain)
        
        self._pointer = _rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_electrumclient_new,
        _UniffiConverterString.lower(electrum_url),
        _UniffiConverterBool.lower(tls),
        _UniffiConverterBool.lower(validate_domain))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_lwk_fn_free_electrumclient, pointer)

    def _uniffi_clone_pointer(self):
        return _rust_call(_UniffiLib.uniffi_lwk_fn_clone_electrumclient, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def broadcast(self, tx: "Transaction") -> "Txid":
        _UniffiConverterTypeTransaction.check_lower(tx)
        
        return _UniffiConverterTypeTxid.lift(
            _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_electrumclient_broadcast,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTransaction.lower(tx))
        )






    def full_scan(self, wollet: "Wollet") -> "typing.Optional[Update]":
        _UniffiConverterTypeWollet.check_lower(wollet)
        
        return _UniffiConverterOptionalTypeUpdate.lift(
            _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_electrumclient_full_scan,self._uniffi_clone_pointer(),
        _UniffiConverterTypeWollet.lower(wollet))
        )





class _UniffiConverterTypeElectrumClient:

    @staticmethod
    def lift(value: int):
        return ElectrumClient._make_instance_(value)

    @staticmethod
    def check_lower(value: ElectrumClient):
        if not isinstance(value, ElectrumClient):
            raise TypeError("Expected ElectrumClient instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: ElectrumClientProtocol):
        if not isinstance(value, ElectrumClient):
            raise TypeError("Expected ElectrumClient instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: ElectrumClientProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class EsploraClientProtocol(typing.Protocol):
    """
    Wrapper over [`lwk_wollet::EsploraClient`]
    """

    def broadcast(self, tx: "Transaction"):
        raise NotImplementedError
    def full_scan(self, wollet: "Wollet"):
        raise NotImplementedError

class EsploraClient:
    """
    Wrapper over [`lwk_wollet::EsploraClient`]
    """


    _pointer: ctypes.c_void_p
    def __init__(self, url: "str"):
        """
        Construct an Esplora Client
        """

        _UniffiConverterString.check_lower(url)
        
        self._pointer = _rust_call(_UniffiLib.uniffi_lwk_fn_constructor_esploraclient_new,
        _UniffiConverterString.lower(url))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_lwk_fn_free_esploraclient, pointer)

    def _uniffi_clone_pointer(self):
        return _rust_call(_UniffiLib.uniffi_lwk_fn_clone_esploraclient, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def broadcast(self, tx: "Transaction") -> "Txid":
        _UniffiConverterTypeTransaction.check_lower(tx)
        
        return _UniffiConverterTypeTxid.lift(
            _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_esploraclient_broadcast,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTransaction.lower(tx))
        )






    def full_scan(self, wollet: "Wollet") -> "typing.Optional[Update]":
        _UniffiConverterTypeWollet.check_lower(wollet)
        
        return _UniffiConverterOptionalTypeUpdate.lift(
            _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_esploraclient_full_scan,self._uniffi_clone_pointer(),
        _UniffiConverterTypeWollet.lower(wollet))
        )





class _UniffiConverterTypeEsploraClient:

    @staticmethod
    def lift(value: int):
        return EsploraClient._make_instance_(value)

    @staticmethod
    def check_lower(value: EsploraClient):
        if not isinstance(value, EsploraClient):
            raise TypeError("Expected EsploraClient instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: EsploraClientProtocol):
        if not isinstance(value, EsploraClient):
            raise TypeError("Expected EsploraClient instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: EsploraClientProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class ForeignPersister(typing.Protocol):
    """
    An exported trait, useful for caller-defined persistence.
    """

    def get(self, index: "int"):
        raise NotImplementedError
    def push(self, update: "Update"):
        raise NotImplementedError

class ForeignPersisterImpl:
    """
    An exported trait, useful for caller-defined persistence.
    """


    _pointer: ctypes.c_void_p

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_lwk_fn_free_foreignpersister, pointer)

    def _uniffi_clone_pointer(self):
        return _rust_call(_UniffiLib.uniffi_lwk_fn_clone_foreignpersister, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def get(self, index: "int") -> "typing.Optional[Update]":
        _UniffiConverterUInt64.check_lower(index)
        
        return _UniffiConverterOptionalTypeUpdate.lift(
            _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_foreignpersister_get,self._uniffi_clone_pointer(),
        _UniffiConverterUInt64.lower(index))
        )






    def push(self, update: "Update"):
        _UniffiConverterTypeUpdate.check_lower(update)
        
        _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_foreignpersister_push,self._uniffi_clone_pointer(),
        _UniffiConverterTypeUpdate.lower(update))





import threading

class ConcurrentHandleMap:
    """
    A map where inserting, getting and removing data is synchronized with a lock.
    """

    def __init__(self):
        # type Handle = int
        self._left_map = {}  # type: Dict[Handle, Any]

        self._lock = threading.Lock()
        self._current_handle = 0
        self._stride = 1

    def insert(self, obj):
        with self._lock:
            handle = self._current_handle
            self._current_handle += self._stride
            self._left_map[handle] = obj
            return handle

    def get(self, handle):
        with self._lock:
            obj = self._left_map.get(handle)
        if not obj:
            raise InternalError("No callback in handlemap; this is a uniffi bug")
        return obj

    def remove(self, handle):
        with self._lock:
            if handle in self._left_map:
                obj = self._left_map.pop(handle)
                return obj

# Magic number for the Rust proxy to call using the same mechanism as every other method,
# to free the callback once it's dropped by Rust.
IDX_CALLBACK_FREE = 0
# Return codes for callback calls
_UNIFFI_CALLBACK_SUCCESS = 0
_UNIFFI_CALLBACK_ERROR = 1
_UNIFFI_CALLBACK_UNEXPECTED_ERROR = 2

class UniffiCallbackInterfaceFfiConverter:
    _handle_map = ConcurrentHandleMap()

    @classmethod
    def lift(cls, handle):
        return cls._handle_map.get(handle)

    @classmethod
    def read(cls, buf):
        handle = buf.read_u64()
        cls.lift(handle)

    @classmethod
    def check_lower(cls, cb):
        pass

    @classmethod
    def lower(cls, cb):
        handle = cls._handle_map.insert(cb)
        return handle

    @classmethod
    def write(cls, cb, buf):
        buf.write_u64(cls.lower(cb))

# Declaration and _UniffiConverters for ForeignPersister Callback Interface

def UniffiCallbackInterfaceForeignPersister(handle, method, args_data, args_len, buf_ptr):
    
    def invoke_get(python_callback, args_stream, buf_ptr):
        def makeCall():return python_callback.get(
                _UniffiConverterUInt64.read(args_stream)
                )

        def makeCallAndHandleReturn():
            rval = makeCall()
            with _UniffiRustBuffer.alloc_with_builder() as builder:
                _UniffiConverterOptionalTypeUpdate.write(rval, builder)
                buf_ptr[0] = builder.finalize()
            return _UNIFFI_CALLBACK_SUCCESS
        try:
            return makeCallAndHandleReturn()
        except LwkError as e:
            # Catch errors declared in the UDL file
            with _UniffiRustBuffer.alloc_with_builder() as builder:
                _UniffiConverterTypeLwkError.write(e, builder)
                buf_ptr[0] = builder.finalize()
            return _UNIFFI_CALLBACK_ERROR

    
    def invoke_push(python_callback, args_stream, buf_ptr):
        def makeCall():return python_callback.push(
                _UniffiConverterTypeUpdate.read(args_stream)
                )

        def makeCallAndHandleReturn():
            makeCall()
            return _UNIFFI_CALLBACK_SUCCESS
        try:
            return makeCallAndHandleReturn()
        except LwkError as e:
            # Catch errors declared in the UDL file
            with _UniffiRustBuffer.alloc_with_builder() as builder:
                _UniffiConverterTypeLwkError.write(e, builder)
                buf_ptr[0] = builder.finalize()
            return _UNIFFI_CALLBACK_ERROR

    

    cb = _UniffiConverterTypeForeignPersister._handle_map.get(handle)

    if method == IDX_CALLBACK_FREE:
        _UniffiConverterTypeForeignPersister._handle_map.remove(handle)

        # Successful return
        # See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
        return _UNIFFI_CALLBACK_SUCCESS

    if method == 1:
        # Call the method and handle any errors
        # See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for details
        try:
            return invoke_get(cb, _UniffiRustBufferStream(args_data, args_len), buf_ptr)
        except BaseException as e:
            # Catch unexpected errors
            try:
                # Try to serialize the exception into a String
                buf_ptr[0] = _UniffiConverterString.lower(repr(e))
            except:
                # If that fails, just give up
                pass
            return _UNIFFI_CALLBACK_UNEXPECTED_ERROR
    if method == 2:
        # Call the method and handle any errors
        # See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for details
        try:
            return invoke_push(cb, _UniffiRustBufferStream(args_data, args_len), buf_ptr)
        except BaseException as e:
            # Catch unexpected errors
            try:
                # Try to serialize the exception into a String
                buf_ptr[0] = _UniffiConverterString.lower(repr(e))
            except:
                # If that fails, just give up
                pass
            return _UNIFFI_CALLBACK_UNEXPECTED_ERROR
    

    # This should never happen, because an out of bounds method index won't
    # ever be used. Once we can catch errors, we should return an InternalException.
    # https://github.com/mozilla/uniffi-rs/issues/351

    # An unexpected error happened.
    # See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
    return _UNIFFI_CALLBACK_UNEXPECTED_ERROR

# We need to keep this function reference alive:
# if they get GC'd while in use then UniFFI internals could attempt to call a function
# that is in freed memory.
# That would be...uh...bad. Yeah, that's the word. Bad.
uniffiCallbackInterfaceForeignPersister = _UNIFFI_FOREIGN_CALLBACK_T(UniffiCallbackInterfaceForeignPersister)
_UniffiLib.uniffi_lwk_fn_init_callback_foreignpersister(uniffiCallbackInterfaceForeignPersister)

class _UniffiConverterTypeForeignPersister:
    _handle_map = ConcurrentHandleMap()

    @staticmethod
    def lift(value: int):
        return ForeignPersisterImpl._make_instance_(value)

    @staticmethod
    def check_lower(value: ForeignPersister):
        pass

    @staticmethod
    def lower(value: ForeignPersister):
        return _UniffiConverterTypeForeignPersister._handle_map.insert(value)

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: ForeignPersister, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class ForeignPersisterLinkProtocol(typing.Protocol):
    """
    Implements [`ForeignPersister`]
    """

    pass

class ForeignPersisterLink:
    """
    Implements [`ForeignPersister`]
    """


    _pointer: ctypes.c_void_p
    def __init__(self, persister: "ForeignPersister"):
        _UniffiConverterTypeForeignPersister.check_lower(persister)
        
        self._pointer = _rust_call(_UniffiLib.uniffi_lwk_fn_constructor_foreignpersisterlink_new,
        _UniffiConverterTypeForeignPersister.lower(persister))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_lwk_fn_free_foreignpersisterlink, pointer)

    def _uniffi_clone_pointer(self):
        return _rust_call(_UniffiLib.uniffi_lwk_fn_clone_foreignpersisterlink, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

class _UniffiConverterTypeForeignPersisterLink:

    @staticmethod
    def lift(value: int):
        return ForeignPersisterLink._make_instance_(value)

    @staticmethod
    def check_lower(value: ForeignPersisterLink):
        if not isinstance(value, ForeignPersisterLink):
            raise TypeError("Expected ForeignPersisterLink instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: ForeignPersisterLinkProtocol):
        if not isinstance(value, ForeignPersisterLink):
            raise TypeError("Expected ForeignPersisterLink instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: ForeignPersisterLinkProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class MnemonicProtocol(typing.Protocol):
    """
    Wrapper over [`bip39::Mnemonic`]
    """

    pass

class Mnemonic:
    """
    Wrapper over [`bip39::Mnemonic`]
    """


    _pointer: ctypes.c_void_p
    def __init__(self, s: "str"):
        """
        Construct a Mnemonic type
        """

        _UniffiConverterString.check_lower(s)
        
        self._pointer = _rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_mnemonic_new,
        _UniffiConverterString.lower(s))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_lwk_fn_free_mnemonic, pointer)

    def _uniffi_clone_pointer(self):
        return _rust_call(_UniffiLib.uniffi_lwk_fn_clone_mnemonic, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_mnemonic_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )





class _UniffiConverterTypeMnemonic:

    @staticmethod
    def lift(value: int):
        return Mnemonic._make_instance_(value)

    @staticmethod
    def check_lower(value: Mnemonic):
        if not isinstance(value, Mnemonic):
            raise TypeError("Expected Mnemonic instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: MnemonicProtocol):
        if not isinstance(value, Mnemonic):
            raise TypeError("Expected Mnemonic instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: MnemonicProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class NetworkProtocol(typing.Protocol):
    """
    Wrapper over [`lwk_wollet::ElementsNetwork`]
    """

    def default_electrum_client(self, ):
        raise NotImplementedError
    def default_esplora_client(self, ):
        raise NotImplementedError
    def is_mainnet(self, ):
        raise NotImplementedError
    def policy_asset(self, ):
        raise NotImplementedError
    def tx_builder(self, ):
        raise NotImplementedError

class Network:
    """
    Wrapper over [`lwk_wollet::ElementsNetwork`]
    """


    _pointer: ctypes.c_void_p

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_lwk_fn_free_network, pointer)

    def _uniffi_clone_pointer(self):
        return _rust_call(_UniffiLib.uniffi_lwk_fn_clone_network, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    @classmethod
    def mainnet(cls, ):
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _rust_call(_UniffiLib.uniffi_lwk_fn_constructor_network_mainnet,)
        return cls._make_instance_(pointer)


    @classmethod
    def regtest(cls, policy_asset: "AssetId"):
        _UniffiConverterTypeAssetId.check_lower(policy_asset)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _rust_call(_UniffiLib.uniffi_lwk_fn_constructor_network_regtest,
        _UniffiConverterTypeAssetId.lower(policy_asset))
        return cls._make_instance_(pointer)


    @classmethod
    def regtest_default(cls, ):
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _rust_call(_UniffiLib.uniffi_lwk_fn_constructor_network_regtest_default,)
        return cls._make_instance_(pointer)


    @classmethod
    def testnet(cls, ):
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _rust_call(_UniffiLib.uniffi_lwk_fn_constructor_network_testnet,)
        return cls._make_instance_(pointer)



    def default_electrum_client(self, ) -> "ElectrumClient":
        return _UniffiConverterTypeElectrumClient.lift(
            _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_network_default_electrum_client,self._uniffi_clone_pointer(),)
        )






    def default_esplora_client(self, ) -> "EsploraClient":
        return _UniffiConverterTypeEsploraClient.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_network_default_esplora_client,self._uniffi_clone_pointer(),)
        )






    def is_mainnet(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_network_is_mainnet,self._uniffi_clone_pointer(),)
        )






    def policy_asset(self, ) -> "AssetId":
        return _UniffiConverterTypeAssetId.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_network_policy_asset,self._uniffi_clone_pointer(),)
        )






    def tx_builder(self, ) -> "TxBuilder":
        return _UniffiConverterTypeTxBuilder.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_network_tx_builder,self._uniffi_clone_pointer(),)
        )






    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_network_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )





class _UniffiConverterTypeNetwork:

    @staticmethod
    def lift(value: int):
        return Network._make_instance_(value)

    @staticmethod
    def check_lower(value: Network):
        if not isinstance(value, Network):
            raise TypeError("Expected Network instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: NetworkProtocol):
        if not isinstance(value, Network):
            raise TypeError("Expected Network instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: NetworkProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class OutPointProtocol(typing.Protocol):
    def txid(self, ):
        raise NotImplementedError
    def vout(self, ):
        raise NotImplementedError

class OutPoint:

    _pointer: ctypes.c_void_p
    def __init__(self, s: "str"):
        """
        Construct an OutPoint object
        """

        _UniffiConverterString.check_lower(s)
        
        self._pointer = _rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_outpoint_new,
        _UniffiConverterString.lower(s))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_lwk_fn_free_outpoint, pointer)

    def _uniffi_clone_pointer(self):
        return _rust_call(_UniffiLib.uniffi_lwk_fn_clone_outpoint, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def txid(self, ) -> "Txid":
        return _UniffiConverterTypeTxid.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_outpoint_txid,self._uniffi_clone_pointer(),)
        )






    def vout(self, ) -> "int":
        return _UniffiConverterUInt32.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_outpoint_vout,self._uniffi_clone_pointer(),)
        )






    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_outpoint_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )





class _UniffiConverterTypeOutPoint:

    @staticmethod
    def lift(value: int):
        return OutPoint._make_instance_(value)

    @staticmethod
    def check_lower(value: OutPoint):
        if not isinstance(value, OutPoint):
            raise TypeError("Expected OutPoint instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: OutPointProtocol):
        if not isinstance(value, OutPoint):
            raise TypeError("Expected OutPoint instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: OutPointProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class PrecisionProtocol(typing.Protocol):
    """
    Wrapper over [`lwk_common::Precision`]
    """

    def sats_to_string(self, sats: "int"):
        """
        See [`lwk_common::Precision::sats_to_string`]
        """

        raise NotImplementedError
    def string_to_sats(self, val: "str"):
        """
        See [`lwk_common::Precision::string_to_sats`]
        """

        raise NotImplementedError

class Precision:
    """
    Wrapper over [`lwk_common::Precision`]
    """


    _pointer: ctypes.c_void_p
    def __init__(self, precision: "int"):
        """
        See [`lwk_common::Precision::new`]
        """

        _UniffiConverterUInt8.check_lower(precision)
        
        self._pointer = _rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_precision_new,
        _UniffiConverterUInt8.lower(precision))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_lwk_fn_free_precision, pointer)

    def _uniffi_clone_pointer(self):
        return _rust_call(_UniffiLib.uniffi_lwk_fn_clone_precision, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def sats_to_string(self, sats: "int") -> "str":
        """
        See [`lwk_common::Precision::sats_to_string`]
        """

        _UniffiConverterInt64.check_lower(sats)
        
        return _UniffiConverterString.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_precision_sats_to_string,self._uniffi_clone_pointer(),
        _UniffiConverterInt64.lower(sats))
        )






    def string_to_sats(self, val: "str") -> "int":
        """
        See [`lwk_common::Precision::string_to_sats`]
        """

        _UniffiConverterString.check_lower(val)
        
        return _UniffiConverterInt64.lift(
            _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_precision_string_to_sats,self._uniffi_clone_pointer(),
        _UniffiConverterString.lower(val))
        )





class _UniffiConverterTypePrecision:

    @staticmethod
    def lift(value: int):
        return Precision._make_instance_(value)

    @staticmethod
    def check_lower(value: Precision):
        if not isinstance(value, Precision):
            raise TypeError("Expected Precision instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: PrecisionProtocol):
        if not isinstance(value, Precision):
            raise TypeError("Expected Precision instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: PrecisionProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class PsetProtocol(typing.Protocol):
    """
    Partially Signed Elements Transaction, wrapper over [`elements::pset::PartiallySignedTransaction`]
    """

    def extract_tx(self, ):
        raise NotImplementedError
    def issuance_asset(self, index: "int"):
        raise NotImplementedError
    def issuance_token(self, index: "int"):
        raise NotImplementedError

class Pset:
    """
    Partially Signed Elements Transaction, wrapper over [`elements::pset::PartiallySignedTransaction`]
    """


    _pointer: ctypes.c_void_p
    def __init__(self, base64: "str"):
        """
        Construct a Watch-Only wallet object
        """

        _UniffiConverterString.check_lower(base64)
        
        self._pointer = _rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_pset_new,
        _UniffiConverterString.lower(base64))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_lwk_fn_free_pset, pointer)

    def _uniffi_clone_pointer(self):
        return _rust_call(_UniffiLib.uniffi_lwk_fn_clone_pset, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def extract_tx(self, ) -> "Transaction":
        return _UniffiConverterTypeTransaction.lift(
            _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_pset_extract_tx,self._uniffi_clone_pointer(),)
        )






    def issuance_asset(self, index: "int") -> "typing.Optional[AssetId]":
        _UniffiConverterUInt32.check_lower(index)
        
        return _UniffiConverterOptionalTypeAssetId.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_pset_issuance_asset,self._uniffi_clone_pointer(),
        _UniffiConverterUInt32.lower(index))
        )






    def issuance_token(self, index: "int") -> "typing.Optional[AssetId]":
        _UniffiConverterUInt32.check_lower(index)
        
        return _UniffiConverterOptionalTypeAssetId.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_pset_issuance_token,self._uniffi_clone_pointer(),
        _UniffiConverterUInt32.lower(index))
        )






    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_pset_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )





class _UniffiConverterTypePset:

    @staticmethod
    def lift(value: int):
        return Pset._make_instance_(value)

    @staticmethod
    def check_lower(value: Pset):
        if not isinstance(value, Pset):
            raise TypeError("Expected Pset instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: PsetProtocol):
        if not isinstance(value, Pset):
            raise TypeError("Expected Pset instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: PsetProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class ScriptProtocol(typing.Protocol):
    def asm(self, ):
        raise NotImplementedError
    def bytes(self, ):
        raise NotImplementedError

class Script:

    _pointer: ctypes.c_void_p
    def __init__(self, hex: "Hex"):
        """
        Construct a Script object
        """

        _UniffiConverterTypeHex.check_lower(hex)
        
        self._pointer = _rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_script_new,
        _UniffiConverterTypeHex.lower(hex))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_lwk_fn_free_script, pointer)

    def _uniffi_clone_pointer(self):
        return _rust_call(_UniffiLib.uniffi_lwk_fn_clone_script, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def asm(self, ) -> "str":
        return _UniffiConverterString.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_script_asm,self._uniffi_clone_pointer(),)
        )






    def bytes(self, ) -> "bytes":
        return _UniffiConverterBytes.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_script_bytes,self._uniffi_clone_pointer(),)
        )






    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_script_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )





class _UniffiConverterTypeScript:

    @staticmethod
    def lift(value: int):
        return Script._make_instance_(value)

    @staticmethod
    def check_lower(value: Script):
        if not isinstance(value, Script):
            raise TypeError("Expected Script instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: ScriptProtocol):
        if not isinstance(value, Script):
            raise TypeError("Expected Script instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: ScriptProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class SignerProtocol(typing.Protocol):
    """
    A Software signer, wrapper over [`lwk_signer::SwSigner`]
    """

    def sign(self, pset: "Pset"):
        """
        Sign the given `pset`

        Note from an API perspective it would be better to consume the `pset` parameter so it would
        be clear the signed PSET is the returned one, but it's not possible with uniffi bindings
        """

        raise NotImplementedError
    def wpkh_slip77_descriptor(self, ):
        raise NotImplementedError

class Signer:
    """
    A Software signer, wrapper over [`lwk_signer::SwSigner`]
    """


    _pointer: ctypes.c_void_p
    def __init__(self, mnemonic: "Mnemonic",network: "Network"):
        """
        Construct a software signer
        """

        _UniffiConverterTypeMnemonic.check_lower(mnemonic)
        
        _UniffiConverterTypeNetwork.check_lower(network)
        
        self._pointer = _rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_signer_new,
        _UniffiConverterTypeMnemonic.lower(mnemonic),
        _UniffiConverterTypeNetwork.lower(network))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_lwk_fn_free_signer, pointer)

    def _uniffi_clone_pointer(self):
        return _rust_call(_UniffiLib.uniffi_lwk_fn_clone_signer, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def sign(self, pset: "Pset") -> "Pset":
        """
        Sign the given `pset`

        Note from an API perspective it would be better to consume the `pset` parameter so it would
        be clear the signed PSET is the returned one, but it's not possible with uniffi bindings
        """

        _UniffiConverterTypePset.check_lower(pset)
        
        return _UniffiConverterTypePset.lift(
            _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_signer_sign,self._uniffi_clone_pointer(),
        _UniffiConverterTypePset.lower(pset))
        )






    def wpkh_slip77_descriptor(self, ) -> "WolletDescriptor":
        return _UniffiConverterTypeWolletDescriptor.lift(
            _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_signer_wpkh_slip77_descriptor,self._uniffi_clone_pointer(),)
        )





class _UniffiConverterTypeSigner:

    @staticmethod
    def lift(value: int):
        return Signer._make_instance_(value)

    @staticmethod
    def check_lower(value: Signer):
        if not isinstance(value, Signer):
            raise TypeError("Expected Signer instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: SignerProtocol):
        if not isinstance(value, Signer):
            raise TypeError("Expected Signer instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: SignerProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class TestEnvProtocol(typing.Protocol):
    """
    Represent a test environment with an elements node and an electrum server.
    useful for testing only, wrapper over [`lwk_test_util::TestElectrumServer`]
    """

    def electrum_url(self, ):
        raise NotImplementedError
    def generate(self, blocks: "int"):
        raise NotImplementedError
    def get_new_address(self, ):
        raise NotImplementedError
    def height(self, ):
        raise NotImplementedError
    def issue_asset(self, satoshi: "int"):
        raise NotImplementedError
    def send_to_address(self, address: "Address",satoshi: "int",asset: "typing.Optional[AssetId]"):
        raise NotImplementedError

class TestEnv:
    """
    Represent a test environment with an elements node and an electrum server.
    useful for testing only, wrapper over [`lwk_test_util::TestElectrumServer`]
    """


    _pointer: ctypes.c_void_p
    def __init__(self, ):
        self._pointer = _rust_call(_UniffiLib.uniffi_lwk_fn_constructor_testenv_new,)

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_lwk_fn_free_testenv, pointer)

    def _uniffi_clone_pointer(self):
        return _rust_call(_UniffiLib.uniffi_lwk_fn_clone_testenv, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def electrum_url(self, ) -> "str":
        return _UniffiConverterString.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_testenv_electrum_url,self._uniffi_clone_pointer(),)
        )






    def generate(self, blocks: "int"):
        _UniffiConverterUInt32.check_lower(blocks)
        
        _rust_call(_UniffiLib.uniffi_lwk_fn_method_testenv_generate,self._uniffi_clone_pointer(),
        _UniffiConverterUInt32.lower(blocks))







    def get_new_address(self, ) -> "Address":
        return _UniffiConverterTypeAddress.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_testenv_get_new_address,self._uniffi_clone_pointer(),)
        )






    def height(self, ) -> "int":
        return _UniffiConverterUInt64.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_testenv_height,self._uniffi_clone_pointer(),)
        )






    def issue_asset(self, satoshi: "int") -> "AssetId":
        _UniffiConverterUInt64.check_lower(satoshi)
        
        return _UniffiConverterTypeAssetId.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_testenv_issue_asset,self._uniffi_clone_pointer(),
        _UniffiConverterUInt64.lower(satoshi))
        )






    def send_to_address(self, address: "Address",satoshi: "int",asset: "typing.Optional[AssetId]") -> "Txid":
        _UniffiConverterTypeAddress.check_lower(address)
        
        _UniffiConverterUInt64.check_lower(satoshi)
        
        _UniffiConverterOptionalTypeAssetId.check_lower(asset)
        
        return _UniffiConverterTypeTxid.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_testenv_send_to_address,self._uniffi_clone_pointer(),
        _UniffiConverterTypeAddress.lower(address),
        _UniffiConverterUInt64.lower(satoshi),
        _UniffiConverterOptionalTypeAssetId.lower(asset))
        )





class _UniffiConverterTypeTestEnv:

    @staticmethod
    def lift(value: int):
        return TestEnv._make_instance_(value)

    @staticmethod
    def check_lower(value: TestEnv):
        if not isinstance(value, TestEnv):
            raise TypeError("Expected TestEnv instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: TestEnvProtocol):
        if not isinstance(value, TestEnv):
            raise TypeError("Expected TestEnv instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: TestEnvProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class TransactionProtocol(typing.Protocol):
    def bytes(self, ):
        raise NotImplementedError
    def fee(self, policy_asset: "AssetId"):
        raise NotImplementedError
    def txid(self, ):
        raise NotImplementedError

class Transaction:

    _pointer: ctypes.c_void_p
    def __init__(self, hex: "Hex"):
        """
        Construct a Transaction object
        """

        _UniffiConverterTypeHex.check_lower(hex)
        
        self._pointer = _rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_transaction_new,
        _UniffiConverterTypeHex.lower(hex))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_lwk_fn_free_transaction, pointer)

    def _uniffi_clone_pointer(self):
        return _rust_call(_UniffiLib.uniffi_lwk_fn_clone_transaction, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def bytes(self, ) -> "bytes":
        return _UniffiConverterBytes.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_transaction_bytes,self._uniffi_clone_pointer(),)
        )






    def fee(self, policy_asset: "AssetId") -> "int":
        _UniffiConverterTypeAssetId.check_lower(policy_asset)
        
        return _UniffiConverterUInt64.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_transaction_fee,self._uniffi_clone_pointer(),
        _UniffiConverterTypeAssetId.lower(policy_asset))
        )






    def txid(self, ) -> "Txid":
        return _UniffiConverterTypeTxid.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_transaction_txid,self._uniffi_clone_pointer(),)
        )






    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_transaction_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )





class _UniffiConverterTypeTransaction:

    @staticmethod
    def lift(value: int):
        return Transaction._make_instance_(value)

    @staticmethod
    def check_lower(value: Transaction):
        if not isinstance(value, Transaction):
            raise TypeError("Expected Transaction instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: TransactionProtocol):
        if not isinstance(value, Transaction):
            raise TypeError("Expected Transaction instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: TransactionProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class TxBuilderProtocol(typing.Protocol):
    """
    Wrapper over [`lwk_wollet::TxBuilder`]
    """

    def add_burn(self, satoshi: "int",asset: "AssetId"):
        """
        Burn satoshi units of the given asset
        """

        raise NotImplementedError
    def add_lbtc_recipient(self, address: "Address",satoshi: "int"):
        """
        Add a recipient receiving L-BTC
        """

        raise NotImplementedError
    def add_recipient(self, address: "Address",satoshi: "int",asset: "AssetId"):
        """
        Add a recipient receiving the given asset
        """

        raise NotImplementedError
    def drain_lbtc_to(self, address: "Address"):
        """
        Sets the address to drain excess L-BTC to
        """

        raise NotImplementedError
    def drain_lbtc_wallet(self, ):
        """
        Select all available L-BTC inputs
        """

        raise NotImplementedError
    def fee_rate(self, rate: "typing.Optional[float]"):
        """
        Set the fee rate
        """

        raise NotImplementedError
    def finish(self, wollet: "Wollet"):
        """
        Build the transaction
        """

        raise NotImplementedError
    def issue_asset(self, asset_sats: "int",asset_receiver: "typing.Optional[Address]",token_sats: "int",token_receiver: "typing.Optional[Address]",contract: "typing.Optional[Contract]"):
        """
        Issue an asset, wrapper of [`lwk_wollet::TxBuilder::issue_asset()`]
        """

        raise NotImplementedError
    def reissue_asset(self, asset_to_reissue: "AssetId",satoshi_to_reissue: "int",asset_receiver: "typing.Optional[Address]",issuance_tx: "typing.Optional[Transaction]"):
        """
        Reissue an asset, wrapper of [`lwk_wollet::TxBuilder::reissue_asset()`]
        """

        raise NotImplementedError

class TxBuilder:
    """
    Wrapper over [`lwk_wollet::TxBuilder`]
    """


    _pointer: ctypes.c_void_p
    def __init__(self, network: "Network"):
        """
        Construct a transaction builder
        """

        _UniffiConverterTypeNetwork.check_lower(network)
        
        self._pointer = _rust_call(_UniffiLib.uniffi_lwk_fn_constructor_txbuilder_new,
        _UniffiConverterTypeNetwork.lower(network))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_lwk_fn_free_txbuilder, pointer)

    def _uniffi_clone_pointer(self):
        return _rust_call(_UniffiLib.uniffi_lwk_fn_clone_txbuilder, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def add_burn(self, satoshi: "int",asset: "AssetId"):
        """
        Burn satoshi units of the given asset
        """

        _UniffiConverterUInt64.check_lower(satoshi)
        
        _UniffiConverterTypeAssetId.check_lower(asset)
        
        _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_txbuilder_add_burn,self._uniffi_clone_pointer(),
        _UniffiConverterUInt64.lower(satoshi),
        _UniffiConverterTypeAssetId.lower(asset))







    def add_lbtc_recipient(self, address: "Address",satoshi: "int"):
        """
        Add a recipient receiving L-BTC
        """

        _UniffiConverterTypeAddress.check_lower(address)
        
        _UniffiConverterUInt64.check_lower(satoshi)
        
        _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_txbuilder_add_lbtc_recipient,self._uniffi_clone_pointer(),
        _UniffiConverterTypeAddress.lower(address),
        _UniffiConverterUInt64.lower(satoshi))







    def add_recipient(self, address: "Address",satoshi: "int",asset: "AssetId"):
        """
        Add a recipient receiving the given asset
        """

        _UniffiConverterTypeAddress.check_lower(address)
        
        _UniffiConverterUInt64.check_lower(satoshi)
        
        _UniffiConverterTypeAssetId.check_lower(asset)
        
        _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_txbuilder_add_recipient,self._uniffi_clone_pointer(),
        _UniffiConverterTypeAddress.lower(address),
        _UniffiConverterUInt64.lower(satoshi),
        _UniffiConverterTypeAssetId.lower(asset))







    def drain_lbtc_to(self, address: "Address"):
        """
        Sets the address to drain excess L-BTC to
        """

        _UniffiConverterTypeAddress.check_lower(address)
        
        _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_txbuilder_drain_lbtc_to,self._uniffi_clone_pointer(),
        _UniffiConverterTypeAddress.lower(address))







    def drain_lbtc_wallet(self, ):
        """
        Select all available L-BTC inputs
        """

        _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_txbuilder_drain_lbtc_wallet,self._uniffi_clone_pointer(),)







    def fee_rate(self, rate: "typing.Optional[float]"):
        """
        Set the fee rate
        """

        _UniffiConverterOptionalFloat.check_lower(rate)
        
        _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_txbuilder_fee_rate,self._uniffi_clone_pointer(),
        _UniffiConverterOptionalFloat.lower(rate))







    def finish(self, wollet: "Wollet") -> "Pset":
        """
        Build the transaction
        """

        _UniffiConverterTypeWollet.check_lower(wollet)
        
        return _UniffiConverterTypePset.lift(
            _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_txbuilder_finish,self._uniffi_clone_pointer(),
        _UniffiConverterTypeWollet.lower(wollet))
        )






    def issue_asset(self, asset_sats: "int",asset_receiver: "typing.Optional[Address]",token_sats: "int",token_receiver: "typing.Optional[Address]",contract: "typing.Optional[Contract]"):
        """
        Issue an asset, wrapper of [`lwk_wollet::TxBuilder::issue_asset()`]
        """

        _UniffiConverterUInt64.check_lower(asset_sats)
        
        _UniffiConverterOptionalTypeAddress.check_lower(asset_receiver)
        
        _UniffiConverterUInt64.check_lower(token_sats)
        
        _UniffiConverterOptionalTypeAddress.check_lower(token_receiver)
        
        _UniffiConverterOptionalTypeContract.check_lower(contract)
        
        _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_txbuilder_issue_asset,self._uniffi_clone_pointer(),
        _UniffiConverterUInt64.lower(asset_sats),
        _UniffiConverterOptionalTypeAddress.lower(asset_receiver),
        _UniffiConverterUInt64.lower(token_sats),
        _UniffiConverterOptionalTypeAddress.lower(token_receiver),
        _UniffiConverterOptionalTypeContract.lower(contract))







    def reissue_asset(self, asset_to_reissue: "AssetId",satoshi_to_reissue: "int",asset_receiver: "typing.Optional[Address]",issuance_tx: "typing.Optional[Transaction]"):
        """
        Reissue an asset, wrapper of [`lwk_wollet::TxBuilder::reissue_asset()`]
        """

        _UniffiConverterTypeAssetId.check_lower(asset_to_reissue)
        
        _UniffiConverterUInt64.check_lower(satoshi_to_reissue)
        
        _UniffiConverterOptionalTypeAddress.check_lower(asset_receiver)
        
        _UniffiConverterOptionalTypeTransaction.check_lower(issuance_tx)
        
        _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_txbuilder_reissue_asset,self._uniffi_clone_pointer(),
        _UniffiConverterTypeAssetId.lower(asset_to_reissue),
        _UniffiConverterUInt64.lower(satoshi_to_reissue),
        _UniffiConverterOptionalTypeAddress.lower(asset_receiver),
        _UniffiConverterOptionalTypeTransaction.lower(issuance_tx))







    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_txbuilder_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )





class _UniffiConverterTypeTxBuilder:

    @staticmethod
    def lift(value: int):
        return TxBuilder._make_instance_(value)

    @staticmethod
    def check_lower(value: TxBuilder):
        if not isinstance(value, TxBuilder):
            raise TypeError("Expected TxBuilder instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: TxBuilderProtocol):
        if not isinstance(value, TxBuilder):
            raise TypeError("Expected TxBuilder instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: TxBuilderProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class TxOutSecretsProtocol(typing.Protocol):
    def asset(self, ):
        raise NotImplementedError
    def asset_bf(self, ):
        raise NotImplementedError
    def value(self, ):
        raise NotImplementedError
    def value_bf(self, ):
        raise NotImplementedError

class TxOutSecrets:

    _pointer: ctypes.c_void_p

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_lwk_fn_free_txoutsecrets, pointer)

    def _uniffi_clone_pointer(self):
        return _rust_call(_UniffiLib.uniffi_lwk_fn_clone_txoutsecrets, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def asset(self, ) -> "AssetId":
        return _UniffiConverterTypeAssetId.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_asset,self._uniffi_clone_pointer(),)
        )






    def asset_bf(self, ) -> "Hex":
        return _UniffiConverterTypeHex.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_asset_bf,self._uniffi_clone_pointer(),)
        )






    def value(self, ) -> "int":
        return _UniffiConverterUInt64.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_value,self._uniffi_clone_pointer(),)
        )






    def value_bf(self, ) -> "Hex":
        return _UniffiConverterTypeHex.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_value_bf,self._uniffi_clone_pointer(),)
        )





class _UniffiConverterTypeTxOutSecrets:

    @staticmethod
    def lift(value: int):
        return TxOutSecrets._make_instance_(value)

    @staticmethod
    def check_lower(value: TxOutSecrets):
        if not isinstance(value, TxOutSecrets):
            raise TypeError("Expected TxOutSecrets instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: TxOutSecretsProtocol):
        if not isinstance(value, TxOutSecrets):
            raise TypeError("Expected TxOutSecrets instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: TxOutSecretsProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class TxidProtocol(typing.Protocol):
    def bytes(self, ):
        raise NotImplementedError

class Txid:

    _pointer: ctypes.c_void_p
    def __init__(self, hex: "Hex"):
        """
        Construct a Txid object
        """

        _UniffiConverterTypeHex.check_lower(hex)
        
        self._pointer = _rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_txid_new,
        _UniffiConverterTypeHex.lower(hex))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_lwk_fn_free_txid, pointer)

    def _uniffi_clone_pointer(self):
        return _rust_call(_UniffiLib.uniffi_lwk_fn_clone_txid, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def bytes(self, ) -> "bytes":
        return _UniffiConverterBytes.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_txid_bytes,self._uniffi_clone_pointer(),)
        )






    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_txid_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )





class _UniffiConverterTypeTxid:

    @staticmethod
    def lift(value: int):
        return Txid._make_instance_(value)

    @staticmethod
    def check_lower(value: Txid):
        if not isinstance(value, Txid):
            raise TypeError("Expected Txid instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: TxidProtocol):
        if not isinstance(value, Txid):
            raise TypeError("Expected Txid instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: TxidProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class UpdateProtocol(typing.Protocol):
    """
    Wrapper over [`lwk_wollet::Update`]
    """

    def serialize(self, ):
        raise NotImplementedError

class Update:
    """
    Wrapper over [`lwk_wollet::Update`]
    """


    _pointer: ctypes.c_void_p
    def __init__(self, bytes: "bytes"):
        _UniffiConverterBytes.check_lower(bytes)
        
        self._pointer = _rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_update_new,
        _UniffiConverterBytes.lower(bytes))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_lwk_fn_free_update, pointer)

    def _uniffi_clone_pointer(self):
        return _rust_call(_UniffiLib.uniffi_lwk_fn_clone_update, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def serialize(self, ) -> "bytes":
        return _UniffiConverterBytes.lift(
            _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_update_serialize,self._uniffi_clone_pointer(),)
        )





class _UniffiConverterTypeUpdate:

    @staticmethod
    def lift(value: int):
        return Update._make_instance_(value)

    @staticmethod
    def check_lower(value: Update):
        if not isinstance(value, Update):
            raise TypeError("Expected Update instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: UpdateProtocol):
        if not isinstance(value, Update):
            raise TypeError("Expected Update instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: UpdateProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class WalletTxProtocol(typing.Protocol):
    def balance(self, ):
        raise NotImplementedError
    def fee(self, ):
        raise NotImplementedError
    def height(self, ):
        raise NotImplementedError
    def inputs(self, ):
        raise NotImplementedError
    def outputs(self, ):
        raise NotImplementedError
    def timestamp(self, ):
        raise NotImplementedError
    def tx(self, ):
        raise NotImplementedError
    def txid(self, ):
        raise NotImplementedError
    def type(self, ):
        raise NotImplementedError
    def unblinded_url(self, explorer_url: "str"):
        raise NotImplementedError

class WalletTx:

    _pointer: ctypes.c_void_p

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_lwk_fn_free_wallettx, pointer)

    def _uniffi_clone_pointer(self):
        return _rust_call(_UniffiLib.uniffi_lwk_fn_clone_wallettx, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def balance(self, ) -> "dict":
        return _UniffiConverterMapTypeAssetIdInt64.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettx_balance,self._uniffi_clone_pointer(),)
        )






    def fee(self, ) -> "int":
        return _UniffiConverterUInt64.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettx_fee,self._uniffi_clone_pointer(),)
        )






    def height(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalUInt32.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettx_height,self._uniffi_clone_pointer(),)
        )






    def inputs(self, ) -> "typing.List[typing.Optional[WalletTxOut]]":
        return _UniffiConverterSequenceOptionalTypeWalletTxOut.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettx_inputs,self._uniffi_clone_pointer(),)
        )






    def outputs(self, ) -> "typing.List[typing.Optional[WalletTxOut]]":
        return _UniffiConverterSequenceOptionalTypeWalletTxOut.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettx_outputs,self._uniffi_clone_pointer(),)
        )






    def timestamp(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalUInt32.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettx_timestamp,self._uniffi_clone_pointer(),)
        )






    def tx(self, ) -> "Transaction":
        return _UniffiConverterTypeTransaction.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettx_tx,self._uniffi_clone_pointer(),)
        )






    def txid(self, ) -> "Txid":
        return _UniffiConverterTypeTxid.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettx_txid,self._uniffi_clone_pointer(),)
        )






    def type(self, ) -> "str":
        return _UniffiConverterString.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettx_type_,self._uniffi_clone_pointer(),)
        )






    def unblinded_url(self, explorer_url: "str") -> "str":
        _UniffiConverterString.check_lower(explorer_url)
        
        return _UniffiConverterString.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettx_unblinded_url,self._uniffi_clone_pointer(),
        _UniffiConverterString.lower(explorer_url))
        )





class _UniffiConverterTypeWalletTx:

    @staticmethod
    def lift(value: int):
        return WalletTx._make_instance_(value)

    @staticmethod
    def check_lower(value: WalletTx):
        if not isinstance(value, WalletTx):
            raise TypeError("Expected WalletTx instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: WalletTxProtocol):
        if not isinstance(value, WalletTx):
            raise TypeError("Expected WalletTx instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: WalletTxProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class WalletTxOutProtocol(typing.Protocol):
    def ext_int(self, ):
        raise NotImplementedError
    def height(self, ):
        raise NotImplementedError
    def outpoint(self, ):
        raise NotImplementedError
    def script_pubkey(self, ):
        raise NotImplementedError
    def unblinded(self, ):
        raise NotImplementedError
    def wildcard_index(self, ):
        raise NotImplementedError

class WalletTxOut:

    _pointer: ctypes.c_void_p

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_lwk_fn_free_wallettxout, pointer)

    def _uniffi_clone_pointer(self):
        return _rust_call(_UniffiLib.uniffi_lwk_fn_clone_wallettxout, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def ext_int(self, ) -> "Chain":
        return _UniffiConverterTypeChain.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettxout_ext_int,self._uniffi_clone_pointer(),)
        )






    def height(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalUInt32.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettxout_height,self._uniffi_clone_pointer(),)
        )






    def outpoint(self, ) -> "OutPoint":
        return _UniffiConverterTypeOutPoint.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettxout_outpoint,self._uniffi_clone_pointer(),)
        )






    def script_pubkey(self, ) -> "Script":
        return _UniffiConverterTypeScript.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettxout_script_pubkey,self._uniffi_clone_pointer(),)
        )






    def unblinded(self, ) -> "TxOutSecrets":
        return _UniffiConverterTypeTxOutSecrets.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettxout_unblinded,self._uniffi_clone_pointer(),)
        )






    def wildcard_index(self, ) -> "int":
        return _UniffiConverterUInt32.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettxout_wildcard_index,self._uniffi_clone_pointer(),)
        )





class _UniffiConverterTypeWalletTxOut:

    @staticmethod
    def lift(value: int):
        return WalletTxOut._make_instance_(value)

    @staticmethod
    def check_lower(value: WalletTxOut):
        if not isinstance(value, WalletTxOut):
            raise TypeError("Expected WalletTxOut instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: WalletTxOutProtocol):
        if not isinstance(value, WalletTxOut):
            raise TypeError("Expected WalletTxOut instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: WalletTxOutProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class WolletProtocol(typing.Protocol):
    """
    A Watch-Only wallet, wrapper over [`lwk_wollet::Wollet`]
    """

    def address(self, index: "typing.Optional[int]"):
        raise NotImplementedError
    def apply_update(self, update: "Update"):
        raise NotImplementedError
    def balance(self, ):
        raise NotImplementedError
    def descriptor(self, ):
        raise NotImplementedError
    def finalize(self, pset: "Pset"):
        raise NotImplementedError
    def transactions(self, ):
        raise NotImplementedError
    def wait_for_tx(self, txid: "Txid",client: "ElectrumClient"):
        """
        Note this a test method but we are not feature gating in test because we need it in
        destination language examples
        """

        raise NotImplementedError

class Wollet:
    """
    A Watch-Only wallet, wrapper over [`lwk_wollet::Wollet`]
    """


    _pointer: ctypes.c_void_p
    def __init__(self, network: "Network",descriptor: "WolletDescriptor",datadir: "typing.Optional[str]"):
        """
        Construct a Watch-Only wallet object
        """

        _UniffiConverterTypeNetwork.check_lower(network)
        
        _UniffiConverterTypeWolletDescriptor.check_lower(descriptor)
        
        _UniffiConverterOptionalString.check_lower(datadir)
        
        self._pointer = _rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_wollet_new,
        _UniffiConverterTypeNetwork.lower(network),
        _UniffiConverterTypeWolletDescriptor.lower(descriptor),
        _UniffiConverterOptionalString.lower(datadir))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_lwk_fn_free_wollet, pointer)

    def _uniffi_clone_pointer(self):
        return _rust_call(_UniffiLib.uniffi_lwk_fn_clone_wollet, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    @classmethod
    def with_custom_persister(cls, network: "Network",descriptor: "WolletDescriptor",persister: "ForeignPersisterLink"):
        """
        Construct a Watch-Only wallet object with a caller provided persister
        """

        _UniffiConverterTypeNetwork.check_lower(network)
        
        _UniffiConverterTypeWolletDescriptor.check_lower(descriptor)
        
        _UniffiConverterTypeForeignPersisterLink.check_lower(persister)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_wollet_with_custom_persister,
        _UniffiConverterTypeNetwork.lower(network),
        _UniffiConverterTypeWolletDescriptor.lower(descriptor),
        _UniffiConverterTypeForeignPersisterLink.lower(persister))
        return cls._make_instance_(pointer)



    def address(self, index: "typing.Optional[int]") -> "AddressResult":
        _UniffiConverterOptionalUInt32.check_lower(index)
        
        return _UniffiConverterTypeAddressResult.lift(
            _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_wollet_address,self._uniffi_clone_pointer(),
        _UniffiConverterOptionalUInt32.lower(index))
        )






    def apply_update(self, update: "Update"):
        _UniffiConverterTypeUpdate.check_lower(update)
        
        _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_wollet_apply_update,self._uniffi_clone_pointer(),
        _UniffiConverterTypeUpdate.lower(update))







    def balance(self, ) -> "dict":
        return _UniffiConverterMapTypeAssetIdUInt64.lift(
            _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_wollet_balance,self._uniffi_clone_pointer(),)
        )






    def descriptor(self, ) -> "WolletDescriptor":
        return _UniffiConverterTypeWolletDescriptor.lift(
            _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_wollet_descriptor,self._uniffi_clone_pointer(),)
        )






    def finalize(self, pset: "Pset") -> "Pset":
        _UniffiConverterTypePset.check_lower(pset)
        
        return _UniffiConverterTypePset.lift(
            _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_wollet_finalize,self._uniffi_clone_pointer(),
        _UniffiConverterTypePset.lower(pset))
        )






    def transactions(self, ) -> "typing.List[WalletTx]":
        return _UniffiConverterSequenceTypeWalletTx.lift(
            _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_wollet_transactions,self._uniffi_clone_pointer(),)
        )






    def wait_for_tx(self, txid: "Txid",client: "ElectrumClient") -> "WalletTx":
        """
        Note this a test method but we are not feature gating in test because we need it in
        destination language examples
        """

        _UniffiConverterTypeTxid.check_lower(txid)
        
        _UniffiConverterTypeElectrumClient.check_lower(client)
        
        return _UniffiConverterTypeWalletTx.lift(
            _rust_call_with_error(
    _UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_wollet_wait_for_tx,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTxid.lower(txid),
        _UniffiConverterTypeElectrumClient.lower(client))
        )





class _UniffiConverterTypeWollet:

    @staticmethod
    def lift(value: int):
        return Wollet._make_instance_(value)

    @staticmethod
    def check_lower(value: Wollet):
        if not isinstance(value, Wollet):
            raise TypeError("Expected Wollet instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: WolletProtocol):
        if not isinstance(value, Wollet):
            raise TypeError("Expected Wollet instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: WolletProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class WolletDescriptorProtocol(typing.Protocol):
    """
    The output descriptors, wrapper over [`lwk_wollet::WolletDescriptor`]
    """

    pass

class WolletDescriptor:
    """
    The output descriptors, wrapper over [`lwk_wollet::WolletDescriptor`]
    """


    _pointer: ctypes.c_void_p
    def __init__(self, descriptor: "str"):
        _UniffiConverterString.check_lower(descriptor)
        
        self._pointer = _rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_wolletdescriptor_new,
        _UniffiConverterString.lower(descriptor))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_lwk_fn_free_wolletdescriptor, pointer)

    def _uniffi_clone_pointer(self):
        return _rust_call(_UniffiLib.uniffi_lwk_fn_clone_wolletdescriptor, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _rust_call(_UniffiLib.uniffi_lwk_fn_method_wolletdescriptor_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )





class _UniffiConverterTypeWolletDescriptor:

    @staticmethod
    def lift(value: int):
        return WolletDescriptor._make_instance_(value)

    @staticmethod
    def check_lower(value: WolletDescriptor):
        if not isinstance(value, WolletDescriptor):
            raise TypeError("Expected WolletDescriptor instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: WolletDescriptorProtocol):
        if not isinstance(value, WolletDescriptor):
            raise TypeError("Expected WolletDescriptor instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: WolletDescriptorProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))





class Chain(enum.Enum):
    """
    Wallet chain
    """

    EXTERNAL = 0
    """
    External address, shown when asked for a payment.
    Wallet having a single descriptor are considered External
    """

    
    INTERNAL = 1
    """
    Internal address, used for the change
    """

    


class _UniffiConverterTypeChain(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return Chain.EXTERNAL
        if variant == 2:
            return Chain.INTERNAL
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == Chain.EXTERNAL:
            return
        if value == Chain.INTERNAL:
            return

    @staticmethod
    def write(value, buf):
        if value == Chain.EXTERNAL:
            buf.write_i32(1)
        if value == Chain.INTERNAL:
            buf.write_i32(2)




# LwkError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class LwkError(Exception):
    """
    Possible errors emitted
    """

    pass

_UniffiTempLwkError = LwkError

class LwkError:  # type: ignore
    class Generic(_UniffiTempLwkError):

        def __init__(self, msg):
            super().__init__(", ".join([
                "msg={!r}".format(msg),
            ]))
            self.msg = msg
        def __repr__(self):
            return "LwkError.Generic({})".format(str(self))
    _UniffiTempLwkError.Generic = Generic # type: ignore
    class PoisonError(_UniffiTempLwkError):

        def __init__(self, msg):
            super().__init__(", ".join([
                "msg={!r}".format(msg),
            ]))
            self.msg = msg
        def __repr__(self):
            return "LwkError.PoisonError({})".format(str(self))
    _UniffiTempLwkError.PoisonError = PoisonError # type: ignore

LwkError = _UniffiTempLwkError # type: ignore
del _UniffiTempLwkError


class _UniffiConverterTypeLwkError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return LwkError.Generic(
                msg=_UniffiConverterString.read(buf),
            )
        if variant == 2:
            return LwkError.PoisonError(
                msg=_UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, LwkError.Generic):
            _UniffiConverterString.check_lower(value.msg)
            return
        if isinstance(value, LwkError.PoisonError):
            _UniffiConverterString.check_lower(value.msg)
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, LwkError.Generic):
            buf.write_i32(1)
            _UniffiConverterString.write(value.msg, buf)
        if isinstance(value, LwkError.PoisonError):
            buf.write_i32(2)
            _UniffiConverterString.write(value.msg, buf)



class _UniffiConverterOptionalUInt8(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterUInt8.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterUInt8.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterUInt8.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalUInt32(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterUInt32.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterUInt32.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterUInt32.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalFloat(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterFloat.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterFloat.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterFloat.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalString(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterString.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterString.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterString.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeAddress(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeAddress.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeAddress.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeAddress.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeContract(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeContract.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeContract.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeContract.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeTransaction(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeTransaction.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeTransaction.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeTransaction.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeUpdate(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeUpdate.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeUpdate.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeUpdate.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeWalletTxOut(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeWalletTxOut.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeWalletTxOut.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeWalletTxOut.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeAssetId(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeAssetId.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeAssetId.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeAssetId.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterSequenceTypeWalletTx(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeWalletTx.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeWalletTx.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeWalletTx.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceOptionalTypeWalletTxOut(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterOptionalTypeWalletTxOut.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterOptionalTypeWalletTxOut.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterOptionalTypeWalletTxOut.read(buf) for i in range(count)
        ]



class _UniffiConverterMapTypeAssetIdUInt64(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, items):
        for (key, value) in items.items():
            _UniffiConverterTypeAssetId.check_lower(key)
            _UniffiConverterUInt64.check_lower(value)

    @classmethod
    def write(cls, items, buf):
        buf.write_i32(len(items))
        for (key, value) in items.items():
            _UniffiConverterTypeAssetId.write(key, buf)
            _UniffiConverterUInt64.write(value, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative map size")

        # It would be nice to use a dict comprehension,
        # but in Python 3.7 and before the evaluation order is not according to spec,
        # so we we're reading the value before the key.
        # This loop makes the order explicit: first reading the key, then the value.
        d = {}
        for i in range(count):
            key = _UniffiConverterTypeAssetId.read(buf)
            val = _UniffiConverterUInt64.read(buf)
            d[key] = val
        return d



class _UniffiConverterMapTypeAssetIdInt64(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, items):
        for (key, value) in items.items():
            _UniffiConverterTypeAssetId.check_lower(key)
            _UniffiConverterInt64.check_lower(value)

    @classmethod
    def write(cls, items, buf):
        buf.write_i32(len(items))
        for (key, value) in items.items():
            _UniffiConverterTypeAssetId.write(key, buf)
            _UniffiConverterInt64.write(value, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative map size")

        # It would be nice to use a dict comprehension,
        # but in Python 3.7 and before the evaluation order is not according to spec,
        # so we we're reading the value before the key.
        # This loop makes the order explicit: first reading the key, then the value.
        d = {}
        for i in range(count):
            key = _UniffiConverterTypeAssetId.read(buf)
            val = _UniffiConverterInt64.read(buf)
            d[key] = val
        return d


# Type alias
AssetId = str

class _UniffiConverterTypeAssetId:
    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value, buf)

    @staticmethod
    def read(buf):
        return _UniffiConverterString.read(buf)

    @staticmethod
    def lift(value):
        return _UniffiConverterString.lift(value)

    @staticmethod
    def check_lower(value):
        return _UniffiConverterString.check_lower(value)

    @staticmethod
    def lower(value):
        return _UniffiConverterString.lower(value)


# Type alias
Hex = str

class _UniffiConverterTypeHex:
    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value, buf)

    @staticmethod
    def read(buf):
        return _UniffiConverterString.read(buf)

    @staticmethod
    def lift(value):
        return _UniffiConverterString.lift(value)

    @staticmethod
    def check_lower(value):
        return _UniffiConverterString.check_lower(value)

    @staticmethod
    def lower(value):
        return _UniffiConverterString.lower(value)

__all__ = [
    "InternalError",
    "Chain",
    "LwkError",
    "Address",
    "AddressResult",
    "Contract",
    "ElectrumClient",
    "EsploraClient",
    "ForeignPersister",
    "ForeignPersisterLink",
    "Mnemonic",
    "Network",
    "OutPoint",
    "Precision",
    "Pset",
    "Script",
    "Signer",
    "TestEnv",
    "Transaction",
    "TxBuilder",
    "TxOutSecrets",
    "Txid",
    "Update",
    "WalletTx",
    "WalletTxOut",
    "Wollet",
    "WolletDescriptor",
]

