"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3Bucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const common_1 = require("./common");
const helpers_1 = require("./private/helpers");
/**
 * (experimental) An S3 bucket destination for data from a Kinesis Data Firehose delivery stream.
 *
 * @experimental
 */
class S3Bucket {
    /**
     * @experimental
     */
    constructor(bucket, props = {}) {
        var _b;
        this.bucket = bucket;
        this.props = props;
        if (((_b = this.props.s3Backup) === null || _b === void 0 ? void 0 : _b.mode) === common_1.BackupMode.FAILED) {
            throw new Error('S3 destinations do not support BackupMode.FAILED');
        }
    }
    /**
     * (experimental) (experimental) Binds this destination to the Kinesis Data Firehose delivery stream.
     *
     * Implementers should use this method to bind resources to the stack and initialize values using the provided stream.
     *
     * @experimental
     */
    bind(scope, _options) {
        var _b, _c, _d, _e;
        const role = (_b = this.props.role) !== null && _b !== void 0 ? _b : new iam.Role(scope, 'S3 Destination Role', {
            assumedBy: new iam.ServicePrincipal('firehose.amazonaws.com'),
        });
        const bucketGrant = this.bucket.grantReadWrite(role);
        const { loggingOptions, dependables: loggingDependables } = (_c = helpers_1.createLoggingOptions(scope, {
            logging: this.props.logging,
            logGroup: this.props.logGroup,
            role,
            streamId: 'S3Destination',
        })) !== null && _c !== void 0 ? _c : {};
        const { backupConfig, dependables: backupDependables } = (_d = helpers_1.createBackupConfig(scope, role, this.props.s3Backup)) !== null && _d !== void 0 ? _d : {};
        return {
            extendedS3DestinationConfiguration: {
                cloudWatchLoggingOptions: loggingOptions,
                processingConfiguration: helpers_1.createProcessingConfig(scope, role, this.props.processor),
                roleArn: role.roleArn,
                s3BackupConfiguration: backupConfig,
                s3BackupMode: this.getS3BackupMode(),
                bufferingHints: helpers_1.createBufferingHints(this.props.bufferingInterval, this.props.bufferingSize),
                bucketArn: this.bucket.bucketArn,
                compressionFormat: (_e = this.props.compression) === null || _e === void 0 ? void 0 : _e.value,
                encryptionConfiguration: helpers_1.createEncryptionConfig(role, this.props.encryptionKey),
                errorOutputPrefix: this.props.errorOutputPrefix,
                prefix: this.props.dataOutputPrefix,
            },
            dependables: [bucketGrant, ...(loggingDependables !== null && loggingDependables !== void 0 ? loggingDependables : []), ...(backupDependables !== null && backupDependables !== void 0 ? backupDependables : [])],
        };
    }
    getS3BackupMode() {
        var _b, _c;
        return ((_b = this.props.s3Backup) === null || _b === void 0 ? void 0 : _b.bucket) || ((_c = this.props.s3Backup) === null || _c === void 0 ? void 0 : _c.mode) === common_1.BackupMode.ALL
            ? 'Enabled'
            : undefined;
    }
}
exports.S3Bucket = S3Bucket;
_a = JSII_RTTI_SYMBOL_1;
S3Bucket[_a] = { fqn: "@aws-cdk/aws-kinesisfirehose-destinations.S3Bucket", version: "1.121.0" };
//# sourceMappingURL=data:application/json;base64,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