"""add people salary information

Revision ID: 2762a797f1f9
Revises: 307edd8c639d
Create Date: 2025-04-01 18:02:39.343857

"""

from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils


# revision identifiers, used by Alembic.
revision = "2762a797f1f9"
down_revision = "307edd8c639d"
branch_labels = None
depends_on = None

from zou.app.models.person import POSITION_TYPES, SENIORITY_TYPES


def upgrade():
    with op.batch_alter_table("person", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "position",
                sqlalchemy_utils.types.choice.ChoiceType(POSITION_TYPES),
                nullable=True,
            )
        )
        batch_op.add_column(
            sa.Column(
                "seniority",
                sqlalchemy_utils.types.choice.ChoiceType(SENIORITY_TYPES),
                nullable=True,
            )
        )
        batch_op.add_column(
            sa.Column("daily_salary", sa.Integer(), nullable=True)
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("person", schema=None) as batch_op:
        batch_op.drop_column("daily_salary")
        batch_op.drop_column("seniority")
        batch_op.drop_column("position")
    # ### end Alembic commands ###
