"""Add plugin.revision

Revision ID: d80f02824047
Revises: e7e633bd6fa2
Create Date: 2025-05-02 16:08:57.078114

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "d80f02824047"
down_revision = "e7e633bd6fa2"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("plugin", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("revision", sa.String(length=12), nullable=True)
        )

    with op.batch_alter_table("salary_scale", schema=None) as batch_op:
        batch_op.alter_column(
            "position", existing_type=sa.VARCHAR(length=255), nullable=True
        )
        batch_op.alter_column(
            "seniority", existing_type=sa.VARCHAR(length=255), nullable=True
        )

    with op.batch_alter_table("task", schema=None) as batch_op:
        batch_op.alter_column(
            "difficulty",
            existing_type=sa.INTEGER(),
            nullable=False,
            existing_server_default=sa.text("3"),
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("task", schema=None) as batch_op:
        batch_op.alter_column(
            "difficulty",
            existing_type=sa.INTEGER(),
            nullable=True,
            existing_server_default=sa.text("3"),
        )

    with op.batch_alter_table("salary_scale", schema=None) as batch_op:
        batch_op.alter_column(
            "seniority", existing_type=sa.VARCHAR(length=255), nullable=False
        )
        batch_op.alter_column(
            "position", existing_type=sa.VARCHAR(length=255), nullable=False
        )

    with op.batch_alter_table("plugin", schema=None) as batch_op:
        batch_op.drop_column("revision")

    # ### end Alembic commands ###
