// This file is generated by "paddle/fluid/pir/dialect/op_generator/op_gen.py"
#pragma once
#include <vector>

#include "paddle/fluid/pir/dialect/operator/interface/decomp.h"
#include "paddle/fluid/pir/dialect/operator/interface/decomp_vjp.h"
#include "paddle/fluid/pir/dialect/operator/interface/infer_symbolic_shape/infer_symbolic_shape.h"
#include "paddle/fluid/pir/dialect/operator/interface/infer_symbolic_shape/cache_grad_op_symbolic_shape.h"
#include "paddle/fluid/pir/dialect/operator/interface/infermeta.h"
#include "paddle/fluid/pir/dialect/operator/interface/layout_transformation.h"
#include "paddle/fluid/pir/dialect/operator/interface/op_yaml_info.h"
#include "paddle/fluid/pir/dialect/operator/interface/parse_kernel_key.h"
#include "paddle/fluid/pir/dialect/operator/interface/vjp.h"
#include "paddle/fluid/pir/dialect/operator/trait/inplace.h"
#include "paddle/fluid/pir/dialect/operator/trait/forward_only.h"
#include "paddle/fluid/pir/dialect/operator/utils/op_yaml_info_util.h"
#include "paddle/fluid/pir/dialect/operator/utils/utils.h"
#include "paddle/pir/include/core/builder.h"
#include "paddle/pir/include/core/op_base.h"
#include "paddle/pir/include/core/op_trait.h"
#include "paddle/pir/include/core/operation_utils.h"
#ifdef PADDLE_WITH_DNNL
#include "paddle/fluid/pir/dialect/operator/trait/onednn.h"
#endif
#include "paddle/fluid/ir_adaptor/translator/pd_op_sig.h"
#include "paddle/fluid/pir/dialect/operator/ir/manual_op.h"
#include "paddle/fluid/pir/dialect/operator/trait/custom_vjp.h"
#include "paddle/phi/core/infermeta_utils.h"

#include "paddle/phi/common/data_type.h"
#include "paddle/fluid/pir/dialect/operator/interface/get_kernel_type_for_var.h"
            

namespace paddle {
namespace dialect {

extern std::unordered_map<std::string, std::vector<PdOpSig>> op_to_multi_kernels_map;
extern std::unordered_map<std::string, std::vector<PdOpSig>> sp_op_to_multi_kernels_map;

} // namespace dialect
} // namespace paddle

namespace paddle {
namespace dialect {

class TEST_API AbsOp : public pir::Op<AbsOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.abs"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Abs_Op : public pir::Op<Abs_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.abs_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  AccuracyOp : public pir::Op<AccuracyOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.accuracy"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value indices_, pir::Value label_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value indices() { return operand_source(1); }
  pir::Value label() { return operand_source(2); }
  pir::Value accuracy() { return result(0); }
  pir::Value correct() { return result(1); }
  pir::Value total() { return result(2); }

};

class  AccuracyCheckOp : public pir::Op<AccuracyCheckOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.accuracy_check"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, const std::string& fn_name, double rtol=1e-5, double atol=1e-8, bool equal_nan=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  AcosOp : public pir::Op<AcosOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.acos"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Acos_Op : public pir::Op<Acos_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.acos_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  AcoshOp : public pir::Op<AcoshOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.acosh"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Acosh_Op : public pir::Op<Acosh_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.acosh_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Adadelta_Op : public pir::Op<Adadelta_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.adadelta_"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value avg_squared_grad_, pir::Value avg_squared_update_, pir::Value learning_rate_, pir::Value master_param_, float rho=0.95f, float epsilon=1.0e-6f, bool multi_precision=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value avg_squared_grad_, pir::Value avg_squared_update_, pir::Value learning_rate_, pir::Value master_param_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value grad() { return operand_source(1); }
  pir::Value avg_squared_grad() { return operand_source(2); }
  pir::Value avg_squared_update() { return operand_source(3); }
  pir::Value learning_rate() { return operand_source(4); }
  pir::Value master_param() { return operand_source(5); }
  pir::Value param_out() { return result(0); }
  pir::Value moment_out() { return result(1); }
  pir::Value inf_norm_out() { return result(2); }
  pir::Value master_param_out() { return result(3); }

};

class  Adagrad_Op : public pir::Op<Adagrad_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.adagrad_"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value moment_, pir::Value learning_rate_, pir::Value master_param_, float epsilon=1.0e-6f, bool multi_precision=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value moment_, pir::Value learning_rate_, pir::Value master_param_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value grad() { return operand_source(1); }
  pir::Value moment() { return operand_source(2); }
  pir::Value learning_rate() { return operand_source(3); }
  pir::Value master_param() { return operand_source(4); }
  pir::Value param_out() { return result(0); }
  pir::Value moment_out() { return result(1); }
  pir::Value master_param_out() { return result(2); }

};

class  AdagradDenseParamSparseGrad_Op : public pir::Op<AdagradDenseParamSparseGrad_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.adagrad_dense_param_sparse_grad_"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value moment_, pir::Value learning_rate_, pir::Value master_param_, float epsilon=1.0e-6f, bool multi_precision=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value moment_, pir::Value learning_rate_, pir::Value master_param_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value grad() { return operand_source(1); }
  pir::Value moment() { return operand_source(2); }
  pir::Value learning_rate() { return operand_source(3); }
  pir::Value master_param() { return operand_source(4); }
  pir::Value param_out() { return result(0); }
  pir::Value moment_out() { return result(1); }
  pir::Value master_param_out() { return result(2); }

};

class  Adam_Op : public pir::Op<Adam_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.adam_"; }
  static const char *attributes_name[5];
  static constexpr uint32_t attributes_num = 5;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, pir::Value moment1_, pir::Value moment2_, pir::Value moment2_max_, pir::Value beta1_pow_, pir::Value beta2_pow_, pir::Value master_param_, pir::Value skip_update_, float beta1=0.9f, float beta2=0.999f, float epsilon=1.0e-8f, bool lazy_mode=false, int64_t min_row_size_to_use_multithread=1000, bool multi_precision=false, bool use_global_beta_pow=false, bool amsgrad=false);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, pir::Value moment1_, pir::Value moment2_, pir::Value moment2_max_, pir::Value beta1_pow_, pir::Value beta2_pow_, pir::Value master_param_, pir::Value skip_update_, pir::Value beta1_, pir::Value beta2_, pir::Value epsilon_, bool lazy_mode=false, int64_t min_row_size_to_use_multithread=1000, bool multi_precision=false, bool use_global_beta_pow=false, bool amsgrad=false);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, pir::Value moment1_, pir::Value moment2_, pir::Value moment2_max_, pir::Value beta1_pow_, pir::Value beta2_pow_, pir::Value master_param_, pir::Value skip_update_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value grad() { return operand_source(1); }
  pir::Value learning_rate() { return operand_source(2); }
  pir::Value moment1() { return operand_source(3); }
  pir::Value moment2() { return operand_source(4); }
  pir::Value moment2_max() { return operand_source(5); }
  pir::Value beta1_pow() { return operand_source(6); }
  pir::Value beta2_pow() { return operand_source(7); }
  pir::Value master_param() { return operand_source(8); }
  pir::Value skip_update() { return operand_source(9); }
  pir::Value beta1() { return operand_source(10); }
  pir::Value beta2() { return operand_source(11); }
  pir::Value epsilon() { return operand_source(12); }
  pir::Value param_out() { return result(0); }
  pir::Value moment1_out() { return result(1); }
  pir::Value moment2_out() { return result(2); }
  pir::Value moment2_max_out() { return result(3); }
  pir::Value beta1_pow_out() { return result(4); }
  pir::Value beta2_pow_out() { return result(5); }
  pir::Value master_param_out() { return result(6); }

};

class  AdamDenseParamSparseGrad_Op : public pir::Op<AdamDenseParamSparseGrad_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.adam_dense_param_sparse_grad_"; }
  static const char *attributes_name[5];
  static constexpr uint32_t attributes_num = 5;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, pir::Value moment1_, pir::Value moment2_, pir::Value moment2_max_, pir::Value beta1_pow_, pir::Value beta2_pow_, pir::Value master_param_, pir::Value skip_update_, float beta1=0.9f, float beta2=0.999f, float epsilon=1.0e-8f, bool lazy_mode=false, int64_t min_row_size_to_use_multithread=1000, bool multi_precision=false, bool use_global_beta_pow=false, bool amsgrad=false);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, pir::Value moment1_, pir::Value moment2_, pir::Value moment2_max_, pir::Value beta1_pow_, pir::Value beta2_pow_, pir::Value master_param_, pir::Value skip_update_, pir::Value beta1_, pir::Value beta2_, pir::Value epsilon_, bool lazy_mode=false, int64_t min_row_size_to_use_multithread=1000, bool multi_precision=false, bool use_global_beta_pow=false, bool amsgrad=false);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, pir::Value moment1_, pir::Value moment2_, pir::Value moment2_max_, pir::Value beta1_pow_, pir::Value beta2_pow_, pir::Value master_param_, pir::Value skip_update_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value grad() { return operand_source(1); }
  pir::Value learning_rate() { return operand_source(2); }
  pir::Value moment1() { return operand_source(3); }
  pir::Value moment2() { return operand_source(4); }
  pir::Value moment2_max() { return operand_source(5); }
  pir::Value beta1_pow() { return operand_source(6); }
  pir::Value beta2_pow() { return operand_source(7); }
  pir::Value master_param() { return operand_source(8); }
  pir::Value skip_update() { return operand_source(9); }
  pir::Value beta1() { return operand_source(10); }
  pir::Value beta2() { return operand_source(11); }
  pir::Value epsilon() { return operand_source(12); }
  pir::Value param_out() { return result(0); }
  pir::Value moment1_out() { return result(1); }
  pir::Value moment2_out() { return result(2); }
  pir::Value moment2_max_out() { return result(3); }
  pir::Value beta1_pow_out() { return result(4); }
  pir::Value beta2_pow_out() { return result(5); }
  pir::Value master_param_out() { return result(6); }

};

class  Adamax_Op : public pir::Op<Adamax_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.adamax_"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, pir::Value moment_, pir::Value inf_norm_, pir::Value beta1_pow_, pir::Value master_param_, float beta1=0.9f, float beta2=0.999f, float epsilon=1.0e-8f, bool multi_precision=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, pir::Value moment_, pir::Value inf_norm_, pir::Value beta1_pow_, pir::Value master_param_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value grad() { return operand_source(1); }
  pir::Value learning_rate() { return operand_source(2); }
  pir::Value moment() { return operand_source(3); }
  pir::Value inf_norm() { return operand_source(4); }
  pir::Value beta1_pow() { return operand_source(5); }
  pir::Value master_param() { return operand_source(6); }
  pir::Value param_out() { return result(0); }
  pir::Value moment_out() { return result(1); }
  pir::Value inf_norm_out() { return result(2); }
  pir::Value master_param_out() { return result(3); }

};

class  Adamw_Op : public pir::Op<Adamw_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.adamw_"; }
  static const char *attributes_name[8];
  static constexpr uint32_t attributes_num = 8;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, pir::Value moment1_, pir::Value moment2_, pir::Value moment2_max_, pir::Value beta1_pow_, pir::Value beta2_pow_, pir::Value master_param_, pir::Value skip_update_, float beta1=0.9f, float beta2=0.999f, float epsilon=1.0e-8f, float lr_ratio=1.0f, float coeff=0.01f, bool with_decay=false, bool lazy_mode=false, int64_t min_row_size_to_use_multithread=1000, bool multi_precision=false, bool use_global_beta_pow=false, bool amsgrad=false);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, pir::Value moment1_, pir::Value moment2_, pir::Value moment2_max_, pir::Value beta1_pow_, pir::Value beta2_pow_, pir::Value master_param_, pir::Value skip_update_, pir::Value beta1_, pir::Value beta2_, pir::Value epsilon_, float lr_ratio=1.0f, float coeff=0.01f, bool with_decay=false, bool lazy_mode=false, int64_t min_row_size_to_use_multithread=1000, bool multi_precision=false, bool use_global_beta_pow=false, bool amsgrad=false);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, pir::Value moment1_, pir::Value moment2_, pir::Value moment2_max_, pir::Value beta1_pow_, pir::Value beta2_pow_, pir::Value master_param_, pir::Value skip_update_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value grad() { return operand_source(1); }
  pir::Value learning_rate() { return operand_source(2); }
  pir::Value moment1() { return operand_source(3); }
  pir::Value moment2() { return operand_source(4); }
  pir::Value moment2_max() { return operand_source(5); }
  pir::Value beta1_pow() { return operand_source(6); }
  pir::Value beta2_pow() { return operand_source(7); }
  pir::Value master_param() { return operand_source(8); }
  pir::Value skip_update() { return operand_source(9); }
  pir::Value beta1() { return operand_source(10); }
  pir::Value beta2() { return operand_source(11); }
  pir::Value epsilon() { return operand_source(12); }
  pir::Value param_out() { return result(0); }
  pir::Value moment1_out() { return result(1); }
  pir::Value moment2_out() { return result(2); }
  pir::Value moment2_max_out() { return result(3); }
  pir::Value beta1_pow_out() { return result(4); }
  pir::Value beta2_pow_out() { return result(5); }
  pir::Value master_param_out() { return result(6); }

};

class  AddPositionEncodingOp : public pir::Op<AddPositionEncodingOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.add_position_encoding"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float alpha=1.0f, float beta=1.0f);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  AddmmOp : public pir::Op<AddmmOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.addmm"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value x_, pir::Value y_, float beta=1.0, float alpha=1.0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value x_, pir::Value y_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value x() { return operand_source(1); }
  pir::Value y() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  Addmm_Op : public pir::Op<Addmm_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.addmm_"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value x_, pir::Value y_, float beta=1.0, float alpha=1.0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value x_, pir::Value y_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value x() { return operand_source(1); }
  pir::Value y() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  AffineChannelOp : public pir::Op<AffineChannelOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.affine_channel"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scale_, pir::Value bias_, const std::string& data_layout="AnyLayout");
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scale_, pir::Value bias_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value scale() { return operand_source(1); }
  pir::Value bias() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  AffineChannel_Op : public pir::Op<AffineChannel_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.affine_channel_"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scale_, pir::Value bias_, const std::string& data_layout="AnyLayout");
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scale_, pir::Value bias_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value scale() { return operand_source(1); }
  pir::Value bias() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  AffineGridOp : public pir::Op<AffineGridOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.affine_grid"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, const std::vector<int64_t>& output_shape={}, bool align_corners=true);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value output_shape_, bool align_corners=true);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value output_shape() { return operand_source(1); }
  pir::Value output() { return result(0); }

};

class  AllOp : public pir::Op<AllOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.all"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int64_t>& axis={}, bool keepdim=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  AllGatherOp : public pir::Op<AllGatherOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.all_gather"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int ring_id=0, int nranks=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  AllReduceOp : public pir::Op<AllReduceOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.all_reduce"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int ring_id=0, int reduce_type=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  AllReduce_Op : public pir::Op<AllReduce_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.all_reduce_"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int ring_id=0, int reduce_type=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  AllToAllOp : public pir::Op<AllToAllOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.all_to_all"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int ring_id=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  AllcloseOp : public pir::Op<AllcloseOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.allclose"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, double rtol=1e-5, double atol=1e-8, bool equal_nan=false);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::Value rtol_, pir::Value atol_, bool equal_nan=false);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value rtol() { return operand_source(2); }
  pir::Value atol() { return operand_source(3); }
  pir::Value out() { return result(0); }

};

class  AmaxOp : public pir::Op<AmaxOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.amax"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int64_t>& axis={}, bool keepdim=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  AminOp : public pir::Op<AminOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.amin"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int64_t>& axis={}, bool keepdim=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  AngleOp : public pir::Op<AngleOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.angle"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  AnyOp : public pir::Op<AnyOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.any"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int64_t>& axis={}, bool keepdim=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  ApFacadeOp : public pir::Op<ApFacadeOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.ap_facade"; }
  static const char *attributes_name[5];
  static constexpr uint32_t attributes_num = 5;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value xs_, int64_t num_outputs, const std::string& custom_op_name, const std::string& infer_meta_func_name, const std::string& infer_symbolic_func_name, const std::string& serialized_attributes);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value xs_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value xs() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  ApTrivialFusionBeginOp : public pir::Op<ApTrivialFusionBeginOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.ap_trivial_fusion_begin"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value xs_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value xs() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  ApTrivialFusionEndOp : public pir::Op<ApTrivialFusionEndOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.ap_trivial_fusion_end"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value xs_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value xs() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  ApVariadicOp : public pir::Op<ApVariadicOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.ap_variadic"; }
  static const char *attributes_name[6];
  static constexpr uint32_t attributes_num = 6;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value xs_, int num_outputs, const std::string& code_module_lambda, const std::string& infer_symbolic_lambda, const std::string& infer_meta_lambda, const std::string& rnel_dispatch_lambda, const std::string& kernel_dispatch_const_data_lambda);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value xs_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value xs() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  ApplyPerChannelScaleOp : public pir::Op<ApplyPerChannelScaleOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.apply_per_channel_scale"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scales_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value scales() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  ArgmaxOp : public pir::Op<ArgmaxOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.argmax"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int64_t axis, bool keepdims=false, bool flatten=false, phi::DataType dtype=phi::DataType::INT64);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value axis_, bool keepdims=false, bool flatten=false, phi::DataType dtype=phi::DataType::INT64);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value axis() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  ArgminOp : public pir::Op<ArgminOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.argmin"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int64_t axis, bool keepdims=false, bool flatten=false, phi::DataType dtype=phi::DataType::INT64);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value axis_, bool keepdims=false, bool flatten=false, phi::DataType dtype=phi::DataType::INT64);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value axis() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  ArgsortOp : public pir::Op<ArgsortOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.argsort"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int axis=-1, bool descending=false, bool stable=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }
  pir::Value indices() { return result(1); }

};

class  AsComplexOp : public pir::Op<AsComplexOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.as_complex"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  AsRealOp : public pir::Op<AsRealOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.as_real"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  AsStridedOp : public pir::Op<AsStridedOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.as_strided"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, const std::vector<int64_t>& dims={}, const std::vector<int64_t>& stride={}, int64_t offset=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Asgd_Op : public pir::Op<Asgd_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.asgd_"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, pir::Value d_, pir::Value y_, pir::Value n_, pir::Value master_param_, bool multi_precision=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, pir::Value d_, pir::Value y_, pir::Value n_, pir::Value master_param_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value grad() { return operand_source(1); }
  pir::Value learning_rate() { return operand_source(2); }
  pir::Value d() { return operand_source(3); }
  pir::Value y() { return operand_source(4); }
  pir::Value n() { return operand_source(5); }
  pir::Value master_param() { return operand_source(6); }
  pir::Value param_out() { return result(0); }
  pir::Value d_out() { return result(1); }
  pir::Value y_out() { return result(2); }
  pir::Value master_param_out() { return result(3); }

};

class  AsinOp : public pir::Op<AsinOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.asin"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Asin_Op : public pir::Op<Asin_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.asin_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  AsinhOp : public pir::Op<AsinhOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.asinh"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Asinh_Op : public pir::Op<Asinh_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.asinh_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  AssignPosOp : public pir::Op<AssignPosOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.assign_pos"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value cum_count_, pir::Value eff_num_len_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value cum_count() { return operand_source(1); }
  pir::Value eff_num_len() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  AssignValue_Op : public pir::Op<AssignValue_Op,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.assign_value_"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value output_, const std::vector<int>& shape, phi::DataType dtype, std::vector<phi::Scalar> values, const phi::Place& place={});
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value output_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value output() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  AtanOp : public pir::Op<AtanOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.atan"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Atan_Op : public pir::Op<Atan_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.atan_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Atan2Op : public pir::Op<Atan2Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.atan2"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  AtanhOp : public pir::Op<AtanhOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.atanh"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Atanh_Op : public pir::Op<Atanh_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.atanh_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  AttentionLstmOp : public pir::Op<AttentionLstmOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.attention_lstm"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value c0_, pir::Value h0_, pir::Value attention_weight_, pir::Value attention_bias_, pir::Value attention_scalar_, pir::Value attention_scalar_bias_, pir::Value lstm_weight_, pir::Value lstm_bias_, const std::string& gate_activation="sigmoid", const std::string& cell_activation="tanh", const std::string& candidate_activation="tanh");
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value c0_, pir::Value h0_, pir::Value attention_weight_, pir::Value attention_bias_, pir::Value attention_scalar_, pir::Value attention_scalar_bias_, pir::Value lstm_weight_, pir::Value lstm_bias_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value c0() { return operand_source(1); }
  pir::Value h0() { return operand_source(2); }
  pir::Value attention_weight() { return operand_source(3); }
  pir::Value attention_bias() { return operand_source(4); }
  pir::Value attention_scalar() { return operand_source(5); }
  pir::Value attention_scalar_bias() { return operand_source(6); }
  pir::Value lstm_weight() { return operand_source(7); }
  pir::Value lstm_bias() { return operand_source(8); }
  pir::Value hidden() { return result(0); }
  pir::Value cell() { return result(1); }
  pir::Value attentioned_x() { return result(2); }
  pir::Value attention_fc_out() { return result(3); }
  pir::Value lstm_x() { return result(4); }
  pir::Value lstm_out() { return result(5); }

};

class  AucOp : public pir::Op<AucOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.auc"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value label_, pir::Value stat_pos_, pir::Value stat_neg_, pir::Value ins_tag_weight_, const std::string& curve="ROC", int num_thresholds=(2 << 12) - 1, int slide_steps=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value label_, pir::Value stat_pos_, pir::Value stat_neg_, pir::Value ins_tag_weight_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value label() { return operand_source(1); }
  pir::Value stat_pos() { return operand_source(2); }
  pir::Value stat_neg() { return operand_source(3); }
  pir::Value ins_tag_weight() { return operand_source(4); }
  pir::Value auc() { return result(0); }
  pir::Value stat_pos_out() { return result(1); }
  pir::Value stat_neg_out() { return result(2); }

};

class  AverageAccumulates_Op : public pir::Op<AverageAccumulates_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.average_accumulates_"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value in_sum_1_, pir::Value in_sum_2_, pir::Value in_sum_3_, pir::Value in_num_accumulates_, pir::Value in_old_num_accumulates_, pir::Value in_num_updates_, float average_window=0, int64_t max_average_window=INT64_MAX, int64_t min_average_window=10000L);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value in_sum_1_, pir::Value in_sum_2_, pir::Value in_sum_3_, pir::Value in_num_accumulates_, pir::Value in_old_num_accumulates_, pir::Value in_num_updates_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value in_sum_1() { return operand_source(1); }
  pir::Value in_sum_2() { return operand_source(2); }
  pir::Value in_sum_3() { return operand_source(3); }
  pir::Value in_num_accumulates() { return operand_source(4); }
  pir::Value in_old_num_accumulates() { return operand_source(5); }
  pir::Value in_num_updates() { return operand_source(6); }
  pir::Value out_sum_1() { return result(0); }
  pir::Value out_sum_2() { return result(1); }
  pir::Value out_sum_3() { return result(2); }
  pir::Value out_num_accumulates() { return result(3); }
  pir::Value out_old_num_accumulates() { return result(4); }
  pir::Value out_num_updates() { return result(5); }

};

class  BaddbmmOp : public pir::Op<BaddbmmOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.baddbmm"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value x_, pir::Value y_, float beta=1.0, float alpha=1.0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value x_, pir::Value y_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value x() { return operand_source(1); }
  pir::Value y() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  Baddbmm_Op : public pir::Op<Baddbmm_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.baddbmm_"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value x_, pir::Value y_, float beta=1.0, float alpha=1.0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value x_, pir::Value y_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value x() { return operand_source(1); }
  pir::Value y() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  BarrierOp : public pir::Op<BarrierOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.barrier"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int ring_id=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  BatchFcOp : public pir::Op<BatchFcOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.batch_fc"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value w_, pir::Value bias_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value w() { return operand_source(1); }
  pir::Value bias() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  BceLossOp : public pir::Op<BceLossOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface,paddle::dialect::CustomVjpTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.bce_loss"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value label_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value label() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  BceLoss_Op : public pir::Op<BceLoss_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::CustomVjpTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.bce_loss_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value label_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value label() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  BeamSearchOp : public pir::Op<BeamSearchOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.beam_search"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value pre_ids_, pir::Value pre_scores_, pir::Value ids_, pir::Value scores_, int level, int beam_size, int end_id, bool is_accumulated=true);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value pre_ids_, pir::Value pre_scores_, pir::Value ids_, pir::Value scores_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value pre_ids() { return operand_source(0); }
  pir::Value pre_scores() { return operand_source(1); }
  pir::Value ids() { return operand_source(2); }
  pir::Value scores() { return operand_source(3); }
  pir::Value selected_ids() { return result(0); }
  pir::Value selected_scores() { return result(1); }
  pir::Value parent_idx() { return result(2); }

};

class  BernoulliOp : public pir::Op<BernoulliOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.bernoulli"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  BicubicInterpOp : public pir::Op<BicubicInterpOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.bicubic_interp"; }
  static const char *attributes_name[8];
  static constexpr uint32_t attributes_num = 8;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value out_size_, pir::Value size_tensor_, pir::Value scale_tensor_, const std::string& data_format="NCHW", int out_d=0, int out_h=0, int out_w=0, const std::vector<float>& scale={}, const std::string& interp_method="bilinear", bool align_corners=true, int align_mode=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value out_size_, pir::Value size_tensor_, pir::Value scale_tensor_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out_size() { return operand_source(1); }
  pir::Value size_tensor() { return operand_source(2); }
  pir::Value scale_tensor() { return operand_source(3); }
  pir::Value output() { return result(0); }

};

class  BilinearOp : public pir::Op<BilinearOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.bilinear"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::Value weight_, pir::Value bias_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value weight() { return operand_source(2); }
  pir::Value bias() { return operand_source(3); }
  pir::Value out() { return result(0); }

};

class  BilinearInterpOp : public pir::Op<BilinearInterpOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.bilinear_interp"; }
  static const char *attributes_name[8];
  static constexpr uint32_t attributes_num = 8;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value out_size_, pir::Value size_tensor_, pir::Value scale_tensor_, const std::string& data_format="NCHW", int out_d=0, int out_h=0, int out_w=0, const std::vector<float>& scale={}, const std::string& interp_method="bilinear", bool align_corners=true, int align_mode=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value out_size_, pir::Value size_tensor_, pir::Value scale_tensor_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out_size() { return operand_source(1); }
  pir::Value size_tensor() { return operand_source(2); }
  pir::Value scale_tensor() { return operand_source(3); }
  pir::Value output() { return result(0); }

};

class  BincountOp : public pir::Op<BincountOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.bincount"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value weights_, int minlength=0);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value weights_, pir::Value minlength_);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value weights_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value weights() { return operand_source(1); }
  pir::Value minlength() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  BinomialOp : public pir::Op<BinomialOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.binomial"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value count_, pir::Value prob_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value count() { return operand_source(0); }
  pir::Value prob() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  BipartiteMatchOp : public pir::Op<BipartiteMatchOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.bipartite_match"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value dist_mat_, const std::string& match_type="bipartite", float dist_threshold=0.5);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value dist_mat_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value dist_mat() { return operand_source(0); }
  pir::Value col_to_row_match_indices() { return result(0); }
  pir::Value col_to_row_match_dist() { return result(1); }

};

class  BitwiseAndOp : public pir::Op<BitwiseAndOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,pir::BinaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.bitwise_and"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  BitwiseAnd_Op : public pir::Op<BitwiseAnd_Op,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,pir::BinaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.bitwise_and_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  BitwiseLeftShiftOp : public pir::Op<BitwiseLeftShiftOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.bitwise_left_shift"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, bool is_arithmetic=true);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  BitwiseLeftShift_Op : public pir::Op<BitwiseLeftShift_Op,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.bitwise_left_shift_"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, bool is_arithmetic=true);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  BitwiseNotOp : public pir::Op<BitwiseNotOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.bitwise_not"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  BitwiseNot_Op : public pir::Op<BitwiseNot_Op,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.bitwise_not_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  BitwiseOrOp : public pir::Op<BitwiseOrOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,pir::BinaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.bitwise_or"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  BitwiseOr_Op : public pir::Op<BitwiseOr_Op,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,pir::BinaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.bitwise_or_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  BitwiseRightShiftOp : public pir::Op<BitwiseRightShiftOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.bitwise_right_shift"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, bool is_arithmetic=true);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  BitwiseRightShift_Op : public pir::Op<BitwiseRightShift_Op,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.bitwise_right_shift_"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, bool is_arithmetic=true);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  BitwiseXorOp : public pir::Op<BitwiseXorOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,pir::BinaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.bitwise_xor"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  BitwiseXor_Op : public pir::Op<BitwiseXor_Op,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,pir::BinaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.bitwise_xor_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  BmmOp : public pir::Op<BmmOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.bmm"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  BoxClipOp : public pir::Op<BoxClipOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.box_clip"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value im_info_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value im_info() { return operand_source(1); }
  pir::Value output() { return result(0); }

};

class  BoxCoderOp : public pir::Op<BoxCoderOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.box_coder"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value prior_box_, pir::Value prior_box_var_, pir::Value target_box_, const std::string& code_type="encode_center_size", bool box_normalized=true, int axis=0, const std::vector<float>& variance={});
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value prior_box_, pir::Value prior_box_var_, pir::Value target_box_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value prior_box() { return operand_source(0); }
  pir::Value prior_box_var() { return operand_source(1); }
  pir::Value target_box() { return operand_source(2); }
  pir::Value output_box() { return result(0); }

};

class  BroadcastOp : public pir::Op<BroadcastOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.broadcast"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int ring_id=0, int root=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Broadcast_Op : public pir::Op<Broadcast_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.broadcast_"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int ring_id=0, int root=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  BroadcastTensorsOp : public pir::Op<BroadcastTensorsOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.broadcast_tensors"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  BuildSrcRankAndLocalExpertIdOp : public pir::Op<BuildSrcRankAndLocalExpertIdOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.build_src_rank_and_local_expert_id"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value expert_num_global_tensor_, const std::vector<int64_t>& expert_num_global, int64_t num_local_experts);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value expert_num_global_tensor_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value expert_num_global_tensor() { return operand_source(0); }
  pir::Value vector() { return result(0); }
  pir::Value local_expert_id() { return result(1); }

};

class  CAllreduceSumOp : public pir::Op<CAllreduceSumOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.c_allreduce_sum"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int ring_id, bool use_calc_stream, bool use_model_parallel);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  CAllreduceSum_Op : public pir::Op<CAllreduceSum_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.c_allreduce_sum_"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int ring_id, bool use_calc_stream, bool use_model_parallel);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  CConcatOp : public pir::Op<CConcatOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.c_concat"; }
  static const char *attributes_name[5];
  static constexpr uint32_t attributes_num = 5;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int rank, int nranks, int ring_id, bool use_calc_stream, bool use_model_parallel);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  CIdentityOp : public pir::Op<CIdentityOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.c_identity"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int ring_id, bool use_calc_stream, bool use_model_parallel);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  CIdentity_Op : public pir::Op<CIdentity_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.c_identity_"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int ring_id, bool use_calc_stream, bool use_model_parallel);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  CScatterOp : public pir::Op<CScatterOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.c_scatter"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int ring_id=0, int root=0, int nranks=0, bool use_calc_stream=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  CSoftmaxWithCrossEntropyOp : public pir::Op<CSoftmaxWithCrossEntropyOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.c_softmax_with_cross_entropy"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value logits_, pir::Value label_, int64_t ignore_index=-100, int ring_id=0, int rank=0, int nranks=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value logits_, pir::Value label_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value logits() { return operand_source(0); }
  pir::Value label() { return operand_source(1); }
  pir::Value softmax() { return result(0); }
  pir::Value loss() { return result(1); }

};

class  CSplitOp : public pir::Op<CSplitOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.c_split"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int rank=0, int nranks=1, int ring_id=0, bool use_model_parallel=true);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  CalAuxLossOp : public pir::Op<CalAuxLossOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.cal_aux_loss"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value gate_prob_, pir::Value dispatch_mask_, pir::Value tokens_mask_, pir::Value dispatch_tokens_mask_, int64_t num_experts, bool use_group, int64_t moe_k, float clip_min);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value gate_prob_, pir::Value dispatch_mask_, pir::Value tokens_mask_, pir::Value dispatch_tokens_mask_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value gate_prob() { return operand_source(0); }
  pir::Value dispatch_mask() { return operand_source(1); }
  pir::Value tokens_mask() { return operand_source(2); }
  pir::Value dispatch_tokens_mask() { return operand_source(3); }
  pir::Value l_aux_loss() { return result(0); }
  pir::Value seqlen_float() { return result(1); }
  pir::Value ce() { return result(2); }

};

class  CalcReducedAttnScoresOp : public pir::Op<CalcReducedAttnScoresOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.calc_reduced_attn_scores"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value q_, pir::Value k_, pir::Value softmax_lse_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value q() { return operand_source(0); }
  pir::Value k() { return operand_source(1); }
  pir::Value softmax_lse() { return operand_source(2); }
  pir::Value reduced_scores() { return result(0); }

};

class TEST_API CastOp : public pir::Op<CastOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.cast"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, phi::DataType dtype);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Cast_Op : public pir::Op<Cast_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.cast_"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, phi::DataType dtype);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  CeilOp : public pir::Op<CeilOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.ceil"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Ceil_Op : public pir::Op<Ceil_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.ceil_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  CeluOp : public pir::Op<CeluOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.celu"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float alpha=1.0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  ChannelShuffleOp : public pir::Op<ChannelShuffleOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.channel_shuffle"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int groups, const std::string& data_format="NCHW");
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  CheckFiniteAndUnscale_Op : public pir::Op<CheckFiniteAndUnscale_Op,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.check_finite_and_unscale_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scale_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value scale() { return operand_source(1); }
  pir::Value out() { return result(0); }
  pir::Value found_infinite() { return result(1); }

};

class  CheckNumericsOp : public pir::Op<CheckNumericsOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.check_numerics"; }
  static const char *attributes_name[5];
  static constexpr uint32_t attributes_num = 5;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value tensor_, const std::string& op_type="", const std::string& var_name="", int check_nan_inf_level=0, int stack_height_limit=-1, const std::string& output_dir="");
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value tensor_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value tensor() { return operand_source(0); }
  pir::Value stats() { return result(0); }
  pir::Value values() { return result(1); }

};

class  CholeskyOp : public pir::Op<CholeskyOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.cholesky"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, bool upper=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  CholeskySolveOp : public pir::Op<CholeskySolveOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.cholesky_solve"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, bool upper=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  ClassCenterSampleOp : public pir::Op<ClassCenterSampleOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.class_center_sample"; }
  static const char *attributes_name[7];
  static constexpr uint32_t attributes_num = 7;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value label_, int num_classes, int num_samples, int ring_id=0, int rank=0, int nranks=1, bool fix_seed=false, int seed=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value label_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value label() { return operand_source(0); }
  pir::Value remapped_label() { return result(0); }
  pir::Value sampled_local_class_center() { return result(1); }

};

class  ClipOp : public pir::Op<ClipOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.clip"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float min, float max);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value min_, pir::Value max_);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value min() { return operand_source(1); }
  pir::Value max() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  Clip_Op : public pir::Op<Clip_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.clip_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float min, float max);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value min_, pir::Value max_);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value min() { return operand_source(1); }
  pir::Value max() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  ClipByNormOp : public pir::Op<ClipByNormOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.clip_by_norm"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float max_norm);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  ClipByNormSrOp : public pir::Op<ClipByNormSrOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.clip_by_norm_sr"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float max_norm);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  CoalesceTensorOp : public pir::Op<CoalesceTensorOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.coalesce_tensor"; }
  static const char *attributes_name[10];
  static constexpr uint32_t attributes_num = 10;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, phi::DataType dtype, bool copy_data=false, bool set_constant=false, bool persist_output=false, float constant=0.0, bool use_align=true, int align_size=-1, int size_of_dtype=-1, const std::vector<int64_t>& concated_shapes={}, const std::vector<int64_t>& concated_ranks={});
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value output() { return result(0); }
  pir::Value fused_output() { return result(1); }

};

class  CollectFpnProposalsOp : public pir::Op<CollectFpnProposalsOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.collect_fpn_proposals"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value multi_level_rois_, pir::Value multi_level_scores_, pir::Value multi_level_rois_num_, int post_nms_topn);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value multi_level_rois_, pir::Value multi_level_scores_, pir::Value multi_level_rois_num_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value multi_level_rois() { return operand_source(0); }
  pir::Value multi_level_scores() { return operand_source(1); }
  pir::Value multi_level_rois_num() { return operand_source(2); }
  pir::Value fpn_rois() { return result(0); }
  pir::Value rois_num() { return result(1); }

};

class  ComplexOp : public pir::Op<ComplexOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.complex"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value real_, pir::Value imag_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value real() { return operand_source(0); }
  pir::Value imag() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class TEST_API ConcatOp : public pir::Op<ConcatOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.concat"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int axis=0);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value axis_);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value axis() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  ConjOp : public pir::Op<ConjOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.conj"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class TEST_API Conv2dOp : public pir::Op<Conv2dOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.conv2d"; }
  static const char *attributes_name[6];
  static constexpr uint32_t attributes_num = 6;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value filter_, const std::vector<int>& strides={1, 1}, const std::vector<int>& paddings={0, 0}, const std::string& padding_algorithm="EXPLICIT", const std::vector<int>& dilations={1, 1}, int groups=1, const std::string& data_format="NCHW");
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value filter_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value filter() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  Conv2dTransposeOp : public pir::Op<Conv2dTransposeOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.conv2d_transpose"; }
  static const char *attributes_name[7];
  static constexpr uint32_t attributes_num = 7;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value filter_, const std::vector<int>& strides={1, 1}, const std::vector<int>& paddings={0, 0}, const std::vector<int>& output_padding={}, const std::vector<int64_t>& output_size={}, const std::string& padding_algorithm="EXPLICIT", int groups=1, const std::vector<int>& dilations={1, 1}, const std::string& data_format="NCHW");
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value filter_, pir::Value output_size_, const std::vector<int>& strides={1, 1}, const std::vector<int>& paddings={0, 0}, const std::vector<int>& output_padding={}, const std::string& padding_algorithm="EXPLICIT", int groups=1, const std::vector<int>& dilations={1, 1}, const std::string& data_format="NCHW");
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value filter_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value filter() { return operand_source(1); }
  pir::Value output_size() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  Conv2dTransposeBiasOp : public pir::Op<Conv2dTransposeBiasOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.conv2d_transpose_bias"; }
  static const char *attributes_name[7];
  static constexpr uint32_t attributes_num = 7;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value filter_, pir::Value bias_, const std::vector<int>& strides={1, 1}, const std::vector<int>& paddings={0, 0}, const std::vector<int>& output_padding={}, const std::vector<int64_t>& output_size={}, const std::string& padding_algorithm="EXPLICIT", int groups=1, const std::vector<int>& dilations={1, 1}, const std::string& data_format="NCHW");
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value filter_, pir::Value bias_, pir::Value output_size_, const std::vector<int>& strides={1, 1}, const std::vector<int>& paddings={0, 0}, const std::vector<int>& output_padding={}, const std::string& padding_algorithm="EXPLICIT", int groups=1, const std::vector<int>& dilations={1, 1}, const std::string& data_format="NCHW");
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value filter_, pir::Value bias_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value filter() { return operand_source(1); }
  pir::Value bias() { return operand_source(2); }
  pir::Value output_size() { return operand_source(3); }
  pir::Value out() { return result(0); }

};

class  Conv3dOp : public pir::Op<Conv3dOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.conv3d"; }
  static const char *attributes_name[6];
  static constexpr uint32_t attributes_num = 6;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value filter_, const std::vector<int>& strides={1, 1, 1}, const std::vector<int>& paddings={0, 0, 0}, const std::string& padding_algorithm="EXPLICIT", int groups=1, const std::vector<int>& dilations={1, 1, 1}, const std::string& data_format="NCDHW");
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value filter_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value filter() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  Conv3dTransposeOp : public pir::Op<Conv3dTransposeOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.conv3d_transpose"; }
  static const char *attributes_name[8];
  static constexpr uint32_t attributes_num = 8;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value filter_, const std::vector<int>& strides={1, 1, 1}, const std::vector<int>& paddings={0, 0, 0}, const std::vector<int>& output_padding={}, const std::vector<int>& output_size={}, const std::string& padding_algorithm="EXPLICIT", int groups=1, const std::vector<int>& dilations={1, 1, 1}, const std::string& data_format="NCHW");
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value filter_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value filter() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  CopyToOp : public pir::Op<CopyToOp,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.copy_to"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build();
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);

  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  CopysignOp : public pir::Op<CopysignOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::BinaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.copysign"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  Copysign_Op : public pir::Op<Copysign_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::BinaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.copysign_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  CorrelationOp : public pir::Op<CorrelationOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.correlation"; }
  static const char *attributes_name[6];
  static constexpr uint32_t attributes_num = 6;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input1_, pir::Value input2_, int pad_size, int kernel_size, int max_displacement, int stride1, int stride2, int corr_type_multiply=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input1_, pir::Value input2_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input1() { return operand_source(0); }
  pir::Value input2() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  CosOp : public pir::Op<CosOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.cos"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Cos_Op : public pir::Op<Cos_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.cos_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  CoshOp : public pir::Op<CoshOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.cosh"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Cosh_Op : public pir::Op<Cosh_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.cosh_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  CrfDecodingOp : public pir::Op<CrfDecodingOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.crf_decoding"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value emission_, pir::Value transition_, pir::Value label_, pir::Value length_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value emission() { return operand_source(0); }
  pir::Value transition() { return operand_source(1); }
  pir::Value label() { return operand_source(2); }
  pir::Value length() { return operand_source(3); }
  pir::Value viterbi_path() { return result(0); }

};

class  CropOp : public pir::Op<CropOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.crop"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int64_t>& shape={}, const std::vector<int64_t>& offsets={});
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value shape_, pir::Value offsets_);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value shape() { return operand_source(1); }
  pir::Value offsets() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  CrossOp : public pir::Op<CrossOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.cross"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, int axis=9);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  CrossEntropyWithSoftmaxOp : public pir::Op<CrossEntropyWithSoftmaxOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.cross_entropy_with_softmax"; }
  static const char *attributes_name[5];
  static constexpr uint32_t attributes_num = 5;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value label_, bool soft_label=false, bool use_softmax=true, bool numeric_stable_mode=true, int ignore_index=-100, int axis=-1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value label_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value label() { return operand_source(1); }
  pir::Value softmax() { return result(0); }
  pir::Value loss() { return result(1); }

};

class  CrossEntropyWithSoftmax_Op : public pir::Op<CrossEntropyWithSoftmax_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.cross_entropy_with_softmax_"; }
  static const char *attributes_name[5];
  static constexpr uint32_t attributes_num = 5;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value label_, bool soft_label=false, bool use_softmax=true, bool numeric_stable_mode=true, int ignore_index=-100, int axis=-1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value label_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value label() { return operand_source(1); }
  pir::Value softmax() { return result(0); }
  pir::Value loss() { return result(1); }

};

class  CrossEntropyWithSoftmaxBwdWDowncastOp : public pir::Op<CrossEntropyWithSoftmaxBwdWDowncastOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.cross_entropy_with_softmax_bwd_w_downcast"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value label_, pir::Value softmax_, pir::Value loss_grad_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value label() { return operand_source(0); }
  pir::Value softmax() { return operand_source(1); }
  pir::Value loss_grad() { return operand_source(2); }
  pir::Value input_grad() { return result(0); }

};

class  CtcAlignOp : public pir::Op<CtcAlignOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.ctc_align"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value input_length_, int blank=0, bool merge_repeated=true, int padding_value=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value input_length_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value input_length() { return operand_source(1); }
  pir::Value output() { return result(0); }
  pir::Value output_length() { return result(1); }

};

class  CudnnLstmOp : public pir::Op<CudnnLstmOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.cudnn_lstm"; }
  static const char *attributes_name[6];
  static constexpr uint32_t attributes_num = 6;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value init_h_, pir::Value init_c_, pir::Value w_, pir::Value weight_list_, pir::Value sequence_length_, float dropout_prob=0.0, bool is_bidirec=false, int hidden_size=100, int num_layers=1, bool is_test=false, int seed=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value init_h_, pir::Value init_c_, pir::Value w_, pir::Value weight_list_, pir::Value sequence_length_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value init_h() { return operand_source(1); }
  pir::Value init_c() { return operand_source(2); }
  pir::Value w() { return operand_source(3); }
  pir::Value weight_list() { return operand_source(4); }
  pir::Value sequence_length() { return operand_source(5); }
  pir::Value out() { return result(0); }
  pir::Value last_h() { return result(1); }
  pir::Value last_c() { return result(2); }
  pir::Value reserve() { return result(3); }
  pir::Value state_out() { return result(4); }

};

class TEST_API CummaxOp : public pir::Op<CummaxOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.cummax"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int axis=-1, phi::DataType dtype=phi::DataType::INT64);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }
  pir::Value indices() { return result(1); }

};

class  CumminOp : public pir::Op<CumminOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.cummin"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int axis=-1, phi::DataType dtype=phi::DataType::INT64);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }
  pir::Value indices() { return result(1); }

};

class  CumprodOp : public pir::Op<CumprodOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.cumprod"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int dim, bool exclusive=false, bool reverse=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Cumprod_Op : public pir::Op<Cumprod_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.cumprod_"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int dim, bool exclusive=false, bool reverse=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  CumsumOp : public pir::Op<CumsumOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.cumsum"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int axis=-1, bool flatten=false, bool exclusive=false, bool reverse=false);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value axis_, bool flatten=false, bool exclusive=false, bool reverse=false);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value axis() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  Cumsum_Op : public pir::Op<Cumsum_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.cumsum_"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int axis=-1, bool flatten=false, bool exclusive=false, bool reverse=false);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value axis_, bool flatten=false, bool exclusive=false, bool reverse=false);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value axis() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  CvmOp : public pir::Op<CvmOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.cvm"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value cvm_, bool use_cvm=true);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value cvm_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value cvm() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  DataOp : public pir::Op<DataOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.data"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, const std::string& name, const std::vector<int64_t>& shape, phi::DataType dtype, const phi::Place& place);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value out() { return result(0); }

};

class  DecayedAdagradOp : public pir::Op<DecayedAdagradOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.decayed_adagrad"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value moment_, pir::Value learning_rate_, float decay=0.95f, float epsilon=1.0e-6f);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value moment_, pir::Value learning_rate_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value grad() { return operand_source(1); }
  pir::Value moment() { return operand_source(2); }
  pir::Value learning_rate() { return operand_source(3); }
  pir::Value param_out() { return result(0); }
  pir::Value moment_out() { return result(1); }

};

class  DecodeJpegOp : public pir::Op<DecodeJpegOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.decode_jpeg"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::string& mode, const phi::Place& place);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  DeformableConvOp : public pir::Op<DeformableConvOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.deformable_conv"; }
  static const char *attributes_name[6];
  static constexpr uint32_t attributes_num = 6;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value offset_, pir::Value filter_, pir::Value mask_, const std::vector<int>& strides, const std::vector<int>& paddings, const std::vector<int>& dilations, int deformable_groups, int groups, int im2col_step);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value offset_, pir::Value filter_, pir::Value mask_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value offset() { return operand_source(1); }
  pir::Value filter() { return operand_source(2); }
  pir::Value mask() { return operand_source(3); }
  pir::Value out() { return result(0); }

};

class  DependOp : public pir::Op<DependOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.depend"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value dep_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value dep() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  DepthwiseConv2dOp : public pir::Op<DepthwiseConv2dOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.depthwise_conv2d"; }
  static const char *attributes_name[6];
  static constexpr uint32_t attributes_num = 6;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value filter_, const std::vector<int>& strides={1, 1}, const std::vector<int>& paddings={0, 0}, const std::string& padding_algorithm="EXPLICIT", int groups=1, const std::vector<int>& dilations={1, 1}, const std::string& data_format="NCHW");
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value filter_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value filter() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  DepthwiseConv2dTransposeOp : public pir::Op<DepthwiseConv2dTransposeOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.depthwise_conv2d_transpose"; }
  static const char *attributes_name[7];
  static constexpr uint32_t attributes_num = 7;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value filter_, const std::vector<int>& strides={1, 1}, const std::vector<int>& paddings={0, 0}, const std::vector<int>& output_padding={}, const std::vector<int64_t>& output_size={}, const std::string& padding_algorithm="EXPLICIT", int groups=1, const std::vector<int>& dilations={1, 1}, const std::string& data_format="NCHW");
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value filter_, pir::Value output_size_, const std::vector<int>& strides={1, 1}, const std::vector<int>& paddings={0, 0}, const std::vector<int>& output_padding={}, const std::string& padding_algorithm="EXPLICIT", int groups=1, const std::vector<int>& dilations={1, 1}, const std::string& data_format="NCHW");
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value filter_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value filter() { return operand_source(1); }
  pir::Value output_size() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  DequantizeAbsMaxOp : public pir::Op<DequantizeAbsMaxOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.dequantize_abs_max"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scale_, float max_range);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scale_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value scale() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  DequantizeLogOp : public pir::Op<DequantizeLogOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.dequantize_log"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value dict_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value dict() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  DetOp : public pir::Op<DetOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.det"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  DgcOp : public pir::Op<DgcOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.dgc"; }
  static const char *attributes_name[7];
  static constexpr uint32_t attributes_num = 7;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value u_, pir::Value v_, pir::Value grad_, pir::Value param_, pir::Value current_step_, pir::Value nranks_, float m=0.9, bool use_nesterov=true, const std::vector<float>& sparsity={}, float rampup_begin_step=0.0, float rampup_step=0.0, float regular_coeff=0.0, int regular_type=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value u_, pir::Value v_, pir::Value grad_, pir::Value param_, pir::Value current_step_, pir::Value nranks_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value u() { return operand_source(0); }
  pir::Value v() { return operand_source(1); }
  pir::Value grad() { return operand_source(2); }
  pir::Value param() { return operand_source(3); }
  pir::Value current_step() { return operand_source(4); }
  pir::Value nranks() { return operand_source(5); }
  pir::Value u_out() { return result(0); }
  pir::Value v_out() { return result(1); }
  pir::Value encode_grad() { return result(2); }
  pir::Value grad_out() { return result(3); }
  pir::Value k() { return result(4); }
  pir::Value gather_buff() { return result(5); }

};


class  DgcClipByNormOp : public pir::Op<DgcClipByNormOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.dgc_clip_by_norm"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value current_step_, float max_norm, float rampup_begin_step=-1.0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value current_step_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value current_step() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  DgcClipByNormSrOp : public pir::Op<DgcClipByNormSrOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.dgc_clip_by_norm_sr"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value current_step_, float max_norm, float rampup_begin_step=-1.0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value current_step_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value current_step() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  DgcMomentumOp : public pir::Op<DgcMomentumOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.dgc_momentum"; }
  static const char *attributes_name[7];
  static constexpr uint32_t attributes_num = 7;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value velocity_, pir::Value learning_rate_, pir::Value master_param_, pir::Value current_step_tensor_, pir::Value nranks_tensor_, float mu, bool use_nesterov=false, const std::string& regularization_method="", float regularization_coeff=0.0f, bool multi_precision=false, float rescale_grad=1.0f, float rampup_begin_step=-1.0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value velocity_, pir::Value learning_rate_, pir::Value master_param_, pir::Value current_step_tensor_, pir::Value nranks_tensor_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value grad() { return operand_source(1); }
  pir::Value velocity() { return operand_source(2); }
  pir::Value learning_rate() { return operand_source(3); }
  pir::Value master_param() { return operand_source(4); }
  pir::Value current_step_tensor() { return operand_source(5); }
  pir::Value nranks_tensor() { return operand_source(6); }
  pir::Value param_out() { return result(0); }
  pir::Value velocity_out() { return result(1); }
  pir::Value master_param_out() { return result(2); }
  pir::Value grad_out() { return result(3); }

};

class  DiagOp : public pir::Op<DiagOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.diag"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int offset=0, float padding_value=0.0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  DiagEmbedOp : public pir::Op<DiagEmbedOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.diag_embed"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, int offset=0, int dim1=-2, int dim2=-1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  DiagonalOp : public pir::Op<DiagonalOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.diagonal"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int offset=0, int axis1=0, int axis2=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  DigammaOp : public pir::Op<DigammaOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.digamma"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Digamma_Op : public pir::Op<Digamma_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.digamma_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  DirichletOp : public pir::Op<DirichletOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.dirichlet"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value alpha_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value alpha() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  DisableCheckModelNanInfOp : public pir::Op<DisableCheckModelNanInfOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.disable_check_model_nan_inf"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int flag=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  DistOp : public pir::Op<DistOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.dist"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, float p=2.0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  DotOp : public pir::Op<DotOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.dot"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  DpsgdOp : public pir::Op<DpsgdOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.dpsgd"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, float clip=10.0f, float batch_size=16.0f, float sigma=1.0f, int seed=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value grad() { return operand_source(1); }
  pir::Value learning_rate() { return operand_source(2); }
  pir::Value param_out() { return result(0); }

};

class  DropoutOp : public pir::Op<DropoutOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface,pir::SideEffectTrait,paddle::dialect::CustomVjpTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.dropout"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value seed_tensor_, float p=0.5f, bool is_test=false, const std::string& mode="downgrade_in_infer", int seed=0, bool fix_seed=false);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value seed_tensor_, pir::Value p_, bool is_test=false, const std::string& mode="downgrade_in_infer", int seed=0, bool fix_seed=false);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value seed_tensor_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value seed_tensor() { return operand_source(1); }
  pir::Value p() { return operand_source(2); }
  pir::Value out() { return result(0); }
  pir::Value mask() { return result(1); }

};

class  EditDistanceOp : public pir::Op<EditDistanceOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.edit_distance"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value hyps_, pir::Value refs_, pir::Value hypslength_, pir::Value refslength_, bool normalized=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value hyps_, pir::Value refs_, pir::Value hypslength_, pir::Value refslength_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value hyps() { return operand_source(0); }
  pir::Value refs() { return operand_source(1); }
  pir::Value hypslength() { return operand_source(2); }
  pir::Value refslength() { return operand_source(3); }
  pir::Value sequencenum() { return result(0); }
  pir::Value out() { return result(1); }

};

class  EigOp : public pir::Op<EigOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.eig"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out_w() { return result(0); }
  pir::Value out_v() { return result(1); }

};

class  EighOp : public pir::Op<EighOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.eigh"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::string& UPLO="L");
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out_w() { return result(0); }
  pir::Value out_v() { return result(1); }

};

class  EigvalsOp : public pir::Op<EigvalsOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.eigvals"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  EigvalshOp : public pir::Op<EigvalshOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.eigvalsh"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::string& uplo="L", bool is_test=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value eigenvalues() { return result(0); }
  pir::Value eigenvectors() { return result(1); }

};

class  EluOp : public pir::Op<EluOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface,pir::UnaryElementWiseTrait,paddle::dialect::CustomVjpTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.elu"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float alpha=1.0f);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Elu_Op : public pir::Op<Elu_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::CustomVjpTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.elu_"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float alpha=1.0f);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  EmbeddingGradAddToOp : public pir::Op<EmbeddingGradAddToOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.embedding_grad_add_to"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value token_indices_, pir::Value main_grad__, pir::Value out_grad_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value token_indices() { return operand_source(0); }
  pir::Value main_grad_() { return operand_source(1); }
  pir::Value out_grad() { return operand_source(2); }
  pir::Value main_grad_out() { return result(0); }

};

class  EmbeddingGradAddTo_Op : public pir::Op<EmbeddingGradAddTo_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.embedding_grad_add_to_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value token_indices_, pir::Value main_grad__, pir::Value out_grad_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value token_indices() { return operand_source(0); }
  pir::Value main_grad_() { return operand_source(1); }
  pir::Value out_grad() { return operand_source(2); }
  pir::Value main_grad_out() { return result(0); }

};

class  EmbeddingWithScaledGradientOp : public pir::Op<EmbeddingWithScaledGradientOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.embedding_with_scaled_gradient"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value weight_, int64_t padding_idx=-1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value weight_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value weight() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  EmptyOp : public pir::Op<EmptyOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.empty"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, const std::vector<int64_t>& shape, phi::DataType dtype=phi::DataType::FLOAT32, const phi::Place& place=phi::CPUPlace());
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value shape_, phi::DataType dtype=phi::DataType::FLOAT32, const phi::Place& place=phi::CPUPlace());
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value shape() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  EmptyLikeOp : public pir::Op<EmptyLikeOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.empty_like"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, phi::DataType dtype=phi::DataType::UNDEFINED, const phi::Place& place={});
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  EnableCheckModelNanInfOp : public pir::Op<EnableCheckModelNanInfOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.enable_check_model_nan_inf"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int flag=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  EqualAllOp : public pir::Op<EqualAllOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.equal_all"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  ErfOp : public pir::Op<ErfOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.erf"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Erf_Op : public pir::Op<Erf_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.erf_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  ErfinvOp : public pir::Op<ErfinvOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.erfinv"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Erfinv_Op : public pir::Op<Erfinv_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.erfinv_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  ExpOp : public pir::Op<ExpOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.exp"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Exp_Op : public pir::Op<Exp_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.exp_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  ExpandAsOp : public pir::Op<ExpandAsOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.expand_as"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, const std::vector<int64_t>& target_shape={});
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  ExpandModalityExpertIdOp : public pir::Op<ExpandModalityExpertIdOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.expand_modality_expert_id"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value expert_id_, int64_t num_expert_per_modality, int64_t group_size, int64_t modality_offset, bool is_group_expert);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value expert_id_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value expert_id() { return operand_source(0); }
  pir::Value expert_id_out() { return result(0); }

};

class  Expm1Op : public pir::Op<Expm1Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.expm1"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Expm1_Op : public pir::Op<Expm1_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.expm1_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Exponential_Op : public pir::Op<Exponential_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.exponential_"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float lam);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  EyeOp : public pir::Op<EyeOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.eye"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, float num_rows, float num_columns, phi::DataType dtype=phi::DataType::FLOAT32, const phi::Place& place={});
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value num_rows_, pir::Value num_columns_, phi::DataType dtype=phi::DataType::FLOAT32, const phi::Place& place={});
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value num_rows() { return operand_source(0); }
  pir::Value num_columns() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  FakeChannelWiseDequantizeMaxAbsOp : public pir::Op<FakeChannelWiseDequantizeMaxAbsOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fake_channel_wise_dequantize_max_abs"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scales_, const std::vector<int>& quant_bits={8}, int quant_axis=0, int x_num_col_dims=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scales_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value scales() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  FakeChannelWiseQuantizeAbsMaxOp : public pir::Op<FakeChannelWiseQuantizeAbsMaxOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fake_channel_wise_quantize_abs_max"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int bit_length=8, int round_type=1, int quant_axis=0, bool is_test=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }
  pir::Value out_scale() { return result(1); }

};

class  FakeChannelWiseQuantizeDequantizeAbsMaxOp : public pir::Op<FakeChannelWiseQuantizeDequantizeAbsMaxOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fake_channel_wise_quantize_dequantize_abs_max"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int bit_length=8, int round_type=1, int quant_axis=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }
  pir::Value out_scale() { return result(1); }

};

class  FakeDequantizeMaxAbsOp : public pir::Op<FakeDequantizeMaxAbsOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fake_dequantize_max_abs"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scale_, float max_range);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scale_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value scale() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  FakeQuantizeAbsMaxOp : public pir::Op<FakeQuantizeAbsMaxOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fake_quantize_abs_max"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int bit_length=8, int round_type=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }
  pir::Value out_scale() { return result(1); }

};

class  FakeQuantizeDequantizeAbsMaxOp : public pir::Op<FakeQuantizeDequantizeAbsMaxOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fake_quantize_dequantize_abs_max"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int bit_length=8, int round_type=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }
  pir::Value out_scale() { return result(1); }

};

class  FakeQuantizeDequantizeMovingAverageAbsMaxOp : public pir::Op<FakeQuantizeDequantizeMovingAverageAbsMaxOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fake_quantize_dequantize_moving_average_abs_max"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value in_scale_, pir::Value in_accum_, pir::Value in_state_, float moving_rate=0.9, int bit_length=8, bool is_test=false, int round_type=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value in_scale_, pir::Value in_accum_, pir::Value in_state_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value in_scale() { return operand_source(1); }
  pir::Value in_accum() { return operand_source(2); }
  pir::Value in_state() { return operand_source(3); }
  pir::Value out() { return result(0); }
  pir::Value out_scale() { return result(1); }
  pir::Value out_state() { return result(2); }
  pir::Value out_accum() { return result(3); }

};

class  FakeQuantizeDequantizeMovingAverageAbsMax_Op : public pir::Op<FakeQuantizeDequantizeMovingAverageAbsMax_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fake_quantize_dequantize_moving_average_abs_max_"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value in_scale_, pir::Value in_accum_, pir::Value in_state_, float moving_rate=0.9, int bit_length=8, bool is_test=false, int round_type=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value in_scale_, pir::Value in_accum_, pir::Value in_state_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value in_scale() { return operand_source(1); }
  pir::Value in_accum() { return operand_source(2); }
  pir::Value in_state() { return operand_source(3); }
  pir::Value out() { return result(0); }
  pir::Value out_scale() { return result(1); }
  pir::Value out_state() { return result(2); }
  pir::Value out_accum() { return result(3); }

};

class  FakeQuantizeMovingAverageAbsMaxOp : public pir::Op<FakeQuantizeMovingAverageAbsMaxOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fake_quantize_moving_average_abs_max"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value in_scale_, pir::Value in_accum_, pir::Value in_state_, float moving_rate=0.9, int bit_length=8, bool is_test=false, int round_type=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value in_scale_, pir::Value in_accum_, pir::Value in_state_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value in_scale() { return operand_source(1); }
  pir::Value in_accum() { return operand_source(2); }
  pir::Value in_state() { return operand_source(3); }
  pir::Value out() { return result(0); }
  pir::Value out_scale() { return result(1); }
  pir::Value out_state() { return result(2); }
  pir::Value out_accum() { return result(3); }

};

class  FakeQuantizeMovingAverageAbsMax_Op : public pir::Op<FakeQuantizeMovingAverageAbsMax_Op,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fake_quantize_moving_average_abs_max_"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value in_scale_, pir::Value in_accum_, pir::Value in_state_, float moving_rate=0.9, int bit_length=8, bool is_test=false, int round_type=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value in_scale_, pir::Value in_accum_, pir::Value in_state_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value in_scale() { return operand_source(1); }
  pir::Value in_accum() { return operand_source(2); }
  pir::Value in_state() { return operand_source(3); }
  pir::Value out() { return result(0); }
  pir::Value out_scale() { return result(1); }
  pir::Value out_state() { return result(2); }
  pir::Value out_accum() { return result(3); }

};

class  FakeQuantizeRangeAbsMaxOp : public pir::Op<FakeQuantizeRangeAbsMaxOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fake_quantize_range_abs_max"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value in_scale_, pir::Value iter_, int window_size=10000, int bit_length=8, bool is_test=false, int round_type=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value in_scale_, pir::Value iter_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value in_scale() { return operand_source(1); }
  pir::Value iter() { return operand_source(2); }
  pir::Value out() { return result(0); }
  pir::Value out_scale() { return result(1); }
  pir::Value out_scales() { return result(2); }

};

class  FakeQuantizeRangeAbsMax_Op : public pir::Op<FakeQuantizeRangeAbsMax_Op,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fake_quantize_range_abs_max_"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value in_scale_, pir::Value iter_, int window_size=10000, int bit_length=8, bool is_test=false, int round_type=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value in_scale_, pir::Value iter_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value in_scale() { return operand_source(1); }
  pir::Value iter() { return operand_source(2); }
  pir::Value out() { return result(0); }
  pir::Value out_scale() { return result(1); }
  pir::Value out_scales() { return result(2); }

};

class  FftC2cOp : public pir::Op<FftC2cOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fft_c2c"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int64_t>& axes, const std::string& normalization, bool forward);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  FftC2rOp : public pir::Op<FftC2rOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fft_c2r"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int64_t>& axes, const std::string& normalization, bool forward, int64_t last_dim_size=0L);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  FftR2cOp : public pir::Op<FftR2cOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fft_r2c"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int64_t>& axes, const std::string& normalization, bool forward, bool onesided);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  FillOp : public pir::Op<FillOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fill"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float value=0);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value value_);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value value() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  Fill_Op : public pir::Op<Fill_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fill_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float value=0);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value value_);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value value() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  FillDiagonalOp : public pir::Op<FillDiagonalOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fill_diagonal"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float value=0, int offset=0, bool wrap=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  FillDiagonal_Op : public pir::Op<FillDiagonal_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fill_diagonal_"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float value=0, int offset=0, bool wrap=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  FillDiagonalTensorOp : public pir::Op<FillDiagonalTensorOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fill_diagonal_tensor"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, int64_t offset=0, int dim1=0, int dim2=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  FillDiagonalTensor_Op : public pir::Op<FillDiagonalTensor_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fill_diagonal_tensor_"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, int64_t offset=0, int dim1=0, int dim2=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  FlashAttnOp : public pir::Op<FlashAttnOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.flash_attn"; }
  static const char *attributes_name[5];
  static constexpr uint32_t attributes_num = 5;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value q_, pir::Value k_, pir::Value v_, pir::Value fixed_seed_offset_, pir::Value attn_mask_, float dropout=0.0, bool causal=false, bool return_softmax=false, bool is_test=false, const std::string& rng_name="");
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value q_, pir::Value k_, pir::Value v_, pir::Value fixed_seed_offset_, pir::Value attn_mask_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value q() { return operand_source(0); }
  pir::Value k() { return operand_source(1); }
  pir::Value v() { return operand_source(2); }
  pir::Value fixed_seed_offset() { return operand_source(3); }
  pir::Value attn_mask() { return operand_source(4); }
  pir::Value out() { return result(0); }
  pir::Value softmax() { return result(1); }
  pir::Value softmax_lse() { return result(2); }
  pir::Value seed_offset() { return result(3); }

};

class  FlashAttnQkvpackedOp : public pir::Op<FlashAttnQkvpackedOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.flash_attn_qkvpacked"; }
  static const char *attributes_name[5];
  static constexpr uint32_t attributes_num = 5;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value qkv_, pir::Value fixed_seed_offset_, pir::Value attn_mask_, float dropout=0.0, bool causal=false, bool return_softmax=false, bool is_test=false, const std::string& rng_name="");
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value qkv_, pir::Value fixed_seed_offset_, pir::Value attn_mask_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value qkv() { return operand_source(0); }
  pir::Value fixed_seed_offset() { return operand_source(1); }
  pir::Value attn_mask() { return operand_source(2); }
  pir::Value out() { return result(0); }
  pir::Value softmax() { return result(1); }
  pir::Value softmax_lse() { return result(2); }
  pir::Value seed_offset() { return result(3); }

};

class  FlashAttnUnpaddedOp : public pir::Op<FlashAttnUnpaddedOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.flash_attn_unpadded"; }
  static const char *attributes_name[6];
  static constexpr uint32_t attributes_num = 6;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value q_, pir::Value k_, pir::Value v_, pir::Value cu_seqlens_q_, pir::Value cu_seqlens_k_, pir::Value fixed_seed_offset_, pir::Value attn_mask_, int64_t max_seqlen_q, int64_t max_seqlen_k, float scale, float dropout=0.0, bool causal=false, bool return_softmax=false, bool is_test=false, const std::string& rng_name="");
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value q_, pir::Value k_, pir::Value v_, pir::Value cu_seqlens_q_, pir::Value cu_seqlens_k_, pir::Value fixed_seed_offset_, pir::Value attn_mask_, pir::Value max_seqlen_q_, pir::Value max_seqlen_k_, float scale, float dropout=0.0, bool causal=false, bool return_softmax=false, bool is_test=false, const std::string& rng_name="");
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value q_, pir::Value k_, pir::Value v_, pir::Value cu_seqlens_q_, pir::Value cu_seqlens_k_, pir::Value fixed_seed_offset_, pir::Value attn_mask_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value q() { return operand_source(0); }
  pir::Value k() { return operand_source(1); }
  pir::Value v() { return operand_source(2); }
  pir::Value cu_seqlens_q() { return operand_source(3); }
  pir::Value cu_seqlens_k() { return operand_source(4); }
  pir::Value fixed_seed_offset() { return operand_source(5); }
  pir::Value attn_mask() { return operand_source(6); }
  pir::Value max_seqlen_q() { return operand_source(7); }
  pir::Value max_seqlen_k() { return operand_source(8); }
  pir::Value out() { return result(0); }
  pir::Value softmax() { return result(1); }
  pir::Value softmax_lse() { return result(2); }
  pir::Value seed_offset() { return result(3); }

};

class  FlashAttnV3Op : public pir::Op<FlashAttnV3Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.flash_attn_v3"; }
  static const char *attributes_name[9];
  static constexpr uint32_t attributes_num = 9;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value q_, pir::Value k_, pir::Value v_, pir::Value q_v__, pir::Value q_descale__, pir::Value k_descale__, pir::Value v_descale__, float softmax_scale, bool is_causal, int window_size_left, int window_size_right, float softcap, int num_splits, bool manual_set_pack_gqa, bool pack_gqa_, int sm_margin);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value q_, pir::Value k_, pir::Value v_, pir::Value q_v__, pir::Value q_descale__, pir::Value k_descale__, pir::Value v_descale__, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value q() { return operand_source(0); }
  pir::Value k() { return operand_source(1); }
  pir::Value v() { return operand_source(2); }
  pir::Value q_v_() { return operand_source(3); }
  pir::Value q_descale_() { return operand_source(4); }
  pir::Value k_descale_() { return operand_source(5); }
  pir::Value v_descale_() { return operand_source(6); }
  pir::Value out() { return result(0); }
  pir::Value softmax_lse() { return result(1); }

};

class  FlashAttnV3VarlenOp : public pir::Op<FlashAttnV3VarlenOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.flash_attn_v3_varlen"; }
  static const char *attributes_name[11];
  static constexpr uint32_t attributes_num = 11;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value q_, pir::Value k_, pir::Value v_, pir::Value cu_seqlens_q_, pir::Value cu_seqlens_k_, pir::Value seqused_q_, pir::Value seqused_k_, pir::Value qv_, pir::Value q_descale_, pir::Value k_descale_, pir::Value v_descale_, int max_seqlen_q, int max_seqlen_k, float softmax_scale, bool causal, int window_size_left, int window_size_right, float softcap, int num_splits, bool manual_set_pack_gqa, bool pack_gqa, int sm_margin);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value q_, pir::Value k_, pir::Value v_, pir::Value cu_seqlens_q_, pir::Value cu_seqlens_k_, pir::Value seqused_q_, pir::Value seqused_k_, pir::Value qv_, pir::Value q_descale_, pir::Value k_descale_, pir::Value v_descale_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value q() { return operand_source(0); }
  pir::Value k() { return operand_source(1); }
  pir::Value v() { return operand_source(2); }
  pir::Value cu_seqlens_q() { return operand_source(3); }
  pir::Value cu_seqlens_k() { return operand_source(4); }
  pir::Value seqused_q() { return operand_source(5); }
  pir::Value seqused_k() { return operand_source(6); }
  pir::Value qv() { return operand_source(7); }
  pir::Value q_descale() { return operand_source(8); }
  pir::Value k_descale() { return operand_source(9); }
  pir::Value v_descale() { return operand_source(10); }
  pir::Value out() { return result(0); }
  pir::Value softmax_lse() { return result(1); }

};

class  FlashAttnVarlenQkvpackedOp : public pir::Op<FlashAttnVarlenQkvpackedOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.flash_attn_varlen_qkvpacked"; }
  static const char *attributes_name[7];
  static constexpr uint32_t attributes_num = 7;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value qkv_, pir::Value cu_seqlens_q_, pir::Value cu_seqlens_k_, pir::Value fixed_seed_offset_, pir::Value attn_mask_, int64_t max_seqlen_q, int64_t max_seqlen_k, float scale, float dropout=0.0, bool causal=false, bool return_softmax=false, bool is_test=false, const std::string& rng_name="", bool varlen_padded=true);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value qkv_, pir::Value cu_seqlens_q_, pir::Value cu_seqlens_k_, pir::Value fixed_seed_offset_, pir::Value attn_mask_, pir::Value max_seqlen_q_, pir::Value max_seqlen_k_, float scale, float dropout=0.0, bool causal=false, bool return_softmax=false, bool is_test=false, const std::string& rng_name="", bool varlen_padded=true);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value qkv_, pir::Value cu_seqlens_q_, pir::Value cu_seqlens_k_, pir::Value fixed_seed_offset_, pir::Value attn_mask_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value qkv() { return operand_source(0); }
  pir::Value cu_seqlens_q() { return operand_source(1); }
  pir::Value cu_seqlens_k() { return operand_source(2); }
  pir::Value fixed_seed_offset() { return operand_source(3); }
  pir::Value attn_mask() { return operand_source(4); }
  pir::Value max_seqlen_q() { return operand_source(5); }
  pir::Value max_seqlen_k() { return operand_source(6); }
  pir::Value out() { return result(0); }
  pir::Value softmax() { return result(1); }
  pir::Value softmax_lse() { return result(2); }
  pir::Value seed_offset() { return result(3); }

};

class  FlashmaskAttentionOp : public pir::Op<FlashmaskAttentionOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.flashmask_attention"; }
  static const char *attributes_name[5];
  static constexpr uint32_t attributes_num = 5;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value q_, pir::Value k_, pir::Value v_, pir::Value startend_row_indices_, pir::Value fixed_seed_offset_, float dropout=0.0, bool causal=false, bool return_softmax=false, bool is_test=false, const std::string& rng_name="");
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value q_, pir::Value k_, pir::Value v_, pir::Value startend_row_indices_, pir::Value fixed_seed_offset_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value q() { return operand_source(0); }
  pir::Value k() { return operand_source(1); }
  pir::Value v() { return operand_source(2); }
  pir::Value startend_row_indices() { return operand_source(3); }
  pir::Value fixed_seed_offset() { return operand_source(4); }
  pir::Value out() { return result(0); }
  pir::Value softmax() { return result(1); }
  pir::Value softmax_lse() { return result(2); }
  pir::Value seed_offset() { return result(3); }

};

class  FlashmaskAttentionV2Op : public pir::Op<FlashmaskAttentionV2Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.flashmask_attention_v2"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value q_, pir::Value k_, pir::Value v_, pir::Value startend_row_indices_, float softmax_scale, bool is_causal);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value q_, pir::Value k_, pir::Value v_, pir::Value startend_row_indices_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value q() { return operand_source(0); }
  pir::Value k() { return operand_source(1); }
  pir::Value v() { return operand_source(2); }
  pir::Value startend_row_indices() { return operand_source(3); }
  pir::Value out() { return result(0); }
  pir::Value softmax_lse() { return result(1); }

};

class  FlattenOp : public pir::Op<FlattenOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.flatten"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int start_axis=1, int stop_axis=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Flatten_Op : public pir::Op<Flatten_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.flatten_"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int start_axis=1, int stop_axis=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  FlipOp : public pir::Op<FlipOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.flip"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int>& axis);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  FloorOp : public pir::Op<FloorOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.floor"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Floor_Op : public pir::Op<Floor_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.floor_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  FmaxOp : public pir::Op<FmaxOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::BinaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fmax"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  FminOp : public pir::Op<FminOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::BinaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fmin"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  FoldOp : public pir::Op<FoldOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fold"; }
  static const char *attributes_name[5];
  static constexpr uint32_t attributes_num = 5;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int>& output_sizes, const std::vector<int>& kernel_sizes, const std::vector<int>& strides, const std::vector<int>& paddings, const std::vector<int>& dilations);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  FractionalMaxPool2dOp : public pir::Op<FractionalMaxPool2dOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fractional_max_pool2d"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int>& output_size, const std::vector<int>& kernel_size={0, 0}, float random_u=0.0, bool return_mask=true);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }
  pir::Value mask() { return result(1); }

};

class  FractionalMaxPool3dOp : public pir::Op<FractionalMaxPool3dOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fractional_max_pool3d"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int>& output_size, const std::vector<int>& kernel_size={0, 0, 0}, float random_u=0.0, bool return_mask=true);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }
  pir::Value mask() { return result(1); }

};

class  FrameOp : public pir::Op<FrameOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.frame"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int frame_length, int hop_length, int axis=-1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  FrobeniusNormOp : public pir::Op<FrobeniusNormOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.frobenius_norm"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int64_t>& axis, bool keep_dim, bool reduce_all);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value axis_, bool keep_dim, bool reduce_all);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value axis() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  FtrlOp : public pir::Op<FtrlOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.ftrl"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value squared_accumulator_, pir::Value linear_accumulator_, pir::Value grad_, pir::Value learning_rate_, float l1=0.0f, float l2=0.0f, float lr_power=-0.5f);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value squared_accumulator_, pir::Value linear_accumulator_, pir::Value grad_, pir::Value learning_rate_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value squared_accumulator() { return operand_source(1); }
  pir::Value linear_accumulator() { return operand_source(2); }
  pir::Value grad() { return operand_source(3); }
  pir::Value learning_rate() { return operand_source(4); }
  pir::Value param_out() { return result(0); }
  pir::Value squared_accum_out() { return result(1); }
  pir::Value linear_accum_out() { return result(2); }

};

class  FtrlSrOp : public pir::Op<FtrlSrOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.ftrl_sr"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value squared_accumulator_, pir::Value linear_accumulator_, pir::Value grad_, pir::Value learning_rate_, float l1=0.0f, float l2=0.0f, float lr_power=-0.5f);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value squared_accumulator_, pir::Value linear_accumulator_, pir::Value grad_, pir::Value learning_rate_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value squared_accumulator() { return operand_source(1); }
  pir::Value linear_accumulator() { return operand_source(2); }
  pir::Value grad() { return operand_source(3); }
  pir::Value learning_rate() { return operand_source(4); }
  pir::Value param_out() { return result(0); }
  pir::Value squared_accum_out() { return result(1); }
  pir::Value linear_accum_out() { return result(2); }

};

class TEST_API FullOp : public pir::Op<FullOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.full"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, const std::vector<int64_t>& shape, double value, phi::DataType dtype=phi::DataType::FLOAT32, const phi::Place& place=phi::CPUPlace());
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value out() { return result(0); }

};

class  Full_Op : public pir::Op<Full_Op,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.full_"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value output_, const std::vector<int64_t>& shape, double value, phi::DataType dtype=phi::DataType::FLOAT32, const phi::Place& place=phi::CPUPlace());
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value output_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value output() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  FullBatchSizeLikeOp : public pir::Op<FullBatchSizeLikeOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.full_batch_size_like"; }
  static const char *attributes_name[6];
  static constexpr uint32_t attributes_num = 6;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, const std::vector<int>& shape, phi::DataType dtype, double value, int input_dim_idx, int output_dim_idx, const phi::Place& place=phi::CPUPlace());
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class TEST_API FullIntArrayOp : public pir::Op<FullIntArrayOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.full_int_array"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, const std::vector<int64_t>& value, phi::DataType dtype=phi::DataType::FLOAT32, const phi::Place& place=phi::CPUPlace());
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value out() { return result(0); }

};

class  FullLikeOp : public pir::Op<FullLikeOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.full_like"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float value, phi::DataType dtype=phi::DataType::UNDEFINED, const phi::Place& place={});
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value value_, phi::DataType dtype=phi::DataType::UNDEFINED, const phi::Place& place={});
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value value() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  FullWithTensorOp : public pir::Op<FullWithTensorOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.full_with_tensor"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value value_, const std::vector<int64_t>& shape, phi::DataType dtype=phi::DataType::FLOAT32);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value value_, pir::Value shape_, phi::DataType dtype=phi::DataType::FLOAT32);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value value_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value value() { return operand_source(0); }
  pir::Value shape() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  FusedBatchNormActOp : public pir::Op<FusedBatchNormActOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fused_batch_norm_act"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scale_, pir::Value bias_, pir::Value mean_, pir::Value variance_, float momentum, float epsilon, const std::string& act_type);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scale_, pir::Value bias_, pir::Value mean_, pir::Value variance_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value scale() { return operand_source(1); }
  pir::Value bias() { return operand_source(2); }
  pir::Value mean() { return operand_source(3); }
  pir::Value variance() { return operand_source(4); }
  pir::Value out() { return result(0); }
  pir::Value mean_out() { return result(1); }
  pir::Value variance_out() { return result(2); }
  pir::Value saved_mean() { return result(3); }
  pir::Value saved_variance() { return result(4); }
  pir::Value reserve_space() { return result(5); }

};

class  FusedBatchNormAct_Op : public pir::Op<FusedBatchNormAct_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fused_batch_norm_act_"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scale_, pir::Value bias_, pir::Value mean_, pir::Value variance_, float momentum, float epsilon, const std::string& act_type);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scale_, pir::Value bias_, pir::Value mean_, pir::Value variance_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value scale() { return operand_source(1); }
  pir::Value bias() { return operand_source(2); }
  pir::Value mean() { return operand_source(3); }
  pir::Value variance() { return operand_source(4); }
  pir::Value out() { return result(0); }
  pir::Value mean_out() { return result(1); }
  pir::Value variance_out() { return result(2); }
  pir::Value saved_mean() { return result(3); }
  pir::Value saved_variance() { return result(4); }
  pir::Value reserve_space() { return result(5); }

};

class  FusedBnAddActivationOp : public pir::Op<FusedBnAddActivationOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fused_bn_add_activation"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value z_, pir::Value scale_, pir::Value bias_, pir::Value mean_, pir::Value variance_, float momentum, float epsilon, const std::string& act_type);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value z_, pir::Value scale_, pir::Value bias_, pir::Value mean_, pir::Value variance_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value z() { return operand_source(1); }
  pir::Value scale() { return operand_source(2); }
  pir::Value bias() { return operand_source(3); }
  pir::Value mean() { return operand_source(4); }
  pir::Value variance() { return operand_source(5); }
  pir::Value out() { return result(0); }
  pir::Value mean_out() { return result(1); }
  pir::Value variance_out() { return result(2); }
  pir::Value saved_mean() { return result(3); }
  pir::Value saved_variance() { return result(4); }
  pir::Value reserve_space() { return result(5); }

};

class  FusedBnAddActivation_Op : public pir::Op<FusedBnAddActivation_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fused_bn_add_activation_"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value z_, pir::Value scale_, pir::Value bias_, pir::Value mean_, pir::Value variance_, float momentum, float epsilon, const std::string& act_type);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value z_, pir::Value scale_, pir::Value bias_, pir::Value mean_, pir::Value variance_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value z() { return operand_source(1); }
  pir::Value scale() { return operand_source(2); }
  pir::Value bias() { return operand_source(3); }
  pir::Value mean() { return operand_source(4); }
  pir::Value variance() { return operand_source(5); }
  pir::Value out() { return result(0); }
  pir::Value mean_out() { return result(1); }
  pir::Value variance_out() { return result(2); }
  pir::Value saved_mean() { return result(3); }
  pir::Value saved_variance() { return result(4); }
  pir::Value reserve_space() { return result(5); }

};

class  FusedSoftmaxMaskOp : public pir::Op<FusedSoftmaxMaskOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fused_softmax_mask"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value mask_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value mask() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  FusedSoftmaxMaskUpperTriangleOp : public pir::Op<FusedSoftmaxMaskUpperTriangleOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.fused_softmax_mask_upper_triangle"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value X_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value X() { return operand_source(0); }
  pir::Value Out() { return result(0); }

};

class  GammainccOp : public pir::Op<GammainccOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::BinaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.gammaincc"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  Gammaincc_Op : public pir::Op<Gammaincc_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::BinaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.gammaincc_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  GammalnOp : public pir::Op<GammalnOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.gammaln"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Gammaln_Op : public pir::Op<Gammaln_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.gammaln_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  GatherOp : public pir::Op<GatherOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.gather"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_, int axis=0);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_, pir::Value axis_);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value index() { return operand_source(1); }
  pir::Value axis() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  GatherNdOp : public pir::Op<GatherNdOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.gather_nd"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value index() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  GatherTreeOp : public pir::Op<GatherTreeOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.gather_tree"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value ids_, pir::Value parents_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value ids() { return operand_source(0); }
  pir::Value parents() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  GaussianOp : public pir::Op<GaussianOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.gaussian"; }
  static const char *attributes_name[5];
  static constexpr uint32_t attributes_num = 5;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, const std::vector<int64_t>& shape, float mean, float std, int seed, phi::DataType dtype, const phi::Place& place={});
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value shape_, float mean, float std, int seed, phi::DataType dtype, const phi::Place& place={});
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value shape() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  GaussianInplaceOp : public pir::Op<GaussianInplaceOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.gaussian_inplace"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float mean=0, float std=1.0, int seed=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  GaussianInplace_Op : public pir::Op<GaussianInplace_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.gaussian_inplace_"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float mean=0, float std=1.0, int seed=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class TEST_API GeluOp : public pir::Op<GeluOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface,paddle::dialect::CustomVjpTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.gelu"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, bool approximate=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  GenerateProposalsOp : public pir::Op<GenerateProposalsOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.generate_proposals"; }
  static const char *attributes_name[6];
  static constexpr uint32_t attributes_num = 6;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value scores_, pir::Value bbox_deltas_, pir::Value im_shape_, pir::Value anchors_, pir::Value variances_, int pre_nms_top_n, int post_nms_top_n, float nms_thresh, float min_size, float eta, bool pixel_offset=true);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value scores_, pir::Value bbox_deltas_, pir::Value im_shape_, pir::Value anchors_, pir::Value variances_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value scores() { return operand_source(0); }
  pir::Value bbox_deltas() { return operand_source(1); }
  pir::Value im_shape() { return operand_source(2); }
  pir::Value anchors() { return operand_source(3); }
  pir::Value variances() { return operand_source(4); }
  pir::Value rpn_rois() { return result(0); }
  pir::Value rpn_roi_probs() { return result(1); }
  pir::Value rpn_rois_num() { return result(2); }

};

class  GlobalGatherOp : public pir::Op<GlobalGatherOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.global_gather"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value local_count_, pir::Value global_count_, int ring_id=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value local_count_, pir::Value global_count_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value local_count() { return operand_source(1); }
  pir::Value global_count() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  GlobalScatterOp : public pir::Op<GlobalScatterOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.global_scatter"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value local_count_, pir::Value global_count_, int ring_id=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value local_count_, pir::Value global_count_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value local_count() { return operand_source(1); }
  pir::Value global_count() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  GraphKhopSamplerOp : public pir::Op<GraphKhopSamplerOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.graph_khop_sampler"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value row_, pir::Value colptr_, pir::Value x_, pir::Value eids_, const std::vector<int>& sample_sizes, bool return_eids);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value row_, pir::Value colptr_, pir::Value x_, pir::Value eids_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value row() { return operand_source(0); }
  pir::Value colptr() { return operand_source(1); }
  pir::Value x() { return operand_source(2); }
  pir::Value eids() { return operand_source(3); }
  pir::Value out_src() { return result(0); }
  pir::Value out_dst() { return result(1); }
  pir::Value sample_index() { return result(2); }
  pir::Value reindex_x() { return result(3); }
  pir::Value out_eids() { return result(4); }

};

class  GraphSampleNeighborsOp : public pir::Op<GraphSampleNeighborsOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.graph_sample_neighbors"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value row_, pir::Value colptr_, pir::Value x_, pir::Value eids_, pir::Value perm_buffer_, int sample_size, bool return_eids, bool flag_perm_buffer);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value row_, pir::Value colptr_, pir::Value x_, pir::Value eids_, pir::Value perm_buffer_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value row() { return operand_source(0); }
  pir::Value colptr() { return operand_source(1); }
  pir::Value x() { return operand_source(2); }
  pir::Value eids() { return operand_source(3); }
  pir::Value perm_buffer() { return operand_source(4); }
  pir::Value out() { return result(0); }
  pir::Value out_count() { return result(1); }
  pir::Value out_eids() { return result(2); }

};

class  GridSampleOp : public pir::Op<GridSampleOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.grid_sample"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value grid_, const std::string& mode="bilinear", const std::string& padding_mode="zeros", bool align_corners=true);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value grid_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value grid() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  GroupNormOp : public pir::Op<GroupNormOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface,paddle::dialect::CustomVjpTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.group_norm"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scale_, pir::Value bias_, float epsilon=1e-5, int groups=-1, const std::string& data_format="NCHW");
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scale_, pir::Value bias_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value scale() { return operand_source(1); }
  pir::Value bias() { return operand_source(2); }
  pir::Value y() { return result(0); }
  pir::Value mean() { return result(1); }
  pir::Value variance() { return result(2); }

};

class  GruOp : public pir::Op<GruOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.gru"; }
  static const char *attributes_name[5];
  static constexpr uint32_t attributes_num = 5;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value h0_, pir::Value weight_, pir::Value bias_, const std::string& activation="tanh", const std::string& gate_activation="sigmoid", bool is_reverse=false, bool origin_mode=false, bool is_test=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value h0_, pir::Value weight_, pir::Value bias_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value h0() { return operand_source(1); }
  pir::Value weight() { return operand_source(2); }
  pir::Value bias() { return operand_source(3); }
  pir::Value batch_gate() { return result(0); }
  pir::Value batch_reset_hidden_prev() { return result(1); }
  pir::Value batch_hidden() { return result(2); }
  pir::Value hidden() { return result(3); }

};

class  GruUnitOp : public pir::Op<GruUnitOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.gru_unit"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value hidden_prev_, pir::Value weight_, pir::Value bias_, int activation=2, int gate_activation=1, bool origin_mode=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value hidden_prev_, pir::Value weight_, pir::Value bias_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value hidden_prev() { return operand_source(1); }
  pir::Value weight() { return operand_source(2); }
  pir::Value bias() { return operand_source(3); }
  pir::Value gate() { return result(0); }
  pir::Value reset_hidden_prev() { return result(1); }
  pir::Value hidden() { return result(2); }

};

class  GumbelSoftmaxOp : public pir::Op<GumbelSoftmaxOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.gumbel_softmax"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float temperature=1.0, bool hard=false, int axis=-1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  HardshrinkOp : public pir::Op<HardshrinkOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.hardshrink"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float threshold=0.5);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  HardsigmoidOp : public pir::Op<HardsigmoidOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface,pir::UnaryElementWiseTrait,paddle::dialect::CustomVjpTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.hardsigmoid"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float slope=0.2, float offset=0.5);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  HardtanhOp : public pir::Op<HardtanhOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.hardtanh"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float t_min=0, float t_max=24);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Hardtanh_Op : public pir::Op<Hardtanh_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.hardtanh_"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float t_min=0, float t_max=24);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  HeavisideOp : public pir::Op<HeavisideOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface,pir::BinaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.heaviside"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  HingeLossOp : public pir::Op<HingeLossOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.hinge_loss"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value logits_, pir::Value labels_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value logits() { return operand_source(0); }
  pir::Value labels() { return operand_source(1); }
  pir::Value loss() { return result(0); }

};

class  HistogramOp : public pir::Op<HistogramOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.histogram"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value weight_, int64_t bins=100, float min=0.0, float max=0.0, bool density=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value weight_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value weight() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  HsigmoidLossOp : public pir::Op<HsigmoidLossOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.hsigmoid_loss"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value label_, pir::Value w_, pir::Value bias_, pir::Value path_, pir::Value code_, int num_classes, bool is_sparse);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value label_, pir::Value w_, pir::Value bias_, pir::Value path_, pir::Value code_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value label() { return operand_source(1); }
  pir::Value w() { return operand_source(2); }
  pir::Value bias() { return operand_source(3); }
  pir::Value path() { return operand_source(4); }
  pir::Value code() { return operand_source(5); }
  pir::Value out() { return result(0); }
  pir::Value pre_out() { return result(1); }
  pir::Value w_out() { return result(2); }

};

class  HuberLossOp : public pir::Op<HuberLossOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.huber_loss"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value label_, float delta);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value label_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value label() { return operand_source(1); }
  pir::Value out() { return result(0); }
  pir::Value residual() { return result(1); }

};

class  I0Op : public pir::Op<I0Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.i0"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  I0_Op : public pir::Op<I0_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.i0_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  I0eOp : public pir::Op<I0eOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.i0e"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  I1Op : public pir::Op<I1Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.i1"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  I1eOp : public pir::Op<I1eOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.i1e"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  IdentityLossOp : public pir::Op<IdentityLossOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.identity_loss"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int reduction=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  IdentityLoss_Op : public pir::Op<IdentityLoss_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.identity_loss_"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int reduction=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Im2sequenceOp : public pir::Op<Im2sequenceOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.im2sequence"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, const std::vector<int>& kernels, const std::vector<int>& strides={1, 1}, const std::vector<int>& paddings={0, 0, 0, 0}, const std::vector<int>& out_stride={1, 1});
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  ImagOp : public pir::Op<ImagOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.imag"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  IndexAddOp : public pir::Op<IndexAddOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::CustomVjpTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.index_add"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_, pir::Value add_value_, int axis=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_, pir::Value add_value_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value index() { return operand_source(1); }
  pir::Value add_value() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  IndexAdd_Op : public pir::Op<IndexAdd_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::CustomVjpTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.index_add_"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_, pir::Value add_value_, int axis=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_, pir::Value add_value_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value index() { return operand_source(1); }
  pir::Value add_value() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  IndexElementwiseGetOp : public pir::Op<IndexElementwiseGetOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.index_elementwise_get"; }
  static const char *attributes_name[7];
  static constexpr uint32_t attributes_num = 7;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_, const std::vector<int64_t>& input_dims, const std::vector<int64_t>& input_strides, const std::vector<int64_t>& index_dims, const std::vector<int64_t>& index_stride, int64_t slice_offset=0, bool accumulate=true, bool is_combined=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value index() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  IndexElementwisePutOp : public pir::Op<IndexElementwisePutOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.index_elementwise_put"; }
  static const char *attributes_name[6];
  static constexpr uint32_t attributes_num = 6;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_, float value, const std::vector<int64_t>& input_dims, const std::vector<int64_t>& input_strides, const std::vector<int64_t>& index_dims, const std::vector<int64_t>& index_strides, int64_t slice_offset);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value index() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  IndexElementwisePut_Op : public pir::Op<IndexElementwisePut_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.index_elementwise_put_"; }
  static const char *attributes_name[6];
  static constexpr uint32_t attributes_num = 6;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_, float value, const std::vector<int64_t>& input_dims, const std::vector<int64_t>& input_strides, const std::vector<int64_t>& index_dims, const std::vector<int64_t>& index_strides, int64_t slice_offset);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value index() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  IndexElementwisePutWithTensorOp : public pir::Op<IndexElementwisePutWithTensorOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.index_elementwise_put_with_tensor"; }
  static const char *attributes_name[5];
  static constexpr uint32_t attributes_num = 5;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_, pir::Value value_, const std::vector<int64_t>& input_dims, const std::vector<int64_t>& input_strides, const std::vector<int64_t>& index_dims, const std::vector<int64_t>& index_strides, int64_t slice_offset);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_, pir::Value value_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value index() { return operand_source(1); }
  pir::Value value() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  IndexElementwisePutWithTensor_Op : public pir::Op<IndexElementwisePutWithTensor_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.index_elementwise_put_with_tensor_"; }
  static const char *attributes_name[5];
  static constexpr uint32_t attributes_num = 5;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_, pir::Value value_, const std::vector<int64_t>& input_dims, const std::vector<int64_t>& input_strides, const std::vector<int64_t>& index_dims, const std::vector<int64_t>& index_strides, int64_t slice_offset);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_, pir::Value value_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value index() { return operand_source(1); }
  pir::Value value() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  IndexPutOp : public pir::Op<IndexPutOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::CustomVjpTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.index_put"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value indices_, pir::Value value_, bool accumulate=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value indices_, pir::Value value_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value indices() { return operand_source(1); }
  pir::Value value() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  IndexPut_Op : public pir::Op<IndexPut_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::CustomVjpTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.index_put_"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value indices_, pir::Value value_, bool accumulate=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value indices_, pir::Value value_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value indices() { return operand_source(1); }
  pir::Value value() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  IndexSampleOp : public pir::Op<IndexSampleOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.index_sample"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value index() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  IndexSelectOp : public pir::Op<IndexSelectOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.index_select"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_, int axis=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value index() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  IndexSelectStridedOp : public pir::Op<IndexSelectStridedOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.index_select_strided"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int64_t index, int axis=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  InstanceNormOp : public pir::Op<InstanceNormOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface,paddle::dialect::CustomVjpTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.instance_norm"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scale_, pir::Value bias_, float epsilon=1e-5);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scale_, pir::Value bias_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value scale() { return operand_source(1); }
  pir::Value bias() { return operand_source(2); }
  pir::Value y() { return result(0); }
  pir::Value saved_mean() { return result(1); }
  pir::Value saved_variance() { return result(2); }

};

class  InverseOp : public pir::Op<InverseOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.inverse"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  IsEmptyOp : public pir::Op<IsEmptyOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.is_empty"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  IscloseOp : public pir::Op<IscloseOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.isclose"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, double rtol=1e-5, double atol=1e-8, bool equal_nan=false);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::Value rtol_, pir::Value atol_, bool equal_nan=false);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value rtol() { return operand_source(2); }
  pir::Value atol() { return operand_source(3); }
  pir::Value out() { return result(0); }

};

class  IsfiniteOp : public pir::Op<IsfiniteOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.isfinite"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  IsfiniteSrOp : public pir::Op<IsfiniteSrOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.isfinite_sr"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  IsinfOp : public pir::Op<IsinfOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.isinf"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  IsinfSrOp : public pir::Op<IsinfSrOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.isinf_sr"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  IsnanOp : public pir::Op<IsnanOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.isnan"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  IsnanSrOp : public pir::Op<IsnanSrOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.isnan_sr"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  KldivLossOp : public pir::Op<KldivLossOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.kldiv_loss"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value label_, const std::string& reduction="mean", bool log_target=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value label_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value label() { return operand_source(1); }
  pir::Value out() { return result(0); }

};


class  KronOp : public pir::Op<KronOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.kron"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  KthvalueOp : public pir::Op<KthvalueOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.kthvalue"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int64_t k=1, int axis=-1, bool keepdim=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }
  pir::Value indices() { return result(1); }

};

class  L1NormOp : public pir::Op<L1NormOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.l1_norm"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  L1Norm_Op : public pir::Op<L1Norm_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.l1_norm_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  LabelSmoothOp : public pir::Op<LabelSmoothOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.label_smooth"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value label_, pir::Value prior_dist_, float epsilon=0.0f);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value label_, pir::Value prior_dist_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value label() { return operand_source(0); }
  pir::Value prior_dist() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  Lamb_Op : public pir::Op<Lamb_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.lamb_"; }
  static const char *attributes_name[6];
  static constexpr uint32_t attributes_num = 6;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, pir::Value moment1_, pir::Value moment2_, pir::Value beta1_pow_, pir::Value beta2_pow_, pir::Value master_param_, pir::Value skip_update_, float weight_decay, float beta1=0.9, float beta2=0.999, float epsilon=1.0e-6f, bool always_adapt=false, bool multi_precision=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, pir::Value moment1_, pir::Value moment2_, pir::Value beta1_pow_, pir::Value beta2_pow_, pir::Value master_param_, pir::Value skip_update_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value grad() { return operand_source(1); }
  pir::Value learning_rate() { return operand_source(2); }
  pir::Value moment1() { return operand_source(3); }
  pir::Value moment2() { return operand_source(4); }
  pir::Value beta1_pow() { return operand_source(5); }
  pir::Value beta2_pow() { return operand_source(6); }
  pir::Value master_param() { return operand_source(7); }
  pir::Value skip_update() { return operand_source(8); }
  pir::Value param_out() { return result(0); }
  pir::Value moment1_out() { return result(1); }
  pir::Value moment2_out() { return result(2); }
  pir::Value beta1_pow_out() { return result(3); }
  pir::Value beta2_pow_out() { return result(4); }
  pir::Value master_param_outs() { return result(5); }

};

class  LambSr_Op : public pir::Op<LambSr_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.lamb_sr_"; }
  static const char *attributes_name[6];
  static constexpr uint32_t attributes_num = 6;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, pir::Value moment1_, pir::Value moment2_, pir::Value beta1_pow_, pir::Value beta2_pow_, pir::Value master_param_, pir::Value skip_update_, float weight_decay, float beta1=0.9, float beta2=0.999, float epsilon=1.0e-6f, bool always_adapt=false, bool multi_precision=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, pir::Value moment1_, pir::Value moment2_, pir::Value beta1_pow_, pir::Value beta2_pow_, pir::Value master_param_, pir::Value skip_update_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value grad() { return operand_source(1); }
  pir::Value learning_rate() { return operand_source(2); }
  pir::Value moment1() { return operand_source(3); }
  pir::Value moment2() { return operand_source(4); }
  pir::Value beta1_pow() { return operand_source(5); }
  pir::Value beta2_pow() { return operand_source(6); }
  pir::Value master_param() { return operand_source(7); }
  pir::Value skip_update() { return operand_source(8); }
  pir::Value param_out() { return result(0); }
  pir::Value moment1_out() { return result(1); }
  pir::Value moment2_out() { return result(2); }
  pir::Value beta1_pow_out() { return result(3); }
  pir::Value beta2_pow_out() { return result(4); }
  pir::Value master_param_outs() { return result(5); }

};

class TEST_API LayerNormOp : public pir::Op<LayerNormOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface,paddle::dialect::CustomVjpTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.layer_norm"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scale_, pir::Value bias_, float epsilon=1e-5, int begin_norm_axis=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scale_, pir::Value bias_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value scale() { return operand_source(1); }
  pir::Value bias() { return operand_source(2); }
  pir::Value out() { return result(0); }
  pir::Value mean() { return result(1); }
  pir::Value variance() { return result(2); }

};

class  LeakyReluOp : public pir::Op<LeakyReluOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface,pir::UnaryElementWiseTrait,paddle::dialect::CustomVjpTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.leaky_relu"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float negative_slope=0.02f);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  LeakyRelu_Op : public pir::Op<LeakyRelu_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::CustomVjpTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.leaky_relu_"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float negative_slope=0.02f);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  LerpOp : public pir::Op<LerpOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.lerp"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::Value weight_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value weight() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  Lerp_Op : public pir::Op<Lerp_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.lerp_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::Value weight_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value weight() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  LgammaOp : public pir::Op<LgammaOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.lgamma"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Lgamma_Op : public pir::Op<Lgamma_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.lgamma_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  LimitByCapacityOp : public pir::Op<LimitByCapacityOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.limit_by_capacity"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value expert_count_, pir::Value capacity_, int n_worker);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value expert_count_, pir::Value capacity_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value expert_count() { return operand_source(0); }
  pir::Value capacity() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  LinearInterpOp : public pir::Op<LinearInterpOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.linear_interp"; }
  static const char *attributes_name[8];
  static constexpr uint32_t attributes_num = 8;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value out_size_, pir::Value size_tensor_, pir::Value scale_tensor_, const std::string& data_format="NCHW", int out_d=0, int out_h=0, int out_w=0, const std::vector<float>& scale={}, const std::string& interp_method="bilinear", bool align_corners=true, int align_mode=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value out_size_, pir::Value size_tensor_, pir::Value scale_tensor_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out_size() { return operand_source(1); }
  pir::Value size_tensor() { return operand_source(2); }
  pir::Value scale_tensor() { return operand_source(3); }
  pir::Value output() { return result(0); }

};

class  LinspaceOp : public pir::Op<LinspaceOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.linspace"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value start_, pir::Value stop_, pir::Value number_, phi::DataType dtype, const phi::Place& place);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value start_, pir::Value stop_, pir::Value number_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value start() { return operand_source(0); }
  pir::Value stop() { return operand_source(1); }
  pir::Value number() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  LlmInt8LinearOp : public pir::Op<LlmInt8LinearOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.llm_int8_linear"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value weight_, pir::Value bias_, pir::Value weight_scale_, float threshold=6.0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value weight_, pir::Value bias_, pir::Value weight_scale_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value weight() { return operand_source(1); }
  pir::Value bias() { return operand_source(2); }
  pir::Value weight_scale() { return operand_source(3); }
  pir::Value out() { return result(0); }

};

class  LogOp : public pir::Op<LogOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.log"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Log_Op : public pir::Op<Log_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.log_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Log10Op : public pir::Op<Log10Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.log10"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Log10_Op : public pir::Op<Log10_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.log10_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Log1pOp : public pir::Op<Log1pOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.log1p"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Log1p_Op : public pir::Op<Log1p_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.log1p_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Log2Op : public pir::Op<Log2Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.log2"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Log2_Op : public pir::Op<Log2_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.log2_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  LogLossOp : public pir::Op<LogLossOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.log_loss"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value label_, float epsilon);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value label_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value label() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  LogSoftmaxOp : public pir::Op<LogSoftmaxOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.log_softmax"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int axis=-1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  LogcumsumexpOp : public pir::Op<LogcumsumexpOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.logcumsumexp"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int axis=-1, bool flatten=false, bool exclusive=false, bool reverse=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  LogicalAndOp : public pir::Op<LogicalAndOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.logical_and"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  LogicalAnd_Op : public pir::Op<LogicalAnd_Op,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.logical_and_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  LogicalNotOp : public pir::Op<LogicalNotOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.logical_not"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  LogicalNot_Op : public pir::Op<LogicalNot_Op,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.logical_not_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  LogicalOrOp : public pir::Op<LogicalOrOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.logical_or"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  LogicalOr_Op : public pir::Op<LogicalOr_Op,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.logical_or_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  LogicalXorOp : public pir::Op<LogicalXorOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.logical_xor"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  LogicalXor_Op : public pir::Op<LogicalXor_Op,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.logical_xor_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  LogitOp : public pir::Op<LogitOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.logit"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float eps=1e-6f);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Logit_Op : public pir::Op<Logit_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.logit_"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float eps=1e-6f);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  LogsigmoidOp : public pir::Op<LogsigmoidOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.logsigmoid"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  LogspaceOp : public pir::Op<LogspaceOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.logspace"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value start_, pir::Value stop_, pir::Value num_, pir::Value base_, phi::DataType dtype, const phi::Place& place={});
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value start_, pir::Value stop_, pir::Value num_, pir::Value base_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value start() { return operand_source(0); }
  pir::Value stop() { return operand_source(1); }
  pir::Value num() { return operand_source(2); }
  pir::Value base() { return operand_source(3); }
  pir::Value out() { return result(0); }

};

class  LogsumexpOp : public pir::Op<LogsumexpOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.logsumexp"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int>& axis={}, bool keepdim=false, bool reduce_all=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  LookupTableDequantOp : public pir::Op<LookupTableDequantOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.lookup_table_dequant"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value w_, pir::Value ids_, int64_t padding_idx=-1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value w_, pir::Value ids_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value w() { return operand_source(0); }
  pir::Value ids() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  LpPool2dOp : public pir::Op<LpPool2dOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.lp_pool2d"; }
  static const char *attributes_name[11];
  static constexpr uint32_t attributes_num = 11;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int64_t>& kernel_size, const std::vector<int64_t>& strides={1,1}, const std::vector<int64_t>& paddings={0,0}, bool ceil_mode=false, bool exclusive=true, const std::string& data_format="NCHW", const std::string& pooling_type="", bool global_pooling=false, bool adaptive=false, const std::string& padding_algorithm="EXPLICIT", float norm_type=0.0f);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  LstmOp : public pir::Op<LstmOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.lstm"; }
  static const char *attributes_name[6];
  static constexpr uint32_t attributes_num = 6;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value h0_, pir::Value c0_, pir::Value weight_, pir::Value bias_, bool use_peepholes=true, bool is_reverse=false, bool is_test=false, const std::string& gate_activation="sigmoid", const std::string& cell_activation="tanh", const std::string& candidate_activation="tanh");
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value h0_, pir::Value c0_, pir::Value weight_, pir::Value bias_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value h0() { return operand_source(1); }
  pir::Value c0() { return operand_source(2); }
  pir::Value weight() { return operand_source(3); }
  pir::Value bias() { return operand_source(4); }
  pir::Value hidden() { return result(0); }
  pir::Value cell() { return result(1); }
  pir::Value batch_gate() { return result(2); }
  pir::Value batch_cell_pre_act() { return result(3); }

};

class  LstsqOp : public pir::Op<LstsqOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.lstsq"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, float rcond=0.0f, const std::string& driver="gels");
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::Value rcond_, const std::string& driver="gels");
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value rcond() { return operand_source(2); }
  pir::Value solution() { return result(0); }
  pir::Value residuals() { return result(1); }
  pir::Value rank() { return result(2); }
  pir::Value singular_values() { return result(3); }

};

class  LuOp : public pir::Op<LuOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.lu"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, bool pivot=true);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }
  pir::Value pivots() { return result(1); }
  pir::Value infos() { return result(2); }

};

class  Lu_Op : public pir::Op<Lu_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.lu_"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, bool pivot=true);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }
  pir::Value pivots() { return result(1); }
  pir::Value infos() { return result(2); }

};

class  LuSolveOp : public pir::Op<LuSolveOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.lu_solve"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value b_, pir::Value lu_, pir::Value pivots_, const std::string& trans);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value b_, pir::Value lu_, pir::Value pivots_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value b() { return operand_source(0); }
  pir::Value lu() { return operand_source(1); }
  pir::Value pivots() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  LuUnpackOp : public pir::Op<LuUnpackOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.lu_unpack"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, bool unpack_ludata=true, bool unpack_pivots=true);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value pmat() { return result(0); }
  pir::Value l() { return result(1); }
  pir::Value u() { return result(2); }

};

class  MarginCrossEntropyOp : public pir::Op<MarginCrossEntropyOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.margin_cross_entropy"; }
  static const char *attributes_name[8];
  static constexpr uint32_t attributes_num = 8;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value logits_, pir::Value label_, bool return_softmax=false, int ring_id=0, int rank=0, int nranks=1, float margin1=1.0f, float margin2=0.5f, float margin3=0.0f, float scale=64.0f);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value logits_, pir::Value label_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value logits() { return operand_source(0); }
  pir::Value label() { return operand_source(1); }
  pir::Value softmax() { return result(0); }
  pir::Value loss() { return result(1); }

};

class  MaskedFillOp : public pir::Op<MaskedFillOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface,paddle::dialect::CustomVjpTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.masked_fill"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value mask_, pir::Value value_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value mask() { return operand_source(1); }
  pir::Value value() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  MaskedFill_Op : public pir::Op<MaskedFill_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::CustomVjpTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.masked_fill_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value mask_, pir::Value value_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value mask() { return operand_source(1); }
  pir::Value value() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  MaskedMultiheadAttention_Op : public pir::Op<MaskedMultiheadAttention_Op,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.masked_multihead_attention_"; }
  static const char *attributes_name[8];
  static constexpr uint32_t attributes_num = 8;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value cache_kv_, pir::Value bias_, pir::Value src_mask_, pir::Value cum_offsets_, pir::Value sequence_lengths_, pir::Value rotary_tensor_, pir::Value beam_cache_offset_, pir::Value qkv_out_scale_, pir::Value out_shift_, pir::Value out_smooth_, int seq_len, int rotary_emb_dims, bool use_neox_rotary_style=false, const std::string& compute_dtype="default", float out_scale=-1, int quant_round_type=1, float quant_max_bound=127.0, float quant_min_bound=-127.0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value cache_kv_, pir::Value bias_, pir::Value src_mask_, pir::Value cum_offsets_, pir::Value sequence_lengths_, pir::Value rotary_tensor_, pir::Value beam_cache_offset_, pir::Value qkv_out_scale_, pir::Value out_shift_, pir::Value out_smooth_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value cache_kv() { return operand_source(1); }
  pir::Value bias() { return operand_source(2); }
  pir::Value src_mask() { return operand_source(3); }
  pir::Value cum_offsets() { return operand_source(4); }
  pir::Value sequence_lengths() { return operand_source(5); }
  pir::Value rotary_tensor() { return operand_source(6); }
  pir::Value beam_cache_offset() { return operand_source(7); }
  pir::Value qkv_out_scale() { return operand_source(8); }
  pir::Value out_shift() { return operand_source(9); }
  pir::Value out_smooth() { return operand_source(10); }
  pir::Value out() { return result(0); }
  pir::Value cache_kv_out() { return result(1); }
  pir::Value beam_cache_offset_out() { return result(2); }

};

class  MaskedSelectOp : public pir::Op<MaskedSelectOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.masked_select"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value mask_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value mask() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  MatchMatrixTensorOp : public pir::Op<MatchMatrixTensorOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.match_matrix_tensor"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::Value w_, int dim_t=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::Value w_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value w() { return operand_source(2); }
  pir::Value out() { return result(0); }
  pir::Value tmp() { return result(1); }

};

class  MatrixNmsOp : public pir::Op<MatrixNmsOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.matrix_nms"; }
  static const char *attributes_name[8];
  static constexpr uint32_t attributes_num = 8;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value bboxes_, pir::Value scores_, float score_threshold, int nms_top_k, int keep_top_k, float post_threshold=0., bool use_gaussian=false, float gaussian_sigma=2., int background_label=0, bool normalized=true);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value bboxes_, pir::Value scores_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value bboxes() { return operand_source(0); }
  pir::Value scores() { return operand_source(1); }
  pir::Value out() { return result(0); }
  pir::Value index() { return result(1); }
  pir::Value roisnum() { return result(2); }

};

class  MatrixPowerOp : public pir::Op<MatrixPowerOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.matrix_power"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int n);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  MatrixRankOp : public pir::Op<MatrixRankOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.matrix_rank"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float tol, bool use_default_tol=true, bool hermitian=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  MatrixRankAtolRtolOp : public pir::Op<MatrixRankAtolRtolOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.matrix_rank_atol_rtol"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value atol_, pir::Value rtol_, bool hermitian=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value atol_, pir::Value rtol_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value atol() { return operand_source(1); }
  pir::Value rtol() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  MatrixRankTolOp : public pir::Op<MatrixRankTolOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.matrix_rank_tol"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value atol_tensor_, bool use_default_tol=true, bool hermitian=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value atol_tensor_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value atol_tensor() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  MaxOp : public pir::Op<MaxOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.max"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int64_t>& axis={}, bool keepdim=false);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value axis_, bool keepdim=false);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value axis() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  MaxPool2dWithIndexOp : public pir::Op<MaxPool2dWithIndexOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.max_pool2d_with_index"; }
  static const char *attributes_name[6];
  static constexpr uint32_t attributes_num = 6;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int>& kernel_size, const std::vector<int>& strides={1, 1}, const std::vector<int>& paddings={0, 0}, bool global_pooling=false, bool adaptive=false, bool ceil_mode=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }
  pir::Value mask() { return result(1); }

};

class  MaxPool3dWithIndexOp : public pir::Op<MaxPool3dWithIndexOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.max_pool3d_with_index"; }
  static const char *attributes_name[6];
  static constexpr uint32_t attributes_num = 6;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int>& kernel_size, const std::vector<int>& strides={1, 1, 1}, const std::vector<int>& paddings={0, 0, 0}, bool global_pooling=false, bool adaptive=false, bool ceil_mode=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }
  pir::Value mask() { return result(1); }

};

class  MaxWithIndexOp : public pir::Op<MaxWithIndexOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.max_with_index"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int64_t dim, bool keepdim=false, bool flatten=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value values() { return result(0); }
  pir::Value indices() { return result(1); }

};

class  MaxoutOp : public pir::Op<MaxoutOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.maxout"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int groups, int axis=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  MeanOp : public pir::Op<MeanOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface,paddle::dialect::CustomVjpTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.mean"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int64_t>& axis={}, bool keepdim=false);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value axis_, bool keepdim=false);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value axis() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  MeanAllOp : public pir::Op<MeanAllOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.mean_all"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  MedianOp : public pir::Op<MedianOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.median"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int64_t>& axis={}, bool keepdim=true, const std::string& mode="avg");
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }
  pir::Value medians() { return result(1); }

};

class  MemcpyD2hOp : public pir::Op<MemcpyD2hOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.memcpy_d2h"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int dst_place_type);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  MemcpyH2dOp : public pir::Op<MemcpyH2dOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.memcpy_h2d"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int dst_place_type);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  MemoryEfficientAttentionOp : public pir::Op<MemoryEfficientAttentionOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.memory_efficient_attention"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value query_, pir::Value key_, pir::Value value_, pir::Value bias_, pir::Value cu_seqlens_q_, pir::Value cu_seqlens_k_, pir::Value causal_diagonal_, pir::Value seqlen_k_, int64_t max_seqlen_q, int64_t max_seqlen_k, bool causal, double dropout_p, float scale, bool is_test);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value query_, pir::Value key_, pir::Value value_, pir::Value bias_, pir::Value cu_seqlens_q_, pir::Value cu_seqlens_k_, pir::Value causal_diagonal_, pir::Value seqlen_k_, pir::Value max_seqlen_q_, pir::Value max_seqlen_k_, bool causal, double dropout_p, float scale, bool is_test);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value query_, pir::Value key_, pir::Value value_, pir::Value bias_, pir::Value cu_seqlens_q_, pir::Value cu_seqlens_k_, pir::Value causal_diagonal_, pir::Value seqlen_k_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value query() { return operand_source(0); }
  pir::Value key() { return operand_source(1); }
  pir::Value value() { return operand_source(2); }
  pir::Value bias() { return operand_source(3); }
  pir::Value cu_seqlens_q() { return operand_source(4); }
  pir::Value cu_seqlens_k() { return operand_source(5); }
  pir::Value causal_diagonal() { return operand_source(6); }
  pir::Value seqlen_k() { return operand_source(7); }
  pir::Value max_seqlen_q() { return operand_source(8); }
  pir::Value max_seqlen_k() { return operand_source(9); }
  pir::Value output() { return result(0); }
  pir::Value logsumexp() { return result(1); }
  pir::Value seed_and_offset() { return result(2); }

};

class  MergeSelectedRowsOp : public pir::Op<MergeSelectedRowsOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.merge_selected_rows"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  MergedAdam_Op : public pir::Op<MergedAdam_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.merged_adam_"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, pir::Value moment1_, pir::Value moment2_, pir::Value moment2_max_, pir::Value beta1_pow_, pir::Value beta2_pow_, pir::Value master_param_, float beta1=0.9f, float beta2=0.999f, float epsilon=1.0e-8f, bool multi_precision=false, bool use_global_beta_pow=false, bool amsgrad=false);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, pir::Value moment1_, pir::Value moment2_, pir::Value moment2_max_, pir::Value beta1_pow_, pir::Value beta2_pow_, pir::Value master_param_, pir::Value beta1_, pir::Value beta2_, pir::Value epsilon_, bool multi_precision=false, bool use_global_beta_pow=false, bool amsgrad=false);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, pir::Value moment1_, pir::Value moment2_, pir::Value moment2_max_, pir::Value beta1_pow_, pir::Value beta2_pow_, pir::Value master_param_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value grad() { return operand_source(1); }
  pir::Value learning_rate() { return operand_source(2); }
  pir::Value moment1() { return operand_source(3); }
  pir::Value moment2() { return operand_source(4); }
  pir::Value moment2_max() { return operand_source(5); }
  pir::Value beta1_pow() { return operand_source(6); }
  pir::Value beta2_pow() { return operand_source(7); }
  pir::Value master_param() { return operand_source(8); }
  pir::Value beta1() { return operand_source(9); }
  pir::Value beta2() { return operand_source(10); }
  pir::Value epsilon() { return operand_source(11); }
  pir::Value param_out() { return result(0); }
  pir::Value moment1_out() { return result(1); }
  pir::Value moment2_out() { return result(2); }
  pir::Value moment2_max_out() { return result(3); }
  pir::Value beta1_pow_out() { return result(4); }
  pir::Value beta2_pow_out() { return result(5); }
  pir::Value master_param_out() { return result(6); }

};

class  MergedMomentum_Op : public pir::Op<MergedMomentum_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.merged_momentum_"; }
  static const char *attributes_name[6];
  static constexpr uint32_t attributes_num = 6;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value velocity_, pir::Value learning_rate_, pir::Value master_param_, float mu, bool use_nesterov=false, const std::vector<std::string>& regularization_method={}, const std::vector<float>& regularization_coeff={}, bool multi_precision=false, float rescale_grad=1.0f);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value velocity_, pir::Value learning_rate_, pir::Value master_param_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value grad() { return operand_source(1); }
  pir::Value velocity() { return operand_source(2); }
  pir::Value learning_rate() { return operand_source(3); }
  pir::Value master_param() { return operand_source(4); }
  pir::Value param_out() { return result(0); }
  pir::Value velocity_out() { return result(1); }
  pir::Value master_param_out() { return result(2); }

};

class  MeshgridOp : public pir::Op<MeshgridOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.meshgrid"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value inputs_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value inputs() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  MinWithIndexOp : public pir::Op<MinWithIndexOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.min_with_index"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int64_t dim, bool keepdim=false, bool flatten=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value values() { return result(0); }
  pir::Value indices() { return result(1); }

};

class  MishOp : public pir::Op<MishOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.mish"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float lambda);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  ModeOp : public pir::Op<ModeOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.mode"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int axis=-1, bool keepdim=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }
  pir::Value indices() { return result(1); }

};

class  MoeCombineOp : public pir::Op<MoeCombineOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.moe_combine"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value combine_weights_, pir::Value scatter_index_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value combine_weights() { return operand_source(1); }
  pir::Value scatter_index() { return operand_source(2); }
  pir::Value y() { return result(0); }

};

class  MoeCombineAutoOp : public pir::Op<MoeCombineAutoOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.moe_combine_auto"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value combine_weights_, pir::Value scatter_index_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value combine_weights() { return operand_source(1); }
  pir::Value scatter_index() { return operand_source(2); }
  pir::Value y() { return result(0); }

};

class  MoeCombineNoWeightOp : public pir::Op<MoeCombineNoWeightOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.moe_combine_no_weight"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value combine_weight_, pir::Value scatter_index_, float epsilon=1.0e-15);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value combine_weight_, pir::Value scatter_index_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value combine_weight() { return operand_source(1); }
  pir::Value scatter_index() { return operand_source(2); }
  pir::Value y() { return result(0); }

};

class  MoeGateDispatchOp : public pir::Op<MoeGateDispatchOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.moe_gate_dispatch"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value gate_logits_, pir::Value corr_bias_, int64_t k, int64_t capacity, bool use_pad);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value gate_logits_, pir::Value corr_bias_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value gate_logits() { return operand_source(1); }
  pir::Value corr_bias() { return operand_source(2); }
  pir::Value y() { return result(0); }
  pir::Value combine_weights() { return result(1); }
  pir::Value scatter_index() { return result(2); }
  pir::Value expert_offset() { return result(3); }
  pir::Value expert_id() { return result(4); }

};

class  MoeGateDispatchAndQuantOp : public pir::Op<MoeGateDispatchAndQuantOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.moe_gate_dispatch_and_quant"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value gate_logits_, pir::Value corr_bias_, int64_t k, int64_t capacity, bool use_pad, bool use_pow2_scale);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value gate_logits_, pir::Value corr_bias_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value gate_logits() { return operand_source(1); }
  pir::Value corr_bias() { return operand_source(2); }
  pir::Value out_fp8() { return result(0); }
  pir::Value scale() { return result(1); }
  pir::Value combine_weights() { return result(2); }
  pir::Value scatter_index() { return result(3); }
  pir::Value expert_offset() { return result(4); }
  pir::Value expert_id() { return result(5); }

};

class  MoeGateDispatchAutoOp : public pir::Op<MoeGateDispatchAutoOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.moe_gate_dispatch_auto"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value gate_logits_, pir::Value corr_bias_, int64_t k, int64_t capacity, bool use_pad);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value gate_logits_, pir::Value corr_bias_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value gate_logits() { return operand_source(1); }
  pir::Value corr_bias() { return operand_source(2); }
  pir::Value y() { return result(0); }
  pir::Value combine_weights() { return result(1); }
  pir::Value scatter_index() { return result(2); }
  pir::Value expert_offset() { return result(3); }
  pir::Value expert_id() { return result(4); }

};

class  MoeGateDispatchPartialNosoftmaxtopkOp : public pir::Op<MoeGateDispatchPartialNosoftmaxtopkOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.moe_gate_dispatch_partial_nosoftmaxtopk"; }
  static const char *attributes_name[7];
  static constexpr uint32_t attributes_num = 7;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value combine_weights_, pir::Value expert_id_, int64_t k, int64_t capacity, int64_t num_experts, bool use_pad, int64_t expert_start_index, int64_t expert_end_index, bool reverse_token_drop);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value combine_weights_, pir::Value expert_id_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value combine_weights() { return operand_source(1); }
  pir::Value expert_id() { return operand_source(2); }
  pir::Value y() { return result(0); }
  pir::Value combine_weights_out() { return result(1); }
  pir::Value scatter_index() { return result(2); }
  pir::Value scatter_index_rev() { return result(3); }
  pir::Value expert_offset() { return result(4); }
  pir::Value expert_nums_local() { return result(5); }

};

class  MoeGateDispatchPermuteOp : public pir::Op<MoeGateDispatchPermuteOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.moe_gate_dispatch_permute"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value gate_logits_, pir::Value corr_bias_, int64_t k, int64_t capacity, int64_t world_size);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value gate_logits_, pir::Value corr_bias_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value gate_logits() { return operand_source(1); }
  pir::Value corr_bias() { return operand_source(2); }
  pir::Value y() { return result(0); }
  pir::Value combine_weights() { return result(1); }
  pir::Value scatter_index() { return result(2); }
  pir::Value expert_offset() { return result(3); }
  pir::Value expert_id() { return result(4); }

};

class  MoePermuteOp : public pir::Op<MoePermuteOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.moe_permute"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value hidden_states_, pir::Value scale_, pir::Value expert_routemap_topk_, pir::Value expert_prob_topk_, int num_experts, const std::vector<int>& tokens_per_expert, int padding_alignment, bool do_gather);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value hidden_states_, pir::Value scale_, pir::Value expert_routemap_topk_, pir::Value expert_prob_topk_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value hidden_states() { return operand_source(0); }
  pir::Value scale() { return operand_source(1); }
  pir::Value expert_routemap_topk() { return operand_source(2); }
  pir::Value expert_prob_topk() { return operand_source(3); }
  pir::Value hidden_states_unzipped() { return result(0); }
  pir::Value zipped_expertwise_rowmap() { return result(1); }
  pir::Value token_prob_unzipped() { return result(2); }
  pir::Value scale_unzipped() { return result(3); }

};

class  MoeUnpermuteOp : public pir::Op<MoeUnpermuteOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.moe_unpermute"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value hidden_states_unzipped_, pir::Value zipped_expertwise_rowmap_, pir::Value expert_routemap_topk_, pir::Value token_prob_unzipped_, int total_zipped_tokens_num, int num_experts, bool use_mix_precision);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value hidden_states_unzipped_, pir::Value zipped_expertwise_rowmap_, pir::Value expert_routemap_topk_, pir::Value token_prob_unzipped_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value hidden_states_unzipped() { return operand_source(0); }
  pir::Value zipped_expertwise_rowmap() { return operand_source(1); }
  pir::Value expert_routemap_topk() { return operand_source(2); }
  pir::Value token_prob_unzipped() { return operand_source(3); }
  pir::Value hidden_states() { return result(0); }
  pir::Value expert_prob_topk() { return result(1); }

};

class  Momentum_Op : public pir::Op<Momentum_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.momentum_"; }
  static const char *attributes_name[6];
  static constexpr uint32_t attributes_num = 6;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value velocity_, pir::Value learning_rate_, pir::Value master_param_, float mu, bool use_nesterov=false, const std::string& regularization_method="", float regularization_coeff=0.0f, bool multi_precision=false, float rescale_grad=1.0f);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value velocity_, pir::Value learning_rate_, pir::Value master_param_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value grad() { return operand_source(1); }
  pir::Value velocity() { return operand_source(2); }
  pir::Value learning_rate() { return operand_source(3); }
  pir::Value master_param() { return operand_source(4); }
  pir::Value param_out() { return result(0); }
  pir::Value velocity_out() { return result(1); }
  pir::Value master_param_out() { return result(2); }

};

class  MomentumDenseParamSparseGrad_Op : public pir::Op<MomentumDenseParamSparseGrad_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.momentum_dense_param_sparse_grad_"; }
  static const char *attributes_name[6];
  static constexpr uint32_t attributes_num = 6;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value velocity_, pir::Value learning_rate_, pir::Value master_param_, float mu, bool use_nesterov=false, const std::string& regularization_method="", float regularization_coeff=0.0f, bool multi_precision=false, float rescale_grad=1.0f);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value velocity_, pir::Value learning_rate_, pir::Value master_param_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value grad() { return operand_source(1); }
  pir::Value velocity() { return operand_source(2); }
  pir::Value learning_rate() { return operand_source(3); }
  pir::Value master_param() { return operand_source(4); }
  pir::Value param_out() { return result(0); }
  pir::Value velocity_out() { return result(1); }
  pir::Value master_param_out() { return result(2); }

};

class  MpAllreduceSumOp : public pir::Op<MpAllreduceSumOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.mp_allreduce_sum"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int ring_id=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  MpAllreduceSum_Op : public pir::Op<MpAllreduceSum_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.mp_allreduce_sum_"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int ring_id=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  MultiDotOp : public pir::Op<MultiDotOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.multi_dot"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  MulticlassNms3Op : public pir::Op<MulticlassNms3Op,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.multiclass_nms3"; }
  static const char *attributes_name[7];
  static constexpr uint32_t attributes_num = 7;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value bboxes_, pir::Value scores_, pir::Value rois_num_, float score_threshold, int nms_top_k, int keep_top_k, float nms_threshold=0.3, bool normalized=true, float nms_eta=1.0, int background_label=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value bboxes_, pir::Value scores_, pir::Value rois_num_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value bboxes() { return operand_source(0); }
  pir::Value scores() { return operand_source(1); }
  pir::Value rois_num() { return operand_source(2); }
  pir::Value out() { return result(0); }
  pir::Value index() { return result(1); }
  pir::Value nms_rois_num() { return result(2); }

};

class  MultinomialOp : public pir::Op<MultinomialOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.multinomial"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int num_samples=1, bool replacement=false);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value num_samples_, bool replacement=false);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value num_samples() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  MultiplexOp : public pir::Op<MultiplexOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.multiplex"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value inputs_, pir::Value index_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value inputs() { return operand_source(0); }
  pir::Value index() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  MvOp : public pir::Op<MvOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.mv"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value vec_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value vec() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  Nadam_Op : public pir::Op<Nadam_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.nadam_"; }
  static const char *attributes_name[5];
  static constexpr uint32_t attributes_num = 5;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, pir::Value momentum_decay_pow_, pir::Value beta2_pow_, pir::Value mu_product_, pir::Value moment1_, pir::Value moment2_, pir::Value master_param_, float beta1=0.9f, float beta2=0.999f, float epsilon=1.0e-8f, float momentum_decay=0.004f, bool multi_precision=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, pir::Value momentum_decay_pow_, pir::Value beta2_pow_, pir::Value mu_product_, pir::Value moment1_, pir::Value moment2_, pir::Value master_param_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value grad() { return operand_source(1); }
  pir::Value learning_rate() { return operand_source(2); }
  pir::Value momentum_decay_pow() { return operand_source(3); }
  pir::Value beta2_pow() { return operand_source(4); }
  pir::Value mu_product() { return operand_source(5); }
  pir::Value moment1() { return operand_source(6); }
  pir::Value moment2() { return operand_source(7); }
  pir::Value master_param() { return operand_source(8); }
  pir::Value param_out() { return result(0); }
  pir::Value momentum_decay_pow_out() { return result(1); }
  pir::Value beta2_pow_out() { return result(2); }
  pir::Value mu_product_out() { return result(3); }
  pir::Value moment1_out() { return result(4); }
  pir::Value moment2_out() { return result(5); }
  pir::Value master_param_out() { return result(6); }

};

class  NanmedianOp : public pir::Op<NanmedianOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.nanmedian"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int64_t>& axis={}, bool keepdim=true, const std::string& mode="avg");
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }
  pir::Value medians() { return result(1); }

};

class  NearestInterpOp : public pir::Op<NearestInterpOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.nearest_interp"; }
  static const char *attributes_name[8];
  static constexpr uint32_t attributes_num = 8;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value out_size_, pir::Value size_tensor_, pir::Value scale_tensor_, const std::string& data_format="NCHW", int out_d=0, int out_h=0, int out_w=0, const std::vector<float>& scale={}, const std::string& interp_method="bilinear", bool align_corners=true, int align_mode=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value out_size_, pir::Value size_tensor_, pir::Value scale_tensor_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out_size() { return operand_source(1); }
  pir::Value size_tensor() { return operand_source(2); }
  pir::Value scale_tensor() { return operand_source(3); }
  pir::Value output() { return result(0); }

};

class  NextafterOp : public pir::Op<NextafterOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,pir::BinaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.nextafter"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  NllLossOp : public pir::Op<NllLossOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.nll_loss"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value label_, pir::Value weight_, int64_t ignore_index=-100, const std::string& reduction="mean");
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value label_, pir::Value weight_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value label() { return operand_source(1); }
  pir::Value weight() { return operand_source(2); }
  pir::Value out() { return result(0); }
  pir::Value total_weight() { return result(1); }

};

class  NmsOp : public pir::Op<NmsOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.nms"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float threshold=1.0f);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  NonzeroOp : public pir::Op<NonzeroOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.nonzero"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value condition_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value condition() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  NormOp : public pir::Op<NormOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.norm"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int axis, float epsilon, bool is_test);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }
  pir::Value norm() { return result(1); }

};

class  NpuIdentityOp : public pir::Op<NpuIdentityOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.npu_identity"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int format=-1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  NumelOp : public pir::Op<NumelOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.numel"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value size() { return result(0); }

};

class  OneHotOp : public pir::Op<OneHotOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.one_hot"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int num_classes);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value num_classes_);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value num_classes() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  OnesOp : public pir::Op<OnesOp,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.ones"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, const std::vector<int64_t>& shape, phi::DataType dtype=phi::DataType::FLOAT32, const phi::Place& place=phi::CPUPlace());
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);

  pir::Value out() { return result(0); }

};

class  OnesLikeOp : public pir::Op<OnesLikeOp,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.ones_like"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, phi::DataType dtype=phi::DataType::UNDEFINED, const phi::Place& place={});
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);

  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  OverlapAddOp : public pir::Op<OverlapAddOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.overlap_add"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int hop_length, int axis=-1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  PNormOp : public pir::Op<PNormOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface,paddle::dialect::CustomVjpTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.p_norm"; }
  static const char *attributes_name[5];
  static constexpr uint32_t attributes_num = 5;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float porder=2, int axis=-1, float epsilon=1.0e-12f, bool keepdim=false, bool asvector=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  PadOp : public pir::Op<PadOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.pad"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int>& paddings, float pad_value);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value pad_value_, const std::vector<int>& paddings);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value pad_value() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  Pad3dOp : public pir::Op<Pad3dOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.pad3d"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int64_t>& paddings, const std::string& mode="constant", float pad_value=0.0, const std::string& data_format="NCDHW");
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value paddings_, const std::string& mode="constant", float pad_value=0.0, const std::string& data_format="NCDHW");
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value paddings() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  PartialAllgatherOp : public pir::Op<PartialAllgatherOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.partial_allgather"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int nranks, int rank, int ring_id=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  PartialAllgather_Op : public pir::Op<PartialAllgather_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.partial_allgather_"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int nranks, int rank, int ring_id=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  PartialConcatOp : public pir::Op<PartialConcatOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.partial_concat"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int start_index=0, int length=-1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  PartialSumOp : public pir::Op<PartialSumOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.partial_sum"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int start_index=0, int length=-1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  PixelShuffleOp : public pir::Op<PixelShuffleOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.pixel_shuffle"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int upscale_factor=1, const std::string& data_format="NCHW");
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  PixelUnshuffleOp : public pir::Op<PixelUnshuffleOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.pixel_unshuffle"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int downscale_factor=1, const std::string& data_format="NCHW");
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  PoissonOp : public pir::Op<PoissonOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.poisson"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  PolygammaOp : public pir::Op<PolygammaOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.polygamma"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int n);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Polygamma_Op : public pir::Op<Polygamma_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.polygamma_"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int n);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Pool2dOp : public pir::Op<Pool2dOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.pool2d"; }
  static const char *attributes_name[9];
  static constexpr uint32_t attributes_num = 9;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int64_t>& kernel_size, const std::vector<int64_t>& strides, const std::vector<int64_t>& paddings, bool ceil_mode, bool exclusive, const std::string& data_format, const std::string& pooling_type, bool global_pooling, bool adaptive, const std::string& padding_algorithm);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value kernel_size_, const std::vector<int64_t>& strides, const std::vector<int64_t>& paddings, bool ceil_mode, bool exclusive, const std::string& data_format, const std::string& pooling_type, bool global_pooling, bool adaptive, const std::string& padding_algorithm);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value kernel_size() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  Pool3dOp : public pir::Op<Pool3dOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.pool3d"; }
  static const char *attributes_name[10];
  static constexpr uint32_t attributes_num = 10;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int64_t>& kernel_size, const std::vector<int64_t>& strides, const std::vector<int64_t>& paddings, bool ceil_mode, bool exclusive, const std::string& data_format, const std::string& pooling_type, bool global_pooling, bool adaptive, const std::string& padding_algorithm);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  PowOp : public pir::Op<PowOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.pow"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float y=1.0f);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Pow_Op : public pir::Op<Pow_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.pow_"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float y=1.0f);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  PreluOp : public pir::Op<PreluOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.prelu"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value alpha_, const std::string& data_format="NCHW", const std::string& mode="all");
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value alpha_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value alpha() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  PriorBoxOp : public pir::Op<PriorBoxOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.prior_box"; }
  static const char *attributes_name[10];
  static constexpr uint32_t attributes_num = 10;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value image_, const std::vector<float>& min_sizes, const std::vector<float>& max_sizes={}, const std::vector<float>& aspect_ratios={}, const std::vector<float>& variances={}, bool flip=true, bool clip=true, float step_w=0.0, float step_h=0.0, float offset=0.5, bool min_max_aspect_ratios_order=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value image_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value image() { return operand_source(1); }
  pir::Value out() { return result(0); }
  pir::Value var() { return result(1); }

};

class  ProdOp : public pir::Op<ProdOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.prod"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int64_t>& axis, bool keepdim, bool reduce_all);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value axis_, bool keepdim, bool reduce_all);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value axis() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  PruneGateByCapacityOp : public pir::Op<PruneGateByCapacityOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.prune_gate_by_capacity"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value gate_idx_, pir::Value expert_count_, int64_t n_expert=0, int64_t n_worker=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value gate_idx_, pir::Value expert_count_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value gate_idx() { return operand_source(0); }
  pir::Value expert_count() { return operand_source(1); }
  pir::Value out_gate_idx() { return result(0); }

};

class  PsroiPoolOp : public pir::Op<PsroiPoolOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.psroi_pool"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value boxes_, pir::Value boxes_num_, int pooled_height=1, int pooled_width=1, int output_channels=1, float spatial_scale=1.0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value boxes_, pir::Value boxes_num_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value boxes() { return operand_source(1); }
  pir::Value boxes_num() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  PutAlongAxisOp : public pir::Op<PutAlongAxisOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.put_along_axis"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value arr_, pir::Value indices_, pir::Value values_, int axis, const std::string& reduce="assign", bool include_self=true);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value arr_, pir::Value indices_, pir::Value values_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value arr() { return operand_source(0); }
  pir::Value indices() { return operand_source(1); }
  pir::Value values() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  PutAlongAxis_Op : public pir::Op<PutAlongAxis_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.put_along_axis_"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value arr_, pir::Value indices_, pir::Value values_, int axis, const std::string& reduce="assign", bool include_self=true);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value arr_, pir::Value indices_, pir::Value values_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value arr() { return operand_source(0); }
  pir::Value indices() { return operand_source(1); }
  pir::Value values() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  PyramidHashOp : public pir::Op<PyramidHashOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.pyramid_hash"; }
  static const char *attributes_name[12];
  static constexpr uint32_t attributes_num = 12;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value w_, pir::Value white_list_, pir::Value black_list_, int num_emb=0, int space_len=0, int pyramid_layer=2, int rand_len=0, float drop_out_percent=0, int is_training=0, bool use_filter=true, int white_list_len=0, int black_list_len=0, int seed=0, float lr=0.0, const std::string& distribute_update_vars="");
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value w_, pir::Value white_list_, pir::Value black_list_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value w() { return operand_source(1); }
  pir::Value white_list() { return operand_source(2); }
  pir::Value black_list() { return operand_source(3); }
  pir::Value out() { return result(0); }
  pir::Value drop_pos() { return result(1); }
  pir::Value x_temp_out() { return result(2); }

};

class  QrOp : public pir::Op<QrOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.qr"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::string& mode="reduced");
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value q() { return result(0); }
  pir::Value r() { return result(1); }

};

class  Radam_Op : public pir::Op<Radam_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.radam_"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, pir::Value beta1_pow_, pir::Value beta2_pow_, pir::Value rho_, pir::Value moment1_, pir::Value moment2_, pir::Value master_param_, float beta1=0.9f, float beta2=0.999f, float epsilon=1.0e-8f, bool multi_precision=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value learning_rate_, pir::Value beta1_pow_, pir::Value beta2_pow_, pir::Value rho_, pir::Value moment1_, pir::Value moment2_, pir::Value master_param_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value grad() { return operand_source(1); }
  pir::Value learning_rate() { return operand_source(2); }
  pir::Value beta1_pow() { return operand_source(3); }
  pir::Value beta2_pow() { return operand_source(4); }
  pir::Value rho() { return operand_source(5); }
  pir::Value moment1() { return operand_source(6); }
  pir::Value moment2() { return operand_source(7); }
  pir::Value master_param() { return operand_source(8); }
  pir::Value param_out() { return result(0); }
  pir::Value beta1_pow_out() { return result(1); }
  pir::Value beta2_pow_out() { return result(2); }
  pir::Value rho_out() { return result(3); }
  pir::Value moment1_out() { return result(4); }
  pir::Value moment2_out() { return result(5); }
  pir::Value master_param_out() { return result(6); }

};

class  RandintOp : public pir::Op<RandintOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.randint"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, int low, int high, const std::vector<int64_t>& shape, phi::DataType dtype=phi::DataType::INT64, const phi::Place& place={});
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value shape_, int low, int high, phi::DataType dtype=phi::DataType::INT64, const phi::Place& place={});
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value shape() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  RandomRoutingOp : public pir::Op<RandomRoutingOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.random_routing"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value prob_, pir::Value topk_value_, pir::Value topk_idx_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value prob() { return operand_source(0); }
  pir::Value topk_value() { return operand_source(1); }
  pir::Value topk_idx() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  RandomRouting_Op : public pir::Op<RandomRouting_Op,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.random_routing_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value prob_, pir::Value topk_value_, pir::Value topk_idx_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value prob() { return operand_source(0); }
  pir::Value topk_value() { return operand_source(1); }
  pir::Value topk_idx() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  RandpermOp : public pir::Op<RandpermOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.randperm"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, int n, phi::DataType dtype, const phi::Place& place={});
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value out() { return result(0); }

};

class  RankAttentionOp : public pir::Op<RankAttentionOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.rank_attention"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value rank_offset_, pir::Value rank_param_, int max_rank=3, int max_size=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value rank_offset_, pir::Value rank_param_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value rank_offset() { return operand_source(1); }
  pir::Value rank_param() { return operand_source(2); }
  pir::Value input_help() { return result(0); }
  pir::Value out() { return result(1); }
  pir::Value ins_rank() { return result(2); }

};

class  ReadFileOp : public pir::Op<ReadFileOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.read_file"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, const std::string& filename="", phi::DataType dtype=phi::DataType::UINT8, const phi::Place& place=phi::CPUPlace());
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value out() { return result(0); }

};

class  RealOp : public pir::Op<RealOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.real"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  ReciprocalOp : public pir::Op<ReciprocalOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.reciprocal"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Reciprocal_Op : public pir::Op<Reciprocal_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.reciprocal_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  ReduceOp : public pir::Op<ReduceOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.reduce"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int ring_id=0, int root_id=0, int reduce_type=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Reduce_Op : public pir::Op<Reduce_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.reduce_"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int ring_id=0, int root_id=0, int reduce_type=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  ReduceAsOp : public pir::Op<ReduceAsOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.reduce_as"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value target_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value target() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  ReduceScatterOp : public pir::Op<ReduceScatterOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.reduce_scatter"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int ring_id=0, int nranks=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  ReindexGraphOp : public pir::Op<ReindexGraphOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.reindex_graph"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value neighbors_, pir::Value count_, pir::Value hashtable_value_, pir::Value hashtable_index_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value neighbors() { return operand_source(1); }
  pir::Value count() { return operand_source(2); }
  pir::Value hashtable_value() { return operand_source(3); }
  pir::Value hashtable_index() { return operand_source(4); }
  pir::Value reindex_src() { return result(0); }
  pir::Value reindex_dst() { return result(1); }
  pir::Value out_nodes() { return result(2); }

};


class TEST_API ReluOp : public pir::Op<ReluOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface,pir::UnaryElementWiseTrait,paddle::dialect::CustomVjpTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.relu"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Relu_Op : public pir::Op<Relu_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::CustomVjpTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.relu_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Relu6Op : public pir::Op<Relu6Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface,pir::UnaryElementWiseTrait,paddle::dialect::CustomVjpTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.relu6"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  RenormOp : public pir::Op<RenormOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.renorm"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float p, int axis, float max_norm);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Renorm_Op : public pir::Op<Renorm_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.renorm_"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float p, int axis, float max_norm);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  RepeatInterleaveOp : public pir::Op<RepeatInterleaveOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.repeat_interleave"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int repeats, int axis, int64_t output_size=-1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  RepeatInterleaveWithTensorIndexOp : public pir::Op<RepeatInterleaveWithTensorIndexOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.repeat_interleave_with_tensor_index"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value repeats_, int axis, int64_t output_size=-1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value repeats_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value repeats() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class TEST_API ReshapeOp : public pir::Op<ReshapeOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.reshape"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int64_t>& shape);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value shape_);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value shape() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  Reshape_Op : public pir::Op<Reshape_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.reshape_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int64_t>& shape);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value shape_);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value shape() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  RestrictNonzeroOp : public pir::Op<RestrictNonzeroOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.restrict_nonzero"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value condition_, int64_t total_true_num);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value condition_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value condition() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  ReverseOp : public pir::Op<ReverseOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.reverse"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int64_t>& axis);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value axis_);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value axis() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  RintOp : public pir::Op<RintOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.rint"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Rint_Op : public pir::Op<Rint_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.rint_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  RmsNormOp : public pir::Op<RmsNormOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.rms_norm"; }
  static const char *attributes_name[6];
  static constexpr uint32_t attributes_num = 6;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value bias_, pir::Value residual_, pir::Value norm_weight_, pir::Value norm_bias_, float epsilon, int begin_norm_axis, float quant_scale, int quant_round_type, float quant_max_bound, float quant_min_bound);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value bias_, pir::Value residual_, pir::Value norm_weight_, pir::Value norm_bias_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value bias() { return operand_source(1); }
  pir::Value residual() { return operand_source(2); }
  pir::Value norm_weight() { return operand_source(3); }
  pir::Value norm_bias() { return operand_source(4); }
  pir::Value out() { return result(0); }
  pir::Value residual_out() { return result(1); }
  pir::Value inv_var() { return result(2); }

};

class  Rmsprop_Op : public pir::Op<Rmsprop_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.rmsprop_"; }
  static const char *attributes_name[5];
  static constexpr uint32_t attributes_num = 5;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value mean_square_, pir::Value grad_, pir::Value moment_, pir::Value learning_rate_, pir::Value mean_grad_, pir::Value master_param_, float epsilon=1.0e-10f, float decay=0.9f, float momentum=0.0f, bool centered=false, bool multi_precision=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value mean_square_, pir::Value grad_, pir::Value moment_, pir::Value learning_rate_, pir::Value mean_grad_, pir::Value master_param_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value mean_square() { return operand_source(1); }
  pir::Value grad() { return operand_source(2); }
  pir::Value moment() { return operand_source(3); }
  pir::Value learning_rate() { return operand_source(4); }
  pir::Value mean_grad() { return operand_source(5); }
  pir::Value master_param() { return operand_source(6); }
  pir::Value param_out() { return result(0); }
  pir::Value moment_out() { return result(1); }
  pir::Value mean_square_out() { return result(2); }
  pir::Value mean_grad_out() { return result(3); }
  pir::Value master_param_outs() { return result(4); }

};

class  RmspropDenseParamSparseGrad_Op : public pir::Op<RmspropDenseParamSparseGrad_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.rmsprop_dense_param_sparse_grad_"; }
  static const char *attributes_name[5];
  static constexpr uint32_t attributes_num = 5;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value mean_square_, pir::Value grad_, pir::Value moment_, pir::Value learning_rate_, pir::Value mean_grad_, pir::Value master_param_, float epsilon=1.0e-10f, float decay=0.9f, float momentum=0.0f, bool centered=false, bool multi_precision=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value mean_square_, pir::Value grad_, pir::Value moment_, pir::Value learning_rate_, pir::Value mean_grad_, pir::Value master_param_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value mean_square() { return operand_source(1); }
  pir::Value grad() { return operand_source(2); }
  pir::Value moment() { return operand_source(3); }
  pir::Value learning_rate() { return operand_source(4); }
  pir::Value mean_grad() { return operand_source(5); }
  pir::Value master_param() { return operand_source(6); }
  pir::Value param_out() { return result(0); }
  pir::Value moment_out() { return result(1); }
  pir::Value mean_square_out() { return result(2); }
  pir::Value mean_grad_out() { return result(3); }
  pir::Value master_param_outs() { return result(4); }

};

class  RnnOp : public pir::Op<RnnOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.rnn"; }
  static const char *attributes_name[8];
  static constexpr uint32_t attributes_num = 8;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value pre_state_, pir::Value weight_list_, pir::Value sequence_length_, pir::Value dropout_state_in_, float dropout_prob=0.0, bool is_bidirec=false, int input_size=10, int hidden_size=100, int num_layers=1, const std::string& mode="RNN_TANH", int seed=0, bool is_test=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value pre_state_, pir::Value weight_list_, pir::Value sequence_length_, pir::Value dropout_state_in_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value pre_state() { return operand_source(1); }
  pir::Value weight_list() { return operand_source(2); }
  pir::Value sequence_length() { return operand_source(3); }
  pir::Value dropout_state_in() { return operand_source(4); }
  pir::Value out() { return result(0); }
  pir::Value dropout_state_out() { return result(1); }
  pir::Value state() { return result(2); }
  pir::Value reserve() { return result(3); }

};

class  Rnn_Op : public pir::Op<Rnn_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.rnn_"; }
  static const char *attributes_name[8];
  static constexpr uint32_t attributes_num = 8;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value pre_state_, pir::Value weight_list_, pir::Value sequence_length_, pir::Value dropout_state_in_, float dropout_prob=0.0, bool is_bidirec=false, int input_size=10, int hidden_size=100, int num_layers=1, const std::string& mode="RNN_TANH", int seed=0, bool is_test=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value pre_state_, pir::Value weight_list_, pir::Value sequence_length_, pir::Value dropout_state_in_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value pre_state() { return operand_source(1); }
  pir::Value weight_list() { return operand_source(2); }
  pir::Value sequence_length() { return operand_source(3); }
  pir::Value dropout_state_in() { return operand_source(4); }
  pir::Value out() { return result(0); }
  pir::Value dropout_state_out() { return result(1); }
  pir::Value state() { return result(2); }
  pir::Value reserve() { return result(3); }

};

class  RoiAlignOp : public pir::Op<RoiAlignOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.roi_align"; }
  static const char *attributes_name[5];
  static constexpr uint32_t attributes_num = 5;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value boxes_, pir::Value boxes_num_, int pooled_height=1, int pooled_width=1, float spatial_scale=1.0, int sampling_ratio=-1, bool aligned=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value boxes_, pir::Value boxes_num_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value boxes() { return operand_source(1); }
  pir::Value boxes_num() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  RoiPoolOp : public pir::Op<RoiPoolOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.roi_pool"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value boxes_, pir::Value boxes_num_, int pooled_height=1, int pooled_width=1, float spatial_scale=1.0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value boxes_, pir::Value boxes_num_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value boxes() { return operand_source(1); }
  pir::Value boxes_num() { return operand_source(2); }
  pir::Value out() { return result(0); }
  pir::Value arg_max() { return result(1); }

};

class  RollOp : public pir::Op<RollOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.roll"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int64_t>& shifts={}, const std::vector<int64_t>& axis={});
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value shifts_, const std::vector<int64_t>& axis={});
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value shifts() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  RoundOp : public pir::Op<RoundOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.round"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int decimals=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Round_Op : public pir::Op<Round_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.round_"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int decimals=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Rprop_Op : public pir::Op<Rprop_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.rprop_"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value prev_, pir::Value learning_rate_, pir::Value master_param_, pir::Value learning_rate_range_, pir::Value etas_, bool multi_precision=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value grad_, pir::Value prev_, pir::Value learning_rate_, pir::Value master_param_, pir::Value learning_rate_range_, pir::Value etas_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value grad() { return operand_source(1); }
  pir::Value prev() { return operand_source(2); }
  pir::Value learning_rate() { return operand_source(3); }
  pir::Value master_param() { return operand_source(4); }
  pir::Value learning_rate_range() { return operand_source(5); }
  pir::Value etas() { return operand_source(6); }
  pir::Value param_out() { return result(0); }
  pir::Value prev_out() { return result(1); }
  pir::Value learning_rate_out() { return result(2); }
  pir::Value master_param_out() { return result(3); }

};

class  RreluOp : public pir::Op<RreluOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.rrelu"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float lower=1.0f/8, float upper=1.0f/3, bool is_test=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }
  pir::Value noise() { return result(1); }

};

class  RsqrtOp : public pir::Op<RsqrtOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.rsqrt"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Rsqrt_Op : public pir::Op<Rsqrt_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.rsqrt_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class TEST_API ScaleOp : public pir::Op<ScaleOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.scale"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float scale=1.0, float bias=0.0, bool bias_after_scale=true);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scale_, float bias=0.0, bool bias_after_scale=true);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value scale() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  ScaleSrOp : public pir::Op<ScaleSrOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.scale_sr"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float scale=1.0, float bias=0.0, bool bias_after_scale=true);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scale_, float bias=0.0, bool bias_after_scale=true);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value scale() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  Scale_Op : public pir::Op<Scale_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.scale_"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float scale=1.0, float bias=0.0, bool bias_after_scale=true);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scale_, float bias=0.0, bool bias_after_scale=true);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value scale() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  ScaleSr_Op : public pir::Op<ScaleSr_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.scale_sr_"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float scale=1.0, float bias=0.0, bool bias_after_scale=true);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value scale_, float bias=0.0, bool bias_after_scale=true);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value scale() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  ScatterOp : public pir::Op<ScatterOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.scatter"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_, pir::Value updates_, bool overwrite=true);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_, pir::Value updates_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value index() { return operand_source(1); }
  pir::Value updates() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  Scatter_Op : public pir::Op<Scatter_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.scatter_"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_, pir::Value updates_, bool overwrite=true);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_, pir::Value updates_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value index() { return operand_source(1); }
  pir::Value updates() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  ScatterNdAddOp : public pir::Op<ScatterNdAddOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.scatter_nd_add"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value index_, pir::Value updates_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value index() { return operand_source(1); }
  pir::Value updates() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  SearchsortedOp : public pir::Op<SearchsortedOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.searchsorted"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value sorted_sequence_, pir::Value values_, bool out_int32=false, bool right=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value sorted_sequence_, pir::Value values_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value sorted_sequence() { return operand_source(0); }
  pir::Value values() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  SegmentPoolOp : public pir::Op<SegmentPoolOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.segment_pool"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value segment_ids_, const std::string& pooltype="SUM");
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value segment_ids_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value segment_ids() { return operand_source(1); }
  pir::Value out() { return result(0); }
  pir::Value summed_ids() { return result(1); }

};

class  SeluOp : public pir::Op<SeluOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.selu"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float scale=1.0507009873554804934193349852946, float alpha=1.6732632423543772848170429916717);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  SendURecvOp : public pir::Op<SendURecvOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.send_u_recv"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value src_index_, pir::Value dst_index_, const std::string& reduce_op="SUM", const std::vector<int64_t>& out_size={0});
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value src_index_, pir::Value dst_index_, pir::Value out_size_, const std::string& reduce_op="SUM");
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value src_index_, pir::Value dst_index_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value src_index() { return operand_source(1); }
  pir::Value dst_index() { return operand_source(2); }
  pir::Value out_size() { return operand_source(3); }
  pir::Value out() { return result(0); }
  pir::Value dst_count() { return result(1); }

};

class  SendUeRecvOp : public pir::Op<SendUeRecvOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.send_ue_recv"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::Value src_index_, pir::Value dst_index_, const std::string& message_op="ADD", const std::string& reduce_op="SUM", const std::vector<int64_t>& out_size={0});
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::Value src_index_, pir::Value dst_index_, pir::Value out_size_, const std::string& message_op="ADD", const std::string& reduce_op="SUM");
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::Value src_index_, pir::Value dst_index_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value src_index() { return operand_source(2); }
  pir::Value dst_index() { return operand_source(3); }
  pir::Value out_size() { return operand_source(4); }
  pir::Value out() { return result(0); }
  pir::Value dst_count() { return result(1); }

};

class  SendUvOp : public pir::Op<SendUvOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.send_uv"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::Value src_index_, pir::Value dst_index_, const std::string& message_op="ADD");
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_, pir::Value src_index_, pir::Value dst_index_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value src_index() { return operand_source(2); }
  pir::Value dst_index() { return operand_source(3); }
  pir::Value out() { return result(0); }

};

class  SequenceConvOp : public pir::Op<SequenceConvOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.sequence_conv"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value padding_data_, pir::Value filter_, int context_length, bool padding_trainable=false, int context_start=0, int context_stride=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value padding_data_, pir::Value filter_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value padding_data() { return operand_source(1); }
  pir::Value filter() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  SequenceMaskOp : public pir::Op<SequenceMaskOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.sequence_mask"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int max_len, phi::DataType out_dtype);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value max_len_, phi::DataType out_dtype);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value max_len() { return operand_source(1); }
  pir::Value y() { return result(0); }

};

class  SequencePoolOp : public pir::Op<SequencePoolOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.sequence_pool"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, bool is_test=false, const std::string& pooltype="AVERAGE", float pad_value=0.0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }
  pir::Value max_index() { return result(1); }

};

class  SetOp : public pir::Op<SetOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.set"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value source_, const std::vector<int64_t>& dims={}, const std::vector<int64_t>& stride={}, int64_t offset=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value source_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value source() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  Set_Op : public pir::Op<Set_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.set_"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value source_, const std::vector<int64_t>& dims={}, const std::vector<int64_t>& stride={}, int64_t offset=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value source_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value source() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  SetValueWithTensorOp : public pir::Op<SetValueWithTensorOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.set_value_with_tensor"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value values_, const std::vector<int64_t>& starts, const std::vector<int64_t>& ends, const std::vector<int64_t>& steps, const std::vector<int64_t>& axes, const std::vector<int64_t>& decrease_axes, const std::vector<int64_t>& none_axes);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value values_, pir::Value starts_, pir::Value ends_, pir::Value steps_, const std::vector<int64_t>& axes, const std::vector<int64_t>& decrease_axes, const std::vector<int64_t>& none_axes);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value values_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value values() { return operand_source(1); }
  pir::Value starts() { return operand_source(2); }
  pir::Value ends() { return operand_source(3); }
  pir::Value steps() { return operand_source(4); }
  pir::Value out() { return result(0); }

};

class  SetValueWithTensor_Op : public pir::Op<SetValueWithTensor_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.set_value_with_tensor_"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value values_, const std::vector<int64_t>& starts, const std::vector<int64_t>& ends, const std::vector<int64_t>& steps, const std::vector<int64_t>& axes, const std::vector<int64_t>& decrease_axes, const std::vector<int64_t>& none_axes);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value values_, pir::Value starts_, pir::Value ends_, pir::Value steps_, const std::vector<int64_t>& axes, const std::vector<int64_t>& decrease_axes, const std::vector<int64_t>& none_axes);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value values_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value values() { return operand_source(1); }
  pir::Value starts() { return operand_source(2); }
  pir::Value ends() { return operand_source(3); }
  pir::Value steps() { return operand_source(4); }
  pir::Value out() { return result(0); }

};

class  Sgd_Op : public pir::Op<Sgd_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.sgd_"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value learning_rate_, pir::Value grad_, pir::Value master_param_, bool multi_precision=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value learning_rate_, pir::Value grad_, pir::Value master_param_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value learning_rate() { return operand_source(1); }
  pir::Value grad() { return operand_source(2); }
  pir::Value master_param() { return operand_source(3); }
  pir::Value param_out() { return result(0); }
  pir::Value master_param_out() { return result(1); }

};

class  SgdDenseParamSparseGrad_Op : public pir::Op<SgdDenseParamSparseGrad_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.sgd_dense_param_sparse_grad_"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value learning_rate_, pir::Value grad_, pir::Value master_param_, bool multi_precision=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value learning_rate_, pir::Value grad_, pir::Value master_param_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value learning_rate() { return operand_source(1); }
  pir::Value grad() { return operand_source(2); }
  pir::Value master_param() { return operand_source(3); }
  pir::Value param_out() { return result(0); }
  pir::Value master_param_out() { return result(1); }

};

class  SgdSparseParamSparseGrad_Op : public pir::Op<SgdSparseParamSparseGrad_Op,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait,paddle::dialect::ForwardOnlyTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.sgd_sparse_param_sparse_grad_"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value learning_rate_, pir::Value grad_, pir::Value master_param_, bool multi_precision=false);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value param_, pir::Value learning_rate_, pir::Value grad_, pir::Value master_param_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value param() { return operand_source(0); }
  pir::Value learning_rate() { return operand_source(1); }
  pir::Value grad() { return operand_source(2); }
  pir::Value master_param() { return operand_source(3); }
  pir::Value param_out() { return result(0); }
  pir::Value master_param_out() { return result(1); }

};

class  ShapeOp : public pir::Op<ShapeOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.shape"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  ShapeSrOp : public pir::Op<ShapeSrOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.shape_sr"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Shape64Op : public pir::Op<Shape64Op,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.shape64"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Shape64SrOp : public pir::Op<Shape64SrOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.shape64_sr"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  ShardIndexOp : public pir::Op<ShardIndexOp,paddle::dialect::InferMetaInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.shard_index"; }
  static const char *attributes_name[4];
  static constexpr uint32_t attributes_num = 4;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, int index_num, int nshards, int shard_id, int ignore_value=-1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);



  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  ShareDataOp : public pir::Op<ShareDataOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.share_data"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  ShareDataSrOp : public pir::Op<ShareDataSrOp,paddle::dialect::InferMetaInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::ForwardOnlyTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.share_data_sr"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);





  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  ShuffleBatchOp : public pir::Op<ShuffleBatchOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::SideEffectTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.shuffle_batch"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value seed_, int startup_seed=0);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value seed_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value seed() { return operand_source(1); }
  pir::Value out() { return result(0); }
  pir::Value shuffle_idx() { return result(1); }
  pir::Value seed_out() { return result(2); }

};

class  ShuffleChannelOp : public pir::Op<ShuffleChannelOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.shuffle_channel"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int group=1);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  SigmoidOp : public pir::Op<SigmoidOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.sigmoid"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Sigmoid_Op : public pir::Op<Sigmoid_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.sigmoid_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  SigmoidCrossEntropyWithLogitsOp : public pir::Op<SigmoidCrossEntropyWithLogitsOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.sigmoid_cross_entropy_with_logits"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value label_, pir::Value pos_weight_, bool normalize=false, int ignore_index=-100);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value label_, pir::Value pos_weight_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value label() { return operand_source(1); }
  pir::Value pos_weight() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  SigmoidCrossEntropyWithLogits_Op : public pir::Op<SigmoidCrossEntropyWithLogits_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.sigmoid_cross_entropy_with_logits_"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value label_, pir::Value pos_weight_, bool normalize=false, int ignore_index=-100);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value label_, pir::Value pos_weight_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value label() { return operand_source(1); }
  pir::Value pos_weight() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  SignOp : public pir::Op<SignOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.sign"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  SiluOp : public pir::Op<SiluOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface,pir::UnaryElementWiseTrait,paddle::dialect::CustomVjpTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.silu"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Silu_Op : public pir::Op<Silu_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::CustomVjpTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.silu_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  SinOp : public pir::Op<SinOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.sin"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Sin_Op : public pir::Op<Sin_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.sin_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  SinhOp : public pir::Op<SinhOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.sinh"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Sinh_Op : public pir::Op<Sinh_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.sinh_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  SliceOp : public pir::Op<SliceOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.slice"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, const std::vector<int64_t>& axes, const std::vector<int64_t>& starts, const std::vector<int64_t>& ends, const std::vector<int64_t>& infer_flags, const std::vector<int64_t>& decrease_axis);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::Value starts_, pir::Value ends_, const std::vector<int64_t>& axes, const std::vector<int64_t>& infer_flags, const std::vector<int64_t>& decrease_axis);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value input_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value input() { return operand_source(0); }
  pir::Value starts() { return operand_source(1); }
  pir::Value ends() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  SlogdetOp : public pir::Op<SlogdetOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.slogdet"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  SoftplusOp : public pir::Op<SoftplusOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.softplus"; }
  static const char *attributes_name[2];
  static constexpr uint32_t attributes_num = 2;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float beta=1.0, float threshold=20.0f);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  SoftshrinkOp : public pir::Op<SoftshrinkOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.softshrink"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, float threshold=0.5);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  SoftsignOp : public pir::Op<SoftsignOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface,pir::UnaryElementWiseTrait,paddle::dialect::CustomVjpTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.softsign"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  SolveOp : public pir::Op<SolveOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.solve"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value y_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value y() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  SparseAttentionOp : public pir::Op<SparseAttentionOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.sparse_attention"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value q_, pir::Value k_, pir::Value v_, pir::Value offset_, pir::Value columns_, pir::Value key_padding_mask_, pir::Value attn_mask_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value q() { return operand_source(0); }
  pir::Value k() { return operand_source(1); }
  pir::Value v() { return operand_source(2); }
  pir::Value offset() { return operand_source(3); }
  pir::Value columns() { return operand_source(4); }
  pir::Value key_padding_mask() { return operand_source(5); }
  pir::Value attn_mask() { return operand_source(6); }
  pir::Value out() { return result(0); }
  pir::Value sparse_dot_sdd() { return result(1); }
  pir::Value softmax() { return result(2); }

};

class  SpectralNormOp : public pir::Op<SpectralNormOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.spectral_norm"; }
  static const char *attributes_name[3];
  static constexpr uint32_t attributes_num = 3;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value weight_, pir::Value u_, pir::Value v_, int dim=0, int power_iters=1, float eps=1e-12f);
  
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value weight_, pir::Value u_, pir::Value v_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value weight() { return operand_source(0); }
  pir::Value u() { return operand_source(1); }
  pir::Value v() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  SplitOp : public pir::Op<SplitOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.split"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int64_t>& sections, int axis);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value sections_, pir::Value axis_);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value sections() { return operand_source(1); }
  pir::Value axis() { return operand_source(2); }
  pir::Value out() { return result(0); }

};

class  SplitWithNumOp : public pir::Op<SplitWithNumOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::GetKernelTypeForVarInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.split_with_num"; }
  static const char *attributes_name[1];
  static constexpr uint32_t attributes_num = 1;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, int num, int axis);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value axis_, int num);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::AttributeMap attributes);
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value axis() { return operand_source(1); }
  pir::Value out() { return result(0); }

};

class  SqrtOp : public pir::Op<SqrtOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.sqrt"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  SqrtSrOp : public pir::Op<SqrtSrOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.sqrt_sr"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Sqrt_Op : public pir::Op<Sqrt_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.sqrt_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  SqrtSr_Op : public pir::Op<SqrtSr_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.sqrt_sr_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  SquareOp : public pir::Op<SquareOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.square"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  SquareSrOp : public pir::Op<SquareSrOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.square_sr"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  Square_Op : public pir::Op<Square_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.square_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  SquareSr_Op : public pir::Op<SquareSr_Op,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,pir::UnaryElementWiseTrait,paddle::dialect::InplaceTrait> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.square_sr_"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  SquaredL2NormOp : public pir::Op<SquaredL2NormOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.squared_l2_norm"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_);
  
  
  
  void VerifySig();

  static phi::DataType GetKernelTypeForVar(
      const std::string& var_name,
        const phi::DataType& tensor_dtype,
        const phi::DataType& expected_kernel_dtype);



  bool InferSymbolicShape(pir::InferSymbolicShapeContext *infer_context);

  void CacheGradOpSymbolicShape(pir::InferSymbolicShapeContext* infer_context);

  static std::vector<std::vector<pir::Value>> Vjp(pir::Operation* op, const std::vector<std::vector<pir::Value>>& inputs_, const std::vector<std::vector<pir::Value>>& outputs, const std::vector<std::vector<pir::Value>>& out_grads, const std::vector<std::vector<bool>>& stop_gradients);
  static std::vector<std::vector<pir::Value>> Decomp(pir::Operation* op);
  static void InferMeta(phi::InferMetaContext *infer_meta );
  static std::vector<pir::Type> InferMeta( const std::vector<pir::Value>& input_values, pir::AttributeMap* p_attributes );
  pir::Value x() { return operand_source(0); }
  pir::Value out() { return result(0); }

};

class  SqueezeOp : public pir::Op<SqueezeOp,paddle::dialect::InferMetaInterface,paddle::dialect::VjpInterface,paddle::dialect::InferSymbolicShapeInterface,paddle::dialect::LayoutTransformationInterface,paddle::dialect::OpYamlInfoInterface,paddle::dialect::CacheGradOpSymbolicShapeInterface,paddle::dialect::GetKernelTypeForVarInterface,paddle::dialect::DecompInterface> {
 public:
  using Op::Op;
  static const char *name() { return "pd_op.squeeze"; }
  static constexpr const char **attributes_name = nullptr;
  static constexpr uint32_t attributes_num = 0;
  static OpInfoTuple GetOpInfo();
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, const std::vector<int64_t>& axis={});
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, pir::Value x_, pir::Value axis_);
  static void Build(pir::Builder &builder, pir::OperationArgument &argument, p