/* Copyright (c) 2023 PaddlePaddle Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. */

#pragma once

#include "paddle/phi/core/dense_tensor.h"

namespace phi {

template <typename T, typename Context>
void CheckNumericsKernel(const Context& dev_ctx,
                         const DenseTensor& tensor,
                         const std::string& op_type,
                         const std::string& var_name,
                         const int check_nan_inf_level,
                         const int stack_height_limit,
                         const std::string& output_dir,
                         DenseTensor* stats,
                         DenseTensor* values);

#ifdef _WIN32
#define INSTANTIATE_CHECKNUMBERICS_KERNEL(type, context)       \
  template PADDLE_API void CheckNumericsKernel<type, context>( \
      const context&,                                          \
      const DenseTensor&,                                      \
      const std::string&,                                      \
      const std::string&,                                      \
      const int,                                               \
      const int,                                               \
      const std::string&,                                      \
      DenseTensor*,                                            \
      DenseTensor*);
#endif
}  // namespace phi
