# This file was autogenerated by genconsts.py
#
# LINSTOR - management of distributed storage/DRBD9 resources
# Copyright (C) 2017 - 2023  LINBIT HA-Solutions GmbH
# All Rights Reserved.
# Author: Robert Altnoeder, Roland Kammerer, Gabor Hernadi, Rene Peinthor
#
#   Licensed under the Apache License, Version 2.0 (the "License"); you may
#   not use this file except in compliance with the License. You may obtain
#   a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#   WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#   License for the specific language governing permissions and limitations
#   under the License.
import sys
from enum import Enum

if sys.version_info > (3,):
    long = int


# ## Bits 62 - 63 (most significant 2) are reserved for the message type masks (error, warning, info)
# Bits 25 - 26 are reserved for the operation type masks (create, modify, delete)
# Bits 18 - 22 are reserved for the object type masks (node, resource, resource definition, ...)
# Bits 0  - 14 are reserved for codes ###
MASK_BITS_TYPE = long(0xC000000000000000)
MASK_ERROR = long(0xC000000000000000)
MASK_WARN = long(0x8000000000000000)
MASK_INFO = long(0x4000000000000000)
MASK_SUCCESS = long(0x0000000000000000)


# ## Operation type masks ###
MASK_BITS_OP = long(0x0000000003000000)
MASK_CRT = long(0x0000000001000000)
MASK_MOD = long(0x0000000002000000)
MASK_DEL = long(0x0000000003000000)


# ## Type masks (Node, ResDfn, Res, VolDfn, Vol, NetInterface, ...) ###
MASK_BITS_OBJ = long(0x00000000007C0000)
MASK_SCHEDULE = long(0x0000000000540000)
MASK_EXT_FILES = long(0x0000000000500000)
MASK_PHYSICAL_DEVICE = long(0x00000000004C0000)
MASK_VLM_GRP = long(0x0000000000480000)
MASK_RSC_GRP = long(0x0000000000440000)
MASK_KVS = long(0x0000000000400000)
MASK_NODE = long(0x00000000003C0000)
MASK_RSC_DFN = long(0x0000000000380000)
MASK_RSC = long(0x0000000000340000)
MASK_VLM_DFN = long(0x0000000000300000)
MASK_VLM = long(0x00000000002C0000)
MASK_NODE_CONN = long(0x0000000000280000)
MASK_RSC_CONN = long(0x0000000000240000)
MASK_VLM_CONN = long(0x0000000000200000)
MASK_NET_IF = long(0x00000000001C0000)
MASK_STOR_POOL_DFN = long(0x0000000000180000)
MASK_STOR_POOL = long(0x0000000000140000)
MASK_CTRL_CONF = long(0x0000000000100000)
MASK_SNAPSHOT = long(0x00000000000C0000)
MASK_BACKUP = long(0x0000000000080000)
MASK_REMOTE = long(0x0000000000040000)


# ## Codes ###
MASK_BITS_CODE = long(0x0000000000007FFF)


# ## Codes 1-9: success ###
CREATED = long(1 | MASK_SUCCESS)
DELETED = long(2 | MASK_SUCCESS)
MODIFIED = long(3 | MASK_SUCCESS)
PASSPHRASE_ACCEPTED = long(4 | MASK_SUCCESS)


# ## Codes 100 - 999: failures ###


# ## Codes 100 - 199: sql failures ###
FAIL_SQL = long(100 | MASK_ERROR)
FAIL_SQL_ROLLBACK = long(101 | MASK_ERROR)


# ## Codes 200-299: invalid * failures ###
FAIL_INVLD_NODE_NAME = long(200 | MASK_ERROR)
FAIL_INVLD_NODE_TYPE = long(201 | MASK_ERROR)
FAIL_INVLD_RSC_NAME = long(202 | MASK_ERROR)
FAIL_INVLD_RSC_PORT = long(203 | MASK_ERROR)
FAIL_INVLD_NODE_ID = long(204 | MASK_ERROR)
FAIL_INVLD_VLM_NR = long(205 | MASK_ERROR)
FAIL_INVLD_VLM_SIZE = long(206 | MASK_ERROR)
FAIL_INVLD_MINOR_NR = long(207 | MASK_ERROR)
FAIL_INVLD_STOR_POOL_NAME = long(208 | MASK_ERROR)
FAIL_INVLD_NET_NAME = long(209 | MASK_ERROR)
FAIL_INVLD_NET_ADDR = long(210 | MASK_ERROR)
FAIL_INVLD_NET_PORT = long(211 | MASK_ERROR)
FAIL_INVLD_NET_TYPE = long(212 | MASK_ERROR)
FAIL_INVLD_PROP = long(213 | MASK_ERROR)
FAIL_INVLD_TRANSPORT_TYPE = long(214 | MASK_ERROR)
FAIL_INVLD_TCP_PORT = long(215 | MASK_ERROR)
FAIL_INVLD_CRYPT_PASSPHRASE = long(216 | MASK_ERROR)
FAIL_INVLD_ENCRYPT_TYPE = long(217 | MASK_ERROR)
FAIL_INVLD_SNAPSHOT_NAME = long(218 | MASK_ERROR)
FAIL_INVLD_PLACE_COUNT = long(219 | MASK_ERROR)
FAIL_INVLD_FREE_SPACE_MGR_NAME = long(220 | MASK_ERROR)
FAIL_INVLD_STOR_DRIVER = long(221 | MASK_ERROR)
FAIL_INVLD_DRBD_PROXY_COMPRESSION_TYPE = long(222 | MASK_ERROR)
FAIL_INVLD_KVS_NAME = long(223 | MASK_ERROR)
FAIL_INVLD_LAYER_KIND = long(224 | MASK_ERROR)
FAIL_INVLD_LAYER_STACK = long(225 | MASK_ERROR)
FAIL_INVLD_EXT_NAME = long(226 | MASK_ERROR)
FAIL_INVLD_PROVIDER = long(227 | MASK_ERROR)
FAIL_INVLD_VLM_SIZES = long(228 | MASK_ERROR)
FAIL_INVLD_VLM_COUNT = long(229 | MASK_ERROR)
FAIL_INVLD_CONF = long(230 | MASK_ERROR)
FAIL_INVLD_SNAPSHOT_SHIPPING_SOURCE = long(231 | MASK_ERROR)
FAIL_INVLD_SNAPSHOT_SHIPPING_TARGET = long(232 | MASK_ERROR)
FAIL_NODE_HAS_USED_RSC = long(233 | MASK_ERROR)
FAIL_INVLD_REQUEST = long(234 | MASK_ERROR)
FAIL_INVLD_EXT_FILE_NAME = long(235 | MASK_ERROR)
FAIL_INVLD_EXT_FILE = long(236 | MASK_ERROR)
FAIL_INVLD_RSC_GRP_NAME = long(237 | MASK_ERROR)
FAIL_INVLD_BACKUP_CONFIG = long(238 | MASK_ERROR)
FAIL_INVLD_REMOTE_NAME = long(239 | MASK_ERROR)
FAIL_INVLD_TIME_PARAM = long(240 | MASK_ERROR)
FAIL_INVLD_SCHEDULE_NAME = long(241 | MASK_ERROR)


# ## Codes 300-399: dependency not found failures ###
FAIL_NOT_FOUND_NODE = long(300 | MASK_ERROR)
FAIL_NOT_FOUND_RSC_DFN = long(301 | MASK_ERROR)
FAIL_NOT_FOUND_RSC = long(302 | MASK_ERROR)
FAIL_NOT_FOUND_VLM_DFN = long(303 | MASK_ERROR)
FAIL_NOT_FOUND_VLM = long(304 | MASK_ERROR)
FAIL_NOT_FOUND_NET_IF = long(305 | MASK_ERROR)
FAIL_NOT_FOUND_NODE_CONN = long(306 | MASK_ERROR)
FAIL_NOT_FOUND_RSC_CONN = long(307 | MASK_ERROR)
FAIL_NOT_FOUND_VLM_CONN = long(308 | MASK_ERROR)
FAIL_NOT_FOUND_STOR_POOL_DFN = long(309 | MASK_ERROR)
FAIL_NOT_FOUND_STOR_POOL = long(310 | MASK_ERROR)
FAIL_NOT_FOUND_DFLT_STOR_POOL = long(311 | MASK_ERROR)
FAIL_NOT_FOUND_CRYPT_KEY = long(312 | MASK_ERROR)
FAIL_NOT_FOUND_SNAPSHOT_DFN = long(313 | MASK_ERROR)
FAIL_NOT_FOUND_SNAPSHOT_VLM_DFN = long(314 | MASK_ERROR)
FAIL_NOT_FOUND_SNAPSHOT = long(315 | MASK_ERROR)
FAIL_NOT_FOUND_KVS = long(316 | MASK_ERROR)
FAIL_NOT_FOUND_RSC_GRP = long(317 | MASK_ERROR)
FAIL_NOT_FOUND_VLM_GRP = long(318 | MASK_ERROR)
FAIL_NOT_FOUND_EXOS_ENCLOSURE = long(319 | MASK_ERROR)
FAIL_NOT_FOUND_EXT_FILE = long(320 | MASK_ERROR)
FAIL_NOT_FOUND_REMOTE = long(321 | MASK_ERROR)
FAIL_NOT_FOUND_BACKUP = long(322 | MASK_ERROR)
FAIL_NOT_FOUND_SCHEDULE = long(323 | MASK_ERROR)


# ## Codes 400-499: access denied failures ###
FAIL_ACC_DENIED_NODE = long(400 | MASK_ERROR)
FAIL_ACC_DENIED_RSC_DFN = long(401 | MASK_ERROR)
FAIL_ACC_DENIED_RSC = long(402 | MASK_ERROR)
FAIL_ACC_DENIED_VLM_DFN = long(403 | MASK_ERROR)
FAIL_ACC_DENIED_VLM = long(404 | MASK_ERROR)
FAIL_ACC_DENIED_STOR_POOL_DFN = long(405 | MASK_ERROR)
FAIL_ACC_DENIED_STOR_POOL = long(406 | MASK_ERROR)
FAIL_ACC_DENIED_NODE_CONN = long(407 | MASK_ERROR)
FAIL_ACC_DENIED_RSC_CONN = long(408 | MASK_ERROR)
FAIL_ACC_DENIED_VLM_CONN = long(409 | MASK_ERROR)
FAIL_ACC_DENIED_STLT_CONN = long(410 | MASK_ERROR)
FAIL_ACC_DENIED_CTRL_CFG = long(411 | MASK_ERROR)
FAIL_ACC_DENIED_COMMAND = long(412 | MASK_ERROR)
FAIL_ACC_DENIED_WATCH = long(413 | MASK_ERROR)
FAIL_ACC_DENIED_SNAPSHOT_DFN = long(414 | MASK_ERROR)
FAIL_ACC_DENIED_SNAPSHOT = long(415 | MASK_ERROR)
FAIL_ACC_DENIED_SNAPSHOT_VLM_DFN = long(416 | MASK_ERROR)
FAIL_ACC_DENIED_FREE_SPACE_MGR = long(417 | MASK_ERROR)
FAIL_ACC_DENIED_KVS = long(418 | MASK_ERROR)
FAIL_ACC_DENIED_RSC_GRP = long(419 | MASK_ERROR)
FAIL_ACC_DENIED_VLM_GRP = long(420 | MASK_ERROR)
FAIL_ACC_DENIED_SNAP_DFN = long(421 | MASK_ERROR)
FAIL_ACC_DENIED_EXT_FILE = long(422 | MASK_ERROR)
FAIL_ACC_DENIED_REMOTE = long(423 | MASK_ERROR)
FAIL_ACC_DENIED_SCHEDULE = long(424 | MASK_ERROR)


# ## Codes 500-599: data already exists failures ###
FAIL_EXISTS_NODE = long(500 | MASK_ERROR)
FAIL_EXISTS_RSC_DFN = long(501 | MASK_ERROR)
FAIL_EXISTS_RSC = long(502 | MASK_ERROR)
FAIL_EXISTS_VLM_DFN = long(503 | MASK_ERROR)
FAIL_EXISTS_VLM = long(504 | MASK_ERROR)
FAIL_EXISTS_NET_IF = long(505 | MASK_ERROR)
FAIL_EXISTS_NODE_CONN = long(506 | MASK_ERROR)
FAIL_EXISTS_RSC_CONN = long(507 | MASK_ERROR)
FAIL_EXISTS_VLM_CONN = long(508 | MASK_ERROR)
FAIL_EXISTS_STOR_POOL_DFN = long(509 | MASK_ERROR)
FAIL_EXISTS_STOR_POOL = long(510 | MASK_ERROR)
FAIL_EXISTS_STLT_CONN = long(511 | MASK_ERROR)
FAIL_EXISTS_CRYPT_PASSPHRASE = long(512 | MASK_ERROR)
FAIL_EXISTS_WATCH = long(513 | MASK_ERROR)
FAIL_EXISTS_SNAPSHOT_DFN = long(514 | MASK_ERROR)
FAIL_EXISTS_SNAPSHOT = long(516 | MASK_ERROR)
FAIL_EXISTS_EXT_NAME = long(517 | MASK_ERROR)
FAIL_EXISTS_NVME_TARGET_PER_RSC_DFN = long(518 | MASK_ERROR)
FAIL_EXISTS_NVME_INITIATOR_PER_RSC_DFN = long(519 | MASK_ERROR)
FAIL_LOST_STOR_POOL = long(521 | MASK_ERROR)
FAIL_EXISTS_RSC_GRP = long(522 | MASK_ERROR)
FAIL_EXISTS_VLM_GRP = long(523 | MASK_ERROR)
FAIL_EXISTS_OPENFLEX_TARGET_PER_RSC_DFN = long(524 | MASK_ERROR)
FAIL_EXISTS_SNAPSHOT_SHIPPING = long(525 | MASK_ERROR)
FAIL_EXISTS_EXOS_ENCLOSURE = long(526 | MASK_ERROR)
FAIL_EXISTS_REMOTE = long(527 | MASK_ERROR)
FAIL_EXISTS_SCHEDULE = long(528 | MASK_ERROR)


# ## Codes 600-699: data missing failures ###
FAIL_MISSING_PROPS = long(600 | MASK_ERROR)
FAIL_MISSING_PROPS_NETCOM_TYPE = long(601 | MASK_ERROR)
FAIL_MISSING_PROPS_NETCOM_PORT = long(602 | MASK_ERROR)
FAIL_MISSING_NETCOM = long(603 | MASK_ERROR)
FAIL_MISSING_PROPS_NETIF_NAME = long(604 | MASK_ERROR)
FAIL_MISSING_STLT_CONN = long(605 | MASK_ERROR)
FAIL_MISSING_EXT_NAME = long(606 | MASK_ERROR)
FAIL_MISSING_NVME_TARGET = long(608 | MASK_ERROR)
FAIL_NO_STLT_CONN_DEFINED = long(609 | MASK_ERROR)
FAIL_MISSING_OPENFLEX_TARGET = long(610 | MASK_ERROR)
FAIL_MISSING_EBS_TARGET = long(611 | MASK_ERROR)


# ## Codes 700-799: uuid mismatch failures ###
FAIL_UUID_NODE = long(700 | MASK_ERROR)
FAIL_UUID_RSC_DFN = long(701 | MASK_ERROR)
FAIL_UUID_RSC = long(702 | MASK_ERROR)
FAIL_UUID_VLM_DFN = long(703 | MASK_ERROR)
FAIL_UUID_VLM = long(704 | MASK_ERROR)
FAIL_UUID_NET_IF = long(705 | MASK_ERROR)
FAIL_UUID_NODE_CONN = long(706 | MASK_ERROR)
FAIL_UUID_RSC_CONN = long(707 | MASK_ERROR)
FAIL_UUID_VLM_CONN = long(708 | MASK_ERROR)
FAIL_UUID_STOR_POOL_DFN = long(709 | MASK_ERROR)
FAIL_UUID_STOR_POOL = long(710 | MASK_ERROR)
FAIL_UUID_KVS = long(711 | MASK_ERROR)


# ## Codes 800-899: number pools exhausted ###
FAIL_POOL_EXHAUSTED_VLM_NR = long(800 | MASK_ERROR)
FAIL_POOL_EXHAUSTED_MINOR_NR = long(801 | MASK_ERROR)
FAIL_POOL_EXHAUSTED_TCP_PORT = long(802 | MASK_ERROR)
FAIL_POOL_EXHAUSTED_NODE_ID = long(803 | MASK_ERROR)
FAIL_POOL_EXHAUSTED_RSC_LAYER_ID = long(804 | MASK_ERROR)
FAIL_POOL_EXHAUSTED_SPECIAL_SATELLTE_TCP_PORT = long(805 | MASK_ERROR)
FAIL_POOL_EXHAUSTED_SNAPSHOT_SHIPPING_TCP_PORT = long(806 | MASK_ERROR)
FAIL_POOL_EXHAUSTED_BACKUP_SHIPPING_TCP_PORT = long(807 | MASK_ERROR)


# ## Other failures ###
FAIL_EBS_COOLDOWN = long(973 | MASK_ERROR)
FAIL_NOT_ALL_UPTODATE = long(974 | MASK_ERROR)
FAIL_EVACUATING = long(975 | MASK_ERROR)
FAIL_BACKUP_UNKNOWN_CLUSTER = long(976 | MASK_ERROR)
FAIL_DEPENDEND_BACKUP = long(977 | MASK_ERROR)
FAIL_BACKUP_INCOMPATIBLE_VERSION = long(978 | MASK_ERROR)
FAIL_SNAPSHOT_NOT_UPTODATE = long(979 | MASK_ERROR)
FAIL_NOT_ENOUGH_FREE_SPACE = long(980 | MASK_ERROR)
FAIL_ONLY_ONE_ACT_RSC_PER_SHARED_STOR_POOL_ALLOWED = long(981 | MASK_ERROR)
FAIL_CRYPT_INIT = long(982 | MASK_ERROR)
FAIL_SNAPSHOT_SHIPPING_NOT_SUPPORTED = long(983 | MASK_ERROR)
FAIL_SNAPSHOT_SHIPPING_IN_PROGRESS = long(984 | MASK_ERROR)
FAIL_UNDECIDABLE_AUTOPLACMENT = long(985 | MASK_ERROR)
FAIL_PRE_SELECT_SCRIPT_DID_NOT_TERMINATE = long(986 | MASK_ERROR)
FAIL_LINSTOR_MANAGED_SATELLITE_DID_NOT_START_PROPERLY = long(987 | MASK_ERROR)
FAIL_STLT_DOES_NOT_SUPPORT_LAYER = long(988 | MASK_ERROR)
FAIL_STLT_DOES_NOT_SUPPORT_PROVIDER = long(989 | MASK_ERROR)
FAIL_STOR_POOL_CONFIGURATION_ERROR = long(990 | MASK_ERROR)
FAIL_INSUFFICIENT_REPLICA_COUNT = long(991 | MASK_ERROR)
FAIL_RSC_BUSY = long(992 | MASK_ERROR)
FAIL_INSUFFICIENT_PEER_SLOTS = long(993 | MASK_ERROR)
FAIL_SNAPSHOTS_NOT_SUPPORTED = long(994 | MASK_ERROR)
FAIL_NOT_CONNECTED = long(995 | MASK_ERROR)
FAIL_NOT_ENOUGH_NODES = long(996 | MASK_ERROR)
FAIL_IN_USE = long(997 | MASK_ERROR)
FAIL_UNKNOWN_ERROR = long(998 | MASK_ERROR)
FAIL_IMPL_ERROR = long(999 | MASK_ERROR)


# ## Codes 1000-9999: warnings ###
WARN_INVLD_OPT_PROP_NETCOM_ENABLED = long(1001 | MASK_WARN)
WARN_NOT_CONNECTED = long(1002 | MASK_WARN)
WARN_STLT_NOT_UPDATED = long(1003 | MASK_WARN)
WARN_NO_STLT_CONN_DEFINED = long(1004 | MASK_WARN)
WARN_DEL_UNSET_PROP = long(1005 | MASK_WARN)
WARN_RSC_ALREADY_DEPLOYED = long(1006 | MASK_WARN)
WARN_RSC_ALREADY_HAS_DISK = long(1007 | MASK_WARN)
WARN_RSC_ALREADY_DISKLESS = long(1008 | MASK_WARN)
WARN_ALL_DISKLESS = long(1009 | MASK_WARN)
WARN_STORAGE_ERROR = long(1010 | MASK_WARN)
WARN_NOT_FOUND_CRYPT_KEY = long(1011 | MASK_WARN)
WARN_STORAGE_KIND_ADDED = long(1012 | MASK_WARN)
WARN_NOT_ENOUGH_NODES_FOR_TIE_BREAKER = long(1013 | MASK_WARN)
WARN_MIXED_PMEM_AND_NON_PMEM = long(1014 | MASK_WARN)
WARN_UNEFFECTIVE_PROP = long(1015 | MASK_WARN)
WARN_INVLD_SNAPSHOT_SHIPPING_PREFIX = long(1016 | MASK_WARN)
WARN_NODE_EVICTED = long(1017 | MASK_WARN)
WARN_RSC_DEACTIVATED = long(1018 | MASK_WARN)
WARN_BACKUP_DL_ONLY = long(1019 | MASK_WARN)
WARN_NOT_EVACUATING = long(1020 | MASK_WARN)
WARN_INVLD_CONF = long(1021 | MASK_WARN)
WARN_NOT_FOUND = long(3000 | MASK_WARN)


# ## Codes 10000-19999: info ###
INFO_NO_RSC_SPAWNED = long(10000 | MASK_INFO)
INFO_NODE_NAME_MISMATCH = long(10001 | MASK_INFO)
INFO_PROP_SET = long(10002 | MASK_INFO)
INFO_TIE_BREAKER_CREATED = long(10003 | MASK_INFO)
INFO_TIE_BREAKER_DELETING = long(10004 | MASK_INFO)
INFO_TIE_BREAKER_TAKEOVER = long(10006 | MASK_INFO)
INFO_PROP_REMOVED = long(10005 | MASK_INFO)
INFO_AUTO_DRBD_PROXY_CREATED = long(10007 | MASK_INFO)
INFO_NOOP = long(10007 | MASK_INFO)
INFO_RSC_ALREADY_EXISTS = long(10008 | MASK_INFO)


# ## Special codes ###
UNKNOWN_API_CALL = long(0x0FFFFFFFFFFFFFFF | MASK_ERROR)
API_CALL_AUTH_REQ = long(0x0FFFFFFFFFFFFFFE | MASK_ERROR)
API_CALL_PARSE_ERROR = long(0x0FFFFFFFFFFFFFFD | MASK_ERROR)


# ## SignIn codes ###
SUCCESS_SIGN_IN = long(10000 | MASK_SUCCESS)
FAIL_SIGN_IN = long(10000 | MASK_ERROR)
FAIL_SIGN_IN_MISSING_CREDENTIALS = long(10001 | MASK_ERROR)


# ## Special answer message content types ###
# Textual MsgApiCallResponse responses
API_REPLY = str('Reply')
# Indicates that the immediate answers to the API call are complete
API_END_OF_IMMEDIATE_ANSWERS = str('EndOfImmediateAnswers')


# ## Create object APIs ###
API_CRT_NODE = str('CrtNode')
API_CRT_RSC = str('CrtRsc')
API_CRT_RSC_DFN = str('CrtRscDfn')
API_CRT_NET_IF = str('CrtNetIf')
API_CRT_VLM_DFN = str('CrtVlmDfn')
API_CRT_SNAPSHOT = str('CrtSnapshot')
API_CRT_BACKUP = str('CrtBackup')
API_CRT_STOR_POOL_DFN = str('CrtStorPoolDfn')
API_CRT_STOR_POOL = str('CrtStorPool')
API_CRT_NODE_CONN = str('CrtNodeConn')
API_CRT_RSC_CONN = str('CrtRscConn')
API_CRT_VLM_CONN = str('CrtVlmConn')
API_AUTO_PLACE_RSC = str('AutoPlaceRsc')
API_CLONE_RSCDFN = str('CloneRscDfn')
API_CLONE_RSCDFN_STATUS = str('CloneRscDfnStatus')
API_CRT_CRYPT_PASS = str('CrtCryptPass')
API_CRT_OF_TARGET_NODE = str('CrtOfTargetNode')
API_RESTORE_VLM_DFN = str('RestoreVlmDfn')
API_RESTORE_SNAPSHOT = str('RestoreSnapshot')
API_CRT_RSC_GRP = str('CrtRscGrp')
API_CRT_VLM_GRP = str('CrtVlmGrp')
API_SPAWN_RSC_DFN = str('SpawnRscDfn')
API_ADJUST_RSC_GRP = str('AdjustRscGrp')
API_CREATE_DEVICE_POOL = str('CreateDevicePool')
API_MAKE_RSC_AVAIL = str('MakeRscAvail')
API_CRT_EXOS_ENCLOSURE = str('CrtExosEnclosure')
API_SET_REMOTE = str('SetRemote')
API_RESTORE_BACKUP = str('RstBackup')
API_ABORT_BACKUP = str('AbortBackup')
API_SHIP_BACKUP = str('ShipBackup')
API_CRT_SCHEDULE = str('CrtSchedule')


# ## Modify object APIs ###
API_MOD_NODE = str('ModNode')
API_MOD_NODE_CONN = str('ModNodeConn')
API_MOD_RSC = str('ModRsc')
API_TOGGLE_DISK = str('ToggleDisk')
API_MOD_RSC_CONN = str('ModRscConn')
API_MOD_RSC_DFN = str('ModRscDfn')
API_MOD_NET_IF = str('ModNetIf')
API_MOD_STOR_POOL = str('ModStorPool')
API_MOD_STOR_POOL_DFN = str('ModStorPoolDfn')
API_MOD_VLM_DFN = str('ModVlmDfn')
API_MOD_VLM = str('ModVlm')
API_MOD_VLM_CONN = str('ModVlmConn')
API_MOD_SNAPSHOT = str('ModSnapshot')
API_MOD_CRYPT_PASS = str('ModCryptPass')
API_ENABLE_DRBD_PROXY = str('EnableDrbdProxy')
API_DISABLE_DRBD_PROXY = str('DisableDrbdProxy')
API_MOD_DRBD_PROXY = str('ModifyDrbdProxy')
API_ROLLBACK_SNAPSHOT = str('RollbackSnapshot')
API_SHIP_SNAPSHOT = str('ShipSnapshot')
API_MOD_KVS = str('ModifyKvs')
API_MOD_RSC_GRP = str('ModifyRscGrp')
API_MOD_VLM_GRP = str('ModifyVlmGrp')
API_ACTIVATE_RSC = str('ActivateRsc')
API_DEACTIVATE_RSC = str('DeactivateRsc')
API_MOD_EXOS_DFLTS = str('ModifyExosDefaults')
API_MOD_EXOS_ENCLOSURE = str('ModExosEnclosure')
API_MOD_SCHEDULE = str('ModSchedule')


# ## Delete object APIs ###
API_DEL_NODE = str('DelNode')
API_DEL_RSC = str('DelRsc')
API_DEL_RSC_DFN = str('DelRscDfn')
API_DEL_NET_IF = str('DelNetIf')
API_DEL_VLM_DFN = str('DelVlmDfn')
API_DEL_STOR_POOL_DFN = str('DelStorPoolDfn')
API_DEL_STOR_POOL = str('DelStorPool')
API_DEL_NODE_CONN = str('DelNodeConn')
API_DEL_RSC_CONN = str('DelRscConn')
API_DEL_VLM_CONN = str('DelVlmConn')
API_DEL_SNAPSHOT = str('DelSnapshot')
API_DEL_KVS = str('DelKvs')
API_DEL_RSC_GRP = str('DelRscGrp')
API_DEL_VLM_GRP = str('DelVlmGrp')
API_DEL_BACKUP = str('DelBackup')
API_LOST_NODE = str('LostNode')
API_LOST_STOR_POOL = str('LostStorPool')
API_DEL_EXOS_ENCLOSURE = str('DelExosEnclosure')
API_DEL_SCHEDULE = str('DelSchedule')


# ## Authentication APIs ###
API_SIGN_IN = str('SignIn')
API_VERSION = str('Version')


# ## Debug APIs ###
API_CRT_DBG_CNSL = str('CrtDbgCnsl')
API_DSTR_DBG_CNSL = str('DstrDbgCnsl')


# ## Command APIs ###
API_CONTROL_CTRL = str('ControlCtrl')
API_CMD_SHUTDOWN = str('Shutdown')
API_NODE_RECONNECT = str('NodeReconnect')
API_NODE_RESTORE = str('NodeRestore')
API_NODE_EVICT = str('NodeEvict')
API_NODE_EVACUATE = str('NodeEvacuate')


# ## List object APIs ###
API_LST_NODE = str('LstNode')
API_LST_NODE_CONN = str('LstNodeConn')
API_LST_RSC = str('LstRsc')
API_LST_RSC_DFN = str('LstRscDfn')
API_LST_NET_IF = str('LstNetIf')
API_LST_VLM_DFN = str('LstVlmDfn')
API_LST_VLM = str('LstVlm')
API_LST_SNAPSHOT_DFN = str('LstSnapshotDfn')
API_LST_STOR_POOL = str('LstStorPool')
API_LST_STOR_POOL_DFN = str('LstStorPoolDfn')
API_LST_ERROR_REPORTS = str('LstErrorReports')
API_REQ_ERROR_REPORTS = str('ReqErrorReports')
API_DEL_ERROR_REPORT = str('DelErrorReport')
API_DEL_ERROR_REPORTS = str('DelErrorReports')
API_REQ_SOS_REPORT = str('ReqSosReport')
API_REQ_RSC_CONN_LIST = str('ReqRscConnList')
API_LST_RSC_CONN = str('LstRscConn')
API_LST_KVS = str('LstKvs')
API_LST_RSC_GRP = str('LstRscGrp')
API_LST_VLM_GRP = str('LstVlmGrp')
API_LST_PHYS_STOR = str('LstPhysicalStorage')
API_LST_SNAPSHOT_SHIPPINGS = str('LstSnapShips')
API_LST_BACKUPS = str('LstBackups')
API_BACKUP_INFO = str('BackupInfo')
API_LST_PROPS_INFO = str('LstPropsInfo')
API_LST_REMOTE = str('LstRemote')
API_LST_EXOS_DFLTS = str('LstExosDefaults')
API_LST_EXOS_ENCLOSURES = str('LstExosEnclosures')
API_EXOS_ENCLOSURE_EVENTS = str('ExosEvents')
API_EXOS_EXEC = str('ExosExec')
API_EXOS_MAP = str('ExosMap')
API_LST_EXT_FILES = str('LstExtFiles')
API_NODE_STATS = str('NodeStats')
API_RSC_GRP_STATS = str('RscGrpStats')
API_RSC_DFN_STATS = str('RscDfnStats')
API_RSC_STATS = str('RscStats')
API_STOR_POOL_STATS = str('StorPoolStats')
API_ERR_REPORT_STATS = str('ErrReportStats')
API_LST_SCHEDULE = str('LstSchedule')


# ## Query APIs ###
API_QRY_MAX_VLM_SIZE = str('QryMaxVlmSize')
API_RSP_MAX_VLM_SIZE = str('RspMaxVlmSize')
API_QRY_SIZE_INFO = str('QrySizeInfo')
API_RSP_SIZE_INFO = str('RspSizeInfo')
API_RSCDFN_SYNC_STATUS = str('RscDfnSyncStatus')


# ## Event APIs ###
API_CRT_WATCH = str('CrtWatch')
API_DEL_WATCH = str('DelWatch')
API_EVENT = str('Event')
API_RPT_SPC = str('RptSpc')
API_PING = str('Ping')
API_PONG = str('Pong')
API_MOD_INF = str('ModInf')
API_VSN_INF = str('VsnInf')
API_SET_CTRL_PROP = str('SetCtrlProp')
API_DEL_CTRL_PROP = str('DelCtrlProp')
API_LST_CTRL_PROPS = str('LstCtrlProps')


# ## Encryption APIs ###
API_ENTER_CRYPT_PASS = str('EnterCryptPass')


# ## External files APIs ###
API_SET_EXT_FILE = str('SetExtFile')
API_DEL_EXT_FILE = str('DeleteExtFile')
API_DEPLOY_EXT_FILE = str('DeployExtFile')
API_UNDEPLOY_EXT_FILE = str('UndeployExtFile')


# ## DRBD property keys ###
KEY_UUID = str('UUID')
KEY_DRBD_CURRENT_GI = str('DrbdCurrentGi')
KEY_DMSTATS = str('DMStats')
KEY_DRBD_AUTO_QUORUM = str('auto-quorum')
KEY_DRBD_AUTO_ADD_QUORUM_TIEBREAKER = str('auto-add-quorum-tiebreaker')
KEY_MINOR_NR_AUTO_RANGE = str('MinorNrAutoRange')
KEY_DRBD_AUTO_DISKFUL = str('auto-diskful')
KEY_DRBD_AUTO_DISKFUL_ALLOW_CLEANUP = str('auto-diskful-allow-cleanup')
KEY_DRBD_DISABLE_AUTO_RESYNC_AFTER = str('auto-resync-after-disable')
KEY_DRBD_DISABLE_AUTO_VERIFY_ALGO = str('auto-verify-algo-disable')
KEY_DRBD_AUTO_VERIFY_ALGO_ALLOWED_USER = str('auto-verify-algo-allowed-user-list')
KEY_DRBD_AUTO_RS_DISCARD_GRANULARITY = str('auto-rs-discard-granularity')
KEY_FORCE_INITIAL_SYNC = str('ForceInitialSync')


# ## Node property keys ###
KEY_NODE = str('Node')
KEY_1ST_NODE = str('FirstNode')
KEY_2ND_NODE = str('SecondNode')
KEY_CUR_STLT_CONN_NAME = str('CurStltConnName')


# ## Resource property keys ###
KEY_RSC_DFN = str('RscDfn')
KEY_RSC_GRP = str('RscGrp')
KEY_TCP_PORT_AUTO_RANGE = str('TcpPortAutoRange')
KEY_PEER_SLOTS_NEW_RESOURCE = str('PeerSlotsNewResource')
KEY_PEER_SLOTS = str('PeerSlots')
KEY_RSC_ROLLBACK_TARGET = str('RollbackTarget')
KEY_RSC_MIGRATE_FROM = str('MigrateFrom')
KEY_RSC_ALLOW_MIXING_DEVICE_KIND = str('AllowMixingStoragePoolDriver')
KEY_RSC_DISKFUL_BY = str('DiskfulBy')


# ## Volume property keys ###
KEY_VLM_GRP = str('VlmGrp')
KEY_VLM_NR = str('VlmNr')
KEY_VLM_RESTORE_FROM_RESOURCE = str('RestoreFromResource')
KEY_VLM_RESTORE_FROM_SNAPSHOT = str('RestoreFromSnapshot')


# ## ldap property keys ###
KEY_SEARCH_DOMAIN = str('SearchDomain')


# ## nvme property keys ###
KEY_TR_TYPE = str('TRType')


# ## Snapshot property keys ###
KEY_SNAPSHOT = str('Snapshot')
KEY_SNAPSHOT_DFN_SEQUENCE_NUMBER = str('SequenceNumber')


# ## Network Interface property keys ###
KEY_PORT = str('Port')
KEY_DISABLE_HTTP_METRICS = str('disable-http-metrics')


# ## Writecache property keys ###
KEY_WRITECACHE_BLOCKSIZE = str('Blocksize')
KEY_WRITECACHE_POOL_NAME = str('PoolName')
KEY_WRITECACHE_SIZE = str('Size')
KEY_WRITECACHE_OPTION_HIGH_WATERMARK = str('HighWatermark')
KEY_WRITECACHE_OPTION_LOW_WATERMARK = str('LowWatermark')
KEY_WRITECACHE_OPTION_START_SECTOR = str('StartSector')
KEY_WRITECACHE_OPTION_WRITEBACK_JOBS = str('WritebackJobs')
KEY_WRITECACHE_OPTION_AUTOCOMMIT_BLOCKS = str('AutocommitBlocks')
KEY_WRITECACHE_OPTION_AUTOCOMMIT_TIME = str('AutocommitTime')
KEY_WRITECACHE_OPTION_FUA = str('Fua')
KEY_WRITECACHE_OPTION_ADDITIONAL = str('Additional')


# ## Cache property keys ###
KEY_CACHE_OPERATING_MODE = str('OpMode')
KEY_CACHE_META_POOL_NAME = str('MetaPool')
KEY_CACHE_CACHE_POOL_NAME = str('CachePool')
KEY_CACHE_META_SIZE = str('Metasize')
KEY_CACHE_CACHE_SIZE = str('Cachesize')
KEY_CACHE_BLOCK_SIZE = str('Blocksize')
KEY_CACHE_POLICY = str('Policy')
KEY_UPDATE_CACHE_INTERVAL = str('UpdateCacheInterval')


# ## BCache property keys ###
KEY_BCACHE_POOL_NAME = str('PoolName')
KEY_BCACHE_SIZE = str('Size')
KEY_BCACHE_BLOCKSIZE = str('Blocksize')
KEY_BCACHE_BUCKETSIZE = str('Bucketsize')
KEY_BCACHE_DATA_OFFSET = str('DataOffset')
KEY_BCACHE_WRITEBACK = str('Writeback')
KEY_BCACHE_DISCARD = str('Discard')
KEY_BCACHE_CACHE_REPLACEMENT_POLICY = str('CacheReplacementPolicy')


# ## Autoplace property keys ###
KEY_AUTOPLACE_STRAT_WEIGHT_MAX_FREESPACE = str('MaxFreeSpace')
KEY_AUTOPLACE_STRAT_WEIGHT_MIN_RESERVED_SPACE = str('MinReservedSpace')
KEY_AUTOPLACE_STRAT_WEIGHT_MIN_RSC_COUNT = str('MinRscCount')
KEY_AUTOPLACE_PRE_SELECT_FILE_NAME = str('PreSelectScript')
KEY_AUTOPLACE_PRE_SELECT_SCRIPT_TIMEOUT = str('PreSelectScriptTimeout')
KEY_AUTOPLACE_MAX_THROUGHPUT = str('MaxThroughput')
KEY_SITE = str('Site')
KEY_AUTOPLACE_ALLOW_TARGET = str('AutoplaceTarget')


# ## Auto-Evict property keys ###
KEY_AUTO_EVICT_MIN_REPLICA_COUNT = str('AutoEvictMinReplicaCount')
KEY_AUTO_EVICT_AFTER_TIME = str('AutoEvictAfterTime')
KEY_AUTO_EVICT_MAX_DISCONNECTED_NODES = str('AutoEvictMaxDisconnectedNodes')
KEY_AUTO_EVICT_ALLOW_EVICTION = str('AutoEvictAllowEviction')


# ## Snapshot shipping property keys ###
KEY_SNAPSHOT_SHIPPING_PREFIX = str('SnapshotShippingPrefix')
KEY_TARGET_NODE = str('TargetNode')
KEY_SOURCE_NODE = str('SourceNode')
KEY_RUN_EVERY = str('RunEvery')
KEY_AUTO_SNAPSHOT_PREFIX = str('Prefix')
KEY_KEEP = str('Keep')
KEY_AUTO_SNAPSHOT_NEXT_ID = str('NextAutoId')
KEY_TCP_PORT_RANGE = str('TcpPortRange')


# ## Backup shipping property keys ###
KEY_BACKUP_TIMEOUT = str('BackupTimeout')
KEY_BACKUP_S3_SUFFIX = str('S3KeySuffix')
KEY_REMOTE = str('Remote')


# ## Clone property keys ###
KEY_USE_ZFS_CLONE = str('UseZFSClone')


# ## NetCom namespaces ###
KEY_NETCOM_ENABLED = str('Enabled')
KEY_NETCOM_BIND_ADDRESS = str('BindAddress')
KEY_NETCOM_KEY_PASSWD = str('KeyPasswd')
KEY_NETCOM_KEY_STORE = str('KeyStore')
KEY_NETCOM_KEY_STORE_PASSWD = str('KeyStorePasswd')
KEY_NETCOM_PORT = str('Port')
KEY_NETCOM_SSL_PROTOCOL = str('SslProtocol')
KEY_NETCOM_TRUST_STORE = str('TrustStore')
KEY_NETCOM_TRUST_STORE_PASSWD = str('TrustStorePasswd')
KEY_NETCOM_TYPE = str('Type')


# ## Property namespaces ###
NAMESPC_NETCOM = str('NetCom')
NAMESPC_DFLT = str('Default')
NAMESPC_LOGGING = str('Logging')
NAMESPC_ALLOC = str('Allocation')
NAMESPC_NETIF = str('NetIf')
NAMESPC_STLT = str('Satellite')
NAMESPC_NODE = str('Node')
NAMESPC_STORAGE_DRIVER = str('StorDriver')
NAMESPC_DRBD_PROXY = str('DrbdProxy')
NAMESPC_AUXILIARY = str('Aux')
NAMESPC_DRBD_OPTIONS = str('DrbdOptions')
NAMESPC_DRBD_NET_OPTIONS = str('DrbdOptions/Net')
NAMESPC_DRBD_DISK_OPTIONS = str('DrbdOptions/Disk')
NAMESPC_DRBD_RESOURCE_OPTIONS = str('DrbdOptions/Resource')
NAMESPC_DRBD_PEER_DEVICE_OPTIONS = str('DrbdOptions/PeerDevice')
NAMESPC_DRBD_PROXY_OPTIONS = str('DrbdOptions/Proxy')
NAMESPC_DRBD_PROXY_COMPRESSION_OPTIONS = str('DrbdOptions/ProxyCompression')
NAMESPC_DRBD_HANDLER_OPTIONS = str('DrbdOptions/Handlers')
NAMESPC_CONNECTION_PATHS = str('Paths')
NAMESPC_REST = str('REST')
NAMESPC_FILESYSTEM = str('FileSystem')
NAMESPC_NVME = str('NVMe')
NAMESPC_SYS_FS = str('sys/fs')
NAMESPC_WRITECACHE = str('Writecache')
NAMESPC_WRITECACHE_OPTIONS = str('Writecache/Options')
NAMESPC_CACHE = str('Cache')
NAMESPC_CACHE_FEATURES = str('Cache/Features')
NAMESPC_CACHE_POLICY_ARGS = str('Cache/Policy')
NAMESPC_BCACHE = str('BCache')
NAMESPC_AUTOPLACER = str('Autoplacer')
NAMESPC_AUTOPLACER_WEIGHTS = str('Autoplacer/Weights')
NAMESPC_SNAPSHOT_SHIPPING = str('SnapshotShipping')
NAMESPC_AUTO_SNAPSHOT = str('AutoSnapshot')
NAMESPC_STLT_DEV_SYMLINKS = str('Satellite/Device/Symlinks')
NAMESPC_EXOS = str('StorDriver/Exos')
NAMESPC_BACKUP_SHIPPING = str('BackupShipping')
NAMESPC_CLUSTER = str('Cluster')
NAMESPC_CLUSTER_REMOTE = str('Cluster/Remote')
NAMESPC_SED = str('SED')
NAMESPC_EBS = str('EBS')
NAMESPC_TAGS = str('Tags')


# ## Storage pool property keys ###
KEY_STOR_POOL_DFN = str('StorPoolDfn')
KEY_STOR_POOL_NAME = str('StorPoolName')
KEY_STOR_POOL_DRBD_META_NAME = str('StorPoolNameDrbdMeta')
KEY_STOR_POOL_VOLUME_GROUP = str('LvmVg')
KEY_STOR_POOL_LVCREATE_TYPE = str('LvcreateType')
KEY_STOR_POOL_LVCREATE_OPTIONS = str('LvcreateOptions')
KEY_STOR_POOL_THIN_POOL = str('ThinPool')
KEY_STOR_POOL_ZPOOL = str('ZPool')
KEY_STOR_POOL_ZPOOLTHIN = str('ZPoolThin')
KEY_STOR_POOL_ZFS_CREATE_OPTIONS = str('ZfscreateOptions')
KEY_STOR_POOL_FILE_DIRECTORY = str('FileDir')
KEY_STOR_POOL_PREF_NIC = str('PrefNic')
KEY_STOR_POOL_CRYPT_PASSWD = str('CryptPasswd')
KEY_STOR_POOL_OVERRIDE_VLM_ID = str('OverrideVlmId')
KEY_STOR_POOL_DFN_MAX_OVERSUBSCRIPTION_RATIO = str('MaxOversubscriptionRatio')
KEY_STOR_POOL_WAIT_TIMEOUT_AFTER_CREATE = str('WaitTimeoutAfterCreate')
KEY_STOR_POOL_OPENFLEX_API_HOST = str('Openflex/ApiHost')
KEY_STOR_POOL_OPENFLEX_API_PORT = str('Openflex/ApiPort')
KEY_STOR_POOL_OPENFLEX_STOR_DEV = str('Openflex/StorDev')
KEY_STOR_POOL_OPENFLEX_STOR_DEV_HOST = str('Openflex/StorDevHost')
KEY_STOR_POOL_OPENFLEX_STOR_POOL = str('Openflex/StorPool')
KEY_STOR_POOL_OPENFLEX_USER_NAME = str('Openflex/UserName')
KEY_STOR_POOL_OPENFLEX_USER_PW = str('Openflex/UserPassword')
KEY_STOR_POOL_OPENFLEX_JOB_WAIT_MAX_COUNT = str('Openflex/JobWaitMaxCount')
KEY_STOR_POOL_OPENFLEX_JOB_WAIT_DELAY = str('Openflex/JobWaitDelay')
KEY_OF_TARGET_PORT_AUTO_RANGE = str('OpenflexTargetPortAutoRange')
KEY_STOR_POOL_EXOS_API_IP = str('IP')
KEY_STOR_POOL_EXOS_API_IP_ENV = str('IPEnv')
KEY_STOR_POOL_EXOS_API_PORT = str('Port')
KEY_STOR_POOL_EXOS_API_USER = str('Username')
KEY_STOR_POOL_EXOS_API_USER_ENV = str('UsernameEnv')
KEY_STOR_POOL_EXOS_API_PASSWORD = str('Password')
KEY_STOR_POOL_EXOS_API_PASSWORD_ENV = str('PasswordEnv')
KEY_STOR_POOL_EXOS_VLM_TYPE = str('VolumeType')
KEY_STOR_POOL_EXOS_CREATE_VOLUME_OPTIONS = str('CreateVolumeOptions')
KEY_STOR_POOL_EXOS_ENCLOSURE = str('Enclosure')
KEY_STOR_POOL_EXOS_POOL_SN = str('PoolSN')
KEY_STOR_POOL_REMOTE_SPDK_API_HOST = str('RemoteSpdk/ApiHost')
KEY_STOR_POOL_REMOTE_SPDK_API_PORT = str('RemoteSpdk/ApiPort')
KEY_STOR_POOL_REMOTE_SPDK_API_USER_NAME = str('RemoteSpdk/UserName')
KEY_STOR_POOL_REMOTE_SPDK_API_USER_PW = str('RemoteSpdk/UserPassword')
KEY_STOR_POOL_REMOTE_SPDK_API_USER_NAME_ENV = str('RemoteSpdk/UserNameEnv')
KEY_STOR_POOL_REMOTE_SPDK_API_USER_PW_ENV = str('RemoteSpdk/UserPasswordEnv')
KEY_EBS_VOLUME_TYPE = str('EBS/VolumeType')
KEY_PREF_NIC = str('PrefNic')


# ## Storage pool traits keys ###
KEY_STOR_POOL_SUPPORTS_SNAPSHOTS = str('SupportsSnapshots')
KEY_STOR_POOL_PROVISIONING = str('Provisioning')
# Unit of smallest allocation. The size in KiB as a decimal number.
KEY_STOR_POOL_ALLOCATION_UNIT = str('AllocationUnit')


# ## Storage pool traits values ###
VAL_STOR_POOL_PROVISIONING_FAT = str('Fat')
VAL_STOR_POOL_PROVISIONING_THIN = str('Thin')
VAL_STOR_POOL_DRBD_META_INTERNAL = str('.internal')
VAL_STOR_POOL_SPACE_NOT_FOUND = long(-1)
VAL_STOR_POOL_SPACE_ENOUGH = long(9223372036854775807)


# ## DRBD Proxy keys (other than 'options') ###
KEY_DRBD_PROXY_COMPRESSION_TYPE = str('CompressionType')
KEY_DRBD_PROXY_AUTO_ENABLE = str('AutoEnable')


# ## File system property keys ###
KEY_FS_TYPE = str('Type')
KEY_FS_MKFSPARAMETERS = str('MkfsParams')
VAL_FS_TYPE_EXT4 = str('ext4')
VAL_FS_TYPE_XFS = str('xfs')


# ## sys/fs property keys ###
KEY_SYS_FS_BLKIO_THROTTLE_READ = str('blkio_throttle_read')
KEY_SYS_FS_BLKIO_THROTTLE_WRITE = str('blkio_throttle_write')
KEY_SYS_FS_BLKIO_THROTTLE_READ_IOPS = str('blkio_throttle_read_iops')
KEY_SYS_FS_BLKIO_THROTTLE_WRITE_IOPS = str('blkio_throttle_write_iops')


# ## Property values ###
VAL_NETCOM_TYPE_SSL = str('SSL')
VAL_NETCOM_TYPE_PLAIN = str('Plain')
VAL_SSL_PROTO_TLSv1 = str('TLSv1')


# ## DRBD related property values ###
VAL_DRBD_PROXY_COMPRESSION_NONE = str('none')
VAL_DRBD_PROXY_COMPRESSION_ZSTD = str('zstd')
VAL_DRBD_PROXY_COMPRESSION_ZLIB = str('zlib')
VAL_DRBD_PROXY_COMPRESSION_LZMA = str('lzma')
VAL_DRBD_PROXY_COMPRESSION_LZ4 = str('lz4')
VAL_DRBD_AUTO_QUORUM_DISABLED = str('disabled')
VAL_DRBD_AUTO_QUORUM_IO_ERROR = str('io-error')
VAL_DRBD_AUTO_QUORUM_SUSPEND_IO = str('suspend-io')


# ## Node Type values ###
VAL_NODE_TYPE_CTRL = str('Controller')
VAL_NODE_TYPE_STLT = str('Satellite')
VAL_NODE_TYPE_CMBD = str('Combined')
VAL_NODE_TYPE_AUX = str('Auxiliary')
VAL_NODE_TYPE_OPENFLEX_TARGET = str('Openflex_Target')
VAL_NODE_TYPE_REMOTE_SPDK = str('Remote_Spdk')
VAL_NODE_TYPE_EXOS_TARGET = str('Exos_Target')


# ## Writecache option values ###
VAL_WRITECACHE_FUA_ON = str('On')
VAL_WRITECACHE_FUA_OFF = str('Off')


# ## Net interface Type values ###
VAL_NETIF_TYPE_IP = str('IP')
VAL_NETIF_TYPE_RDMA = str('RDMA')
VAL_NETIF_TYPE_ROCE = str('RoCE')


# ## Authentication keys ###
KEY_SEC_IDENTITY = str('SecIdentity')
KEY_SEC_ROLE = str('SecRole')
KEY_SEC_TYPE = str('SecType')
KEY_SEC_DOMAIN = str('SecDomain')
KEY_SEC_PASSWORD = str('SecPassword')
KEY_POOL_NAME = str('PoolName')


# ## External commands keys ###
KEY_EXT_CMD_WAIT_TO = str('ExtCmdWaitTimeout')


# ## External files keys ###
KEY_EXT_FILE = str('ExtFile')


# ## Default ports ###
DFLT_CTRL_PORT_SSL = int(3371)
DFLT_CTRL_PORT_PLAIN = int(3370)
DFLT_STLT_PORT_SSL = int(3367)
DFLT_STLT_PORT_PLAIN = int(3366)


# ## Boolean values ###
VAL_TRUE = str('True')
VAL_FALSE = str('False')
VAL_YES = str('Yes')
VAL_NO = str('No')


# ## Snapshot-shipping values ###
VAL_SNAP_SHIP_NAME = str('SnapshotShipping')


class SnapshotShipStatus(Enum):
    RUNNING = "Running"
    COMPLETE = "Complete"


# ## Flag string values ###
FLAG_CLEAN = str('CLEAN')
FLAG_EVICTED = str('EVICTED')
FLAG_EVACUATE = str('EVACUATE')
FLAG_DELETE = str('DELETE')
FLAG_DISKLESS = str('DISKLESS')
FLAG_QIGNORE = str('QIGNORE')
FLAG_ENCRYPTED = str('ENCRYPTED')
FLAG_GROSS_SIZE = str('GROSS_SIZE')
FLAG_SUCCESSFUL = str('SUCCESSFUL')
FLAG_SHIPPING = str('SHIPPING')
FLAG_SHIPPING_CLEANUP = str('SHIPPING_CLEANUP')
FLAG_SHIPPING_ABORT = str('SHIPPING_ABORT')
FLAG_SHIPPED = str('SHIPPED')
FLAG_AUTO_SNAPSHOT = str('AUTO_SNAPSHOT')
FLAG_BACKUP = str('BACKUP')
FLAG_RESTORE_BACKUP_ON_SUCCESS = str('RESTORE_BACKUP_ON_SUCCESS')
FLAG_BACKUP_TARGET = str('BACKUP_TARGET')
FLAG_BACKUP_SOURCE = str('BACKUP_SOURCE')
FLAG_FAILED_DEPLOYMENT = str('FAILED_DEPLOYMENT')
FLAG_FAILED_DISCONNECT = str('FAILED_DISCONNECT')
FLAG_RESIZE = str('RESIZE')
FLAG_DISK_ADDING = str('DISK_ADDING')
FLAG_DISK_ADD_REQUESTED = str('DISK_ADD_REQUESTED')
FLAG_DISK_REMOVING = str('DISK_REMOVING')
FLAG_DISK_REMOVE_REQUESTED = str('DISK_REMOVE_REQUESTED')
FLAG_TIE_BREAKER = str('TIE_BREAKER')
FLAG_DRBD_DISKLESS = str('DRBD_DISKLESS')
FLAG_NVME_INITIATOR = str('NVME_INITIATOR')
FLAG_RSC_INACTIVE = str('INACTIVE')
FLAG_EBS_INITIATOR = str('EBS_INITIATOR')


# ## Device layer kinds ###


class DeviceLayerKind(Enum):
    DRBD = "DRBD"
    LUKS = "LUKS"
    STORAGE = "STORAGE"
    NVME = "NVME"
    OPENFLEX = "OPENFLEX"
    EXOS = "EXOS"
    WRITECACHE = "WRITECACHE"
    CACHE = "CACHE"
    BCACHE = "BCACHE"


# ## Satellite connection statuses ###


class ConnectionStatus(Enum):
    OFFLINE = 0
    CONNECTED = 1
    ONLINE = 2
    VERSION_MISMATCH = 3
    FULL_SYNC_FAILED = 4
    AUTHENTICATION_ERROR = 5
    UNKNOWN = 6
    HOSTNAME_MISMATCH = 7
    OTHER_CONTROLLER = 8
    AUTHENTICATED = 9
    NO_STLT_CONN = 10


# ## Clone states ###


class CloneStatus(Enum):
    FAILED = "FAILED"
    CLONING = "CLONING"
    COMPLETE = "COMPLETE"


# ## Default names ###
DEFAULT_NETIF = str('default')
DFLT_SNAPSHOT_SHIPPING_PREFIX = str('ship')


# ## Default values ###
DFLT_AUTO_SNAPSHOT_KEEP = str('10')
DFLT_SHIPPED_SNAPSHOT_KEEP = str('10')


if __name__ == "__main__":
    MAP_MASK = {
        'MASK_BITS_TYPE': MASK_BITS_TYPE,
        'MASK_ERROR': MASK_ERROR,
        'MASK_WARN': MASK_WARN,
        'MASK_INFO': MASK_INFO,
        'MASK_SUCCESS': MASK_SUCCESS,
        'MASK_BITS_OP': MASK_BITS_OP,
        'MASK_CRT': MASK_CRT,
        'MASK_MOD': MASK_MOD,
        'MASK_DEL': MASK_DEL,
        'MASK_BITS_OBJ': MASK_BITS_OBJ,
        'MASK_SCHEDULE': MASK_SCHEDULE,
        'MASK_EXT_FILES': MASK_EXT_FILES,
        'MASK_PHYSICAL_DEVICE': MASK_PHYSICAL_DEVICE,
        'MASK_VLM_GRP': MASK_VLM_GRP,
        'MASK_RSC_GRP': MASK_RSC_GRP,
        'MASK_KVS': MASK_KVS,
        'MASK_NODE': MASK_NODE,
        'MASK_RSC_DFN': MASK_RSC_DFN,
        'MASK_RSC': MASK_RSC,
        'MASK_VLM_DFN': MASK_VLM_DFN,
        'MASK_VLM': MASK_VLM,
        'MASK_NODE_CONN': MASK_NODE_CONN,
        'MASK_RSC_CONN': MASK_RSC_CONN,
        'MASK_VLM_CONN': MASK_VLM_CONN,
        'MASK_NET_IF': MASK_NET_IF,
        'MASK_STOR_POOL_DFN': MASK_STOR_POOL_DFN,
        'MASK_STOR_POOL': MASK_STOR_POOL,
        'MASK_CTRL_CONF': MASK_CTRL_CONF,
        'MASK_SNAPSHOT': MASK_SNAPSHOT,
        'MASK_BACKUP': MASK_BACKUP,
        'MASK_REMOTE': MASK_REMOTE,
        'MASK_BITS_CODE': MASK_BITS_CODE,
        'CREATED': CREATED,
        'DELETED': DELETED,
        'MODIFIED': MODIFIED,
        'PASSPHRASE_ACCEPTED': PASSPHRASE_ACCEPTED,
        'FAIL_SQL': FAIL_SQL,
        'FAIL_SQL_ROLLBACK': FAIL_SQL_ROLLBACK,
        'FAIL_INVLD_NODE_NAME': FAIL_INVLD_NODE_NAME,
        'FAIL_INVLD_NODE_TYPE': FAIL_INVLD_NODE_TYPE,
        'FAIL_INVLD_RSC_NAME': FAIL_INVLD_RSC_NAME,
        'FAIL_INVLD_RSC_PORT': FAIL_INVLD_RSC_PORT,
        'FAIL_INVLD_NODE_ID': FAIL_INVLD_NODE_ID,
        'FAIL_INVLD_VLM_NR': FAIL_INVLD_VLM_NR,
        'FAIL_INVLD_VLM_SIZE': FAIL_INVLD_VLM_SIZE,
        'FAIL_INVLD_MINOR_NR': FAIL_INVLD_MINOR_NR,
        'FAIL_INVLD_STOR_POOL_NAME': FAIL_INVLD_STOR_POOL_NAME,
        'FAIL_INVLD_NET_NAME': FAIL_INVLD_NET_NAME,
        'FAIL_INVLD_NET_ADDR': FAIL_INVLD_NET_ADDR,
        'FAIL_INVLD_NET_PORT': FAIL_INVLD_NET_PORT,
        'FAIL_INVLD_NET_TYPE': FAIL_INVLD_NET_TYPE,
        'FAIL_INVLD_PROP': FAIL_INVLD_PROP,
        'FAIL_INVLD_TRANSPORT_TYPE': FAIL_INVLD_TRANSPORT_TYPE,
        'FAIL_INVLD_TCP_PORT': FAIL_INVLD_TCP_PORT,
        'FAIL_INVLD_CRYPT_PASSPHRASE': FAIL_INVLD_CRYPT_PASSPHRASE,
        'FAIL_INVLD_ENCRYPT_TYPE': FAIL_INVLD_ENCRYPT_TYPE,
        'FAIL_INVLD_SNAPSHOT_NAME': FAIL_INVLD_SNAPSHOT_NAME,
        'FAIL_INVLD_PLACE_COUNT': FAIL_INVLD_PLACE_COUNT,
        'FAIL_INVLD_FREE_SPACE_MGR_NAME': FAIL_INVLD_FREE_SPACE_MGR_NAME,
        'FAIL_INVLD_STOR_DRIVER': FAIL_INVLD_STOR_DRIVER,
        'FAIL_INVLD_DRBD_PROXY_COMPRESSION_TYPE': FAIL_INVLD_DRBD_PROXY_COMPRESSION_TYPE,
        'FAIL_INVLD_KVS_NAME': FAIL_INVLD_KVS_NAME,
        'FAIL_INVLD_LAYER_KIND': FAIL_INVLD_LAYER_KIND,
        'FAIL_INVLD_LAYER_STACK': FAIL_INVLD_LAYER_STACK,
        'FAIL_INVLD_EXT_NAME': FAIL_INVLD_EXT_NAME,
        'FAIL_INVLD_PROVIDER': FAIL_INVLD_PROVIDER,
        'FAIL_INVLD_VLM_SIZES': FAIL_INVLD_VLM_SIZES,
        'FAIL_INVLD_VLM_COUNT': FAIL_INVLD_VLM_COUNT,
        'FAIL_INVLD_CONF': FAIL_INVLD_CONF,
        'FAIL_INVLD_SNAPSHOT_SHIPPING_SOURCE': FAIL_INVLD_SNAPSHOT_SHIPPING_SOURCE,
        'FAIL_INVLD_SNAPSHOT_SHIPPING_TARGET': FAIL_INVLD_SNAPSHOT_SHIPPING_TARGET,
        'FAIL_NODE_HAS_USED_RSC': FAIL_NODE_HAS_USED_RSC,
        'FAIL_INVLD_REQUEST': FAIL_INVLD_REQUEST,
        'FAIL_INVLD_EXT_FILE_NAME': FAIL_INVLD_EXT_FILE_NAME,
        'FAIL_INVLD_EXT_FILE': FAIL_INVLD_EXT_FILE,
        'FAIL_INVLD_RSC_GRP_NAME': FAIL_INVLD_RSC_GRP_NAME,
        'FAIL_INVLD_BACKUP_CONFIG': FAIL_INVLD_BACKUP_CONFIG,
        'FAIL_INVLD_REMOTE_NAME': FAIL_INVLD_REMOTE_NAME,
        'FAIL_INVLD_TIME_PARAM': FAIL_INVLD_TIME_PARAM,
        'FAIL_INVLD_SCHEDULE_NAME': FAIL_INVLD_SCHEDULE_NAME,
        'FAIL_NOT_FOUND_NODE': FAIL_NOT_FOUND_NODE,
        'FAIL_NOT_FOUND_RSC_DFN': FAIL_NOT_FOUND_RSC_DFN,
        'FAIL_NOT_FOUND_RSC': FAIL_NOT_FOUND_RSC,
        'FAIL_NOT_FOUND_VLM_DFN': FAIL_NOT_FOUND_VLM_DFN,
        'FAIL_NOT_FOUND_VLM': FAIL_NOT_FOUND_VLM,
        'FAIL_NOT_FOUND_NET_IF': FAIL_NOT_FOUND_NET_IF,
        'FAIL_NOT_FOUND_NODE_CONN': FAIL_NOT_FOUND_NODE_CONN,
        'FAIL_NOT_FOUND_RSC_CONN': FAIL_NOT_FOUND_RSC_CONN,
        'FAIL_NOT_FOUND_VLM_CONN': FAIL_NOT_FOUND_VLM_CONN,
        'FAIL_NOT_FOUND_STOR_POOL_DFN': FAIL_NOT_FOUND_STOR_POOL_DFN,
        'FAIL_NOT_FOUND_STOR_POOL': FAIL_NOT_FOUND_STOR_POOL,
        'FAIL_NOT_FOUND_DFLT_STOR_POOL': FAIL_NOT_FOUND_DFLT_STOR_POOL,
        'FAIL_NOT_FOUND_CRYPT_KEY': FAIL_NOT_FOUND_CRYPT_KEY,
        'FAIL_NOT_FOUND_SNAPSHOT_DFN': FAIL_NOT_FOUND_SNAPSHOT_DFN,
        'FAIL_NOT_FOUND_SNAPSHOT_VLM_DFN': FAIL_NOT_FOUND_SNAPSHOT_VLM_DFN,
        'FAIL_NOT_FOUND_SNAPSHOT': FAIL_NOT_FOUND_SNAPSHOT,
        'FAIL_NOT_FOUND_KVS': FAIL_NOT_FOUND_KVS,
        'FAIL_NOT_FOUND_RSC_GRP': FAIL_NOT_FOUND_RSC_GRP,
        'FAIL_NOT_FOUND_VLM_GRP': FAIL_NOT_FOUND_VLM_GRP,
        'FAIL_NOT_FOUND_EXOS_ENCLOSURE': FAIL_NOT_FOUND_EXOS_ENCLOSURE,
        'FAIL_NOT_FOUND_EXT_FILE': FAIL_NOT_FOUND_EXT_FILE,
        'FAIL_NOT_FOUND_REMOTE': FAIL_NOT_FOUND_REMOTE,
        'FAIL_NOT_FOUND_BACKUP': FAIL_NOT_FOUND_BACKUP,
        'FAIL_NOT_FOUND_SCHEDULE': FAIL_NOT_FOUND_SCHEDULE,
        'FAIL_ACC_DENIED_NODE': FAIL_ACC_DENIED_NODE,
        'FAIL_ACC_DENIED_RSC_DFN': FAIL_ACC_DENIED_RSC_DFN,
        'FAIL_ACC_DENIED_RSC': FAIL_ACC_DENIED_RSC,
        'FAIL_ACC_DENIED_VLM_DFN': FAIL_ACC_DENIED_VLM_DFN,
        'FAIL_ACC_DENIED_VLM': FAIL_ACC_DENIED_VLM,
        'FAIL_ACC_DENIED_STOR_POOL_DFN': FAIL_ACC_DENIED_STOR_POOL_DFN,
        'FAIL_ACC_DENIED_STOR_POOL': FAIL_ACC_DENIED_STOR_POOL,
        'FAIL_ACC_DENIED_NODE_CONN': FAIL_ACC_DENIED_NODE_CONN,
        'FAIL_ACC_DENIED_RSC_CONN': FAIL_ACC_DENIED_RSC_CONN,
        'FAIL_ACC_DENIED_VLM_CONN': FAIL_ACC_DENIED_VLM_CONN,
        'FAIL_ACC_DENIED_STLT_CONN': FAIL_ACC_DENIED_STLT_CONN,
        'FAIL_ACC_DENIED_CTRL_CFG': FAIL_ACC_DENIED_CTRL_CFG,
        'FAIL_ACC_DENIED_COMMAND': FAIL_ACC_DENIED_COMMAND,
        'FAIL_ACC_DENIED_WATCH': FAIL_ACC_DENIED_WATCH,
        'FAIL_ACC_DENIED_SNAPSHOT_DFN': FAIL_ACC_DENIED_SNAPSHOT_DFN,
        'FAIL_ACC_DENIED_SNAPSHOT': FAIL_ACC_DENIED_SNAPSHOT,
        'FAIL_ACC_DENIED_SNAPSHOT_VLM_DFN': FAIL_ACC_DENIED_SNAPSHOT_VLM_DFN,
        'FAIL_ACC_DENIED_FREE_SPACE_MGR': FAIL_ACC_DENIED_FREE_SPACE_MGR,
        'FAIL_ACC_DENIED_KVS': FAIL_ACC_DENIED_KVS,
        'FAIL_ACC_DENIED_RSC_GRP': FAIL_ACC_DENIED_RSC_GRP,
        'FAIL_ACC_DENIED_VLM_GRP': FAIL_ACC_DENIED_VLM_GRP,
        'FAIL_ACC_DENIED_SNAP_DFN': FAIL_ACC_DENIED_SNAP_DFN,
        'FAIL_ACC_DENIED_EXT_FILE': FAIL_ACC_DENIED_EXT_FILE,
        'FAIL_ACC_DENIED_REMOTE': FAIL_ACC_DENIED_REMOTE,
        'FAIL_ACC_DENIED_SCHEDULE': FAIL_ACC_DENIED_SCHEDULE,
        'FAIL_EXISTS_NODE': FAIL_EXISTS_NODE,
        'FAIL_EXISTS_RSC_DFN': FAIL_EXISTS_RSC_DFN,
        'FAIL_EXISTS_RSC': FAIL_EXISTS_RSC,
        'FAIL_EXISTS_VLM_DFN': FAIL_EXISTS_VLM_DFN,
        'FAIL_EXISTS_VLM': FAIL_EXISTS_VLM,
        'FAIL_EXISTS_NET_IF': FAIL_EXISTS_NET_IF,
        'FAIL_EXISTS_NODE_CONN': FAIL_EXISTS_NODE_CONN,
        'FAIL_EXISTS_RSC_CONN': FAIL_EXISTS_RSC_CONN,
        'FAIL_EXISTS_VLM_CONN': FAIL_EXISTS_VLM_CONN,
        'FAIL_EXISTS_STOR_POOL_DFN': FAIL_EXISTS_STOR_POOL_DFN,
        'FAIL_EXISTS_STOR_POOL': FAIL_EXISTS_STOR_POOL,
        'FAIL_EXISTS_STLT_CONN': FAIL_EXISTS_STLT_CONN,
        'FAIL_EXISTS_CRYPT_PASSPHRASE': FAIL_EXISTS_CRYPT_PASSPHRASE,
        'FAIL_EXISTS_WATCH': FAIL_EXISTS_WATCH,
        'FAIL_EXISTS_SNAPSHOT_DFN': FAIL_EXISTS_SNAPSHOT_DFN,
        'FAIL_EXISTS_SNAPSHOT': FAIL_EXISTS_SNAPSHOT,
        'FAIL_EXISTS_EXT_NAME': FAIL_EXISTS_EXT_NAME,
        'FAIL_EXISTS_NVME_TARGET_PER_RSC_DFN': FAIL_EXISTS_NVME_TARGET_PER_RSC_DFN,
        'FAIL_EXISTS_NVME_INITIATOR_PER_RSC_DFN': FAIL_EXISTS_NVME_INITIATOR_PER_RSC_DFN,
        'FAIL_LOST_STOR_POOL': FAIL_LOST_STOR_POOL,
        'FAIL_EXISTS_RSC_GRP': FAIL_EXISTS_RSC_GRP,
        'FAIL_EXISTS_VLM_GRP': FAIL_EXISTS_VLM_GRP,
        'FAIL_EXISTS_OPENFLEX_TARGET_PER_RSC_DFN': FAIL_EXISTS_OPENFLEX_TARGET_PER_RSC_DFN,
        'FAIL_EXISTS_SNAPSHOT_SHIPPING': FAIL_EXISTS_SNAPSHOT_SHIPPING,
        'FAIL_EXISTS_EXOS_ENCLOSURE': FAIL_EXISTS_EXOS_ENCLOSURE,
        'FAIL_EXISTS_REMOTE': FAIL_EXISTS_REMOTE,
        'FAIL_EXISTS_SCHEDULE': FAIL_EXISTS_SCHEDULE,
        'FAIL_MISSING_PROPS': FAIL_MISSING_PROPS,
        'FAIL_MISSING_PROPS_NETCOM_TYPE': FAIL_MISSING_PROPS_NETCOM_TYPE,
        'FAIL_MISSING_PROPS_NETCOM_PORT': FAIL_MISSING_PROPS_NETCOM_PORT,
        'FAIL_MISSING_NETCOM': FAIL_MISSING_NETCOM,
        'FAIL_MISSING_PROPS_NETIF_NAME': FAIL_MISSING_PROPS_NETIF_NAME,
        'FAIL_MISSING_STLT_CONN': FAIL_MISSING_STLT_CONN,
        'FAIL_MISSING_EXT_NAME': FAIL_MISSING_EXT_NAME,
        'FAIL_MISSING_NVME_TARGET': FAIL_MISSING_NVME_TARGET,
        'FAIL_NO_STLT_CONN_DEFINED': FAIL_NO_STLT_CONN_DEFINED,
        'FAIL_MISSING_OPENFLEX_TARGET': FAIL_MISSING_OPENFLEX_TARGET,
        'FAIL_MISSING_EBS_TARGET': FAIL_MISSING_EBS_TARGET,
        'FAIL_UUID_NODE': FAIL_UUID_NODE,
        'FAIL_UUID_RSC_DFN': FAIL_UUID_RSC_DFN,
        'FAIL_UUID_RSC': FAIL_UUID_RSC,
        'FAIL_UUID_VLM_DFN': FAIL_UUID_VLM_DFN,
        'FAIL_UUID_VLM': FAIL_UUID_VLM,
        'FAIL_UUID_NET_IF': FAIL_UUID_NET_IF,
        'FAIL_UUID_NODE_CONN': FAIL_UUID_NODE_CONN,
        'FAIL_UUID_RSC_CONN': FAIL_UUID_RSC_CONN,
        'FAIL_UUID_VLM_CONN': FAIL_UUID_VLM_CONN,
        'FAIL_UUID_STOR_POOL_DFN': FAIL_UUID_STOR_POOL_DFN,
        'FAIL_UUID_STOR_POOL': FAIL_UUID_STOR_POOL,
        'FAIL_UUID_KVS': FAIL_UUID_KVS,
        'FAIL_POOL_EXHAUSTED_VLM_NR': FAIL_POOL_EXHAUSTED_VLM_NR,
        'FAIL_POOL_EXHAUSTED_MINOR_NR': FAIL_POOL_EXHAUSTED_MINOR_NR,
        'FAIL_POOL_EXHAUSTED_TCP_PORT': FAIL_POOL_EXHAUSTED_TCP_PORT,
        'FAIL_POOL_EXHAUSTED_NODE_ID': FAIL_POOL_EXHAUSTED_NODE_ID,
        'FAIL_POOL_EXHAUSTED_RSC_LAYER_ID': FAIL_POOL_EXHAUSTED_RSC_LAYER_ID,
        'FAIL_POOL_EXHAUSTED_SPECIAL_SATELLTE_TCP_PORT': FAIL_POOL_EXHAUSTED_SPECIAL_SATELLTE_TCP_PORT,
        'FAIL_POOL_EXHAUSTED_SNAPSHOT_SHIPPING_TCP_PORT': FAIL_POOL_EXHAUSTED_SNAPSHOT_SHIPPING_TCP_PORT,
        'FAIL_POOL_EXHAUSTED_BACKUP_SHIPPING_TCP_PORT': FAIL_POOL_EXHAUSTED_BACKUP_SHIPPING_TCP_PORT,
        'FAIL_EBS_COOLDOWN': FAIL_EBS_COOLDOWN,
        'FAIL_NOT_ALL_UPTODATE': FAIL_NOT_ALL_UPTODATE,
        'FAIL_EVACUATING': FAIL_EVACUATING,
        'FAIL_BACKUP_UNKNOWN_CLUSTER': FAIL_BACKUP_UNKNOWN_CLUSTER,
        'FAIL_DEPENDEND_BACKUP': FAIL_DEPENDEND_BACKUP,
        'FAIL_BACKUP_INCOMPATIBLE_VERSION': FAIL_BACKUP_INCOMPATIBLE_VERSION,
        'FAIL_SNAPSHOT_NOT_UPTODATE': FAIL_SNAPSHOT_NOT_UPTODATE,
        'FAIL_NOT_ENOUGH_FREE_SPACE': FAIL_NOT_ENOUGH_FREE_SPACE,
        'FAIL_ONLY_ONE_ACT_RSC_PER_SHARED_STOR_POOL_ALLOWED': FAIL_ONLY_ONE_ACT_RSC_PER_SHARED_STOR_POOL_ALLOWED,
        'FAIL_CRYPT_INIT': FAIL_CRYPT_INIT,
        'FAIL_SNAPSHOT_SHIPPING_NOT_SUPPORTED': FAIL_SNAPSHOT_SHIPPING_NOT_SUPPORTED,
        'FAIL_SNAPSHOT_SHIPPING_IN_PROGRESS': FAIL_SNAPSHOT_SHIPPING_IN_PROGRESS,
        'FAIL_UNDECIDABLE_AUTOPLACMENT': FAIL_UNDECIDABLE_AUTOPLACMENT,
        'FAIL_PRE_SELECT_SCRIPT_DID_NOT_TERMINATE': FAIL_PRE_SELECT_SCRIPT_DID_NOT_TERMINATE,
        'FAIL_LINSTOR_MANAGED_SATELLITE_DID_NOT_START_PROPERLY': FAIL_LINSTOR_MANAGED_SATELLITE_DID_NOT_START_PROPERLY,
        'FAIL_STLT_DOES_NOT_SUPPORT_LAYER': FAIL_STLT_DOES_NOT_SUPPORT_LAYER,
        'FAIL_STLT_DOES_NOT_SUPPORT_PROVIDER': FAIL_STLT_DOES_NOT_SUPPORT_PROVIDER,
        'FAIL_STOR_POOL_CONFIGURATION_ERROR': FAIL_STOR_POOL_CONFIGURATION_ERROR,
        'FAIL_INSUFFICIENT_REPLICA_COUNT': FAIL_INSUFFICIENT_REPLICA_COUNT,
        'FAIL_RSC_BUSY': FAIL_RSC_BUSY,
        'FAIL_INSUFFICIENT_PEER_SLOTS': FAIL_INSUFFICIENT_PEER_SLOTS,
        'FAIL_SNAPSHOTS_NOT_SUPPORTED': FAIL_SNAPSHOTS_NOT_SUPPORTED,
        'FAIL_NOT_CONNECTED': FAIL_NOT_CONNECTED,
        'FAIL_NOT_ENOUGH_NODES': FAIL_NOT_ENOUGH_NODES,
        'FAIL_IN_USE': FAIL_IN_USE,
        'FAIL_UNKNOWN_ERROR': FAIL_UNKNOWN_ERROR,
        'FAIL_IMPL_ERROR': FAIL_IMPL_ERROR,
        'WARN_INVLD_OPT_PROP_NETCOM_ENABLED': WARN_INVLD_OPT_PROP_NETCOM_ENABLED,
        'WARN_NOT_CONNECTED': WARN_NOT_CONNECTED,
        'WARN_STLT_NOT_UPDATED': WARN_STLT_NOT_UPDATED,
        'WARN_NO_STLT_CONN_DEFINED': WARN_NO_STLT_CONN_DEFINED,
        'WARN_DEL_UNSET_PROP': WARN_DEL_UNSET_PROP,
        'WARN_RSC_ALREADY_DEPLOYED': WARN_RSC_ALREADY_DEPLOYED,
        'WARN_RSC_ALREADY_HAS_DISK': WARN_RSC_ALREADY_HAS_DISK,
        'WARN_RSC_ALREADY_DISKLESS': WARN_RSC_ALREADY_DISKLESS,
        'WARN_ALL_DISKLESS': WARN_ALL_DISKLESS,
        'WARN_STORAGE_ERROR': WARN_STORAGE_ERROR,
        'WARN_NOT_FOUND_CRYPT_KEY': WARN_NOT_FOUND_CRYPT_KEY,
        'WARN_STORAGE_KIND_ADDED': WARN_STORAGE_KIND_ADDED,
        'WARN_NOT_ENOUGH_NODES_FOR_TIE_BREAKER': WARN_NOT_ENOUGH_NODES_FOR_TIE_BREAKER,
        'WARN_MIXED_PMEM_AND_NON_PMEM': WARN_MIXED_PMEM_AND_NON_PMEM,
        'WARN_UNEFFECTIVE_PROP': WARN_UNEFFECTIVE_PROP,
        'WARN_INVLD_SNAPSHOT_SHIPPING_PREFIX': WARN_INVLD_SNAPSHOT_SHIPPING_PREFIX,
        'WARN_NODE_EVICTED': WARN_NODE_EVICTED,
        'WARN_RSC_DEACTIVATED': WARN_RSC_DEACTIVATED,
        'WARN_BACKUP_DL_ONLY': WARN_BACKUP_DL_ONLY,
        'WARN_NOT_EVACUATING': WARN_NOT_EVACUATING,
        'WARN_INVLD_CONF': WARN_INVLD_CONF,
        'WARN_NOT_FOUND': WARN_NOT_FOUND,
        'INFO_NO_RSC_SPAWNED': INFO_NO_RSC_SPAWNED,
        'INFO_NODE_NAME_MISMATCH': INFO_NODE_NAME_MISMATCH,
        'INFO_PROP_SET': INFO_PROP_SET,
        'INFO_TIE_BREAKER_CREATED': INFO_TIE_BREAKER_CREATED,
        'INFO_TIE_BREAKER_DELETING': INFO_TIE_BREAKER_DELETING,
        'INFO_TIE_BREAKER_TAKEOVER': INFO_TIE_BREAKER_TAKEOVER,
        'INFO_PROP_REMOVED': INFO_PROP_REMOVED,
        'INFO_AUTO_DRBD_PROXY_CREATED': INFO_AUTO_DRBD_PROXY_CREATED,
        'INFO_NOOP': INFO_NOOP,
        'INFO_RSC_ALREADY_EXISTS': INFO_RSC_ALREADY_EXISTS,
        'UNKNOWN_API_CALL': UNKNOWN_API_CALL,
        'API_CALL_AUTH_REQ': API_CALL_AUTH_REQ,
        'API_CALL_PARSE_ERROR': API_CALL_PARSE_ERROR,
        'SUCCESS_SIGN_IN': SUCCESS_SIGN_IN,
        'FAIL_SIGN_IN': FAIL_SIGN_IN,
        'FAIL_SIGN_IN_MISSING_CREDENTIALS': FAIL_SIGN_IN_MISSING_CREDENTIALS
    }
    TYPE_MASKS = [
        0xC000000000000000,  # TYPE
        0x0000000003000000,  # OPERATION
        0x00000000003C0000,  # OBJECT
        0xC00000000000FFFF   # ACTION
    ]

    for num_str in sys.argv[1:]:
        num = long(num_str)
        mask = []
        for type_mask in TYPE_MASKS:
            for key, mask_value in MAP_MASK.items():
                if num & type_mask == mask_value:
                    mask.append(key)
        print(num_str + " = " + " | ". join(mask))
