# This file was auto-generated by Fern from our API Definition.

from .types import (
    BulkRuleResponseItem,
    BulkRuleResponseItemError,
    CreateTestRequest,
    DecisionLog,
    DecisionLogDecision,
    DecisionLogDecisionConditionsItemValue,
    DecisionLogRequest,
    DecisionLogResponse,
    DynamicRequestPayload,
    DynamicResponsePayload,
    DynamicValue,
    DynamicValueListResponse,
    Error,
    FlowBase,
    FlowDetail,
    FlowExecutionError,
    FlowListResponse,
    Folder,
    FolderListResponse,
    ParallelSolveRequest,
    ParallelSolveRequestValue,
    ParallelSolveResponse,
    RuleBase,
    RuleDetail,
    RuleExport,
    RuleListResponse,
    RuleUsage,
    SchemaField,
    SchemaFieldDefaultValue,
    SchemaFieldType,
    SuccessMessage,
    Test,
    TestListResponse,
    TestTestState,
    TestTestStateConditionsItemValue,
    TestTestStateEvaluationError,
    UsageStatistics,
    UserGroup,
    UserGroupListResponse,
    UserInviteResponse,
    UserInviteResponseUser,
    ValueLimits,
)
from .errors import BadRequestError, ForbiddenError, InternalServerError, NotFoundError
from . import assets, decisions, flows, rules, tests, users, values
from .client import AsyncRulebricks, Rulebricks
from .environment import RulebricksEnvironment
from .users import UserInviteRequestRole
from .forge import Rule, Condition, DynamicValue, DynamicValues

class Config:
    api_key: str = ""
    base_url: str = "https://rulebricks.com"
    timeout: float = 10

# Initialize the API clients immediately when the module is loaded
sync_api = Rulebricks(base_url=Config.base_url, api_key=Config.api_key, timeout=Config.timeout)
async_api = AsyncRulebricks(base_url=Config.base_url, api_key=Config.api_key, timeout=Config.timeout)

rules = sync_api.rules
flows = sync_api.flows
assets = sync_api.assets
decisions = sync_api.decisions
tests = sync_api.tests
users = sync_api.users
values = sync_api.values

def configure(api_key: str = "", base_url: str = "https://rulebricks.com", timeout: float = 10.0):
    """Configure your Rulebricks API client. This needs to be called before using other Rulebricks methods."""
    Config.api_key = api_key
    Config.base_url = base_url
    Config.timeout = timeout

    # Reinitialize clients with new config
    global sync_api, async_api
    sync_api = Rulebricks(base_url=Config.base_url, api_key=Config.api_key, timeout=Config.timeout)
    async_api = AsyncRulebricks(base_url=Config.base_url, api_key=Config.api_key, timeout=Config.timeout)

    global rules, flows, assets, decisions, tests, users, values
    rules = sync_api.rules
    flows = sync_api.flows
    assets = sync_api.assets
    decisions = sync_api.decisions
    tests = sync_api.tests
    users = sync_api.users
    values = sync_api.values

__all__ = [
    "AsyncRulebricks",
    "BadRequestError",
    "BulkRuleResponseItem",
    "BulkRuleResponseItemError",
    "CreateTestRequest",
    "DecisionLog",
    "DecisionLogDecision",
    "DecisionLogDecisionConditionsItemValue",
    "DecisionLogRequest",
    "DecisionLogResponse",
    "DynamicRequestPayload",
    "DynamicResponsePayload",
    "DynamicValue",
    "DynamicValueListResponse",
    "Error",
    "FlowBase",
    "FlowDetail",
    "FlowExecutionError",
    "FlowListResponse",
    "Folder",
    "FolderListResponse",
    "ForbiddenError",
    "InternalServerError",
    "NotFoundError",
    "ParallelSolveRequest",
    "ParallelSolveRequestValue",
    "ParallelSolveResponse",
    "RuleBase",
    "RuleDetail",
    "RuleExport",
    "RuleListResponse",
    "RuleUsage",
    "Rulebricks",
    "RulebricksEnvironment",
    "SchemaField",
    "SchemaFieldDefaultValue",
    "SchemaFieldType",
    "SuccessMessage",
    "Test",
    "TestListResponse",
    "TestTestState",
    "TestTestStateConditionsItemValue",
    "TestTestStateEvaluationError",
    "UsageStatistics",
    "UserGroup",
    "UserGroupListResponse",
    "UserInviteRequestRole",
    "UserInviteResponse",
    "UserInviteResponseUser",
    "ValueLimits",
    "assets",
    "decisions",
    "flows",
    "rules",
    "tests",
    "users",
    "values",
    "configure"
]
