# This file was auto-generated by Fern from our API Definition.

from ...core.client_wrapper import SyncClientWrapper
import typing
from ...core.request_options import RequestOptions
from ...types.flow_list_response import FlowListResponse
from ...core.pydantic_utilities import parse_obj_as
from ...errors.internal_server_error import InternalServerError
from json.decoder import JSONDecodeError
from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper


class FlowsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> FlowListResponse:
        """
        List all flows in the organization.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FlowListResponse
            Success

        Examples
        --------
        from rulebricks import Rulebricks

        client = Rulebricks(
            api_key="YOUR_API_KEY",
        )
        client.assets.flows.list()
        """
        _response = self._client_wrapper.httpx_client.request(
            "admin/flows/list",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    FlowListResponse,
                    parse_obj_as(
                        type_=FlowListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncFlowsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> FlowListResponse:
        """
        List all flows in the organization.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FlowListResponse
            Success

        Examples
        --------
        import asyncio

        from rulebricks import AsyncRulebricks

        client = AsyncRulebricks(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.assets.flows.list()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "admin/flows/list",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    FlowListResponse,
                    parse_obj_as(
                        type_=FlowListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
