# This file was auto-generated by Fern from our API Definition.

import typing
from ...core.client_wrapper import SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.folder_list_response import FolderListResponse
from ...core.pydantic_utilities import parse_obj_as
from ...errors.internal_server_error import InternalServerError
from json.decoder import JSONDecodeError
from ...core.api_error import ApiError
from ...types.folder import Folder
from ...errors.bad_request_error import BadRequestError
from ...errors.not_found_error import NotFoundError
from ...core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class FoldersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> FolderListResponse:
        """
        Retrieve all rule folders for the authenticated user.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FolderListResponse
            Success

        Examples
        --------
        from rulebricks import Rulebricks

        client = Rulebricks(
            api_key="YOUR_API_KEY",
        )
        client.assets.folders.list()
        """
        _response = self._client_wrapper.httpx_client.request(
            "admin/folders",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    FolderListResponse,
                    parse_obj_as(
                        type_=FolderListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def upsert(
        self,
        *,
        name: str,
        id: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Folder:
        """
        Create a new rule folder or update an existing one for the authenticated user.

        Parameters
        ----------
        name : str
            Name of the folder

        id : typing.Optional[str]
            Folder ID (required for updates, omit for creation)

        description : typing.Optional[str]
            Description of the folder

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Folder
            Success

        Examples
        --------
        from rulebricks import Rulebricks

        client = Rulebricks(
            api_key="YOUR_API_KEY",
        )
        client.assets.folders.upsert(
            name="Marketing Rules",
            description="Rules for marketing automation workflows",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "admin/folders",
            method="POST",
            json={
                "id": id,
                "name": name,
                "description": description,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Folder,
                    parse_obj_as(
                        type_=Folder,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete(
        self, *, id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> Folder:
        """
        Delete a specific rule folder for the authenticated user. This does not delete the rules within the folder.

        Parameters
        ----------
        id : str
            ID of the folder to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Folder
            Success

        Examples
        --------
        from rulebricks import Rulebricks

        client = Rulebricks(
            api_key="YOUR_API_KEY",
        )
        client.assets.folders.delete(
            id="abc123",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "admin/folders",
            method="DELETE",
            json={
                "id": id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Folder,
                    parse_obj_as(
                        type_=Folder,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncFoldersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> FolderListResponse:
        """
        Retrieve all rule folders for the authenticated user.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FolderListResponse
            Success

        Examples
        --------
        import asyncio

        from rulebricks import AsyncRulebricks

        client = AsyncRulebricks(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.assets.folders.list()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "admin/folders",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    FolderListResponse,
                    parse_obj_as(
                        type_=FolderListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def upsert(
        self,
        *,
        name: str,
        id: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Folder:
        """
        Create a new rule folder or update an existing one for the authenticated user.

        Parameters
        ----------
        name : str
            Name of the folder

        id : typing.Optional[str]
            Folder ID (required for updates, omit for creation)

        description : typing.Optional[str]
            Description of the folder

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Folder
            Success

        Examples
        --------
        import asyncio

        from rulebricks import AsyncRulebricks

        client = AsyncRulebricks(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.assets.folders.upsert(
                name="Marketing Rules",
                description="Rules for marketing automation workflows",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "admin/folders",
            method="POST",
            json={
                "id": id,
                "name": name,
                "description": description,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Folder,
                    parse_obj_as(
                        type_=Folder,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete(
        self, *, id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> Folder:
        """
        Delete a specific rule folder for the authenticated user. This does not delete the rules within the folder.

        Parameters
        ----------
        id : str
            ID of the folder to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Folder
            Success

        Examples
        --------
        import asyncio

        from rulebricks import AsyncRulebricks

        client = AsyncRulebricks(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.assets.folders.delete(
                id="abc123",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "admin/folders",
            method="DELETE",
            json={
                "id": id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Folder,
                    parse_obj_as(
                        type_=Folder,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
