# This file was auto-generated by Fern from our API Definition.

import typing
from ...core.client_wrapper import SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.success_message import SuccessMessage
from ...core.pydantic_utilities import parse_obj_as
from ...errors.bad_request_error import BadRequestError
from ...errors.not_found_error import NotFoundError
from ...errors.internal_server_error import InternalServerError
from json.decoder import JSONDecodeError
from ...core.api_error import ApiError
from ...types.rule_export import RuleExport
from ...errors.forbidden_error import ForbiddenError
from ...types.rule_list_response import RuleListResponse
from ...core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RulesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def delete(
        self, *, id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> SuccessMessage:
        """
        Delete a specific rule by its ID.

        Parameters
        ----------
        id : str
            The ID of the rule to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessMessage
            Rule deleted successfully

        Examples
        --------
        from rulebricks import Rulebricks

        client = Rulebricks(
            api_key="YOUR_API_KEY",
        )
        client.assets.rules.delete(
            id="id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "admin/rules/delete",
            method="DELETE",
            json={
                "id": id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SuccessMessage,
                    parse_obj_as(
                        type_=SuccessMessage,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def pull(
        self, *, id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> RuleExport:
        """
        Export a specific rule by its ID.

        Parameters
        ----------
        id : str
            The ID of the rule to export.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RuleExport
            Successful response

        Examples
        --------
        from rulebricks import Rulebricks

        client = Rulebricks(
            api_key="YOUR_API_KEY",
        )
        client.assets.rules.pull(
            id="id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "admin/rules/export",
            method="GET",
            params={
                "id": id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    RuleExport,
                    parse_obj_as(
                        type_=RuleExport,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def push(
        self,
        *,
        rule: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RuleExport:
        """
        Import a rule into the user's account.

        Parameters
        ----------
        rule : typing.Dict[str, typing.Optional[typing.Any]]
            The rule data to import.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RuleExport
            Rule imported successfully

        Examples
        --------
        from rulebricks import Rulebricks

        client = Rulebricks(
            api_key="YOUR_API_KEY",
        )
        client.assets.rules.push(
            rule={"key": "value"},
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "admin/rules/import",
            method="POST",
            json={
                "rule": rule,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    RuleExport,
                    parse_obj_as(
                        type_=RuleExport,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def list(
        self,
        *,
        folder: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RuleListResponse:
        """
        List all rules in the organization. Optionally filter by folder name or ID.

        Parameters
        ----------
        folder : typing.Optional[str]
            Filter rules by folder name or folder ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RuleListResponse
            Success

        Examples
        --------
        from rulebricks import Rulebricks

        client = Rulebricks(
            api_key="YOUR_API_KEY",
        )
        client.assets.rules.list()
        """
        _response = self._client_wrapper.httpx_client.request(
            "admin/rules/list",
            method="GET",
            params={
                "folder": folder,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    RuleListResponse,
                    parse_obj_as(
                        type_=RuleListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncRulesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def delete(
        self, *, id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> SuccessMessage:
        """
        Delete a specific rule by its ID.

        Parameters
        ----------
        id : str
            The ID of the rule to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessMessage
            Rule deleted successfully

        Examples
        --------
        import asyncio

        from rulebricks import AsyncRulebricks

        client = AsyncRulebricks(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.assets.rules.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "admin/rules/delete",
            method="DELETE",
            json={
                "id": id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SuccessMessage,
                    parse_obj_as(
                        type_=SuccessMessage,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def pull(
        self, *, id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> RuleExport:
        """
        Export a specific rule by its ID.

        Parameters
        ----------
        id : str
            The ID of the rule to export.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RuleExport
            Successful response

        Examples
        --------
        import asyncio

        from rulebricks import AsyncRulebricks

        client = AsyncRulebricks(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.assets.rules.pull(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "admin/rules/export",
            method="GET",
            params={
                "id": id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    RuleExport,
                    parse_obj_as(
                        type_=RuleExport,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def push(
        self,
        *,
        rule: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RuleExport:
        """
        Import a rule into the user's account.

        Parameters
        ----------
        rule : typing.Dict[str, typing.Optional[typing.Any]]
            The rule data to import.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RuleExport
            Rule imported successfully

        Examples
        --------
        import asyncio

        from rulebricks import AsyncRulebricks

        client = AsyncRulebricks(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.assets.rules.push(
                rule={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "admin/rules/import",
            method="POST",
            json={
                "rule": rule,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    RuleExport,
                    parse_obj_as(
                        type_=RuleExport,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def list(
        self,
        *,
        folder: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RuleListResponse:
        """
        List all rules in the organization. Optionally filter by folder name or ID.

        Parameters
        ----------
        folder : typing.Optional[str]
            Filter rules by folder name or folder ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RuleListResponse
            Success

        Examples
        --------
        import asyncio

        from rulebricks import AsyncRulebricks

        client = AsyncRulebricks(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.assets.rules.list()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "admin/rules/list",
            method="GET",
            params={
                "folder": folder,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    RuleListResponse,
                    parse_obj_as(
                        type_=RuleListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
