# This file was auto-generated by Fern from our API Definition.

import typing
from .environment import RulebricksEnvironment
import httpx
from .core.client_wrapper import SyncClientWrapper
from .rules.client import RulesClient
from .flows.client import FlowsClient
from .decisions.client import DecisionsClient
from .users.client import UsersClient
from .assets.client import AssetsClient
from .values.client import ValuesClient
from .tests.client import TestsClient
from .core.client_wrapper import AsyncClientWrapper
from .rules.client import AsyncRulesClient
from .flows.client import AsyncFlowsClient
from .decisions.client import AsyncDecisionsClient
from .users.client import AsyncUsersClient
from .assets.client import AsyncAssetsClient
from .values.client import AsyncValuesClient
from .tests.client import AsyncTestsClient


class Rulebricks:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : RulebricksEnvironment
        The environment to use for requests from the client. from .environment import RulebricksEnvironment



        Defaults to RulebricksEnvironment.DEFAULT



    api_key : str
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from rulebricks import Rulebricks

    client = Rulebricks(
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: RulebricksEnvironment = RulebricksEnvironment.DEFAULT,
        api_key: str,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout
            if timeout is not None
            else 60
            if httpx_client is None
            else httpx_client.timeout.read
        )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(
                timeout=_defaulted_timeout, follow_redirects=follow_redirects
            )
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.rules = RulesClient(client_wrapper=self._client_wrapper)
        self.flows = FlowsClient(client_wrapper=self._client_wrapper)
        self.decisions = DecisionsClient(client_wrapper=self._client_wrapper)
        self.users = UsersClient(client_wrapper=self._client_wrapper)
        self.assets = AssetsClient(client_wrapper=self._client_wrapper)
        self.values = ValuesClient(client_wrapper=self._client_wrapper)
        self.tests = TestsClient(client_wrapper=self._client_wrapper)


class AsyncRulebricks:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : RulebricksEnvironment
        The environment to use for requests from the client. from .environment import RulebricksEnvironment



        Defaults to RulebricksEnvironment.DEFAULT



    api_key : str
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from rulebricks import AsyncRulebricks

    client = AsyncRulebricks(
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: RulebricksEnvironment = RulebricksEnvironment.DEFAULT,
        api_key: str,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout
            if timeout is not None
            else 60
            if httpx_client is None
            else httpx_client.timeout.read
        )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(
                timeout=_defaulted_timeout, follow_redirects=follow_redirects
            )
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.rules = AsyncRulesClient(client_wrapper=self._client_wrapper)
        self.flows = AsyncFlowsClient(client_wrapper=self._client_wrapper)
        self.decisions = AsyncDecisionsClient(client_wrapper=self._client_wrapper)
        self.users = AsyncUsersClient(client_wrapper=self._client_wrapper)
        self.assets = AsyncAssetsClient(client_wrapper=self._client_wrapper)
        self.values = AsyncValuesClient(client_wrapper=self._client_wrapper)
        self.tests = AsyncTestsClient(client_wrapper=self._client_wrapper)


def _get_base_url(
    *, base_url: typing.Optional[str] = None, environment: RulebricksEnvironment
) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception(
            "Please pass in either base_url or environment to construct the client"
        )
