# This file was auto-generated by Fern from our API Definition.

from ..core.client_wrapper import SyncClientWrapper
import typing
import datetime as dt
from ..core.request_options import RequestOptions
from ..types.decision_log_response import DecisionLogResponse
from ..core.datetime_utils import serialize_datetime
from ..core.pydantic_utilities import parse_obj_as
from ..errors.bad_request_error import BadRequestError
from ..errors.internal_server_error import InternalServerError
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper


class DecisionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def query(
        self,
        *,
        slug: str,
        from_: typing.Optional[dt.datetime] = None,
        to: typing.Optional[dt.datetime] = None,
        cursor: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DecisionLogResponse:
        """
        Retrieve logs for a specific user and rule, with optional date range and pagination.

        Parameters
        ----------
        slug : str
            The slug of the rule to query logs for.

        from_ : typing.Optional[dt.datetime]
            Start date for the query range (ISO8601 format).

        to : typing.Optional[dt.datetime]
            End date for the query range (ISO8601 format).

        cursor : typing.Optional[str]
            Cursor for pagination.

        limit : typing.Optional[int]
            Number of results to return per page.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DecisionLogResponse
            Successful response

        Examples
        --------
        from rulebricks import Rulebricks

        client = Rulebricks(
            api_key="YOUR_API_KEY",
        )
        client.decisions.query(
            slug="slug",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "decisions/query",
            method="GET",
            params={
                "slug": slug,
                "from": serialize_datetime(from_) if from_ is not None else None,
                "to": serialize_datetime(to) if to is not None else None,
                "cursor": cursor,
                "limit": limit,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    DecisionLogResponse,
                    parse_obj_as(
                        type_=DecisionLogResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncDecisionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def query(
        self,
        *,
        slug: str,
        from_: typing.Optional[dt.datetime] = None,
        to: typing.Optional[dt.datetime] = None,
        cursor: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DecisionLogResponse:
        """
        Retrieve logs for a specific user and rule, with optional date range and pagination.

        Parameters
        ----------
        slug : str
            The slug of the rule to query logs for.

        from_ : typing.Optional[dt.datetime]
            Start date for the query range (ISO8601 format).

        to : typing.Optional[dt.datetime]
            End date for the query range (ISO8601 format).

        cursor : typing.Optional[str]
            Cursor for pagination.

        limit : typing.Optional[int]
            Number of results to return per page.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DecisionLogResponse
            Successful response

        Examples
        --------
        import asyncio

        from rulebricks import AsyncRulebricks

        client = AsyncRulebricks(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.decisions.query(
                slug="slug",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "decisions/query",
            method="GET",
            params={
                "slug": slug,
                "from": serialize_datetime(from_) if from_ is not None else None,
                "to": serialize_datetime(to) if to is not None else None,
                "cursor": cursor,
                "limit": limit,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    DecisionLogResponse,
                    parse_obj_as(
                        type_=DecisionLogResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
