# This file was auto-generated by Fern from our API Definition.

import typing
from ...core.client_wrapper import SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.test_list_response import TestListResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import parse_obj_as
from ...errors.not_found_error import NotFoundError
from ...errors.internal_server_error import InternalServerError
from json.decoder import JSONDecodeError
from ...core.api_error import ApiError
from ...types.test import Test
from ...errors.bad_request_error import BadRequestError
from ...core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class FlowsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self, slug: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TestListResponse:
        """
        Retrieves a list of tests associated with the flow identified by the slug.

        Parameters
        ----------
        slug : str
            The unique identifier for the resource.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TestListResponse
            A list of tests for the specified flow.

        Examples
        --------
        from rulebricks import Rulebricks

        client = Rulebricks(
            api_key="YOUR_API_KEY",
        )
        client.tests.flows.list(
            slug="slug",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"admin/flows/{jsonable_encoder(slug)}/tests",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    TestListResponse,
                    parse_obj_as(
                        type_=TestListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create(
        self,
        slug: str,
        *,
        name: str,
        request: typing.Dict[str, typing.Optional[typing.Any]],
        response: typing.Dict[str, typing.Optional[typing.Any]],
        critical: bool,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Test:
        """
        Adds a new test to the test suite of a flow identified by the slug.

        Parameters
        ----------
        slug : str
            The unique identifier for the resource.

        name : str
            The name of the test.

        request : typing.Dict[str, typing.Optional[typing.Any]]
            The request object for the test.

        response : typing.Dict[str, typing.Optional[typing.Any]]
            The expected response object for the test.

        critical : bool
            Indicates whether the test is critical.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Test
            Test created successfully.

        Examples
        --------
        from rulebricks import Rulebricks

        client = Rulebricks(
            api_key="YOUR_API_KEY",
        )
        client.tests.flows.create(
            slug="slug",
            name="Test 3",
            request={"param1": "value1"},
            response={"status": "success"},
            critical=True,
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"admin/flows/{jsonable_encoder(slug)}/tests",
            method="POST",
            json={
                "name": name,
                "request": request,
                "response": response,
                "critical": critical,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Test,
                    parse_obj_as(
                        type_=Test,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete(
        self,
        slug: str,
        test_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Test:
        """
        Deletes a test from the test suite of a flow identified by the slug.

        Parameters
        ----------
        slug : str
            The unique identifier for the resource.

        test_id : str
            The ID of the test.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Test
            Test deleted successfully.

        Examples
        --------
        from rulebricks import Rulebricks

        client = Rulebricks(
            api_key="YOUR_API_KEY",
        )
        client.tests.flows.delete(
            slug="slug",
            test_id="testId",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"admin/flows/{jsonable_encoder(slug)}/tests/{jsonable_encoder(test_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Test,
                    parse_obj_as(
                        type_=Test,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncFlowsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self, slug: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TestListResponse:
        """
        Retrieves a list of tests associated with the flow identified by the slug.

        Parameters
        ----------
        slug : str
            The unique identifier for the resource.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TestListResponse
            A list of tests for the specified flow.

        Examples
        --------
        import asyncio

        from rulebricks import AsyncRulebricks

        client = AsyncRulebricks(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tests.flows.list(
                slug="slug",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"admin/flows/{jsonable_encoder(slug)}/tests",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    TestListResponse,
                    parse_obj_as(
                        type_=TestListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create(
        self,
        slug: str,
        *,
        name: str,
        request: typing.Dict[str, typing.Optional[typing.Any]],
        response: typing.Dict[str, typing.Optional[typing.Any]],
        critical: bool,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Test:
        """
        Adds a new test to the test suite of a flow identified by the slug.

        Parameters
        ----------
        slug : str
            The unique identifier for the resource.

        name : str
            The name of the test.

        request : typing.Dict[str, typing.Optional[typing.Any]]
            The request object for the test.

        response : typing.Dict[str, typing.Optional[typing.Any]]
            The expected response object for the test.

        critical : bool
            Indicates whether the test is critical.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Test
            Test created successfully.

        Examples
        --------
        import asyncio

        from rulebricks import AsyncRulebricks

        client = AsyncRulebricks(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tests.flows.create(
                slug="slug",
                name="Test 3",
                request={"param1": "value1"},
                response={"status": "success"},
                critical=True,
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"admin/flows/{jsonable_encoder(slug)}/tests",
            method="POST",
            json={
                "name": name,
                "request": request,
                "response": response,
                "critical": critical,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Test,
                    parse_obj_as(
                        type_=Test,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete(
        self,
        slug: str,
        test_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Test:
        """
        Deletes a test from the test suite of a flow identified by the slug.

        Parameters
        ----------
        slug : str
            The unique identifier for the resource.

        test_id : str
            The ID of the test.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Test
            Test deleted successfully.

        Examples
        --------
        import asyncio

        from rulebricks import AsyncRulebricks

        client = AsyncRulebricks(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tests.flows.delete(
                slug="slug",
                test_id="testId",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"admin/flows/{jsonable_encoder(slug)}/tests/{jsonable_encoder(test_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Test,
                    parse_obj_as(
                        type_=Test,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
