# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
from .rule_usage import RuleUsage
import typing_extensions
from ..core.serialization import FieldMetadata
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class DynamicValue(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    Unique identifier for the dynamic value.
    """

    name: str = pydantic.Field()
    """
    Name of the dynamic value (may include dot notation for nested properties).
    """

    type: str = pydantic.Field()
    """
    Type identifier for the value (e.g., 'string', 'number', 'boolean', 'list', 'function', etc.)
    """

    value: typing.Optional[typing.Optional[typing.Any]] = None
    usages: typing.Optional[typing.List[RuleUsage]] = pydantic.Field(default=None)
    """
    Rules that use this dynamic value (only included when 'include=usage' parameter is used).
    """

    access_groups: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="accessGroups")
    ] = pydantic.Field(default=None)
    """
    Access groups assigned to this value.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
