# This file was auto-generated by Fern from our API Definition.

from .rule_base import RuleBase
import typing
import datetime as dt
import pydantic
from .folder import Folder
from .schema_field import SchemaField
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class RuleDetail(RuleBase):
    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The date this rule was created.
    """

    folder: typing.Optional[Folder] = None
    request_schema: typing.Optional[typing.List[SchemaField]] = pydantic.Field(
        default=None
    )
    """
    The published request schema for the rule.
    """

    response_schema: typing.Optional[typing.List[SchemaField]] = pydantic.Field(
        default=None
    )
    """
    The published response schema for the rule.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
