# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import typing
import pydantic
import datetime as dt
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class RuleUsage(UniversalBaseModel):
    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier for the rule.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the rule.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the rule.
    """

    slug: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique slug for the rule used in API requests.
    """

    published: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the rule is published.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The date this rule was last updated.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
