# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import typing
import pydantic
from .schema_field_type import SchemaFieldType
import typing_extensions
from .schema_field_default_value import SchemaFieldDefaultValue
from ..core.serialization import FieldMetadata
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class SchemaField(UniversalBaseModel):
    key: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique key for this field.
    """

    show: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this field is visible in the UI.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Display name for this field.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of this field.
    """

    type: typing.Optional[SchemaFieldType] = pydantic.Field(default=None)
    """
    Data type of this field.
    """

    default_value: typing_extensions.Annotated[
        typing.Optional[SchemaFieldDefaultValue], FieldMetadata(alias="defaultValue")
    ] = pydantic.Field(default=None)
    """
    Default value for this field.
    """

    default_computed_value: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="defaultComputedValue")
    ] = pydantic.Field(default=None)
    """
    Computed default value for this field.
    """

    transform: typing.Optional[str] = pydantic.Field(default=None)
    """
    Transformation expression to apply to this field.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
