# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
import typing_extensions
from .test_test_state import TestTestState
from ..core.serialization import FieldMetadata
import datetime as dt
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class Test(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    Unique identifier for the test.
    """

    name: str = pydantic.Field()
    """
    The name of the test.
    """

    request: typing.Dict[str, typing.Optional[typing.Any]] = pydantic.Field()
    """
    The request object for the test.
    """

    response: typing.Dict[str, typing.Optional[typing.Any]] = pydantic.Field()
    """
    The expected response object for the test.
    """

    critical: bool = pydantic.Field()
    """
    Indicates whether the test is critical.
    """

    error: bool = pydantic.Field()
    """
    Indicates if the test resulted in an error.
    """

    success: bool = pydantic.Field()
    """
    Indicates if the test was successful.
    """

    test_state: typing_extensions.Annotated[
        typing.Optional[TestTestState], FieldMetadata(alias="testState")
    ] = pydantic.Field(default=None)
    """
    The state of the test after execution.
    """

    last_executed: typing_extensions.Annotated[
        typing.Optional[dt.datetime], FieldMetadata(alias="lastExecuted")
    ] = pydantic.Field(default=None)
    """
    The timestamp when the test was last executed.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
