# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import typing_extensions
import typing
from ..core.serialization import FieldMetadata
import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class ValueLimits(UniversalBaseModel):
    """
    System limits for dynamic values
    """

    max_keys: typing_extensions.Annotated[
        typing.Optional[int], FieldMetadata(alias="MAX_KEYS")
    ] = pydantic.Field(default=None)
    """
    Maximum number of value keys per user
    """

    max_value_length: typing_extensions.Annotated[
        typing.Optional[int], FieldMetadata(alias="MAX_VALUE_LENGTH")
    ] = pydantic.Field(default=None)
    """
    Maximum length of a single value in characters
    """

    max_total_size: typing_extensions.Annotated[
        typing.Optional[int], FieldMetadata(alias="MAX_TOTAL_SIZE")
    ] = pydantic.Field(default=None)
    """
    Maximum total size of all values in bytes
    """

    max_key_length: typing_extensions.Annotated[
        typing.Optional[int], FieldMetadata(alias="MAX_KEY_LENGTH")
    ] = pydantic.Field(default=None)
    """
    Maximum length of a key name
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
