# This file was auto-generated by Fern from our API Definition.

import typing
from ..core.client_wrapper import SyncClientWrapper
from .groups.client import GroupsClient
from .types.user_invite_request_role import UserInviteRequestRole
from ..core.request_options import RequestOptions
from ..types.user_invite_response import UserInviteResponse
from ..core.pydantic_utilities import parse_obj_as
from ..errors.bad_request_error import BadRequestError
from ..errors.internal_server_error import InternalServerError
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper
from .groups.client import AsyncGroupsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class UsersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper
        self.groups = GroupsClient(client_wrapper=self._client_wrapper)

    def invite(
        self,
        *,
        email: str,
        role: typing.Optional[UserInviteRequestRole] = OMIT,
        access_groups: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UserInviteResponse:
        """
        Invite a new user to the organization or update role or access group data for an existing user.

        Parameters
        ----------
        email : str
            Email of the user to invite.

        role : typing.Optional[UserInviteRequestRole]
            System or custom role ID to assign to the user. Available system roles include 'admin', 'editor', and 'developer'.

        access_groups : typing.Optional[typing.Sequence[str]]
            List of access group names or IDs to assign to the user. All specified groups must exist in your organization.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserInviteResponse
            Invite successful or permissions updated successfully.

        Examples
        --------
        from rulebricks import Rulebricks

        client = Rulebricks(
            api_key="YOUR_API_KEY",
        )
        client.users.invite(
            email="newuser@example.com",
            role="developer",
            access_groups=["group1", "group2"],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "admin/users/invite",
            method="POST",
            json={
                "email": email,
                "role": role,
                "accessGroups": access_groups,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    UserInviteResponse,
                    parse_obj_as(
                        type_=UserInviteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncUsersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper
        self.groups = AsyncGroupsClient(client_wrapper=self._client_wrapper)

    async def invite(
        self,
        *,
        email: str,
        role: typing.Optional[UserInviteRequestRole] = OMIT,
        access_groups: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UserInviteResponse:
        """
        Invite a new user to the organization or update role or access group data for an existing user.

        Parameters
        ----------
        email : str
            Email of the user to invite.

        role : typing.Optional[UserInviteRequestRole]
            System or custom role ID to assign to the user. Available system roles include 'admin', 'editor', and 'developer'.

        access_groups : typing.Optional[typing.Sequence[str]]
            List of access group names or IDs to assign to the user. All specified groups must exist in your organization.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserInviteResponse
            Invite successful or permissions updated successfully.

        Examples
        --------
        import asyncio

        from rulebricks import AsyncRulebricks

        client = AsyncRulebricks(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.users.invite(
                email="newuser@example.com",
                role="developer",
                access_groups=["group1", "group2"],
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "admin/users/invite",
            method="POST",
            json={
                "email": email,
                "role": role,
                "accessGroups": access_groups,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    UserInviteResponse,
                    parse_obj_as(
                        type_=UserInviteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
