/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2.mudel.sonamallid;

import ee.ut.soras.ajavtV2.AjaTuvastaja;
import ee.ut.soras.ajavtV2.mudel.AjavtSona;
import ee.ut.soras.ajavtV2.mudel.MustriTahis;
import ee.ut.soras.ajavtV2.mudel.TuvastamisReegel;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.AjavaljendiKandidaat;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.Granulaarsus;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.SemantikaDefinitsioon;
import ee.ut.soras.ajavtV2.mudel.sonamallid.FraasiMuster;
import ee.ut.soras.ajavtV2.mudel.sonamallid.MallileVastavus;
import ee.ut.soras.ajavtV2.mudel.sonamallid.SonaKlass;
import ee.ut.soras.ajavtV2.mudel.sonamallid.SonaMall;
import ee.ut.soras.ajavtV2.util.SemDefValjadeParsija;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class FraasiMusterFSM
implements FraasiMuster {
    private String mustriID;
    private List<SonaMall> sonaMallid;
    private List<Boolean> onArajaetav;
    private TuvastamisReegel tuvastamisReegel = null;
    private List<Transition> transitions = null;
    private List<Transition> emptyTransitions = null;
    private List<StateAndPath> currentStates = null;
    private List<Integer> startStates = null;
    private int endState = -1;

    public FraasiMusterFSM(List<SonaMall> sonaMallid, List<Boolean> valikulisus, List<Boolean> araJaetavus, String mustriID) {
        this.mustriID = mustriID;
        this.sonaMallid = sonaMallid;
        this.onArajaetav = araJaetavus;
        this.buildAutomaton(sonaMallid, valikulisus);
    }

    private void buildAutomaton(List<SonaMall> sonaMallid, List<Boolean> valikulisus) {
        this.endState = sonaMallid.size();
        this.startStates = new ArrayList<Integer>();
        this.startStates.add(0);
        this.transitions = new ArrayList<Transition>();
        this.emptyTransitions = new ArrayList<Transition>();
        for (int i = 0; i < sonaMallid.size(); ++i) {
            SonaMall mall = sonaMallid.get(i);
            Transition t = new Transition(i, i + 1, mall);
            this.transitions.add(t);
            boolean valikuline = valikulisus.get(i);
            if (!valikuline) continue;
            t = new Transition(i, i + 1, null);
            this.emptyTransitions.add(t);
        }
        ArrayList<Integer> reachedStates = new ArrayList<Integer>();
        reachedStates.addAll(this.startStates);
        while (!reachedStates.isEmpty()) {
            Integer state = (Integer)reachedStates.remove(0);
            for (Transition trans : this.emptyTransitions) {
                int resultState = trans.attemptTransition(state, null, null);
                if (resultState <= -1 || resultState == state) continue;
                this.startStates.add(resultState);
                reachedStates.add(resultState);
            }
        }
    }

    @Override
    public void kontrolliMustrileVastavust(AjavtSona sona, HashMap<String, MallileVastavus> kontrollitudSonaKlassid) throws Exception {
        Object state;
        ArrayList<StateAndPath> nextStates = new ArrayList<StateAndPath>();
        boolean endStateReached = false;
        if (this.currentStates == null) {
            this.currentStates = new ArrayList<StateAndPath>();
        }
        for (Integer startState : this.startStates) {
            StateAndPath initialState = new StateAndPath(startState);
            this.currentStates.add(initialState);
        }
        LinkedList<StateAndPath> reachedStates = new LinkedList<StateAndPath>();
        for (StateAndPath stateAndPath : this.currentStates) {
            int state2 = stateAndPath.getState();
            for (Transition trans : this.transitions) {
                int resultState = trans.attemptTransition(state2, sona, kontrollitudSonaKlassid);
                if (resultState <= -1) continue;
                if (resultState == this.endState) {
                    endStateReached = true;
                }
                StateAndPath newSP = new StateAndPath(resultState, stateAndPath, state2, sona);
                nextStates.add(newSP);
                reachedStates.add(newSP);
            }
        }
        while (!reachedStates.isEmpty()) {
            StateAndPath stateAndPath = (StateAndPath)reachedStates.remove(0);
            state = stateAndPath.getState();
            for (Transition trans : this.emptyTransitions) {
                int resultState = trans.attemptTransition((Integer)state, sona, kontrollitudSonaKlassid);
                if (resultState <= -1 || resultState == (Integer)state) continue;
                StateAndPath newSP = new StateAndPath(resultState, stateAndPath, -1, null);
                nextStates.add(newSP);
                reachedStates.add(newSP);
                if (resultState != this.endState) continue;
                endStateReached = true;
            }
        }
        if (endStateReached) {
            this.konstrueeriJaKinnitaEraldatudAjavaljendiKandidaadid(nextStates);
            Iterator<StateAndPath> iterator = nextStates.iterator();
            while (iterator.hasNext()) {
                state = iterator.next();
                if (((StateAndPath)state).getState() != this.endState) continue;
                iterator.remove();
            }
        }
        this.currentStates = nextStates;
    }

    private AjavaljendiKandidaat konstrueeriJaKinnitaEraldatudAjavaljendiKandidaadid(ArrayList<StateAndPath> nextStates) {
        for (StateAndPath stateAndPath : nextStates) {
            if (stateAndPath.getState() != this.endState) continue;
            AjavaljendiKandidaat ajavaljendiKandidaat = null;
            HashMap<String, List<AjavtSona>> malleRahuldavadAlamkandidaadid = stateAndPath.getPath();
            ArrayList<AjavtSona> eraldatudSonad = new ArrayList<AjavtSona>();
            for (int i = 0; i < this.endState; ++i) {
                String strKey = String.valueOf(i);
                if (!malleRahuldavadAlamkandidaadid.containsKey(strKey) || this.onArajaetav.get(i).booleanValue()) continue;
                eraldatudSonad.addAll((Collection<AjavtSona>)malleRahuldavadAlamkandidaadid.get(strKey));
            }
            if (eraldatudSonad.isEmpty()) continue;
            ajavaljendiKandidaat = new AjavaljendiKandidaat();
            if (this.lisaKandidaadileSemantikaDefinitsioonid(ajavaljendiKandidaat, malleRahuldavadAlamkandidaadid)) {
                AjaTuvastaja.seoSonadKandidaadiKylge(ajavaljendiKandidaat, eraldatudSonad);
                ajavaljendiKandidaat.lisaTuvastamisReegel(this.tuvastamisReegel);
            }
            ajavaljendiKandidaat.setMustriID(this.mustriID);
        }
        return null;
    }

    private boolean lisaKandidaadileSemantikaDefinitsioonid(AjavaljendiKandidaat ajav, HashMap<String, List<AjavtSona>> malliRahuldavadAlamFraasid) {
        SemDefValjadeParsija.FORMAT_OF_VALUE formatOfValue;
        boolean eraldatiVahemaltYksSemDef = false;
        ArrayList<SemantikaDefinitsioon> semDefidSonaMallidest = new ArrayList<SemantikaDefinitsioon>();
        HashMap<Integer, String> semDefidSonaMallidestIndeksMustris = new HashMap<Integer, String>();
        HashMap<String, String> rahuldatudMustriosad = new HashMap<String, String>();
        for (int i = 0; i < this.sonaMallid.size(); ++i) {
            String voti = String.valueOf(i);
            if (!malliRahuldavadAlamFraasid.containsKey(voti)) continue;
            List<AjavtSona> malliRahuldavAlamFraas = malliRahuldavadAlamFraasid.get(voti);
            AjavtSona viimaneSobitunudSona = malliRahuldavAlamFraas.get(malliRahuldavAlamFraas.size() - 1);
            List<SemantikaDefinitsioon> semDefs = this.sonaMallid.get(i).tagastaMalliSemantilineOsa(viimaneSobitunudSona);
            if (semDefs == null || semDefs.isEmpty()) continue;
            if (semDefs.get(0).getSonaKlass() != null) {
                rahuldatudMustriosad.put(semDefs.get(0).getSonaKlass(), "1");
                rahuldatudMustriosad.put(semDefs.get(0).getSonaKlass() + "_" + voti, "1");
                for (int j = 0; j < semDefs.size(); ++j) {
                    semDefidSonaMallidestIndeksMustris.put(semDefidSonaMallidest.size() + j, voti);
                }
            }
            semDefidSonaMallidest.addAll(semDefs);
        }
        if (this.tuvastamisReegel != null) {
            List<SemantikaDefinitsioon> semDefidUued = this.tuvastamisReegel.taiendaSonaMallidestSaadudSemDeffe(malliRahuldavadAlamFraasid, rahuldatudMustriosad, semDefidSonaMallidest, semDefidSonaMallidestIndeksMustris, this.sonaMallid);
            semDefidSonaMallidest.addAll(semDefidUued);
        }
        for (SemantikaDefinitsioon semDefinitsioon1 : semDefidSonaMallidest) {
            String refferedName;
            formatOfValue = SemDefValjadeParsija.detectFormatOfValue(semDefinitsioon1.getSemValue());
            if (formatOfValue == SemDefValjadeParsija.FORMAT_OF_VALUE.REF_TO_VAL) {
                refferedName = semDefinitsioon1.getSemValue().split(":")[1];
                for (SemantikaDefinitsioon semDefinitsioon2 : semDefidSonaMallidest) {
                    if (semDefinitsioon2.getSonaKlass() == null || !semDefinitsioon2.getSonaKlass().equals(refferedName) || semDefinitsioon2.getSemValue() == null) continue;
                    semDefinitsioon1.setSemValue(semDefinitsioon2.getSemValue());
                }
            }
            if (formatOfValue != SemDefValjadeParsija.FORMAT_OF_VALUE.REF_TO_LAB) continue;
            refferedName = semDefinitsioon1.getSemValue().split(":")[1];
            for (SemantikaDefinitsioon semDefinitsioon2 : semDefidSonaMallidest) {
                if (semDefinitsioon2.getSonaKlass() == null || !semDefinitsioon2.getSonaKlass().equals(refferedName) || semDefinitsioon2.getSemLabel() == null) continue;
                semDefinitsioon1.setSemValue(semDefinitsioon2.getSemLabel());
            }
        }
        ListIterator<SemantikaDefinitsioon> listIterator = semDefidSonaMallidest.listIterator();
        while (listIterator.hasNext()) {
            SemantikaDefinitsioon semDefinitsioon = (SemantikaDefinitsioon)listIterator.next();
            formatOfValue = SemDefValjadeParsija.detectFormatOfValue(semDefinitsioon.getSemValue());
            if (semDefinitsioon.getGranulaarsus() != Granulaarsus.HOUR_OF_DAY && (semDefinitsioon.getSemLabel() != null || formatOfValue == SemDefValjadeParsija.FORMAT_OF_VALUE.UNSET || formatOfValue == SemDefValjadeParsija.FORMAT_OF_VALUE.FRACTION || formatOfValue == SemDefValjadeParsija.FORMAT_OF_VALUE.INTEGER || formatOfValue == SemDefValjadeParsija.FORMAT_OF_VALUE.CONSTANT)) continue;
            List<SemantikaDefinitsioon> lahtikirjutatudDefinitsioonid = SemDefValjadeParsija.kirjutaLahtiSemantikadefinitsioon(semDefinitsioon, formatOfValue);
            listIterator.remove();
            for (SemantikaDefinitsioon lahtiKirjutatudSemDef : lahtikirjutatudDefinitsioonid) {
                listIterator.add(lahtiKirjutatudSemDef);
            }
        }
        Collections.sort(semDefidSonaMallidest);
        for (int i = 0; i < semDefidSonaMallidest.size(); ++i) {
            SemantikaDefinitsioon semDefinitsioon = (SemantikaDefinitsioon)semDefidSonaMallidest.get(i);
            ajav.lisaSemantikaEhitusklots(semDefinitsioon);
            eraldatiVahemaltYksSemDef = true;
        }
        if (eraldatiVahemaltYksSemDef && this.tuvastamisReegel != null && this.tuvastamisReegel.kasLeidubMustriTahiseid()) {
            List<MustriTahis> mustriTahised = this.tuvastamisReegel.parsiRahuldatudMustriosaleVastavadMustriTahised(malliRahuldavadAlamFraasid, rahuldatudMustriosad);
            ajav.lisaMustriTahised(mustriTahised);
        }
        return eraldatiVahemaltYksSemDef;
    }

    @Override
    public String getMustriID() {
        return this.mustriID;
    }

    @Override
    public void setMustriID(String mustriID) {
        this.mustriID = mustriID;
    }

    @Override
    public List<SonaMall> getSonaMallid() {
        return this.sonaMallid;
    }

    @Override
    public void setTuvastamisReegel(TuvastamisReegel tuvastamisReegel) {
        this.tuvastamisReegel = tuvastamisReegel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.mustriID != null) {
            sb.append(this.mustriID);
            sb.append(" ");
        }
        sb.append("< ");
        for (int i = 0; i < this.sonaMallid.size(); ++i) {
            SonaMall mall = this.sonaMallid.get(i);
            sb.append(mall);
            sb.append(" ");
        }
        sb.append(">");
        return sb.toString();
    }

    private class StateAndPath {
        private int state = -1;
        private HashMap<String, List<AjavtSona>> pathOfMatches = null;

        public StateAndPath(int state) {
            this.state = state;
        }

        public StateAndPath(int newState, StateAndPath prevStateAndPath, int sonaMalliIndeks, AjavtSona sona) {
            this.state = newState;
            if (prevStateAndPath.pathOfMatches != null) {
                this.pathOfMatches = new HashMap<String, List<AjavtSona>>(prevStateAndPath.pathOfMatches);
            }
            if (sonaMalliIndeks != -1) {
                this.addToPath(sonaMalliIndeks, sona);
            }
        }

        public int getState() {
            return this.state;
        }

        public void addToPath(Integer key, AjavtSona sona) {
            String strKey;
            if (this.pathOfMatches == null) {
                this.pathOfMatches = new HashMap();
            }
            if (this.pathOfMatches.containsKey(strKey = key.toString())) {
                if (sona != null) {
                    this.pathOfMatches.get(strKey).add(sona);
                }
            } else {
                ArrayList<AjavtSona> list = new ArrayList<AjavtSona>();
                if (sona != null) {
                    list.add(sona);
                }
                this.pathOfMatches.put(strKey, list);
            }
        }

        public HashMap<String, List<AjavtSona>> getPath() {
            return this.pathOfMatches;
        }
    }

    private class Transition {
        private int sourceState = -1;
        private SonaMall requiredMatch = null;
        private int targetState = -1;

        public Transition(int source, int target, SonaMall requiredMatch) {
            this.sourceState = source;
            this.targetState = target;
            this.requiredMatch = requiredMatch;
        }

        public int attemptTransition(int source, AjavtSona sona, HashMap<String, MallileVastavus> kontrollitudSonaKlassid) {
            if (source == this.sourceState) {
                SonaMall kontrollitavMall = this.requiredMatch;
                if (kontrollitavMall == null) {
                    return this.targetState;
                }
                MallileVastavus vastavus = MallileVastavus.EI_VASTA;
                if (kontrollitavMall.getTyyp() == SonaMall.TYYP.SONAKLASS) {
                    String klassiNimi = ((SonaKlass)kontrollitavMall).getNimi();
                    if (kontrollitudSonaKlassid.containsKey(klassiNimi)) {
                        vastavus = kontrollitudSonaKlassid.get(klassiNimi);
                    } else {
                        vastavus = kontrollitavMall.vastabMallile(sona);
                        kontrollitudSonaKlassid.put(klassiNimi, vastavus);
                    }
                } else {
                    vastavus = kontrollitavMall.vastabMallile(sona);
                }
                if (vastavus == MallileVastavus.VASTAB_LOPLIKULT) {
                    return this.targetState;
                }
                if (vastavus == MallileVastavus.EI_VASTA) {
                    return -1;
                }
                return this.sourceState;
            }
            return -1;
        }
    }
}

