/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2.mudel.sonamallid;

import ee.ut.soras.ajavtV2.mudel.AjavtSona;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.AjavaljendiKandidaat;
import java.util.List;
import java.util.regex.Pattern;

public class NegatiivneMuster {
    private int algusPositsioon = Integer.MIN_VALUE;
    private String[] musterSonena = null;
    private Pattern[] musterRegExpidena = null;
    private boolean sailitaYmbritsevadMargid = false;

    private void kompileeriRegulaarAvaldised() {
        if (this.musterSonena != null && this.musterSonena.length > 0) {
            this.musterRegExpidena = new Pattern[this.musterSonena.length];
            for (int i = 0; i < this.musterSonena.length; ++i) {
                String regExpDescript = this.musterSonena[i];
                try {
                    this.musterRegExpidena[i] = Pattern.compile(regExpDescript);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public boolean sobitaMustriga(List<AjavtSona> sonad, int ajavAlgusPos) {
        if (this.algusPositsioon != Integer.MIN_VALUE) {
            int startPos;
            if (this.musterRegExpidena == null) {
                this.kompileeriRegulaarAvaldised();
            }
            if (this.musterRegExpidena != null && 0 <= (startPos = ajavAlgusPos + this.algusPositsioon)) {
                int i;
                for (i = 0; startPos + i < sonad.size() && i < this.musterRegExpidena.length; ++i) {
                    AjavtSona sona = sonad.get(startPos + i);
                    Pattern pattern = this.musterRegExpidena[i];
                    if (pattern != null) {
                        boolean wordMatches = false;
                        wordMatches = !this.sailitaYmbritsevadMargid ? pattern.matcher(sona.getAlgSonaYmbritsevateMarkideta()).matches() : pattern.matcher(sona.getAlgSonaErisymbolidNormaliseeritud()).matches();
                        if (wordMatches) continue;
                        return false;
                    }
                    return false;
                }
                if (i == this.musterRegExpidena.length) {
                    return true;
                }
            }
        }
        return false;
    }

    public void kontrolliNegatiivsetMustritJaVajaduselEemaldaAjav(List<AjavtSona> sonad, int ajavAlgusPos, AjavaljendiKandidaat kandidaat) {
        boolean sobitusMustriga = this.sobitaMustriga(sonad, ajavAlgusPos);
        if (sobitusMustriga) {
            kandidaat.eemaldaEnnastSonadeKyljest();
        }
    }

    public int getAlgusPositsioon() {
        return this.algusPositsioon;
    }

    public void setAlgusPositsioon(int algusPositsioon) {
        this.algusPositsioon = algusPositsioon;
    }

    public boolean isSailitaYmbritsevadMargid() {
        return this.sailitaYmbritsevadMargid;
    }

    public void setSailitaYmbritsevadMargid(boolean sailitaYmbritsevadMargid) {
        this.sailitaYmbritsevadMargid = sailitaYmbritsevadMargid;
    }

    public void setMusterSonena(String musterSonena) {
        String[] potentsiaalsedAvaldised = musterSonena.split("\\s+");
        if (potentsiaalsedAvaldised.length > 0) {
            int sobivaidAvaldisi = 0;
            for (int i = 0; i < potentsiaalsedAvaldised.length; ++i) {
                String string = potentsiaalsedAvaldised[i];
                potentsiaalsedAvaldised[i] = string = string.replace("/", "");
                if (potentsiaalsedAvaldised[i].length() <= 0) continue;
                ++sobivaidAvaldisi;
            }
            if (sobivaidAvaldisi > 0) {
                this.musterSonena = new String[sobivaidAvaldisi];
                int j = 0;
                for (int i = 0; i < potentsiaalsedAvaldised.length; ++i) {
                    if (potentsiaalsedAvaldised[i].length() <= 0) continue;
                    this.musterSonena[j++] = potentsiaalsedAvaldised[i];
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.musterSonena != null) {
            sb.append("-(");
            sb.append(this.algusPositsioon);
            sb.append(")- ");
            for (String alamMuster : this.musterSonena) {
                sb.append(alamMuster + " ");
            }
            sb.append(" --");
        } else {
            sb.append("-- null --");
        }
        return sb.toString();
    }
}

