/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogiPidaja {
    private boolean kirjutaLogiFaili = false;
    private boolean kirjutaLogiValjundisse = false;
    private PrintStream raportivoog = null;
    private String failinimePrefiks = "logi";
    private String raportiFailiNimi = "";
    private String kodeering = "UTF-8";

    public LogiPidaja(boolean kirjutaLogiFaili) {
        this.setKirjutaLogiFaili(kirjutaLogiFaili);
    }

    public LogiPidaja(boolean kirjutaLogiFaili, String failinimePrefiks) {
        this.failinimePrefiks = failinimePrefiks;
        this.setKirjutaLogiFaili(kirjutaLogiFaili);
    }

    private void initsialiseeriFailiVoog() {
        String raportiFailiNimi;
        Date curDate = new Date();
        this.raportiFailiNimi = raportiFailiNimi = this.konstrueeriRaportiFailiNimi(curDate);
        try {
            FileOutputStream fileOutput = new FileOutputStream(raportiFailiNimi, true);
            this.raportivoog = new PrintStream((OutputStream)fileOutput, true, this.kodeering);
            this.println("---------------------------------------------------------");
            this.println(curDate.toString());
            this.println();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("Ilmnes t6rge ning faili " + raportiFailiNimi + " ei 6nnestunud andmeid lisada.");
            this.raportivoog = null;
        }
    }

    private String konstrueeriRaportiFailiNimi(Date curDate) {
        SimpleDateFormat formaat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-SSS");
        return this.failinimePrefiks + "_" + formaat.format(curDate) + ".txt";
    }

    public void println() {
        this.print("\n");
    }

    public void println(String line) {
        this.print(line + "\n");
    }

    public void print(String line) {
        if (this.raportivoog != null) {
            this.raportivoog.print(line);
            this.raportivoog.flush();
        }
        if (this.kirjutaLogiValjundisse) {
            System.out.print(line);
        }
    }

    public void printErrStackTraces(Exception exp) {
        if (this.raportivoog != null) {
            exp.printStackTrace(this.raportivoog);
        }
        exp.printStackTrace();
    }

    private void sulgeRaportiVoog() {
        if (this.raportivoog != null) {
            Date kuup2ev = new Date();
            this.println("---------------------------------------------------------");
            this.println();
            this.println(String.valueOf("T88 l6pp: " + kuup2ev.toString()));
            this.println();
            this.raportivoog.close();
        }
    }

    public boolean isKirjutaLogiFaili() {
        return this.kirjutaLogiFaili;
    }

    public void setKirjutaLogiFaili(boolean kirjutaLogiFaili) {
        if (!this.kirjutaLogiFaili && kirjutaLogiFaili) {
            this.initsialiseeriFailiVoog();
        } else if (this.kirjutaLogiFaili && !kirjutaLogiFaili) {
            this.sulgeRaportiVoog();
        }
        this.kirjutaLogiFaili = kirjutaLogiFaili;
    }

    public boolean isKirjutaLogiValjundisse() {
        return this.kirjutaLogiValjundisse;
    }

    public void setKirjutaLogiValjundisse(boolean kirjutaLogiValjundisse) {
        this.kirjutaLogiValjundisse = kirjutaLogiValjundisse;
    }

    public String getRaportiFailiNimi() {
        if (this.raportiFailiNimi != null && this.raportiFailiNimi.lastIndexOf(File.separator) > -1) {
            int k = this.raportiFailiNimi.lastIndexOf(File.separator);
            return this.raportiFailiNimi.substring(k + File.separator.length());
        }
        return this.raportiFailiNimi;
    }

    public PrintStream getRaportiVoog() {
        return this.raportivoog;
    }
}

