/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.learning.weight.bayesian;

import org.linqs.psl.application.learning.weight.bayesian.GaussianProcessPrior;
import org.linqs.psl.application.learning.weight.bayesian.SquaredExpKernel;
import org.linqs.psl.config.Config;
import org.linqs.psl.util.FloatMatrix;

public abstract class GaussianProcessKernel {
    public static final String CONFIG_PREFIX = "gppker";
    public static final String SCALE_KEY = "gppker.scale";
    public static float SCALE_DEFAULT = 1.0f;
    public static final String REL_DEP_KEY = "gppker.reldep";
    public static float REL_DEP_DEFAULT = 1.0f;
    public static final String SPACE_KEY = "gppker.space";
    public static final String SPACE_DEFAULT = Space.SS.toString();
    protected final FloatMatrix scalingWeights;
    protected final boolean weighted;
    protected final float scale;
    protected final float relDep;
    protected final Space space;

    public GaussianProcessKernel() {
        this(null, false);
    }

    public GaussianProcessKernel(float[] scalingWeights) {
        this(FloatMatrix.columnVector(scalingWeights), true);
    }

    private GaussianProcessKernel(FloatMatrix scalingWeights, boolean weighted) {
        this.scalingWeights = scalingWeights;
        this.weighted = weighted;
        this.scale = Config.getFloat(SCALE_KEY, SCALE_DEFAULT);
        this.relDep = Config.getFloat(REL_DEP_KEY, REL_DEP_DEFAULT);
        this.space = Space.valueOf(Config.getString(SPACE_KEY, SPACE_DEFAULT).toUpperCase());
    }

    public abstract float kernel(FloatMatrix var1, FloatMatrix var2);

    public float kernel(float[] point1, float[] point2, float[] buffer1, float[] buffer2, FloatMatrix matrixShell1, FloatMatrix matrixShell2) {
        assert (point1.length == point2.length);
        assert (buffer1.length == buffer2.length);
        assert (point1.length == buffer1.length);
        for (int i = 0; i < point1.length; ++i) {
            buffer1[i] = point1[i];
            buffer2[i] = point2[i];
        }
        matrixShell1.assume(buffer1, buffer1.length, 1);
        matrixShell2.assume(buffer2, buffer2.length, 1);
        return this.kernel(matrixShell1, matrixShell2);
    }

    public float kernel(float[] point1, float[] point2) {
        return this.kernel(point1, point2, new float[point1.length], new float[point2.length], new FloatMatrix(), new FloatMatrix());
    }

    public static GaussianProcessKernel makeKernel(KernelType type, GaussianProcessPrior method) {
        switch (type) {
            case SQUARED_EXP: {
                return new SquaredExpKernel();
            }
            case WEIGHTED_SQUARED_EXP: {
                int[] counts = method.computeScalingFactor();
                float max = 0.0f;
                for (int i = 0; i < counts.length; ++i) {
                    if (!((float)counts[i] > max)) continue;
                    max = counts[i];
                }
                float[] scale = new float[counts.length];
                for (int i = 0; i < counts.length; ++i) {
                    scale[i] = (float)counts[i] / max;
                }
                return new SquaredExpKernel(scale);
            }
        }
        throw new IllegalStateException("Unknown KernelType: " + (Object)((Object)type));
    }

    public static enum KernelType {
        SQUARED_EXP,
        WEIGHTED_SQUARED_EXP;

    }

    public static enum Space {
        SS,
        OS,
        LS;

    }
}

