/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.learning.weight.search.grid;

import java.util.List;
import org.linqs.psl.application.learning.weight.search.grid.GridSearch;
import org.linqs.psl.config.Config;
import org.linqs.psl.database.Database;
import org.linqs.psl.model.Model;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.util.RandUtils;
import org.linqs.psl.util.StringUtils;

public class RandomGridSearch
extends GridSearch {
    public static final String CONFIG_PREFIX = "randomgridsearch";
    public static final String MAX_LOCATIONS_KEY = "randomgridsearch.maxlocations";
    public static final int MAX_LOCATIONS_DEFAULT = 150;
    private int maxLocations = Config.getInt("randomgridsearch.maxlocations", 150);

    public RandomGridSearch(Model model, Database rvDB, Database observedDB) {
        this(model.getRules(), rvDB, observedDB);
    }

    public RandomGridSearch(List<Rule> rules, Database rvDB, Database observedDB) {
        super(rules, rvDB, observedDB);
        if (this.maxLocations < 1) {
            throw new IllegalArgumentException("Need at least one location for grid search.");
        }
        this.numLocations = Math.min(this.numLocations, this.maxLocations);
    }

    @Override
    protected boolean chooseNextLocation() {
        do {
            this.currentLocation = this.randomConfiguration();
        } while (this.objectives.containsKey(this.currentLocation));
        return true;
    }

    protected String randomConfiguration() {
        int[] indexes = new int[this.mutableRules.size()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = RandUtils.nextInt(this.possibleWeights.length);
        }
        return StringUtils.join(":", indexes);
    }

    @Override
    public void setBudget(double budget) {
        super.setBudget(budget);
        this.numLocations = Math.min(this.numLocations, (int)Math.ceil(budget * (double)this.maxLocations));
    }
}

