/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database.atom;

import java.util.Set;
import org.linqs.psl.config.Config;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.util.IteratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistedAtomManager
extends AtomManager {
    private static final Logger log = LoggerFactory.getLogger(PersistedAtomManager.class);
    public static final String CONFIG_PREFIX = "persistedatommanager";
    public static final String THROW_ACCESS_EXCEPTION_KEY = "persistedatommanager.throwaccessexception";
    public static final boolean THROW_ACCESS_EXCEPTION_DEFAULT = true;
    private final boolean throwOnIllegalAccess = Config.getBoolean("persistedatommanager.throwaccessexception", true);
    private boolean warnOnIllegalAccess;
    private int persistedAtomCount;

    public PersistedAtomManager(Database db) {
        this(db, false);
    }

    public PersistedAtomManager(Database db, boolean prebuiltCache) {
        super(db);
        boolean bl = this.warnOnIllegalAccess = !this.throwOnIllegalAccess;
        if (prebuiltCache) {
            this.persistedAtomCount = db.getCachedRVACount();
        } else {
            this.buildPersistedAtomCache();
        }
    }

    private void buildPersistedAtomCache() {
        this.persistedAtomCount = 0;
        for (StandardPredicate predicate : this.db.getDataStore().getRegisteredPredicates()) {
            if (this.db.isClosed(predicate)) {
                this.db.getAllGroundAtoms(predicate);
                continue;
            }
            for (RandomVariableAtom atom : this.db.getAllGroundRandomVariableAtoms(predicate)) {
                atom.setPersisted(true);
                ++this.persistedAtomCount;
            }
            this.db.getAllGroundObservedAtoms(predicate);
        }
    }

    @Override
    public GroundAtom getAtom(Predicate predicate, Constant ... arguments) {
        GroundAtom atom = this.db.getAtom(predicate, arguments);
        if (!(atom instanceof RandomVariableAtom)) {
            return atom;
        }
        RandomVariableAtom rvAtom = (RandomVariableAtom)atom;
        if (!rvAtom.getPersisted()) {
            rvAtom.setAccessException(true);
        }
        if (this.enableAccessExceptions && (this.throwOnIllegalAccess || this.warnOnIllegalAccess) && rvAtom.getAccessException()) {
            this.reportAccessException(null, rvAtom);
        }
        return rvAtom;
    }

    public void commitPersistedAtoms() {
        this.db.commitCachedAtoms(true);
    }

    public int getPersistedCount() {
        return this.persistedAtomCount;
    }

    public Iterable<RandomVariableAtom> getPersistedRVAtoms() {
        return IteratorUtils.filter(this.db.getAllCachedRandomVariableAtoms(), new IteratorUtils.FilterFunction<RandomVariableAtom>(){

            @Override
            public boolean keep(RandomVariableAtom atom) {
                return atom.getPersisted();
            }
        });
    }

    protected void addToPersistedCache(Set<RandomVariableAtom> atoms) {
        for (RandomVariableAtom atom : atoms) {
            if (atom.getPersisted()) continue;
            atom.setPersisted(true);
            ++this.persistedAtomCount;
        }
    }

    @Override
    public void reportAccessException(RuntimeException ex, GroundAtom offendingAtom) {
        if (this.throwOnIllegalAccess) {
            if (ex == null) {
                ex = new PersistedAccessException((RandomVariableAtom)offendingAtom);
            }
            throw ex;
        }
        if (this.warnOnIllegalAccess) {
            this.warnOnIllegalAccess = false;
            log.warn(String.format("Found a non-persisted RVA (%s). If you do not understand the implications of this warning, check your configuration and set '%s' to true. This warning will only be logged once.", offendingAtom, THROW_ACCESS_EXCEPTION_KEY));
        }
    }

    public static class PersistedAccessException
    extends IllegalArgumentException {
        public RandomVariableAtom atom;

        public PersistedAccessException(RandomVariableAtom atom) {
            super("Can only call getAtom() on persisted RandomVariableAtoms (RVAs) using a PersistedAtomManager. Cannot access " + atom + "." + " This typically means that provided data is insufficient." + " An RVA (atom to be inferred (target)) was constructed during" + " grounding that does not exist in the provided data.");
            this.atom = atom;
        }
    }
}

