/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.dcd.term;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.linqs.psl.reasoner.dcd.term.DCDObjectiveTerm;
import org.linqs.psl.reasoner.dcd.term.DCDStreamingTermStore;
import org.linqs.psl.reasoner.term.streaming.StreamingCacheIterator;
import org.linqs.psl.util.RuntimeStats;

public class DCDStreamingCacheIterator
extends StreamingCacheIterator<DCDObjectiveTerm> {
    public DCDStreamingCacheIterator(DCDStreamingTermStore parentStore, boolean readonly, List<DCDObjectiveTerm> termCache, List<DCDObjectiveTerm> termPool, ByteBuffer termBuffer, ByteBuffer volatileBuffer, boolean shufflePage, int[] shuffleMap, boolean randomizePageAccess, int numPages) {
        super(parentStore, readonly, termCache, termPool, termBuffer, volatileBuffer, shufflePage, shuffleMap, randomizePageAccess, numPages);
    }

    @Override
    protected void readPage(String termPagePath, String volatilePagePath) {
        int termsSize = 0;
        int numTerms = 0;
        int headerSize = 8;
        int volatilesSize = 0;
        try (FileInputStream termStream = new FileInputStream(termPagePath);
             FileInputStream volatileStream = new FileInputStream(volatilePagePath);){
            termStream.read(this.termBuffer.array(), 0, headerSize);
            termsSize = this.termBuffer.getInt();
            numTerms = this.termBuffer.getInt();
            volatilesSize = 4 * numTerms;
            termStream.read(this.termBuffer.array(), headerSize, termsSize);
            volatileStream.read(this.volatileBuffer.array(), 0, volatilesSize);
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("Unable to read cache pages: [%s ; %s].", termPagePath, volatilePagePath), ex);
        }
        RuntimeStats.logDiskRead(headerSize + termsSize);
        RuntimeStats.logDiskRead(volatilesSize);
        for (int i = 0; i < numTerms; ++i) {
            DCDObjectiveTerm term = (DCDObjectiveTerm)this.termPool.get(i);
            term.read(this.termBuffer, this.volatileBuffer);
            this.termCache.add(term);
        }
    }

    @Override
    protected void writeVolatilePage(String volatilePagePath) {
        int volatileBufferSize = 4 * this.termCache.size();
        if (this.shufflePage) {
            for (int shuffledIndex = 0; shuffledIndex < this.termCache.size(); ++shuffledIndex) {
                int writeIndex = this.shuffleMap[shuffledIndex];
                DCDObjectiveTerm term = (DCDObjectiveTerm)this.termCache.get(shuffledIndex);
                this.volatileBuffer.putFloat(writeIndex * 4, term.getLagrange());
            }
        } else {
            for (DCDObjectiveTerm term : this.termCache) {
                this.volatileBuffer.putFloat(term.getLagrange());
            }
        }
        try (FileOutputStream stream = new FileOutputStream(volatilePagePath);){
            stream.write(this.volatileBuffer.array(), 0, volatileBufferSize);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to write volatile cache page: " + volatilePagePath, ex);
        }
        RuntimeStats.logDiskWrite(volatileBufferSize);
    }
}

