"""
Ruby Manager Web3 - A Python package for Ruby-style Web3 interactions with POA blockchain
"""

try:
    from ._version import version as __version__
except ImportError:
    __version__ = "0.1.0"

__author__ = "Your Name"
__email__ = "your.email@example.com"

from .core.manager import RubyWeb3Manager
from .core.contracts import ContractManager
from .core.tokens import TokenManager
from .utils.converter import RubyConverter
from .utils.formatter import ResponseFormatter
from .models.transactions import Transaction, TokenTransfer, GasEstimate
from .models.tokens import TokenInfo, TokenBalance
from .services.multicall import MulticallService
from .services.events import EventService
from .services.price_feed import PriceFeedService

__all__ = [
    "RubyWeb3Manager",
    "ContractManager",
    "TokenManager",
    "RubyConverter",
    "ResponseFormatter",
    "Transaction",
    "TokenTransfer",
    "GasEstimate",
    "TokenInfo",
    "TokenBalance",
    "MulticallService",
    "EventService",
    "PriceFeedService",
]