from dataclasses import dataclass
from typing import Optional, Dict, Any
from datetime import datetime
from web3 import Web3

@dataclass
class Transaction:
    hash: str
    from_address: str
    to_address: Optional[str]
    value: int
    gas: int
    gas_price: int
    block_number: Optional[int]
    timestamp: Optional[datetime]
    status: Optional[str] = None
    input_data: str = "0x"
    
    @property
    def value_eth(self) -> float:
        return Web3.from_wei(self.value, 'ether')

@dataclass
class TokenTransfer:
    token_address: str
    from_address: str
    to_address: str
    value: int
    transaction_hash: str
    log_index: int

@dataclass
class GasEstimate:
    gas_limit: int
    gas_price: int
    total_cost_wei: int
    total_cost_eth: float