import re
from web3 import Web3
from eth_account import Account

def validate_private_key(private_key: str) -> bool:
    """Validate private key format"""
    try:
        # Remove '0x' prefix if present
        if private_key.startswith('0x'):
            private_key = private_key[2:]
        
        # Check if it's a valid hex string of correct length
        if len(private_key) != 64 or not re.match('^[0-9a-fA-F]+$', private_key):
            return False
        
        # Try to create account from key
        Account.from_key(private_key)
        return True
    except:
        return False

def validate_address(address: str) -> bool:
    """Validate Ethereum address"""
    return Web3.is_address(address)

def sanitize_input(input_str: str) -> str:
    """Sanitize user input"""
    # Remove any potentially dangerous characters
    return re.sub(r'[^\w\s\.@\-]', '', input_str)