/*

   BLIS
   An object-based framework for developing high-performance BLAS-like
   libraries.

   Copyright (C) 2014, The University of Texas at Austin

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:
    - Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    - Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    - Neither the name of The University of Texas at Austin nor the names
      of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
   HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

#ifndef BLIS_AUXINFO_MACRO_DEFS_H
#define BLIS_AUXINFO_MACRO_DEFS_H


// auxinfo_t field query

static pack_t bli_auxinfo_schema_a( auxinfo_t* ai )
{
	return ai->schema_a;
}
static pack_t bli_auxinfo_schema_b( auxinfo_t* ai )
{
	return ai->schema_b;
}

static void* bli_auxinfo_next_a( auxinfo_t* ai )
{
	return ai->a_next;
}
static void* bli_auxinfo_next_b( auxinfo_t* ai )
{
	return ai->b_next;
}

static inc_t bli_auxinfo_is_a( auxinfo_t* ai )
{
	return ai->is_a;
}
static inc_t bli_auxinfo_is_b( auxinfo_t* ai )
{
	return ai->is_b;
}

static inc_t bli_auxinfo_dt_on_output( auxinfo_t* ai )
{
	return ai->dt_on_output;
}


// auxinfo_t field modification

static void bli_auxinfo_set_schema_a( pack_t schema, auxinfo_t* ai )
{
	ai->schema_a = schema;
}
static void bli_auxinfo_set_schema_b( pack_t schema, auxinfo_t* ai )
{
	ai->schema_b = schema;
}

static void bli_auxinfo_set_next_a( void* p, auxinfo_t* ai )
{
	ai->a_next = p;
}
static void bli_auxinfo_set_next_b( void* p, auxinfo_t* ai )
{
	ai->b_next = p;
}
static void bli_auxinfo_set_next_ab( void* ap, void* bp, auxinfo_t* ai )
{
	ai->a_next = ap;
	ai->b_next = bp;
}

static void bli_auxinfo_set_is_a( inc_t is, auxinfo_t* ai )
{
	ai->is_a = is;
}
static void bli_auxinfo_set_is_b( inc_t is, auxinfo_t* ai )
{
	ai->is_b = is;
}

static void bli_auxinfo_set_dt_on_output( num_t dt_on_output, auxinfo_t* ai )
{
	ai->dt_on_output = dt_on_output;
}

#endif 

