window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = [{"fullname": "__init__", "modulename": "__init__", "kind": "module", "doc": "<h1 class=\"modulename\">\nMilestone XProtect REST Services Python3 Library\n</h1>\n\n<h1 id=\"overview\">Overview</h1>\n\n<p>This API provides Python programmers the ability to retrieve various configuration information for Milestone Systems XProtect Video Manegement Systems (VMS) products. \nIt utilizes the Milestone Systems XProtect VMS API Gateway addon product REST services to retrieve the information.\nMore information on Milestone XProtect products can be found on the <a href=\"https://www.milestonesys.com/video-technology/platform/xprotect/\" target=\"_blank\">Milestone\nXProtect Products page</a>.</p>\n\n<h1 id=\"what-this-api-can-do\">What this API <em>CAN</em> Do</h1>\n\n<p>This API provides an easy way to retrieve XProtect configuration details:  Cameras, Microphones, Speakers, Product License Information, Site information, etc.  Check out\nthe <code>milestonexprotectrestpython.xprrestservice.XPRRestService</code> class help documentation for more details.</p>\n\n<h1 id=\"what-this-api-cannot-do-yet-anyway\">What this API <em>CANNOT</em> Do (yet anyway)</h1>\n\n<p>This API does not provide any functionality to ADD, UPDATE, or DELETE XProtect configurations.  The underlying XProtect REST services DO support these operations, but this API does not.</p>\n\n<h1 id=\"requirements-and-dependencies\">Requirements and Dependencies</h1>\n\n<p>The following XProtect requirements must be met in order to utilize this API:</p>\n\n<ul>\n<li><p>Milestone Systems XProtect Management Server 2023 R2, Version 23.2a+.</p>\n\n<p>The XProtect Management Server provides web-services for various commands and configuration.\nThe XProtect software products can be downloaded from the: <a href=\"https://www.milestonesys.com/video-technology/platform/try-xprotect/\" target=\"_blank\">\nMilestone XProtect Products download page</a>.</p></li>\n<li><p>Milestone Systems XProtect VMS API Gateway.</p>\n\n<p>The XProtect API Gateway Addon provides RESTful services for various commands and configuration management.\nThe XProtect software products can be downloaded from the <a href=\"https://doc.milestonesys.com/latest/en-US/standard_features/apigateway/installation/api_gway_install-api-gateway.htm\" target=\"_blank\">Milestone XProtect API Gateway download page</a>.</p>\n\n<p>Installation of the XProtect API Gateway requires XProtect VMS 2022 R1 or later.</p></li>\n</ul>\n\n<p>The following Python-related requirements must be met in order to utilize this API:</p>\n\n<ul>\n<li><p>Python 3.4 or greater (not tested with Python 2).</p></li>\n<li><p>smartinspectPython package (&gt;= 3.0.20) - for diagnostics and logging support.</p></li>\n<li><p>requests package (&gt;= 2.0).</p></li>\n<li><p>requests-ntlm package (&gt;= 1.2.0).</p></li>\n</ul>\n\n<h1 id=\"documentation\">Documentation</h1>\n\n<p>Documentation is located in the package library under the 'docs' folder; use the index.html as your starting point. </p>\n\n<h1 id=\"quick-start-sample-code\">Quick-Start Sample Code</h1>\n\n<p>The following code snippet will get you started with establishing a connection to the XProtect REST API Gateway and retrieving a list of all Camera devices. </p>\n\n<p>Check out the <code>milestonexprotectrestpython.xprrestservice.XPRRestService</code> class methods for more sample code.</p>\n\n<p><details>\n  <summary>Get All Camera Devices</summary></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprfilteroperator</span> <span class=\"kn\">import</span> <span class=\"n\">XPRFilterOperator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword@1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get camera devices, both enabled and disabled.</span>\n<span class=\"n\">cams</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetCameras</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Cameras (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">cams</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n\n<h1 id=\"licensing\">Licensing</h1>\n\n<p>This project is licensed under the terms of the MIT End-User License Agreement (EULA) license.</p>\n\n<h1 id=\"logging-tracing-support\">Logging / Tracing Support</h1>\n\n<p>The SmartInspectPython package (installed with this package) can be used to easily debug your applications that utilize this API.</p>\n\n<p>The following topics and code samples will get you started on how to enable logging support. <br />\nNote that logging support can be turned on and off without changing code or restarting the application. <br />\nClick on the topics below to expand the section and reveal more information.  </p>\n\n<p><details>\n  <summary>Configure Logging Support Settings File</summary>\n  <br/>\n  Add the following lines to a new file (e.g. \"smartinspect.cfg\") in your application startup / test directory. <br />\n  Note the file name can be whatever you like, just specify it on the call to <code>SiAuto.Si.LoadConfiguration()</code> when initializing the logger.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\">; smartinspect.cfg</span>\n\n<span class=\"c1\">; SmartInspect Logging Configuration General settings.</span>\n<span class=\"c1\">; - &quot;Enabled&quot; parameter to turn logging on (True) or off (False).</span>\n<span class=\"c1\">; - &quot;Level&quot; parameter to control the logging level (Debug|Verbose|Message|Warning|Error).</span>\n<span class=\"c1\">; - &quot;AppName&quot; parameter to control the application name.</span>\n<span class=\"na\">Enabled</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">False</span><span class=\"w\"> </span>\n<span class=\"na\">Level</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">Verbose</span>\n<span class=\"na\">DefaultLevel</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">Debug</span>\n<span class=\"na\">AppName</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">My Application Name</span>\n\n<span class=\"c1\">; SmartInspect Logging Configuration Output settings.</span>\n<span class=\"c1\">; - Log to SmartInspect Console Viewer running on the specified network address.</span>\n<span class=\"na\">Connections</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">tcp(host=192.168.1.1,port=4228,timeout=5000,reconnect=true,reconnect.interval=10s,async.enabled=true)</span>\n<span class=\"c1\">; - Log to a file, keeping 14 days worth of logs.</span>\n<span class=\"c1\">;Connections = &quot;file(filename=\\&quot;./tests/logfiles/logfile.log\\&quot;, rotate=daily, maxparts=14, append=true)&quot;</span>\n<span class=\"c1\">; - Log to an encrypted file, keeping 14 days worth of logs.</span>\n<span class=\"c1\">;Connections = &quot;file(filename=\\&quot;./tests/logfiles/logfileEncrypted.sil\\&quot;, encrypt=true, key=&quot;&quot;1234567890123456&quot;&quot;, rotate=daily, maxparts=14, append=true)&quot;</span>\n\n<span class=\"c1\">; set defaults for new sessions</span>\n<span class=\"c1\">; note that session defaults do not apply to the SiAuto.Main session, since</span>\n<span class=\"c1\">; this session was already added before a configuration file can be loaded. </span>\n<span class=\"c1\">; session defaults only apply to newly added sessions and do not affect existing sessions.</span>\n<span class=\"na\">SessionDefaults.Active</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">True</span>\n<span class=\"na\">SessionDefaults.Level</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">Message</span>\n<span class=\"na\">SessionDefaults.ColorBG</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">0xFFFFFF</span>\n\n<span class=\"c1\">; configure some individual session properties.</span>\n<span class=\"c1\">; note that this does not add the session to the sessionmanager; it simply</span>\n<span class=\"c1\">; sets the property values IF the session name already exists.</span>\n<span class=\"na\">Session.Main.Active</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">True</span>\n<span class=\"na\">Session.Main.ColorBG</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">0xFFFFFF</span>\n</code></pre>\n</div>\n\n<p></details></p>\n\n<p><details>\n  <summary>Initialize Logging Support, MAIN module</summary>\n  <br/>\n  Add the following lines to your program startup module. <br />\n  This will import the necessary package modules, and initialize logging support. <br />\n  NOTE - This code should only be executed one time!  </p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># load SmartInspect settings from a configuration settings file.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siauto</span> <span class=\"kn\">import</span> <span class=\"o\">*</span>\n<span class=\"n\">siConfigPath</span><span class=\"p\">:</span><span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;./tests/smartinspect.cfg&quot;</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">LoadConfiguration</span><span class=\"p\">(</span><span class=\"n\">siConfigPath</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># start monitoring the configuration file for changes, and reload it when it changes.</span>\n<span class=\"c1\"># this will check the file for changes every 60 seconds.</span>\n<span class=\"n\">siConfig</span><span class=\"p\">:</span><span class=\"n\">SIConfigurationTimer</span> <span class=\"o\">=</span> <span class=\"n\">SIConfigurationTimer</span><span class=\"p\">(</span><span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"p\">,</span> <span class=\"n\">siConfigPath</span><span class=\"p\">,</span> <span class=\"mi\">60</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># get smartinspect logger reference.</span>\n<span class=\"n\">_logsi</span><span class=\"p\">:</span><span class=\"n\">SISession</span> <span class=\"o\">=</span> <span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Main</span>\n\n<span class=\"c1\"># log system environment and application startup parameters.</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogSeparator</span><span class=\"p\">(</span><span class=\"n\">SILevel</span><span class=\"o\">.</span><span class=\"n\">Fatal</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogAppDomain</span><span class=\"p\">(</span><span class=\"n\">SILevel</span><span class=\"o\">.</span><span class=\"n\">Verbose</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogSystem</span><span class=\"p\">(</span><span class=\"n\">SILevel</span><span class=\"o\">.</span><span class=\"n\">Verbose</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p></details></p>\n\n<p><details>\n  <summary>Initialize Logging Support, CLASS or sub-modules</summary>\n  <br/>\n  Add the following lines to your program supporting modules. <br />\n  This will import the necessary package modules, and initialize the shared logging session.  </p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># get smartinspect logger reference.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siauto</span> <span class=\"kn\">import</span> <span class=\"o\">*</span>\n<span class=\"n\">_logsi</span><span class=\"p\">:</span><span class=\"n\">SISession</span> <span class=\"o\">=</span> <span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Main</span>\n</code></pre>\n</div>\n\n<p></details></p>\n\n<p><details>\n  <summary>More Information on SmartInspect</summary>\n  <br/>\n  You can use SmartInspectPython by itself to create log files for your own applications. <br />\n  Use the following PIP command to install the SmartInspectPython package from PyPi.org: <br />\n  <code>pip install smartinspectpython</code>\n  <br/>\n  <br/>\n  The SmarrtInspect Redistributable Console Viewer (free) is required to view SmartInspect Log (.sil) formatted log files, as well capture packets via the TcpProtocol \n  or PipeProtocol connections.  The Redistributable Console Viewer can be downloaded from the <a href=\"https://code-partners.com/offerings/smartinspect/releases/\" target=\"_blank\">Code-Partners Software Downloads Page</a>. Note that the \"Redistributable Console Viewer\" is a free product, while the \"SmartInspect Full Setup\" is \n  the Professional level viewer that adds a few more bells and whistles for a fee.  Also note that a Console Viewer is NOT required to view plain text (non .sil) formatted \n  log files.\n</details></p>\n\n<hr />\n\n<p><details>\n  <summary>View Change Log</summary></p>\n\n<h1 id=\"change-log\">Change Log</h1>\n\n<p>All notable changes to this project are listed here.\nDetailed changes are listed in the module where the change was made.</p>\n\n<p>Change are listed in reverse chronological order (newest to oldest).</p>\n\n<p><span class=\"changelog\"></p>\n\n<h6 id=\"103-20230913\">[ 1.0.3 ] - 2023/09/13</h6>\n\n<ul>\n<li>Internal method name changes.</li>\n</ul>\n\n<h6 id=\"102-20230913\">[ 1.0.2 ] - 2023/09/13</h6>\n\n<ul>\n<li>Changed all constants that start with \"MSG_TRACE_METHOD_RESTREQUEST\" to \"MSG_TRACE_METHOD_REQUEST\".</li>\n</ul>\n\n<h6 id=\"100-20230707\">[ 1.0.0 ] - 2023/07/07</h6>\n\n<ul>\n<li>Version 1 initial release.</li>\n</ul>\n\n<p></span>\n</details></p>\n"}, {"fullname": "milestonexprotectrestpython.xpranalyticsevent", "modulename": "milestonexprotectrestpython.xpranalyticsevent", "kind": "module", "doc": "<p>Module: xpranalyticsevent.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xpranalyticsevent.XPRAnalyticsEvent", "modulename": "milestonexprotectrestpython.xpranalyticsevent", "qualname": "XPRAnalyticsEvent", "kind": "class", "doc": "<p>Analytics Event information.</p>\n\n<p>More information about Analytics Event configuration can be found on the\n<a target=\"_blank\" href=\"https://doc.milestonesys.com/2023R2/en-US/standard_features/sf_mc/sf_ui/mc_analyticsevents_rande.htm\">vendor documentation page</a>.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "milestonexprotectrestpython.xpranalyticsevent.XPRAnalyticsEvent.__init__", "modulename": "milestonexprotectrestpython.xpranalyticsevent", "qualname": "XPRAnalyticsEvent.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xpranalyticsevent.XPRAnalyticsEvent.DateModified", "modulename": "milestonexprotectrestpython.xpranalyticsevent", "qualname": "XPRAnalyticsEvent.DateModified", "kind": "variable", "doc": "<p>Date and time (in UTC format) that the entry was last modified.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DateModified property value.</p>\n</blockquote>\n", "annotation": ": datetime.datetime"}, {"fullname": "milestonexprotectrestpython.xpranalyticsevent.XPRAnalyticsEvent.Description", "modulename": "milestonexprotectrestpython.xpranalyticsevent", "qualname": "XPRAnalyticsEvent.Description", "kind": "variable", "doc": "<p>Description of the event.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Description property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xpranalyticsevent.XPRAnalyticsEvent.DisplayName", "modulename": "milestonexprotectrestpython.xpranalyticsevent", "qualname": "XPRAnalyticsEvent.DisplayName", "kind": "variable", "doc": "<p>User-friendly display name used in various user-interface displays.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DisplayName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xpranalyticsevent.XPRAnalyticsEvent.Id", "modulename": "milestonexprotectrestpython.xpranalyticsevent", "qualname": "XPRAnalyticsEvent.Id", "kind": "variable", "doc": "<p>The globally unique identifier of the item.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Id property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xpranalyticsevent.XPRAnalyticsEvent.Name", "modulename": "milestonexprotectrestpython.xpranalyticsevent", "qualname": "XPRAnalyticsEvent.Name", "kind": "variable", "doc": "<p>Name of the event.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Name property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xpranalyticsevent.XPRAnalyticsEvent.SourceArray", "modulename": "milestonexprotectrestpython.xpranalyticsevent", "qualname": "XPRAnalyticsEvent.SourceArray", "kind": "variable", "doc": "<p>Source item types. <br />\nContains an array of possible sources of the event. <br />\nCan contain Camera, Hardware and other itemtype values. <br />\nFor MIP plugin events the source itemtype is MIPItem and the filter contains the MIP Kind of source. \nThe actual source is selected in the rule and alarm definition configuration.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The SourceArray property value.</p>\n</blockquote>\n", "annotation": ": list[str]"}, {"fullname": "milestonexprotectrestpython.xprappmessages", "modulename": "milestonexprotectrestpython.xprappmessages", "kind": "module", "doc": "<p>Module: xprappmessages.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprappmessages.XPRAppMessages", "modulename": "milestonexprotectrestpython.xprappmessages", "qualname": "XPRAppMessages", "kind": "class", "doc": "<p>A strongly-typed resource class, for looking up localized strings, etc.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "milestonexprotectrestpython.xprappmessages.XPRAppMessages.UNHANDLED_EXCEPTION", "modulename": "milestonexprotectrestpython.xprappmessages", "qualname": "XPRAppMessages.UNHANDLED_EXCEPTION", "kind": "variable", "doc": "<p>XPR0001E - An unhandled exception occured while processing method \"{0}\".\n{1}</p>\n", "annotation": ": str", "default_value": "&#x27;XPR0001E - An unhandled exception occured while processing method &quot;{0}&quot;.\\n{1}\\n&#x27;"}, {"fullname": "milestonexprotectrestpython.xprappmessages.XPRAppMessages.EXCEPTION_SERVICE_PARSE_RESULTS", "modulename": "milestonexprotectrestpython.xprappmessages", "qualname": "XPRAppMessages.EXCEPTION_SERVICE_PARSE_RESULTS", "kind": "variable", "doc": "<p>XPR0002E - An exception occured while parsing XProtect REST results for \"{0}\" details.\n{1}</p>\n", "annotation": ": str", "default_value": "&#x27;XPR0002E - An exception occured while parsing XProtect REST results for &quot;{0}&quot; details. \\n{1}\\n&#x27;"}, {"fullname": "milestonexprotectrestpython.xprappmessages.XPRAppMessages.EXCEPTION_SERVICE_ERROR_BASE", "modulename": "milestonexprotectrestpython.xprappmessages", "qualname": "XPRAppMessages.EXCEPTION_SERVICE_ERROR_BASE", "kind": "variable", "doc": "<p>XPR0003E - \"{0}\" method call failed due to a failure response returned by XProtect REST services.</p>\n", "annotation": ": str", "default_value": "&#x27;XPR0003E - &quot;{0}&quot; method call failed due to a failure response returned by XProtect REST services.&#x27;"}, {"fullname": "milestonexprotectrestpython.xprappmessages.XPRAppMessages.EXCEPTION_SERVICE_STATUS_UNKNOWN", "modulename": "milestonexprotectrestpython.xprappmessages", "qualname": "XPRAppMessages.EXCEPTION_SERVICE_STATUS_UNKNOWN", "kind": "variable", "doc": "<p>XPR0004E - An unknown XProtect REST server response code and body was returned:\nStatus Code = {0}\nJSON Response:\n{1}</p>\n", "annotation": ": str", "default_value": "&#x27;XPR0004E - An unknown XProtect REST server response status code was returned:\\nStatus Code = {0}\\nJSON Response:\\n{1}\\n\\n&#x27;"}, {"fullname": "milestonexprotectrestpython.xprappmessages.XPRAppMessages.EXCEPTION_LOGININFO_NOT_SUPPLIED", "modulename": "milestonexprotectrestpython.xprappmessages", "qualname": "XPRAppMessages.EXCEPTION_LOGININFO_NOT_SUPPLIED", "kind": "variable", "doc": "<p>XPR0005E - LoginInfo object not established.  You must first issue a Login call to \nestablish a LoginInfo object that will be used on subsequent calls to XProtect REST services.</p>\n", "annotation": ": str", "default_value": "&#x27;XPR0005E - LoginInfo object not established.  You must first issue a Login call to establish a LoginInfo object that will be used on subsequent calls to XProtect REST services.&#x27;"}, {"fullname": "milestonexprotectrestpython.xprappmessages.XPRAppMessages.ARGUMENT_TYPE_ERROR", "modulename": "milestonexprotectrestpython.xprappmessages", "qualname": "XPRAppMessages.ARGUMENT_TYPE_ERROR", "kind": "variable", "doc": "<p>XPR0006E - {0} argument must be of type \"{1}\"; the \"{2}\" type not is supported for this argument.</p>\n", "annotation": ": str", "default_value": "&#x27;XPR0006E - {0} argument must be of type &quot;{1}&quot;; the &quot;{2}&quot; type is not supported for this argument.&#x27;"}, {"fullname": "milestonexprotectrestpython.xprappmessages.XPRAppMessages.ARGUMENT_REQUIRED_ERROR", "modulename": "milestonexprotectrestpython.xprappmessages", "qualname": "XPRAppMessages.ARGUMENT_REQUIRED_ERROR", "kind": "variable", "doc": "<p>XPR0007E - The \"{0}\" argument is required, and cannot be null / None.</p>\n", "annotation": ": str", "default_value": "&#x27;XPR0007E - The &quot;{0}&quot; argument is required, and cannot be null / None.&#x27;"}, {"fullname": "milestonexprotectrestpython.xprappmessages.XPRAppMessages.COLLECTION_ARGUMENT_TYPE_ERROR", "modulename": "milestonexprotectrestpython.xprappmessages", "qualname": "XPRAppMessages.COLLECTION_ARGUMENT_TYPE_ERROR", "kind": "variable", "doc": "<p>XPR0008E - Collection \"{0}\" method \"{1}\" argument must be of type \"{2}\"; an object of type \"{3}\" is not supported for this method argument.</p>\n", "annotation": ": str", "default_value": "&#x27;XPR0008E - Collection &quot;{0}&quot; method &quot;{1}&quot; argument must be of type &quot;{2}&quot;; an object of type &quot;{3}&quot; is not supported for this method argument.&#x27;"}, {"fullname": "milestonexprotectrestpython.xprappmessages.XPRAppMessages.DICTIONARY_KEY_NOT_FOUND_ERROR", "modulename": "milestonexprotectrestpython.xprappmessages", "qualname": "XPRAppMessages.DICTIONARY_KEY_NOT_FOUND_ERROR", "kind": "variable", "doc": "<p>XPR0009E - Could not locate key \"{0}\" in response dictionary.</p>\n", "annotation": ": str", "default_value": "&#x27;XPR0009E - Could not locate key &quot;{0}&quot; in response dictionary.&#x27;"}, {"fullname": "milestonexprotectrestpython.xprappmessages.XPRAppMessages.DICTIONARY_VALUE_NOT_CONVERTIBLE", "modulename": "milestonexprotectrestpython.xprappmessages", "qualname": "XPRAppMessages.DICTIONARY_VALUE_NOT_CONVERTIBLE", "kind": "variable", "doc": "<p>XPR0012E - Could not convert response dictionary key \"{0}\" value \"{1}\" to type \"{2}\".</p>\n", "annotation": ": str", "default_value": "&#x27;XPR0012E - Could not convert response dictionary key &quot;{0}&quot; value &quot;{1}&quot; to type &quot;{2}&quot;.&#x27;"}, {"fullname": "milestonexprotectrestpython.xprauthenticationtype", "modulename": "milestonexprotectrestpython.xprauthenticationtype", "kind": "module", "doc": "<p>Module: xprauthenticationtype.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprauthenticationtype.XPRAuthenticationType", "modulename": "milestonexprotectrestpython.xprauthenticationtype", "qualname": "XPRAuthenticationType", "kind": "class", "doc": "<p>Authentication Types.</p>\n", "bases": "milestonexprotectrestpython.xprenumcomparable.XPREnumComparable"}, {"fullname": "milestonexprotectrestpython.xprauthenticationtype.XPRAuthenticationType.Unknown", "modulename": "milestonexprotectrestpython.xprauthenticationtype", "qualname": "XPRAuthenticationType.Unknown", "kind": "variable", "doc": "<p>Authentication type could not be determined.</p>\n", "default_value": "&lt;XPRAuthenticationType.Unknown: 0&gt;"}, {"fullname": "milestonexprotectrestpython.xprauthenticationtype.XPRAuthenticationType.Basic", "modulename": "milestonexprotectrestpython.xprauthenticationtype", "qualname": "XPRAuthenticationType.Basic", "kind": "variable", "doc": "<p>User was authenticated with XProtect Basic User type credentials.</p>\n", "default_value": "&lt;XPRAuthenticationType.Basic: 1&gt;"}, {"fullname": "milestonexprotectrestpython.xprauthenticationtype.XPRAuthenticationType.Windows", "modulename": "milestonexprotectrestpython.xprauthenticationtype", "qualname": "XPRAuthenticationType.Windows", "kind": "variable", "doc": "<p>User was authenticated with XProtect Windows User type credentials.</p>\n", "default_value": "&lt;XPRAuthenticationType.Windows: 2&gt;"}, {"fullname": "milestonexprotectrestpython.xprcamera", "modulename": "milestonexprotectrestpython.xprcamera", "kind": "module", "doc": "<p>Module: xprcamera.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprcamera.XPRCamera", "modulename": "milestonexprotectrestpython.xprcamera", "qualname": "XPRCamera", "kind": "class", "doc": "<p>Camera device information.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n", "bases": "milestonexprotectrestpython.xprdevice.XPRDevice"}, {"fullname": "milestonexprotectrestpython.xprcamera.XPRCamera.__init__", "modulename": "milestonexprotectrestpython.xprcamera", "qualname": "XPRCamera.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xprcamera.XPRCamera.EdgeStorageEnabled", "modulename": "milestonexprotectrestpython.xprcamera", "qualname": "XPRCamera.EdgeStorageEnabled", "kind": "variable", "doc": "<p>Determines if remote recording is enabled (True) or not (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The EdgeStorageEnabled property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprcamera.XPRCamera.EdgeStoragePlaybackEnabled", "modulename": "milestonexprotectrestpython.xprcamera", "qualname": "XPRCamera.EdgeStoragePlaybackEnabled", "kind": "variable", "doc": "<p>Determines if remote recording playback is enabled (True) or not (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The EdgeStoragePlaybackEnabled property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprcamera.XPRCamera.ManualRecordingTimeoutEnabled", "modulename": "milestonexprotectrestpython.xprcamera", "qualname": "XPRCamera.ManualRecordingTimeoutEnabled", "kind": "variable", "doc": "<p>Determines if manual recording timeout is enabled (True) or not (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ManualRecordingTimeoutEnabled property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprcamera.XPRCamera.ManualRecordingTimeoutMinutes", "modulename": "milestonexprotectrestpython.xprcamera", "qualname": "XPRCamera.ManualRecordingTimeoutMinutes", "kind": "variable", "doc": "<p>Number of minutes to automatically stop all manual recordings started by XProtect Smart \nClient users if manual recording timeout is enabled.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ManualRecordingTimeoutMinutes property value.</p>\n</blockquote>\n\n<p>The number of minutes you specify must be sufficiently large enough to accommodate the \nrequirements of the various manual recordings without overloading the system.</p>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprcamera.XPRCamera.PrebufferEnabled", "modulename": "milestonexprotectrestpython.xprcamera", "qualname": "XPRCamera.PrebufferEnabled", "kind": "variable", "doc": "<p>Determines if pre-buffering is enabled (True) or not (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The PrebufferEnabled property value.</p>\n</blockquote>\n\n<p>Pre-buffering is the ability to record audio and video before the actual triggering event occurs.</p>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprcamera.XPRCamera.PrebufferInMemory", "modulename": "milestonexprotectrestpython.xprcamera", "qualname": "XPRCamera.PrebufferInMemory", "kind": "variable", "doc": "<p>Determines if pre-buffering is stored in-memory (True) or onto disk storage (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The PrebufferInMemory property value.</p>\n</blockquote>\n\n<p>Storage to memory instead of to disk improves system performance, but is only possible for \nshorter pre-buffer periods (usually 15 seconds or less).</p>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprcamera.XPRCamera.PrebufferSeconds", "modulename": "milestonexprotectrestpython.xprcamera", "qualname": "XPRCamera.PrebufferSeconds", "kind": "variable", "doc": "<p>Number of seconds to automatically stop all manual recordings started by XProtect Smart \nClient users if manual recording timeout is enabled.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The PrebufferSeconds property value.</p>\n</blockquote>\n\n<p>The number of seconds you specify must be sufficiently large to accommodate your requirements \nin the various recording rules you define.</p>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprcamera.XPRCamera.RecordingFramerate", "modulename": "milestonexprotectrestpython.xprcamera", "qualname": "XPRCamera.RecordingFramerate", "kind": "variable", "doc": "<p>Maximum number of frames per second (FPS) the device supports.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The RecordingFramerate property value.</p>\n</blockquote>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprcamera.XPRCamera.RecordKeyFramesOnly", "modulename": "milestonexprotectrestpython.xprcamera", "qualname": "XPRCamera.RecordKeyFramesOnly", "kind": "variable", "doc": "<p>Determines if only keyframes will be recorded (True) or if ALL frames are recorded (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The RecordKeyFramesOnly property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprcamera.XPRCamera.RecordOnRelatedDevices", "modulename": "milestonexprotectrestpython.xprcamera", "qualname": "XPRCamera.RecordOnRelatedDevices", "kind": "variable", "doc": "<p>Determines if recording on related devices is enabled (True) or not (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The RecordOnRelatedDevices property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprcamera.XPRCamera.RecordingEnabled", "modulename": "milestonexprotectrestpython.xprcamera", "qualname": "XPRCamera.RecordingEnabled", "kind": "variable", "doc": "<p>Determines if recording is enabled (True) or not (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The RecordingEnabled property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprcamera.XPRCamera.RecordingStorageId", "modulename": "milestonexprotectrestpython.xprcamera", "qualname": "XPRCamera.RecordingStorageId", "kind": "variable", "doc": "<p>The Storage identifier of where recordings are stored for this device.  </p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The RecordingStorageId property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprchildsite", "modulename": "milestonexprotectrestpython.xprchildsite", "kind": "module", "doc": "<p>Module: xprchildsite.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprchildsite.XPRChildSite", "modulename": "milestonexprotectrestpython.xprchildsite", "qualname": "XPRChildSite", "kind": "class", "doc": "<p>Site information.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "milestonexprotectrestpython.xprchildsite.XPRChildSite.__init__", "modulename": "milestonexprotectrestpython.xprchildsite", "qualname": "XPRChildSite.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xprchildsite.XPRChildSite.ConnectionState", "modulename": "milestonexprotectrestpython.xprchildsite", "qualname": "XPRChildSite.ConnectionState", "kind": "variable", "doc": "<p>State of the connection to the parent site.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ConnectionState property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprchildsite.XPRChildSite.DateModified", "modulename": "milestonexprotectrestpython.xprchildsite", "qualname": "XPRChildSite.DateModified", "kind": "variable", "doc": "<p>Date and time (in UTC format) that the child site entry was last modified.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DateModified property value.</p>\n</blockquote>\n", "annotation": ": datetime.datetime"}, {"fullname": "milestonexprotectrestpython.xprchildsite.XPRChildSite.Description", "modulename": "milestonexprotectrestpython.xprchildsite", "qualname": "XPRChildSite.Description", "kind": "variable", "doc": "<p>A description of the child site.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Description property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprchildsite.XPRChildSite.DisplayName", "modulename": "milestonexprotectrestpython.xprchildsite", "qualname": "XPRChildSite.DisplayName", "kind": "variable", "doc": "<p>User-friendly display name used in various user-interface displays.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DisplayName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprchildsite.XPRChildSite.Id", "modulename": "milestonexprotectrestpython.xprchildsite", "qualname": "XPRChildSite.Id", "kind": "variable", "doc": "<p>The globally unique identifier of the child site.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Id property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprchildsite.XPRChildSite.Name", "modulename": "milestonexprotectrestpython.xprchildsite", "qualname": "XPRChildSite.Name", "kind": "variable", "doc": "<p>Name of the child site.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Name property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprchildsite.XPRChildSite.ServiceAccount", "modulename": "milestonexprotectrestpython.xprchildsite", "qualname": "XPRChildSite.ServiceAccount", "kind": "variable", "doc": "<p>Service account under which the management server is running.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ServiceAccount property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprchildsite.XPRChildSite.SynchronizationStatus", "modulename": "milestonexprotectrestpython.xprchildsite", "qualname": "XPRChildSite.SynchronizationStatus", "kind": "variable", "doc": "<p>Status of the last synchronization of the hierarchy.  </p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The SynchronizationStatus property value.</p>\n</blockquote>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprchildsite.XPRChildSite.Version", "modulename": "milestonexprotectrestpython.xprchildsite", "qualname": "XPRChildSite.Version", "kind": "variable", "doc": "<p>Version number of the child site's management server.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Version property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprcollection", "modulename": "milestonexprotectrestpython.xprcollection", "kind": "module", "doc": "<p>Module: xprcollection.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprcollection.XPRCollection", "modulename": "milestonexprotectrestpython.xprcollection", "qualname": "XPRCollection", "kind": "class", "doc": "<p>Collection of objects.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n", "bases": "typing.Iterable"}, {"fullname": "milestonexprotectrestpython.xprcollection.XPRCollection.__init__", "modulename": "milestonexprotectrestpython.xprcollection", "qualname": "XPRCollection.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>itemType (type):</strong>  Type of items this collection will contain.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">itemType</span><span class=\"p\">:</span> <span class=\"nb\">type</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, {"fullname": "milestonexprotectrestpython.xprcollection.XPRCollection.append", "modulename": "milestonexprotectrestpython.xprcollection", "qualname": "XPRCollection.append", "kind": "function", "doc": "<p>Adds a new item to the collection.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>item (object):</strong>  Item that will be added to the collection.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>TypeError:</strong>  Item argument is not of a type specified when the collection was initialized.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">item</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprcollection.XPRCollection.count", "modulename": "milestonexprotectrestpython.xprcollection", "qualname": "XPRCollection.count", "kind": "variable", "doc": "<p>Returns the number of items in the collection.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The number of items in the collection.</p>\n</blockquote>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprcollection.XPRCollection.clear", "modulename": "milestonexprotectrestpython.xprcollection", "qualname": "XPRCollection.clear", "kind": "function", "doc": "<p>Removes all items in the collection.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprcollection.XPRCollection.extend", "modulename": "milestonexprotectrestpython.xprcollection", "qualname": "XPRCollection.extend", "kind": "function", "doc": "<p>Extends the collection with items from another collection.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>other (object):</strong>  Collection of items to add to the collection.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"nb\">object</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprcollection.XPRCollection.get", "modulename": "milestonexprotectrestpython.xprcollection", "qualname": "XPRCollection.get", "kind": "function", "doc": "<p>Read an item from the collection at the specified index.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>index (int):</strong>  Index of the collection item to get.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The collection item at the specified index.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">index</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">object</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprcollection.XPRCollection.insert", "modulename": "milestonexprotectrestpython.xprcollection", "qualname": "XPRCollection.insert", "kind": "function", "doc": "<p>Inserts a new item in the collection at the specified index.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>index (int):</strong>  Index at which to insert the new item.</li>\n<li><strong>item (object):</strong>  Item that will be added to the collection.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>TypeError:</strong>  Item argument is not of a type specified when the collection was initialized.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">index</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">item</span><span class=\"p\">:</span> <span class=\"nb\">object</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprcollection.XPRCollection.length", "modulename": "milestonexprotectrestpython.xprcollection", "qualname": "XPRCollection.length", "kind": "variable", "doc": "<p>Returns the number of items in the collection.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The number of items in the collection.</p>\n</blockquote>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprcollection.XPRCollection.pop", "modulename": "milestonexprotectrestpython.xprcollection", "qualname": "XPRCollection.pop", "kind": "function", "doc": "<p>Remove and return the last item from the collection.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The last item from the collection.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">object</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprcollection.XPRCollection.remove", "modulename": "milestonexprotectrestpython.xprcollection", "qualname": "XPRCollection.remove", "kind": "function", "doc": "<p>Removes an item from the collection.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>item (object):</strong>  Item that will be removed from the collection.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>TypeError:</strong>  Item argument is not of a type specified when the collection was initialized.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">item</span><span class=\"p\">:</span> <span class=\"nb\">object</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprcollection.XPRCollection.sort", "modulename": "milestonexprotectrestpython.xprcollection", "qualname": "XPRCollection.sort", "kind": "function", "doc": "<p>Sorts the collection items by Name (default).</p>\n\n<p>Use the following guidelines when calling a sort method that uses key=lambda syntax:</p>\n\n<pre><code># good syntax, as it handles x.Name = None values.\nepColl.sort(key=lambda x: x.Name or \"\", reverse=False)\n\n# bad syntax, as the sort will fail if x.Name = None!\nepColl.sort(key=lambda x: x.Name, reverse=False)\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprconst", "modulename": "milestonexprotectrestpython.xprconst", "kind": "module", "doc": "<p>Module: xprconst.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n<tr>\n  <td>2023/09/13</td>\n  <td>1.0.2.0</td>\n  <td>Changed all constants that start with \"MSG_TRACE_METHOD_RESTREQUEST\" to \"MSG_TRACE_METHOD_REQUEST\".</td>\n</tr>\n<tr>\n  <td>2023/09/13</td>\n  <td>1.0.4.0</td>\n  <td>Test case scenario updates.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprconst.VERSION", "modulename": "milestonexprotectrestpython.xprconst", "qualname": "VERSION", "kind": "variable", "doc": "<p>Current version of the Milestone XProtect REST Python3 Library.</p>\n", "annotation": ": str", "default_value": "&#x27;1.0.4&#x27;"}, {"fullname": "milestonexprotectrestpython.xprconst.PACKAGENAME", "modulename": "milestonexprotectrestpython.xprconst", "qualname": "PACKAGENAME", "kind": "variable", "doc": "<p>Name of our package (used by PDoc Documentation build).</p>\n", "annotation": ": str", "default_value": "&#x27;milestonexprotectrestpython&#x27;"}, {"fullname": "milestonexprotectrestpython.xprconst.PDOC_BRAND_ICON_URL", "modulename": "milestonexprotectrestpython.xprconst", "qualname": "PDOC_BRAND_ICON_URL", "kind": "variable", "doc": "<p>PDoc Documentation brand icon link url that is displayed in the help document TOC.\nValue = \"https://www.milestonesys.com/video-technology/platform/xprotect/\"</p>\n", "annotation": ": str", "default_value": "&#x27;https://www.milestonesys.com/video-technology/platform/xprotect/&#x27;"}, {"fullname": "milestonexprotectrestpython.xprconst.PDOC_BRAND_ICON_URL_SRC", "modulename": "milestonexprotectrestpython.xprconst", "qualname": "PDOC_BRAND_ICON_URL_SRC", "kind": "variable", "doc": "<p>PDoc Documentation brand icon link url that is displayed in the help document TOC.\nValue = \"milestonexprotect.ico\"</p>\n", "annotation": ": str", "default_value": "&#x27;milestonexprotect.ico&#x27;"}, {"fullname": "milestonexprotectrestpython.xprconst.PDOC_BRAND_ICON_URL_TITLE", "modulename": "milestonexprotectrestpython.xprconst", "qualname": "PDOC_BRAND_ICON_URL_TITLE", "kind": "variable", "doc": "<p>PDoc Documentation brand icon link title that is displayed in the help document TOC.\nValue = \"A XProtect Client\"</p>\n", "annotation": ": str", "default_value": "&#x27;A XProtect Client&#x27;"}, {"fullname": "milestonexprotectrestpython.xprconst.UNKNOWN_VALUE", "modulename": "milestonexprotectrestpython.xprconst", "qualname": "UNKNOWN_VALUE", "kind": "variable", "doc": "<p>Indicates if an event argument value is unknown for event argument objects that are displayed as a string.</p>\n\n<p>Value: \n    <code>\"&lt;unknown&gt;\"</code></p>\n", "annotation": ": str", "default_value": "&#x27;&lt;unknown&gt;&#x27;"}, {"fullname": "milestonexprotectrestpython.xprconst.MSG_TRACE_METHOD_REQUEST", "modulename": "milestonexprotectrestpython.xprconst", "qualname": "MSG_TRACE_METHOD_REQUEST", "kind": "variable", "doc": "<p>{0} REST request</p>\n", "annotation": ": str", "default_value": "&#x27;{0} REST request&#x27;"}, {"fullname": "milestonexprotectrestpython.xprconst.MSG_TRACE_METHOD_REQUEST_HEADERS", "modulename": "milestonexprotectrestpython.xprconst", "qualname": "MSG_TRACE_METHOD_REQUEST_HEADERS", "kind": "variable", "doc": "<p>{0} REST request headers</p>\n", "annotation": ": str", "default_value": "&#x27;{0} REST request headers&#x27;"}, {"fullname": "milestonexprotectrestpython.xprconst.MSG_TRACE_METHOD_REQUEST_BODY", "modulename": "milestonexprotectrestpython.xprconst", "qualname": "MSG_TRACE_METHOD_REQUEST_BODY", "kind": "variable", "doc": "<p>{0} REST request body</p>\n", "annotation": ": str", "default_value": "&#x27;{0} REST request body&#x27;"}, {"fullname": "milestonexprotectrestpython.xprconst.MSG_TRACE_METHOD_RESPONSE", "modulename": "milestonexprotectrestpython.xprconst", "qualname": "MSG_TRACE_METHOD_RESPONSE", "kind": "variable", "doc": "<p>{0} REST response</p>\n", "annotation": ": str", "default_value": "&#x27;{0} REST response&#x27;"}, {"fullname": "milestonexprotectrestpython.xprconst.MSG_TRACE_METHOD_RESPONSE_BODY", "modulename": "milestonexprotectrestpython.xprconst", "qualname": "MSG_TRACE_METHOD_RESPONSE_BODY", "kind": "variable", "doc": "<p>{0} REST response body</p>\n", "annotation": ": str", "default_value": "&#x27;{0} REST response body&#x27;"}, {"fullname": "milestonexprotectrestpython.xprconst.MSG_TRACE_PROCESSING_DICTIONARY", "modulename": "milestonexprotectrestpython.xprconst", "qualname": "MSG_TRACE_PROCESSING_DICTIONARY", "kind": "variable", "doc": "<p>Processing dictionary \"{0}\" node\"</p>\n", "annotation": ": str", "default_value": "&#x27;Processing dictionary &quot;{0}&quot; node&#x27;"}, {"fullname": "milestonexprotectrestpython.xprconst.MSG_TRACE_PROCESSING_DICTIONARY_COLLECTION", "modulename": "milestonexprotectrestpython.xprconst", "qualname": "MSG_TRACE_PROCESSING_DICTIONARY_COLLECTION", "kind": "variable", "doc": "<p>Processing dictionary \"{0}\" collection node, and any \"{1}\" item nodes</p>\n", "annotation": ": str", "default_value": "&#x27;Processing dictionary collection &quot;{0}&quot; node, and any &quot;{1}&quot; item nodes&#x27;"}, {"fullname": "milestonexprotectrestpython.xprconst.MSG_TRACE_RESULT_COLLECTION", "modulename": "milestonexprotectrestpython.xprconst", "qualname": "MSG_TRACE_RESULT_COLLECTION", "kind": "variable", "doc": "<p>{0} Collection results</p>\n", "annotation": ": str", "default_value": "&#x27;{0} Collection results&#x27;"}, {"fullname": "milestonexprotectrestpython.xprconst.MSG_TRACE_RESULT_OBJECT", "modulename": "milestonexprotectrestpython.xprconst", "qualname": "MSG_TRACE_RESULT_OBJECT", "kind": "variable", "doc": "<p>{0} object created: {1}</p>\n", "annotation": ": str", "default_value": "&#x27;{0} object created: {1}&#x27;"}, {"fullname": "milestonexprotectrestpython.xprdevice", "modulename": "milestonexprotectrestpython.xprdevice", "kind": "module", "doc": "<p>Module: xprdevice.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprdevice.XPRDevice", "modulename": "milestonexprotectrestpython.xprdevice", "qualname": "XPRDevice", "kind": "class", "doc": "<p>Device information base class.</p>\n\n<p>More information about Device configuration can be found on the\n<a target=\"_blank\" href=\"https://doc.milestonesys.com/latest/en-US/standard_features/sf_mc/sf_ui/mc_devicestabs_devices.htm#MC_InfoTabExplained.htm\">vendor documentation page</a>.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "milestonexprotectrestpython.xprdevice.XPRDevice.__init__", "modulename": "milestonexprotectrestpython.xprdevice", "qualname": "XPRDevice.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xprdevice.XPRDevice.Channel", "modulename": "milestonexprotectrestpython.xprdevice", "qualname": "XPRDevice.Channel", "kind": "variable", "doc": "<p>The channel number of the device.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Channel property value.</p>\n</blockquote>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprdevice.XPRDevice.CoverageDirection", "modulename": "milestonexprotectrestpython.xprdevice", "qualname": "XPRDevice.CoverageDirection", "kind": "variable", "doc": "<p>The viewing coverage direction of the device.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The CoverageDirection property value.</p>\n</blockquote>\n", "annotation": ": float"}, {"fullname": "milestonexprotectrestpython.xprdevice.XPRDevice.CoverageDepth", "modulename": "milestonexprotectrestpython.xprdevice", "qualname": "XPRDevice.CoverageDepth", "kind": "variable", "doc": "<p>The viewing coverage depth of the device.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The CoverageDepth property value.</p>\n</blockquote>\n", "annotation": ": float"}, {"fullname": "milestonexprotectrestpython.xprdevice.XPRDevice.CoverageFieldOfView", "modulename": "milestonexprotectrestpython.xprdevice", "qualname": "XPRDevice.CoverageFieldOfView", "kind": "variable", "doc": "<p>The coverage field of view of the device.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The CoverageFieldOfView property value.</p>\n</blockquote>\n", "annotation": ": float"}, {"fullname": "milestonexprotectrestpython.xprdevice.XPRDevice.DateCreated", "modulename": "milestonexprotectrestpython.xprdevice", "qualname": "XPRDevice.DateCreated", "kind": "variable", "doc": "<p>Date and time (in UTC format) that the item was created.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DateCreated property value.</p>\n</blockquote>\n", "annotation": ": datetime.datetime"}, {"fullname": "milestonexprotectrestpython.xprdevice.XPRDevice.DateModified", "modulename": "milestonexprotectrestpython.xprdevice", "qualname": "XPRDevice.DateModified", "kind": "variable", "doc": "<p>Date and time (in UTC format) that the item was last modified.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DateModified property value.</p>\n</blockquote>\n", "annotation": ": datetime.datetime"}, {"fullname": "milestonexprotectrestpython.xprdevice.XPRDevice.Description", "modulename": "milestonexprotectrestpython.xprdevice", "qualname": "XPRDevice.Description", "kind": "variable", "doc": "<p>A description of the device.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Description property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprdevice.XPRDevice.DisplayName", "modulename": "milestonexprotectrestpython.xprdevice", "qualname": "XPRDevice.DisplayName", "kind": "variable", "doc": "<p>User-friendly display name used in various user-interface displays.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DisplayName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprdevice.XPRDevice.Enabled", "modulename": "milestonexprotectrestpython.xprdevice", "qualname": "XPRDevice.Enabled", "kind": "variable", "doc": "<p>The enabled status of the device - True if enabled; otherwise False.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Enabled property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprdevice.XPRDevice.GisPoint", "modulename": "milestonexprotectrestpython.xprdevice", "qualname": "XPRDevice.GisPoint", "kind": "variable", "doc": "<p>Geographic location of the device in the format latitude, longitude, and potentially altitude.  </p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The GisPoint property value.</p>\n</blockquote>\n\n<p>The format is \"POINT (LATITUDE LONGITUDE)\" and if you want to clear the \ncoordinates, the value to use is \"POINT EMPTY\". <br />\nExamples: \"POINT (55.656932878513 12.3763545558449)\" \"POINT EMPTY\".\nCan also include altitude; if so the format is \"POINT (LATITUDE LONGITUDE ALTITUDE)\".</p>\n\n<p>The value determines the position of the device icon on the smart map in XProtect Smart Client.</p>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprdevice.XPRDevice.HardwareId", "modulename": "milestonexprotectrestpython.xprdevice", "qualname": "XPRDevice.HardwareId", "kind": "variable", "doc": "<p>The globally unique identifier of the hardware, with which the device is connected.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The HardwareId property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprdevice.XPRDevice.Icon", "modulename": "milestonexprotectrestpython.xprdevice", "qualname": "XPRDevice.Icon", "kind": "variable", "doc": "<p>Icon identifier. The relevant device icon to show.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Icon property value.</p>\n</blockquote>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprdevice.XPRDevice.Id", "modulename": "milestonexprotectrestpython.xprdevice", "qualname": "XPRDevice.Id", "kind": "variable", "doc": "<p>The globally unique identifier of the device.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Id property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprdevice.XPRDevice.Name", "modulename": "milestonexprotectrestpython.xprdevice", "qualname": "XPRDevice.Name", "kind": "variable", "doc": "<p>Name of the device.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Name property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprdevice.XPRDevice.ShortName", "modulename": "milestonexprotectrestpython.xprdevice", "qualname": "XPRDevice.ShortName", "kind": "variable", "doc": "<p>Short name. Used as name in the user interface where appropriate.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ShortName property value.</p>\n</blockquote>\n\n<p>The maximum length of characters is 128.</p>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprdevicegroup", "modulename": "milestonexprotectrestpython.xprdevicegroup", "kind": "module", "doc": "<p>Module: xprdevicegroup.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprdevicegroup.XPRDeviceGroup", "modulename": "milestonexprotectrestpython.xprdevicegroup", "qualname": "XPRDeviceGroup", "kind": "class", "doc": "<p>Device Group information.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "milestonexprotectrestpython.xprdevicegroup.XPRDeviceGroup.__init__", "modulename": "milestonexprotectrestpython.xprdevicegroup", "qualname": "XPRDeviceGroup.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xprdevicegroup.XPRDeviceGroup.BuiltIn", "modulename": "milestonexprotectrestpython.xprdevicegroup", "qualname": "XPRDeviceGroup.BuiltIn", "kind": "variable", "doc": "<p>The BuiltIn status of the group - True if BuiltIn; otherwise False.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The BuiltIn property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprdevicegroup.XPRDeviceGroup.DateModified", "modulename": "milestonexprotectrestpython.xprdevicegroup", "qualname": "XPRDeviceGroup.DateModified", "kind": "variable", "doc": "<p>Date and time (in UTC format) that the group entry was last modified.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DateModified property value.</p>\n</blockquote>\n", "annotation": ": datetime.datetime"}, {"fullname": "milestonexprotectrestpython.xprdevicegroup.XPRDeviceGroup.Description", "modulename": "milestonexprotectrestpython.xprdevicegroup", "qualname": "XPRDeviceGroup.Description", "kind": "variable", "doc": "<p>A description of the group.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Description property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprdevicegroup.XPRDeviceGroup.DisplayName", "modulename": "milestonexprotectrestpython.xprdevicegroup", "qualname": "XPRDeviceGroup.DisplayName", "kind": "variable", "doc": "<p>User-friendly display name used in various user-interface displays.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DisplayName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprdevicegroup.XPRDeviceGroup.Id", "modulename": "milestonexprotectrestpython.xprdevicegroup", "qualname": "XPRDeviceGroup.Id", "kind": "variable", "doc": "<p>The globally unique identifier of the group.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Id property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprdevicegroup.XPRDeviceGroup.ItemType", "modulename": "milestonexprotectrestpython.xprdevicegroup", "qualname": "XPRDeviceGroup.ItemType", "kind": "variable", "doc": "<p>Type of the group item.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ItemType property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprdevicegroup.XPRDeviceGroup.Name", "modulename": "milestonexprotectrestpython.xprdevicegroup", "qualname": "XPRDeviceGroup.Name", "kind": "variable", "doc": "<p>Name of the group.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Name property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprenumcomparable", "modulename": "milestonexprotectrestpython.xprenumcomparable", "kind": "module", "doc": "<p>Module: xprenumcomparable.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprenumcomparable.XPREnumComparable", "modulename": "milestonexprotectrestpython.xprenumcomparable", "qualname": "XPREnumComparable", "kind": "class", "doc": "<p>Class used to compare Enum objects without having to specify \".value\" on\nthe end of the enum name.</p>\n", "bases": "enum.Enum"}, {"fullname": "milestonexprotectrestpython.xprenumcomparable.XPREnumComparable.__init__", "modulename": "milestonexprotectrestpython.xprenumcomparable", "qualname": "XPREnumComparable.__init__", "kind": "function", "doc": "<p>Initializes a new instalce of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>other (object):</strong>  Object to compare with this object.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">other</span></span>)</span>"}, {"fullname": "milestonexprotectrestpython.xpreventtype", "modulename": "milestonexprotectrestpython.xpreventtype", "kind": "module", "doc": "<p>Module: xpreventtype.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xpreventtype.XPREventType", "modulename": "milestonexprotectrestpython.xpreventtype", "qualname": "XPREventType", "kind": "class", "doc": "<p>Event Type information.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "milestonexprotectrestpython.xpreventtype.XPREventType.__init__", "modulename": "milestonexprotectrestpython.xpreventtype", "qualname": "XPREventType.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xpreventtype.XPREventType.BuiltIn", "modulename": "milestonexprotectrestpython.xpreventtype", "qualname": "XPREventType.BuiltIn", "kind": "variable", "doc": "<p>The BuiltIn status of the item - True if BuiltIn; otherwise False.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The BuiltIn property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xpreventtype.XPREventType.CounterEventID", "modulename": "milestonexprotectrestpython.xpreventtype", "qualname": "XPREventType.CounterEventID", "kind": "variable", "doc": "<p>Globally unique identifier of the Counter event that relates to this event.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The CounterEventID property value.</p>\n</blockquote>\n\n<p>For example ... if this event type were a \"Start Recording\" event, then it's counter\nevent would be the \"Stop Recording\" event.</p>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xpreventtype.XPREventType.DateModified", "modulename": "milestonexprotectrestpython.xpreventtype", "qualname": "XPREventType.DateModified", "kind": "variable", "doc": "<p>Date and time (in UTC format) that the item was last modified.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DateModified property value.</p>\n</blockquote>\n", "annotation": ": datetime.datetime"}, {"fullname": "milestonexprotectrestpython.xpreventtype.XPREventType.Description", "modulename": "milestonexprotectrestpython.xpreventtype", "qualname": "XPREventType.Description", "kind": "variable", "doc": "<p>A description of the event type.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Description property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xpreventtype.XPREventType.DisplayName", "modulename": "milestonexprotectrestpython.xpreventtype", "qualname": "XPREventType.DisplayName", "kind": "variable", "doc": "<p>User-friendly display name used in various user-interface displays.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DisplayName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xpreventtype.XPREventType.EventTypeGroupId", "modulename": "milestonexprotectrestpython.xpreventtype", "qualname": "XPREventType.EventTypeGroupId", "kind": "variable", "doc": "<p>Globally unique identifier of the parent EventTypeGroup.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The EventTypeGroupId property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xpreventtype.XPREventType.GeneratorGroupId", "modulename": "milestonexprotectrestpython.xpreventtype", "qualname": "XPREventType.GeneratorGroupId", "kind": "variable", "doc": "<p>Globally unique identifier of the originating group.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The GeneratorGroupId property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xpreventtype.XPREventType.GeneratorGroupName", "modulename": "milestonexprotectrestpython.xpreventtype", "qualname": "XPREventType.GeneratorGroupName", "kind": "variable", "doc": "<p>Name of the originating group.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The GeneratorGroupName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xpreventtype.XPREventType.GeneratorId", "modulename": "milestonexprotectrestpython.xpreventtype", "qualname": "XPREventType.GeneratorId", "kind": "variable", "doc": "<p>Globally unique identifier of the originator.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The GeneratorId property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xpreventtype.XPREventType.GeneratorName", "modulename": "milestonexprotectrestpython.xpreventtype", "qualname": "XPREventType.GeneratorName", "kind": "variable", "doc": "<p>Name of the originator.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The GeneratorName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xpreventtype.XPREventType.GeneratorSubType", "modulename": "milestonexprotectrestpython.xpreventtype", "qualname": "XPREventType.GeneratorSubType", "kind": "variable", "doc": "<p>Sub-type of the originator.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The GeneratorSubType property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xpreventtype.XPREventType.GeneratorType", "modulename": "milestonexprotectrestpython.xpreventtype", "qualname": "XPREventType.GeneratorType", "kind": "variable", "doc": "<p>Type of the originator.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The GeneratorType property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xpreventtype.XPREventType.Id", "modulename": "milestonexprotectrestpython.xpreventtype", "qualname": "XPREventType.Id", "kind": "variable", "doc": "<p>The globally unique identifier of the item.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Id property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xpreventtype.XPREventType.Name", "modulename": "milestonexprotectrestpython.xpreventtype", "qualname": "XPREventType.Name", "kind": "variable", "doc": "<p>Name of the entry type.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Name property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xpreventtype.XPREventType.OccursGlobally", "modulename": "milestonexprotectrestpython.xpreventtype", "qualname": "XPREventType.OccursGlobally", "kind": "variable", "doc": "<p>True if the event type occurs globally; otherwise, False.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The OccursGlobally property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xpreventtype.XPREventType.SourceArray", "modulename": "milestonexprotectrestpython.xpreventtype", "qualname": "XPREventType.SourceArray", "kind": "variable", "doc": "<p>Source item types. <br />\nContains an array of possible sources of the event. <br />\nCan contain Camera, Hardware and other itemtype values. <br />\nFor MIP plugin events the source itemtype is MIPItem and the filter contains the MIP Kind of source. \nThe actual source is selected in the rule and alarm definition configuration.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The SourceArray property value.</p>\n</blockquote>\n", "annotation": ": list[str]"}, {"fullname": "milestonexprotectrestpython.xpreventtype.XPREventType.SourceFilterArray", "modulename": "milestonexprotectrestpython.xpreventtype", "qualname": "XPREventType.SourceFilterArray", "kind": "variable", "doc": "<p>Source filters. <br />\nContains an array where the index is matching the sources. <br />\nContent is formatted as {value} or {type},{value}. <br />\nIf source is \"MIPItem\" this value is the kind as defined in MIPKind (e.g. \"3b559f2e-3693-5463-a6fb-005c1f0259dc\").</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The SourceFilterArray property value.</p>\n</blockquote>\n", "annotation": ": list[str]"}, {"fullname": "milestonexprotectrestpython.xpreventtype.XPREventType.State", "modulename": "milestonexprotectrestpython.xpreventtype", "qualname": "XPREventType.State", "kind": "variable", "doc": "<p>State of the event type (e.g. \"Warning\", \"Error\", \"Idle\", etc).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The State property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xpreventtype.XPREventType.StateGroupId", "modulename": "milestonexprotectrestpython.xpreventtype", "qualname": "XPREventType.StateGroupId", "kind": "variable", "doc": "<p>State group ID. <br />\nAn event type can belong at most to one state group. <br />\nAll event types with the same state group ID are used to determine the state of a source. \nA source can be related to more than one state group. For example, a camera source is \nrelated to at least two state groups: The motion state group and the recording state group. </p>\n\n<p>Event types motion started and stopped in the motion state group determine whether something \nis moving inside the frame. Together, event types recording started and stopped in the recording \nstate group determine whether the camera stream is being recorded.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The StateGroupId property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xpreventtypegroup", "modulename": "milestonexprotectrestpython.xpreventtypegroup", "kind": "module", "doc": "<p>Module: xpreventtypegroup.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xpreventtypegroup.XPREventTypeGroup", "modulename": "milestonexprotectrestpython.xpreventtypegroup", "qualname": "XPREventTypeGroup", "kind": "class", "doc": "<p>Event Type Group information.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "milestonexprotectrestpython.xpreventtypegroup.XPREventTypeGroup.__init__", "modulename": "milestonexprotectrestpython.xpreventtypegroup", "qualname": "XPREventTypeGroup.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xpreventtypegroup.XPREventTypeGroup.DisplayName", "modulename": "milestonexprotectrestpython.xpreventtypegroup", "qualname": "XPREventTypeGroup.DisplayName", "kind": "variable", "doc": "<p>User-friendly display name used in various user-interface displays.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DisplayName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xpreventtypegroup.XPREventTypeGroup.Id", "modulename": "milestonexprotectrestpython.xpreventtypegroup", "qualname": "XPREventTypeGroup.Id", "kind": "variable", "doc": "<p>The globally unique identifier of the item.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Id property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprexception", "modulename": "milestonexprotectrestpython.xprexception", "kind": "module", "doc": "<p>Module: xprexception.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprexception.XPRException", "modulename": "milestonexprotectrestpython.xprexception", "qualname": "XPRException", "kind": "class", "doc": "<p>Exception thrown if a non-fatal application error occurs.</p>\n", "bases": "builtins.Exception"}, {"fullname": "milestonexprotectrestpython.xprexception.XPRException.__init__", "modulename": "milestonexprotectrestpython.xprexception", "qualname": "XPRException.__init__", "kind": "function", "doc": "<p>Initializes a new class instance using specified message text.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>message (str):</strong>  Exception message text.</li>\n<li><strong>innerException (Exception):</strong>  If specified, the exception that caused this exception. <br />\nDefault is None.</li>\n<li><strong>logsi (SISession):</strong>  Trace session object that this exception will be logged to, or null to bypass trace logging. <br />\nDefault is None.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">message</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">innerException</span><span class=\"p\">:</span> <span class=\"ne\">Exception</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">logsi</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sisession</span><span class=\"o\">.</span><span class=\"n\">SISession</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, {"fullname": "milestonexprotectrestpython.xprexception.XPRException.InnerException", "modulename": "milestonexprotectrestpython.xprexception", "qualname": "XPRException.InnerException", "kind": "variable", "doc": "<p>If specified, the exception that caused this exception. <br />\nDefault is None.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The InnerException property value.</p>\n</blockquote>\n", "annotation": ": Exception"}, {"fullname": "milestonexprotectrestpython.xprexception.XPRException.Message", "modulename": "milestonexprotectrestpython.xprexception", "qualname": "XPRException.Message", "kind": "variable", "doc": "<p>Exception message text.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Message property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprexception.XPRException.MessageId", "modulename": "milestonexprotectrestpython.xprexception", "qualname": "XPRException.MessageId", "kind": "variable", "doc": "<p>Exception message identifier.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Message property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprfilteroperator", "modulename": "milestonexprotectrestpython.xprfilteroperator", "kind": "module", "doc": "<p>Module: xprfilteroperator.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprfilteroperator.XPRFilterOperator", "modulename": "milestonexprotectrestpython.xprfilteroperator", "qualname": "XPRFilterOperator", "kind": "class", "doc": "<p>Filter Types.</p>\n", "bases": "milestonexprotectrestpython.xprenumcomparable.XPREnumComparable"}, {"fullname": "milestonexprotectrestpython.xprfilteroperator.XPRFilterOperator.NotSet", "modulename": "milestonexprotectrestpython.xprfilteroperator", "qualname": "XPRFilterOperator.NotSet", "kind": "variable", "doc": "<p>Filter type will not be used.</p>\n", "default_value": "&lt;XPRFilterOperator.NotSet: 0&gt;"}, {"fullname": "milestonexprotectrestpython.xprfilteroperator.XPRFilterOperator.lt", "modulename": "milestonexprotectrestpython.xprfilteroperator", "qualname": "XPRFilterOperator.lt", "kind": "variable", "doc": "<p>Less Than operator. <br />\nUsed to evaluate numerical and date or time property values.</p>\n", "default_value": "&lt;XPRFilterOperator.lt: 1&gt;"}, {"fullname": "milestonexprotectrestpython.xprfilteroperator.XPRFilterOperator.gt", "modulename": "milestonexprotectrestpython.xprfilteroperator", "qualname": "XPRFilterOperator.gt", "kind": "variable", "doc": "<p>Greater Than operator. <br />\nUsed to evaluate numerical and date or time property values.</p>\n", "default_value": "&lt;XPRFilterOperator.gt: 2&gt;"}, {"fullname": "milestonexprotectrestpython.xprfilteroperator.XPRFilterOperator.equals", "modulename": "milestonexprotectrestpython.xprfilteroperator", "qualname": "XPRFilterOperator.equals", "kind": "variable", "doc": "<p>Equals operator. <br />\nUsed to match a string property value that exactly matches a specified value.</p>\n", "default_value": "&lt;XPRFilterOperator.equals: 3&gt;"}, {"fullname": "milestonexprotectrestpython.xprfilteroperator.XPRFilterOperator.notEquals", "modulename": "milestonexprotectrestpython.xprfilteroperator", "qualname": "XPRFilterOperator.notEquals", "kind": "variable", "doc": "<p>Not equals operator. <br />\nUsed to match a string property value that does not match a specified value.</p>\n", "default_value": "&lt;XPRFilterOperator.notEquals: 4&gt;"}, {"fullname": "milestonexprotectrestpython.xprfilteroperator.XPRFilterOperator.startsWith", "modulename": "milestonexprotectrestpython.xprfilteroperator", "qualname": "XPRFilterOperator.startsWith", "kind": "variable", "doc": "<p>String starts with operator. <br />\nUsed to match a string property value that begins with a specified value.</p>\n", "default_value": "&lt;XPRFilterOperator.startsWith: 5&gt;"}, {"fullname": "milestonexprotectrestpython.xprfilteroperator.XPRFilterOperator.contains", "modulename": "milestonexprotectrestpython.xprfilteroperator", "qualname": "XPRFilterOperator.contains", "kind": "variable", "doc": "<p>String that contains operator. <br />\nUsed to match a string property value that contains a specified value.</p>\n", "default_value": "&lt;XPRFilterOperator.contains: 6&gt;"}, {"fullname": "milestonexprotectrestpython.xprgenericevent", "modulename": "milestonexprotectrestpython.xprgenericevent", "kind": "module", "doc": "<p>Module: xprgenericevent.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprgenericevent.XPRGenericEvent", "modulename": "milestonexprotectrestpython.xprgenericevent", "qualname": "XPRGenericEvent", "kind": "class", "doc": "<p>Generic Event information.</p>\n\n<p>More information about Generic Event configuration can be found on the\n<a target=\"_blank\" href=\"https://doc.milestonesys.com/2023R2/en-US/standard_features/sf_mc/sf_ui/mc_genericevents_rande.htm\">vendor documentation page</a>.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "milestonexprotectrestpython.xprgenericevent.XPRGenericEvent.__init__", "modulename": "milestonexprotectrestpython.xprgenericevent", "qualname": "XPRGenericEvent.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xprgenericevent.XPRGenericEvent.DataSource", "modulename": "milestonexprotectrestpython.xprgenericevent", "qualname": "XPRGenericEvent.DataSource", "kind": "variable", "doc": "<p>Name of the data source.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DataSource property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprgenericevent.XPRGenericEvent.DateModified", "modulename": "milestonexprotectrestpython.xprgenericevent", "qualname": "XPRGenericEvent.DateModified", "kind": "variable", "doc": "<p>Date and time (in UTC format) that the entry was last modified.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DateModified property value.</p>\n</blockquote>\n", "annotation": ": datetime.datetime"}, {"fullname": "milestonexprotectrestpython.xprgenericevent.XPRGenericEvent.DisplayName", "modulename": "milestonexprotectrestpython.xprgenericevent", "qualname": "XPRGenericEvent.DisplayName", "kind": "variable", "doc": "<p>User-friendly display name used in various user-interface displays.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DisplayName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprgenericevent.XPRGenericEvent.Enabled", "modulename": "milestonexprotectrestpython.xprgenericevent", "qualname": "XPRGenericEvent.Enabled", "kind": "variable", "doc": "<p>True if the event is enabled; otherwise, False.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Enabled property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprgenericevent.XPRGenericEvent.Expression", "modulename": "milestonexprotectrestpython.xprgenericevent", "qualname": "XPRGenericEvent.Expression", "kind": "variable", "doc": "<p>Expression that the system should look out for when analyzing data packages.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Expression property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprgenericevent.XPRGenericEvent.ExpressionType", "modulename": "milestonexprotectrestpython.xprgenericevent", "qualname": "XPRGenericEvent.ExpressionType", "kind": "variable", "doc": "<p>Indicates how particular the system should be when analyzing received data packages. <br />\nThe options are the following:  </p>\n\n<ul>\n<li>Search: In order for the event to occur, the received data package must contain the text specified in the Expression field, but may also have more content.  </li>\n<li>Match: In order for the event to occur, the received data package must contain exactly the text specified in the Expression field, and nothing else.  </li>\n<li>Regular expression.  </li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ExpressionType property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprgenericevent.XPRGenericEvent.Id", "modulename": "milestonexprotectrestpython.xprgenericevent", "qualname": "XPRGenericEvent.Id", "kind": "variable", "doc": "<p>The globally unique identifier of the item.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Id property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprgenericevent.XPRGenericEvent.Name", "modulename": "milestonexprotectrestpython.xprgenericevent", "qualname": "XPRGenericEvent.Name", "kind": "variable", "doc": "<p>Name of the event.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Name property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprgenericevent.XPRGenericEvent.Priority", "modulename": "milestonexprotectrestpython.xprgenericevent", "qualname": "XPRGenericEvent.Priority", "kind": "variable", "doc": "<p>Priority of the event.</p>\n\n<p>The priority must be specified as a number between 0 (highest priority) and 999999 (lowest priority).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Priority property value.</p>\n</blockquote>\n\n<p>The same data package may be analyzed for different events. The ability to assign a priority to each event \nlets you manage which event should be triggered if a received package matches the criteria for several events.</p>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprinputevent", "modulename": "milestonexprotectrestpython.xprinputevent", "kind": "module", "doc": "<p>Module: xprinputevent.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprinputevent.XPRInputEvent", "modulename": "milestonexprotectrestpython.xprinputevent", "qualname": "XPRInputEvent", "kind": "class", "doc": "<p>InputEvent device information.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n", "bases": "milestonexprotectrestpython.xprdevice.XPRDevice"}, {"fullname": "milestonexprotectrestpython.xprinputevent.XPRInputEvent.__init__", "modulename": "milestonexprotectrestpython.xprinputevent", "qualname": "XPRInputEvent.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xprlicensedetail", "modulename": "milestonexprotectrestpython.xprlicensedetail", "kind": "module", "doc": "<p>Module: xprlicensedetail.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>CareId</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprlicensedetail.XPRLicenseDetail", "modulename": "milestonexprotectrestpython.xprlicensedetail", "qualname": "XPRLicenseDetail", "kind": "class", "doc": "<p>License detail information.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n\n<p>More information about License configuration can be found on the\n<a target=\"_blank\" href=\"https://doc.milestonesys.com/2023R2/en-US/standard_features/sf_mc/sf_licensing/mc_LicenseDetailpageui.htm\">vendor documentation page</a>.</p>\n"}, {"fullname": "milestonexprotectrestpython.xprlicensedetail.XPRLicenseDetail.__init__", "modulename": "milestonexprotectrestpython.xprlicensedetail", "qualname": "XPRLicenseDetail.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xprlicensedetail.XPRLicenseDetail.Activated", "modulename": "milestonexprotectrestpython.xprlicensedetail", "qualname": "XPRLicenseDetail.Activated", "kind": "variable", "doc": "<p>Number of licenses that have been activated.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Activated property value.</p>\n</blockquote>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprlicensedetail.XPRLicenseDetail.ChangesWithoutActivation", "modulename": "milestonexprotectrestpython.xprlicensedetail", "qualname": "XPRLicenseDetail.ChangesWithoutActivation", "kind": "variable", "doc": "<p>Number of used device changes without activation licenses.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ChangesWithoutActivation property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlicensedetail.XPRLicenseDetail.DisplayName", "modulename": "milestonexprotectrestpython.xprlicensedetail", "qualname": "XPRLicenseDetail.DisplayName", "kind": "variable", "doc": "<p>User-friendly display name used in various user-interface displays.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DisplayName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlicensedetail.XPRLicenseDetail.GracePeriodIn", "modulename": "milestonexprotectrestpython.xprlicensedetail", "qualname": "XPRLicenseDetail.GracePeriodIn", "kind": "variable", "doc": "<p>Number of licenses that you have not yet activated and that therefore run in a grace period.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The GracePeriodIn property value.</p>\n</blockquote>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprlicensedetail.XPRLicenseDetail.GracePeriodExpired", "modulename": "milestonexprotectrestpython.xprlicensedetail", "qualname": "XPRLicenseDetail.GracePeriodExpired", "kind": "variable", "doc": "<p>Number of licenses that you have not yet activated and whose grace period has expired.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The GracePeriodExpired property value.</p>\n</blockquote>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprlicensedetail.XPRLicenseDetail.LicenseType", "modulename": "milestonexprotectrestpython.xprlicensedetail", "qualname": "XPRLicenseDetail.LicenseType", "kind": "variable", "doc": "<p>License Type value.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The LicenseType property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlicensedetail.XPRLicenseDetail.NotLicensed", "modulename": "milestonexprotectrestpython.xprlicensedetail", "qualname": "XPRLicenseDetail.NotLicensed", "kind": "variable", "doc": "<p>Number of licenses that you have in-use that exceed the number of available licenses.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The NotLicensed property value.</p>\n</blockquote>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprlicensedetail.XPRLicenseDetail.PluginId", "modulename": "milestonexprotectrestpython.xprlicensedetail", "qualname": "XPRLicenseDetail.PluginId", "kind": "variable", "doc": "<p>The globally unique identifier of the plugin.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The PluginId property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlicensedetail.XPRLicenseDetail.Note", "modulename": "milestonexprotectrestpython.xprlicensedetail", "qualname": "XPRLicenseDetail.Note", "kind": "variable", "doc": "<p>Notes pertaining to the license.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Note property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlicenseinformation", "modulename": "milestonexprotectrestpython.xprlicenseinformation", "kind": "module", "doc": "<p>Module: xprlicenseinformation.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>CareId</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprlicenseinformation.XPRLicenseInformation", "modulename": "milestonexprotectrestpython.xprlicenseinformation", "qualname": "XPRLicenseInformation", "kind": "class", "doc": "<p>License information.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n\n<p>More information about License configuration can be found on the\n<a target=\"_blank\" href=\"https://doc.milestonesys.com/2023R2/en-US/standard_features/sf_mc/sf_licensing/mc_licenseinformationpageui.htm\">vendor documentation page</a>.</p>\n"}, {"fullname": "milestonexprotectrestpython.xprlicenseinformation.XPRLicenseInformation.__init__", "modulename": "milestonexprotectrestpython.xprlicenseinformation", "qualname": "XPRLicenseInformation.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xprlicenseinformation.XPRLicenseInformation.ActivationAutomatic", "modulename": "milestonexprotectrestpython.xprlicenseinformation", "qualname": "XPRLicenseInformation.ActivationAutomatic", "kind": "variable", "doc": "<p>True if automatic license activation is enabled; otherwise, False.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ActivationAutomatic property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprlicenseinformation.XPRLicenseInformation.CareLevel", "modulename": "milestonexprotectrestpython.xprlicenseinformation", "qualname": "XPRLicenseInformation.CareLevel", "kind": "variable", "doc": "<p>Care Level identifier.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The CareLevel property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlicenseinformation.XPRLicenseInformation.CareId", "modulename": "milestonexprotectrestpython.xprlicenseinformation", "qualname": "XPRLicenseInformation.CareId", "kind": "variable", "doc": "<p>Care ID.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The CareId property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlicenseinformation.XPRLicenseInformation.DisplayName", "modulename": "milestonexprotectrestpython.xprlicenseinformation", "qualname": "XPRLicenseInformation.DisplayName", "kind": "variable", "doc": "<p>User-friendly display name used in various user-interface displays.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DisplayName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlicenseinformation.XPRLicenseInformation.Id", "modulename": "milestonexprotectrestpython.xprlicenseinformation", "qualname": "XPRLicenseInformation.Id", "kind": "variable", "doc": "<p>The globally unique identifier of the license information.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Id property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlicenseinformation.XPRLicenseInformation.SoftwareLicenseCode", "modulename": "milestonexprotectrestpython.xprlicenseinformation", "qualname": "XPRLicenseInformation.SoftwareLicenseCode", "kind": "variable", "doc": "<p>Product Software License Code value.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The SoftwareLicenseCode property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlicenseinformation.XPRLicenseInformation.Sku", "modulename": "milestonexprotectrestpython.xprlicenseinformation", "qualname": "XPRLicenseInformation.Sku", "kind": "variable", "doc": "<p>Product SKU identifier.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Sku property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlicenseoverview", "modulename": "milestonexprotectrestpython.xprlicenseoverview", "kind": "module", "doc": "<p>Module: xprlicenseoverview.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>CareId</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprlicenseoverview.XPRLicenseOverview", "modulename": "milestonexprotectrestpython.xprlicenseoverview", "qualname": "XPRLicenseOverview", "kind": "class", "doc": "<p>License overview information.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n\n<p>More information about License configuration can be found on the\n<a target=\"_blank\" href=\"https://doc.milestonesys.com/2023R2/en-US/standard_features/sf_mc/sf_licensing/mc_LicenseOverviewpageui.htm\">vendor documentation page</a>.</p>\n"}, {"fullname": "milestonexprotectrestpython.xprlicenseoverview.XPRLicenseOverview.__init__", "modulename": "milestonexprotectrestpython.xprlicenseoverview", "qualname": "XPRLicenseOverview.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xprlicenseoverview.XPRLicenseOverview.ActivatedStatus", "modulename": "milestonexprotectrestpython.xprlicenseoverview", "qualname": "XPRLicenseOverview.ActivatedStatus", "kind": "variable", "doc": "<p>License activation status description.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ActivatedStatus property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlicenseoverview.XPRLicenseOverview.DisplayName", "modulename": "milestonexprotectrestpython.xprlicenseoverview", "qualname": "XPRLicenseOverview.DisplayName", "kind": "variable", "doc": "<p>User-friendly display name used in various user-interface displays.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DisplayName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlicenseoverview.XPRLicenseOverview.LicenseType", "modulename": "milestonexprotectrestpython.xprlicenseoverview", "qualname": "XPRLicenseOverview.LicenseType", "kind": "variable", "doc": "<p>License Type value.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The LicenseType property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlicenseoverview.XPRLicenseOverview.PluginId", "modulename": "milestonexprotectrestpython.xprlicenseoverview", "qualname": "XPRLicenseOverview.PluginId", "kind": "variable", "doc": "<p>The globally unique identifier of the plugin.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The PluginId property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlicenseproduct", "modulename": "milestonexprotectrestpython.xprlicenseproduct", "kind": "module", "doc": "<p>Module: xprlicenseproduct.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>CarePremium</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprlicenseproduct.XPRLicenseProduct", "modulename": "milestonexprotectrestpython.xprlicenseproduct", "qualname": "XPRLicenseProduct", "kind": "class", "doc": "<p>License product information.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n\n<p>More information about License configuration can be found on the\n<a target=\"_blank\" href=\"https://doc.milestonesys.com/2023R2/en-US/standard_features/sf_mc/sf_licensing/mc_LicenseProductpageui.htm\">vendor documentation page</a>.</p>\n"}, {"fullname": "milestonexprotectrestpython.xprlicenseproduct.XPRLicenseProduct.__init__", "modulename": "milestonexprotectrestpython.xprlicenseproduct", "qualname": "XPRLicenseProduct.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xprlicenseproduct.XPRLicenseProduct.CarePlus", "modulename": "milestonexprotectrestpython.xprlicenseproduct", "qualname": "XPRLicenseProduct.CarePlus", "kind": "variable", "doc": "<p>Care Level identifier.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The CarePlus property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlicenseproduct.XPRLicenseProduct.CarePremium", "modulename": "milestonexprotectrestpython.xprlicenseproduct", "qualname": "XPRLicenseProduct.CarePremium", "kind": "variable", "doc": "<p>Care ID.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The CarePremium property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlicenseproduct.XPRLicenseProduct.DisplayName", "modulename": "milestonexprotectrestpython.xprlicenseproduct", "qualname": "XPRLicenseProduct.DisplayName", "kind": "variable", "doc": "<p>User-friendly display name used in various user-interface displays.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DisplayName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlicenseproduct.XPRLicenseProduct.ExpirationDate", "modulename": "milestonexprotectrestpython.xprlicenseproduct", "qualname": "XPRLicenseProduct.ExpirationDate", "kind": "variable", "doc": "<p>Date and time (in UTC format) of when the license expires.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ExpirationDate property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlicenseproduct.XPRLicenseProduct.ProductDisplayName", "modulename": "milestonexprotectrestpython.xprlicenseproduct", "qualname": "XPRLicenseProduct.ProductDisplayName", "kind": "variable", "doc": "<p>Product display name.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ProductDisplayName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlicenseproduct.XPRLicenseProduct.PluginId", "modulename": "milestonexprotectrestpython.xprlicenseproduct", "qualname": "XPRLicenseProduct.PluginId", "kind": "variable", "doc": "<p>The globally unique identifier of the plugin.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The PluginId property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlicenseproduct.XPRLicenseProduct.SoftwareLicenseCode", "modulename": "milestonexprotectrestpython.xprlicenseproduct", "qualname": "XPRLicenseProduct.SoftwareLicenseCode", "kind": "variable", "doc": "<p>Product Software License Code value.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The SoftwareLicenseCode property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlogininfo", "modulename": "milestonexprotectrestpython.xprlogininfo", "kind": "module", "doc": "<p>Module: xprlogininfo.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprlogininfo.XPRLoginInfo", "modulename": "milestonexprotectrestpython.xprlogininfo", "qualname": "XPRLoginInfo", "kind": "class", "doc": "<p>Login information returned by a successful call to the LoginBasicUser \nor LoginWindowsUser call.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "milestonexprotectrestpython.xprlogininfo.XPRLoginInfo.__init__", "modulename": "milestonexprotectrestpython.xprlogininfo", "qualname": "XPRLoginInfo.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xprlogininfo.XPRLoginInfo.AuthenticationType", "modulename": "milestonexprotectrestpython.xprlogininfo", "qualname": "XPRLoginInfo.AuthenticationType", "kind": "variable", "doc": "<p>Type of user credentials used (e.g. Basic, Windows, etc) in the authentication process.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The AuthenticationType property value.</p>\n</blockquote>\n", "annotation": ": milestonexprotectrestpython.xprauthenticationtype.XPRAuthenticationType"}, {"fullname": "milestonexprotectrestpython.xprlogininfo.XPRLoginInfo.ExpireTime", "modulename": "milestonexprotectrestpython.xprlogininfo", "qualname": "XPRLoginInfo.ExpireTime", "kind": "variable", "doc": "<p>Date and Time (UTC) at which the security token willl expire.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ExpireTime property value.</p>\n</blockquote>\n\n<p>This value is calculated by adding the TimeToLive property value to the \nRegistrationTime property value.</p>\n", "annotation": ": datetime.datetime"}, {"fullname": "milestonexprotectrestpython.xprlogininfo.XPRLoginInfo.Password", "modulename": "milestonexprotectrestpython.xprlogininfo", "qualname": "XPRLoginInfo.Password", "kind": "variable", "doc": "<p>Security password which is used in subsequent calls to the REST server \nfor authentication.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Password property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlogininfo.XPRLoginInfo.RegistrationTime", "modulename": "milestonexprotectrestpython.xprlogininfo", "qualname": "XPRLoginInfo.RegistrationTime", "kind": "variable", "doc": "<p>Time at which the security token was registered, in UTC format.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The RegistrationTime property value.</p>\n</blockquote>\n", "annotation": ": datetime.datetime"}, {"fullname": "milestonexprotectrestpython.xprlogininfo.XPRLoginInfo.Scope", "modulename": "milestonexprotectrestpython.xprlogininfo", "qualname": "XPRLoginInfo.Scope", "kind": "variable", "doc": "<p>Security Scope which the token is to be used for (e.g. \"managementserver\", etc).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Scope property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlogininfo.XPRLoginInfo.TimeToLiveLimited", "modulename": "milestonexprotectrestpython.xprlogininfo", "qualname": "XPRLoginInfo.TimeToLiveLimited", "kind": "variable", "doc": "<p>TimeToLive calculated using time profile from APPLICATIONACCESSCLIENTLOGIN attribute.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The TimeToLiveLimited property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprlogininfo.XPRLoginInfo.TimeToLiveMilliseconds", "modulename": "milestonexprotectrestpython.xprlogininfo", "qualname": "XPRLoginInfo.TimeToLiveMilliseconds", "kind": "variable", "doc": "<p>Remaining time (in milliseconds) to live for the security token.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The TimeToLiveSeconds property value, converted to milliseconds.</p>\n</blockquote>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprlogininfo.XPRLoginInfo.TimeToLiveSeconds", "modulename": "milestonexprotectrestpython.xprlogininfo", "qualname": "XPRLoginInfo.TimeToLiveSeconds", "kind": "variable", "doc": "<p>Remaining time (in seconds) to live for the security token.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The TimeToLiveSeconds property value.</p>\n</blockquote>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprlogininfo.XPRLoginInfo.Token", "modulename": "milestonexprotectrestpython.xprlogininfo", "qualname": "XPRLoginInfo.Token", "kind": "variable", "doc": "<p>Security token which is used in subsequent calls to the REST server \nfor authentication.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Token property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlogininfo.XPRLoginInfo.TokenType", "modulename": "milestonexprotectrestpython.xprlogininfo", "qualname": "XPRLoginInfo.TokenType", "kind": "variable", "doc": "<p>Security Token Type (e.g. \"Bearer\", etc).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The TokenType property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlogininfo.XPRLoginInfo.UserName", "modulename": "milestonexprotectrestpython.xprlogininfo", "qualname": "XPRLoginInfo.UserName", "kind": "variable", "doc": "<p>Security username which is used in subsequent calls to the REST server \nfor authentication.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The UserName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprlogintokenexpiredexception", "modulename": "milestonexprotectrestpython.xprlogintokenexpiredexception", "kind": "module", "doc": "<p>Module: xprlogintokenexpiredexception.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprlogintokenexpiredexception.XPRLoginTokenExpiredException", "modulename": "milestonexprotectrestpython.xprlogintokenexpiredexception", "qualname": "XPRLoginTokenExpiredException", "kind": "class", "doc": "<p>Raised when the API service detects that the login token is expired.</p>\n", "bases": "milestonexprotectrestpython.xprexception.XPRException"}, {"fullname": "milestonexprotectrestpython.xprlogintokenexpiredexception.XPRLoginTokenExpiredException.__init__", "modulename": "milestonexprotectrestpython.xprlogintokenexpiredexception", "qualname": "XPRLoginTokenExpiredException.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>message (str):</strong>  Exception message text.</li>\n<li><strong>logsi (SISession):</strong>  Trace session object that this exception will be logged to, or null to bypass trace logging.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">message</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">logsi</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sisession</span><span class=\"o\">.</span><span class=\"n\">SISession</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, {"fullname": "milestonexprotectrestpython.xprmetadata", "modulename": "milestonexprotectrestpython.xprmetadata", "kind": "module", "doc": "<p>Module: xprmetadata.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprmetadata.XPRMetadata", "modulename": "milestonexprotectrestpython.xprmetadata", "qualname": "XPRMetadata", "kind": "class", "doc": "<p>Metadata device information.</p>\n\n<p>More information about MetaData configuration can be found on the\n<a target=\"_blank\" href=\"https://doc.milestonesys.com/latest/en-US/standard_features/sf_mc/sf_ui/mc_devicestabs_devices.htm#MC_InfoTabExplained.htm\">vendor documentation page</a>.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n", "bases": "milestonexprotectrestpython.xprdevice.XPRDevice"}, {"fullname": "milestonexprotectrestpython.xprmetadata.XPRMetadata.__init__", "modulename": "milestonexprotectrestpython.xprmetadata", "qualname": "XPRMetadata.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xprmetadata.XPRMetadata.EdgeStorageEnabled", "modulename": "milestonexprotectrestpython.xprmetadata", "qualname": "XPRMetadata.EdgeStorageEnabled", "kind": "variable", "doc": "<p>Determines if remote recording is enabled (True) or not (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The EdgeStorageEnabled property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprmetadata.XPRMetadata.EdgeStoragePlaybackEnabled", "modulename": "milestonexprotectrestpython.xprmetadata", "qualname": "XPRMetadata.EdgeStoragePlaybackEnabled", "kind": "variable", "doc": "<p>Determines if remote recording playback is enabled (True) or not (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The EdgeStoragePlaybackEnabled property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprmetadata.XPRMetadata.ManualRecordingTimeoutEnabled", "modulename": "milestonexprotectrestpython.xprmetadata", "qualname": "XPRMetadata.ManualRecordingTimeoutEnabled", "kind": "variable", "doc": "<p>Determines if manual recording timeout is enabled (True) or not (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ManualRecordingTimeoutEnabled property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprmetadata.XPRMetadata.ManualRecordingTimeoutMinutes", "modulename": "milestonexprotectrestpython.xprmetadata", "qualname": "XPRMetadata.ManualRecordingTimeoutMinutes", "kind": "variable", "doc": "<p>Number of minutes to automatically stop all manual recordings started by XProtect Smart \nClient users if manual recording timeout is enabled.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ManualRecordingTimeoutMinutes property value.</p>\n</blockquote>\n\n<p>The number of minutes you specify must be sufficiently large enough to accommodate the \nrequirements of the various manual recordings without overloading the system.</p>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprmetadata.XPRMetadata.PrebufferEnabled", "modulename": "milestonexprotectrestpython.xprmetadata", "qualname": "XPRMetadata.PrebufferEnabled", "kind": "variable", "doc": "<p>Determines if pre-buffering is enabled (True) or not (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The PrebufferEnabled property value.</p>\n</blockquote>\n\n<p>Pre-buffering is the ability to record audio and video before the actual triggering event occurs.</p>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprmetadata.XPRMetadata.PrebufferInMemory", "modulename": "milestonexprotectrestpython.xprmetadata", "qualname": "XPRMetadata.PrebufferInMemory", "kind": "variable", "doc": "<p>Determines if pre-buffering is stored in-memory (True) or onto disk storage (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The PrebufferInMemory property value.</p>\n</blockquote>\n\n<p>Storage to memory instead of to disk improves system performance, but is only possible for \nshorter pre-buffer periods (usually 15 seconds or less).</p>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprmetadata.XPRMetadata.PrebufferSeconds", "modulename": "milestonexprotectrestpython.xprmetadata", "qualname": "XPRMetadata.PrebufferSeconds", "kind": "variable", "doc": "<p>Number of seconds to automatically stop all manual recordings started by XProtect Smart \nClient users if manual recording timeout is enabled.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The PrebufferSeconds property value.</p>\n</blockquote>\n\n<p>The number of seconds you specify must be sufficiently large to accommodate your requirements \nin the various recording rules you define.</p>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprmetadata.XPRMetadata.RecordingEnabled", "modulename": "milestonexprotectrestpython.xprmetadata", "qualname": "XPRMetadata.RecordingEnabled", "kind": "variable", "doc": "<p>Determines if recording is enabled (True) or not (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The RecordingEnabled property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprmetadata.XPRMetadata.RecordingStorageId", "modulename": "milestonexprotectrestpython.xprmetadata", "qualname": "XPRMetadata.RecordingStorageId", "kind": "variable", "doc": "<p>The Storage identifier of where recordings are stored for this device.  </p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The RecordingStorageId property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprmicrophone", "modulename": "milestonexprotectrestpython.xprmicrophone", "kind": "module", "doc": "<p>Module: xprmicrophone.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprmicrophone.XPRMicrophone", "modulename": "milestonexprotectrestpython.xprmicrophone", "qualname": "XPRMicrophone", "kind": "class", "doc": "<p>Microphone device information.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n", "bases": "milestonexprotectrestpython.xprdevice.XPRDevice"}, {"fullname": "milestonexprotectrestpython.xprmicrophone.XPRMicrophone.__init__", "modulename": "milestonexprotectrestpython.xprmicrophone", "qualname": "XPRMicrophone.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xprmicrophone.XPRMicrophone.EdgeStorageEnabled", "modulename": "milestonexprotectrestpython.xprmicrophone", "qualname": "XPRMicrophone.EdgeStorageEnabled", "kind": "variable", "doc": "<p>Determines if remote recording is enabled (True) or not (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The EdgeStorageEnabled property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprmicrophone.XPRMicrophone.EdgeStoragePlaybackEnabled", "modulename": "milestonexprotectrestpython.xprmicrophone", "qualname": "XPRMicrophone.EdgeStoragePlaybackEnabled", "kind": "variable", "doc": "<p>Determines if remote recording playback is enabled (True) or not (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The EdgeStoragePlaybackEnabled property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprmicrophone.XPRMicrophone.ManualRecordingTimeoutEnabled", "modulename": "milestonexprotectrestpython.xprmicrophone", "qualname": "XPRMicrophone.ManualRecordingTimeoutEnabled", "kind": "variable", "doc": "<p>Determines if manual recording timeout is enabled (True) or not (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ManualRecordingTimeoutEnabled property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprmicrophone.XPRMicrophone.ManualRecordingTimeoutMinutes", "modulename": "milestonexprotectrestpython.xprmicrophone", "qualname": "XPRMicrophone.ManualRecordingTimeoutMinutes", "kind": "variable", "doc": "<p>Number of minutes to automatically stop all manual recordings started by XProtect Smart \nClient users if manual recording timeout is enabled.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ManualRecordingTimeoutMinutes property value.</p>\n</blockquote>\n\n<p>The number of minutes you specify must be sufficiently large enough to accommodate the \nrequirements of the various manual recordings without overloading the system.</p>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprmicrophone.XPRMicrophone.PrebufferEnabled", "modulename": "milestonexprotectrestpython.xprmicrophone", "qualname": "XPRMicrophone.PrebufferEnabled", "kind": "variable", "doc": "<p>Determines if pre-buffering is enabled (True) or not (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The PrebufferEnabled property value.</p>\n</blockquote>\n\n<p>Pre-buffering is the ability to record audio and video before the actual triggering event occurs.</p>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprmicrophone.XPRMicrophone.PrebufferInMemory", "modulename": "milestonexprotectrestpython.xprmicrophone", "qualname": "XPRMicrophone.PrebufferInMemory", "kind": "variable", "doc": "<p>Determines if pre-buffering is stored in-memory (True) or onto disk storage (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The PrebufferInMemory property value.</p>\n</blockquote>\n\n<p>Storage to memory instead of to disk improves system performance, but is only possible for \nshorter pre-buffer periods (usually 15 seconds or less).</p>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprmicrophone.XPRMicrophone.PrebufferSeconds", "modulename": "milestonexprotectrestpython.xprmicrophone", "qualname": "XPRMicrophone.PrebufferSeconds", "kind": "variable", "doc": "<p>Number of seconds to automatically stop all manual recordings started by XProtect Smart \nClient users if manual recording timeout is enabled.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The PrebufferSeconds property value.</p>\n</blockquote>\n\n<p>The number of seconds you specify must be sufficiently large to accommodate your requirements \nin the various recording rules you define.</p>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprmicrophone.XPRMicrophone.RecordingEnabled", "modulename": "milestonexprotectrestpython.xprmicrophone", "qualname": "XPRMicrophone.RecordingEnabled", "kind": "variable", "doc": "<p>Determines if recording is enabled (True) or not (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The RecordingEnabled property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprmicrophone.XPRMicrophone.RecordingStorageId", "modulename": "milestonexprotectrestpython.xprmicrophone", "qualname": "XPRMicrophone.RecordingStorageId", "kind": "variable", "doc": "<p>The Storage identifier of where recordings are stored for this device.  </p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The RecordingStorageId property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprmotiondetection", "modulename": "milestonexprotectrestpython.xprmotiondetection", "kind": "module", "doc": "<p>Module: xprmotiondetection.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprmotiondetection.XPRMotionDetection", "modulename": "milestonexprotectrestpython.xprmotiondetection", "qualname": "XPRMotionDetection", "kind": "class", "doc": "<p>Motion Detection information.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n\n<p>More information about Motion Detection configuration can be found on the\n<a target=\"_blank\" href=\"https://doc.milestonesys.com/2023R2/en-US/standard_features/sf_mc/sf_ui/mc_devicestabs_devices.htm#MC_MotionTabDevices.htm\">vendor documentation page</a>.</p>\n"}, {"fullname": "milestonexprotectrestpython.xprmotiondetection.XPRMotionDetection.__init__", "modulename": "milestonexprotectrestpython.xprmotiondetection", "qualname": "XPRMotionDetection.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xprmotiondetection.XPRMotionDetection.DetectionMethod", "modulename": "milestonexprotectrestpython.xprmotiondetection", "qualname": "XPRMotionDetection.DetectionMethod", "kind": "variable", "doc": "<p>Motion detection method used to optimize motion detection by analyzing only \na percentage of the image. Valid values are:  </p>\n\n<ul>\n<li>Normal  </li>\n<li>Optimized  </li>\n<li>Fast  </li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DetectionMethod property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprmotiondetection.XPRMotionDetection.DisplayName", "modulename": "milestonexprotectrestpython.xprmotiondetection", "qualname": "XPRMotionDetection.DisplayName", "kind": "variable", "doc": "<p>User-friendly display name used in various user-interface displays.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DisplayName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprmotiondetection.XPRMotionDetection.Enabled", "modulename": "milestonexprotectrestpython.xprmotiondetection", "qualname": "XPRMotionDetection.Enabled", "kind": "variable", "doc": "<p>True if motion detection is enabled; otherwise, False.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Enabled property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprmotiondetection.XPRMotionDetection.ExcludeRegions", "modulename": "milestonexprotectrestpython.xprmotiondetection", "qualname": "XPRMotionDetection.ExcludeRegions", "kind": "variable", "doc": "<p>Defines regions of the camera view to exclude from motion detection.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ExcludeRegions property value.</p>\n</blockquote>\n\n<p>Excluding motion detection from specific areas helps you avoid detection of irrelevant motion, \nfor example if the camera covers an area where a tree is swaying in the wind or where cars \nregularly pass by in the background.</p>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprmotiondetection.XPRMotionDetection.GenerateMotionMetadata", "modulename": "milestonexprotectrestpython.xprmotiondetection", "qualname": "XPRMotionDetection.GenerateMotionMetadata", "kind": "variable", "doc": "<p>True to generate motion metadata for smart search function; otherwise, False.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The GenerateMotionMetadata property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprmotiondetection.XPRMotionDetection.GridSize", "modulename": "milestonexprotectrestpython.xprmotiondetection", "qualname": "XPRMotionDetection.GridSize", "kind": "variable", "doc": "<p>Grid size used when defining exclude regions.  Valid values are:</p>\n\n<ul>\n<li>8x8  </li>\n<li>16x16  </li>\n<li>32x32  </li>\n<li>64x64  </li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The GridSize property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprmotiondetection.XPRMotionDetection.HardwareAccelerationMode", "modulename": "milestonexprotectrestpython.xprmotiondetection", "qualname": "XPRMotionDetection.HardwareAccelerationMode", "kind": "variable", "doc": "<p>Hardware acceleration mode that is in use.  Valid values are:</p>\n\n<ul>\n<li>Automatic = hardware acceleration enabled.  </li>\n<li>Off = hardware acceleration disabled.  </li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The HardwareAccelerationMode property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprmotiondetection.XPRMotionDetection.Id", "modulename": "milestonexprotectrestpython.xprmotiondetection", "qualname": "XPRMotionDetection.Id", "kind": "variable", "doc": "<p>Globally unique identifier of the motion detection item.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Id property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprmotiondetection.XPRMotionDetection.KeyframesOnly", "modulename": "milestonexprotectrestpython.xprmotiondetection", "qualname": "XPRMotionDetection.KeyframesOnly", "kind": "variable", "doc": "<p>True to do motion detection on keyframes only; otherwise, False to do motion\ndetection on the entire video stream.  </p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The KeyframesOnly property value.</p>\n</blockquote>\n\n<p>Only applies to MPEG-4/H.264/H.265.</p>\n\n<p>Motion detection on keyframes reduces the amount of processing power used to carry \nout the analysis.</p>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprmotiondetection.XPRMotionDetection.ManualSensitivity", "modulename": "milestonexprotectrestpython.xprmotiondetection", "qualname": "XPRMotionDetection.ManualSensitivity", "kind": "variable", "doc": "<p>Determines how much each pixel in the image must change before it is \nregarded as motion.  Value in range 0 - 765.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ManualSensitivity property value.</p>\n</blockquote>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprmotiondetection.XPRMotionDetection.ManualSensitivityEnabled", "modulename": "milestonexprotectrestpython.xprmotiondetection", "qualname": "XPRMotionDetection.ManualSensitivityEnabled", "kind": "variable", "doc": "<p>True to enable manual sensitivity settings; otherwise, False to\nutilize automatic sensitivity settings.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ManualSensitivityEnabled property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprmotiondetection.XPRMotionDetection.ParentId", "modulename": "milestonexprotectrestpython.xprmotiondetection", "qualname": "XPRMotionDetection.ParentId", "kind": "variable", "doc": "<p>Globally unique identifier of the parent device.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ParentId property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprmotiondetection.XPRMotionDetection.ParentType", "modulename": "milestonexprotectrestpython.xprmotiondetection", "qualname": "XPRMotionDetection.ParentType", "kind": "variable", "doc": "<p>Parent device type (\"cameras\", etc).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ParentType property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprmotiondetection.XPRMotionDetection.ProcessTime", "modulename": "milestonexprotectrestpython.xprmotiondetection", "qualname": "XPRMotionDetection.ProcessTime", "kind": "variable", "doc": "<p>Image processing interval that determines how often the system performs \nthe motion detection analysis. <br />\nDefault value is every 500 milliseconds.</p>\n\n<p>Motion detection check interval that specifies how often to check for motion. \nValid values are:</p>\n\n<ul>\n<li>Ms100 = every 100 milliseconds.</li>\n<li>Ms250 = every 250 milliseconds.</li>\n<li>Ms500 = every 500 milliseconds.</li>\n<li>Ms750 = every 750 milliseconds.</li>\n<li>Ms1000 = every 1000 milliseconds (or 1 second).</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ProcessTime property value.</p>\n</blockquote>\n\n<p>The interval is applied if the actual frame rate is higher than the interval you set here.\nFor example, every 1000 milliseconds are once every second.</p>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprmotiondetection.XPRMotionDetection.Threshold", "modulename": "milestonexprotectrestpython.xprmotiondetection", "qualname": "XPRMotionDetection.Threshold", "kind": "variable", "doc": "<p>Determine how many pixels in the image must change before it is regarded \nas motion and triggers a motion event.  Value in range 0 - 10000.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Threshold property value.</p>\n</blockquote>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprmotiondetection.XPRMotionDetection.UseExcludeRegions", "modulename": "milestonexprotectrestpython.xprmotiondetection", "qualname": "XPRMotionDetection.UseExcludeRegions", "kind": "variable", "doc": "<p>True to enable exclude regions in the motion detection; otherwise, False to\ninclude all pixels in the view for motion detection.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The UseExcludeRegions property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xproutput", "modulename": "milestonexprotectrestpython.xproutput", "kind": "module", "doc": "<p>Module: xproutput.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xproutput.XPROutput", "modulename": "milestonexprotectrestpython.xproutput", "qualname": "XPROutput", "kind": "class", "doc": "<p>Output device information.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n", "bases": "milestonexprotectrestpython.xprdevice.XPRDevice"}, {"fullname": "milestonexprotectrestpython.xproutput.XPROutput.__init__", "modulename": "milestonexprotectrestpython.xproutput", "qualname": "XPROutput.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xprrecordingserver", "modulename": "milestonexprotectrestpython.xprrecordingserver", "kind": "module", "doc": "<p>Module: xprrecordingserver.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprrecordingserver.XPRRecordingServer", "modulename": "milestonexprotectrestpython.xprrecordingserver", "qualname": "XPRRecordingServer", "kind": "class", "doc": "<p>Recording Server information.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n\n<p>More information about recording server configuration can be found on the\n<a target=\"_blank\" href=\"https://doc.milestonesys.com/2023R2/en-US/standard_features/sf_mc/sf_ui/mc_recordingservers_servers.htm\">vendor documentation page</a>.</p>\n"}, {"fullname": "milestonexprotectrestpython.xprrecordingserver.XPRRecordingServer.__init__", "modulename": "milestonexprotectrestpython.xprrecordingserver", "qualname": "XPRRecordingServer.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xprrecordingserver.XPRRecordingServer.ActiveWebServerUri", "modulename": "milestonexprotectrestpython.xprrecordingserver", "qualname": "XPRRecordingServer.ActiveWebServerUri", "kind": "variable", "doc": "<p>Public address of the recording server's web server over the internet.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ActiveWebServerUri property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprrecordingserver.XPRRecordingServer.DateModified", "modulename": "milestonexprotectrestpython.xprrecordingserver", "qualname": "XPRRecordingServer.DateModified", "kind": "variable", "doc": "<p>Date and time (in UTC format) that the recording server entry was last modified.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DateModified property value.</p>\n</blockquote>\n", "annotation": ": datetime.datetime"}, {"fullname": "milestonexprotectrestpython.xprrecordingserver.XPRRecordingServer.Description", "modulename": "milestonexprotectrestpython.xprrecordingserver", "qualname": "XPRRecordingServer.Description", "kind": "variable", "doc": "<p>A description of the recording server.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Description property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprrecordingserver.XPRRecordingServer.DisplayName", "modulename": "milestonexprotectrestpython.xprrecordingserver", "qualname": "XPRRecordingServer.DisplayName", "kind": "variable", "doc": "<p>User-friendly display name used in various user-interface displays.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DisplayName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprrecordingserver.XPRRecordingServer.Enabled", "modulename": "milestonexprotectrestpython.xprrecordingserver", "qualname": "XPRRecordingServer.Enabled", "kind": "variable", "doc": "<p>The Enabled status of the recording server - True if Enabled; otherwise False.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Enabled property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprrecordingserver.XPRRecordingServer.HostName", "modulename": "milestonexprotectrestpython.xprrecordingserver", "qualname": "XPRRecordingServer.HostName", "kind": "variable", "doc": "<p>The recording server's host name.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The HostName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprrecordingserver.XPRRecordingServer.Id", "modulename": "milestonexprotectrestpython.xprrecordingserver", "qualname": "XPRRecordingServer.Id", "kind": "variable", "doc": "<p>The globally unique identifier of the recording server.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Id property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprrecordingserver.XPRRecordingServer.MulticastServerAddress", "modulename": "milestonexprotectrestpython.xprrecordingserver", "qualname": "XPRRecordingServer.MulticastServerAddress", "kind": "variable", "doc": "<p>The multicast server address of the recording server.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The MulticastServerAddress property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprrecordingserver.XPRRecordingServer.Name", "modulename": "milestonexprotectrestpython.xprrecordingserver", "qualname": "XPRRecordingServer.Name", "kind": "variable", "doc": "<p>Name of the recording server.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Name property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprrecordingserver.XPRRecordingServer.PortNumber", "modulename": "milestonexprotectrestpython.xprrecordingserver", "qualname": "XPRRecordingServer.PortNumber", "kind": "variable", "doc": "<p>Port number to be used for handling web server requests, for example for handling PTZ \ncamera control commands and for browse and live requests from XProtect Smart Client. <br />\nDefault is port 7563.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The PortNumber property value.</p>\n</blockquote>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprrecordingserver.XPRRecordingServer.PublicAccessEnabled", "modulename": "milestonexprotectrestpython.xprrecordingserver", "qualname": "XPRRecordingServer.PublicAccessEnabled", "kind": "variable", "doc": "<p>Indicates if the recording server is publicly accessible (True) or private (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The PublicAccessEnabled property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprrecordingserver.XPRRecordingServer.PublicWebserverHostName", "modulename": "milestonexprotectrestpython.xprrecordingserver", "qualname": "XPRRecordingServer.PublicWebserverHostName", "kind": "variable", "doc": "<p>Recording server's public web server address.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The PublicWebserverHostName property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprrecordingserver.XPRRecordingServer.PublicWebserverPort", "modulename": "milestonexprotectrestpython.xprrecordingserver", "qualname": "XPRRecordingServer.PublicWebserverPort", "kind": "variable", "doc": "<p>Recording server's public web server port number.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The PublicWebserverPort property value.</p>\n</blockquote>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprrecordingserver.XPRRecordingServer.ShutdownOnStorageFailure", "modulename": "milestonexprotectrestpython.xprrecordingserver", "qualname": "XPRRecordingServer.ShutdownOnStorageFailure", "kind": "variable", "doc": "<p>Indicates if the recording server will be shut down automatically if a\nstorage failure occurs (True) or not (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ShutdownOnStorageFailure property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprrecordingserver.XPRRecordingServer.SiteId", "modulename": "milestonexprotectrestpython.xprrecordingserver", "qualname": "XPRRecordingServer.SiteId", "kind": "variable", "doc": "<p>Globally unique identifier of the Site that defines this recording server.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The SiteId property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprrecordingserver.XPRRecordingServer.SynchronizationTime", "modulename": "milestonexprotectrestpython.xprrecordingserver", "qualname": "XPRRecordingServer.SynchronizationTime", "kind": "variable", "doc": "<p>The SynchronizationTime property value.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The SynchronizationTime property value.</p>\n</blockquote>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprrecordingserver.XPRRecordingServer.TimeZoneName", "modulename": "milestonexprotectrestpython.xprrecordingserver", "qualname": "XPRRecordingServer.TimeZoneName", "kind": "variable", "doc": "<p>Time zone that the recording server is located in.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The TimeZoneName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprrecordingserver.XPRRecordingServer.WebServerUri", "modulename": "milestonexprotectrestpython.xprrecordingserver", "qualname": "XPRRecordingServer.WebServerUri", "kind": "variable", "doc": "<p>Local address of the recording server's web server. You use the local address, for example, \nfor handling PTZ camera control commands, and for handling browsing and live requests from \nXProtect Smart Client.  </p>\n\n<p>The address includes the port number that is used for web server communication (typically port 7563).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The WebServerUri property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprrestservice", "modulename": "milestonexprotectrestpython.xprrestservice", "kind": "module", "doc": "<p>Module: xprrestservice.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService", "kind": "class", "doc": "<p>The REST Service class provides access to XProtect API Gateway REST services.</p>\n", "bases": "milestonexprotectrestpython.xprrestservicebase.XPRRestServiceBase"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.__init__", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>Exception:</strong>  The method fails for any reason.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetAnalyticsEvents", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetAnalyticsEvents", "kind": "function", "doc": "<p>Returns configuration information for one or more Analytics Event items.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRAnalyticsEvent items that contain AnalyticsEvent \n  configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any other reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprfilteroperator</span> <span class=\"kn\">import</span> <span class=\"n\">XPRFilterOperator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get Analytics events, both enabled and disabled.</span>\n<span class=\"n\">evnts</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetAnalyticsEvents</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** AnalyticsEvents (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">evnts</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get Analytics events, enabled only.</span>\n<span class=\"n\">evnts</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetAnalyticsEvents</span><span class=\"p\">(</span><span class=\"kc\">False</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** AnalyticsEvents (Enabled only):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">evnts</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get Analytics events, whose displayName contains &#39;my&#39;.</span>\n<span class=\"n\">evnts</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetAnalyticsEvents</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;displayName&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;my&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** AnalyticsEvents (whose displayName contains &#39;my&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">evnts</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get Analytics events, whose name contains &#39;my&#39;.</span>\n<span class=\"n\">evnts</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetAnalyticsEvents</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;name&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;my&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** AnalyticsEvents (whose name contains &#39;my&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">evnts</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetCameraGroups", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetCameraGroups", "kind": "function", "doc": "<p>Returns configuration information for one or more CameraGroups.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n<li><strong>parentId (str):</strong>  Parent Group identifier to retrieve child group items of, or null to retrieve top level groups.\nDefault is None.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRCameraGroup items that contain camera group \n  configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any other reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprfilteroperator</span> <span class=\"kn\">import</span> <span class=\"n\">XPRFilterOperator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get camera device groups, both enabled and disabled.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetCameraGroups</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** CameraGroups (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get camera device groups, enabled only.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetCameraGroups</span><span class=\"p\">(</span><span class=\"kc\">False</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** CameraGroups (Enabled only):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get camera device groups, whose displayName contains &#39;1080p&#39;.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetCameraGroups</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;displayName&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;1080p&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** CameraGroups (whose displayName contains &#39;1080p&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get camera device groups, whose name contains &#39;iPad&#39;.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetCameraGroups</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;name&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;iPad&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** CameraGroups (whose name contains &#39;iPad&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get camera device child groups for a designated parent group id.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetCameraGroups</span><span class=\"p\">(</span><span class=\"n\">parentId</span><span class=\"o\">=</span><span class=\"s2\">&quot;b6791e89-e336-44f5-adfc-0936b4472147&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** CameraGroups (child groups of parent group id):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">parentId</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetCameraMotionDetections", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetCameraMotionDetections", "kind": "function", "doc": "<p>Returns configuration information for one or more Camera device MotionDetections.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>cameraId (str):</strong>  Globally unique identifier of the camera whose MotionDetections are to be retrieved.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRMotionDetection items that contain camera motion\n  detection configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any other reason.  </li>\n</ul>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get camera device motiondetections for a designated parent camera id.</span>\n<span class=\"n\">motions</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetCameraMotionDetections</span><span class=\"p\">(</span><span class=\"s2\">&quot;f0f31f69-36a2-46a3-80b6-48e4bf617db8&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Camera MotionDetection (for parent camera id):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">motions</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">cameraId</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetCameras", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetCameras", "kind": "function", "doc": "<p>Returns configuration information for one or more Camera devices.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRCamera items that contain camera \n  configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any other reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprfilteroperator</span> <span class=\"kn\">import</span> <span class=\"n\">XPRFilterOperator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get camera devices, both enabled and disabled.</span>\n<span class=\"n\">cams</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetCameras</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Cameras (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">cams</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get camera devices, enabled only.</span>\n<span class=\"n\">cams</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetCameras</span><span class=\"p\">(</span><span class=\"kc\">False</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Cameras (Enabled only):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">cams</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># sort results by name, descending.</span>\n<span class=\"n\">cams</span><span class=\"o\">.</span><span class=\"n\">sort</span><span class=\"p\">(</span><span class=\"n\">reverse</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Cameras (Collection Sorted by: Name, descending):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">cams</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># sort results by description, ascending.</span>\n<span class=\"n\">cams</span><span class=\"o\">.</span><span class=\"n\">sort</span><span class=\"p\">(</span><span class=\"n\">key</span><span class=\"o\">=</span><span class=\"k\">lambda</span> <span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"n\">x</span><span class=\"o\">.</span><span class=\"n\">Description</span> <span class=\"ow\">or</span> <span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Cameras (Collection Sorted by: Description, ascending):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">cams</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get camera devices, whose displayName property contains &#39;Office&#39;.</span>\n<span class=\"n\">cams</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetCameras</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;displayName&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Office&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Cameras (whose displayName contains &#39;Office&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">cams</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get camera devices, whose name property contains &#39;iPad&#39;.</span>\n<span class=\"n\">cams</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetCameras</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;name&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;iPad&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Cameras (whose name contains &#39;iPad&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">cams</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetCameraStreams", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetCameraStreams", "kind": "function", "doc": "<p>Returns configuration information for one or more Camera device streams.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>cameraId (str):</strong>  Globally unique identifier of the camera whose streams are to be retrieved.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRStream items that contain camera stream\n  configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any other reason.  </li>\n</ul>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get camera device streams for a designated parent camera id.</span>\n<span class=\"n\">streams</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetCameraStreams</span><span class=\"p\">(</span><span class=\"s2\">&quot;f0f31f69-36a2-46a3-80b6-48e4bf617db8&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Camera Streams (for parent camera id):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">streams</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">cameraId</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetChildSites", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetChildSites", "kind": "function", "doc": "<p>Returns configuration information for one or more Child Sites.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n<li><strong>parentId (str):</strong>  Parent Site identifier to retrieve child site items of, or null to retrieve top level sites.\nDefault is None.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRChildSite items that contain site\n  configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any other reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprfilteroperator</span> <span class=\"kn\">import</span> <span class=\"n\">XPRFilterOperator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get child sites, both enabled and disabled.</span>\n<span class=\"n\">sites</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetChildSites</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** ChildSites (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">sites</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get child sites, enabled only.</span>\n<span class=\"n\">sites</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetChildSites</span><span class=\"p\">(</span><span class=\"kc\">False</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** ChildSites (Enabled only):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">sites</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get child sites, whose displayName contains &#39;WIN10VM&#39;.</span>\n<span class=\"n\">sites</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetChildSites</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;displayName&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;WIN10VM&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** ChildSites (whose displayName contains &#39;WIN10VM&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">sites</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get child sites, whose name contains &#39;WIN10&#39;.</span>\n<span class=\"n\">sites</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetChildSites</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;name&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;WIN10&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** ChildSites (whose name contains &#39;WIN10&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">sites</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get child sites for a designated parent site id.</span>\n<span class=\"n\">sites</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetChildSites</span><span class=\"p\">(</span><span class=\"n\">parentId</span><span class=\"o\">=</span><span class=\"s2\">&quot;f7587456-97e2-5e94-808f-8756a8a7c926&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** ChildSites (child sites of parent site id):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">sites</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">parentId</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetEventTypeGroups", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetEventTypeGroups", "kind": "function", "doc": "<p>Returns configuration information for one or more EventTypeGroups.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPREventTypeGroup items that contain EventType group \n  configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any other reason.  </li>\n</ul>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get event type groups.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetEventTypeGroups</span><span class=\"p\">()</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** EventTypeGroups:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetEventTypes", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetEventTypes", "kind": "function", "doc": "<p>Returns configuration information for one or more EventType items.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPREventType items that contain EventType \n  configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any other reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprfilteroperator</span> <span class=\"kn\">import</span> <span class=\"n\">XPRFilterOperator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get event types, both enabled and disabled.</span>\n<span class=\"n\">evntyps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetEventTypes</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** EventTypes (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">evntyps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get event types, enabled only.</span>\n<span class=\"n\">evntyps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetEventTypes</span><span class=\"p\">(</span><span class=\"kc\">False</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** EventTypes (Enabled only):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">evntyps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get event types, whose displayName contains &#39;Fire&#39;.</span>\n<span class=\"n\">evntyps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetEventTypes</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;displayName&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Fire&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** EventTypes (whose displayName contains &#39;Fire&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">evntyps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get event types, whose generatorType contains &#39;hardware&#39;.</span>\n<span class=\"n\">evntyps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetEventTypes</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;generatorType&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;hardware&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** EventTypes (whose generatorType contains &#39;hardware&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">evntyps</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetGenericEventDataSources", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetGenericEventDataSources", "kind": "function", "doc": "<p>Returns configuration information for one or more Generic Event DataSource items.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRGenericEventDataSource items that contain GenericEventDataSource \n  configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any other reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprfilteroperator</span> <span class=\"kn\">import</span> <span class=\"n\">XPRFilterOperator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get Generic Event DataSources, both enabled and disabled.</span>\n<span class=\"n\">datsrc</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetGenericEventDataSources</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** GenericEventDataSources (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">datsrc</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get Generic Event DataSources, enabled only.</span>\n<span class=\"n\">datsrc</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetGenericEventDataSources</span><span class=\"p\">(</span><span class=\"kc\">False</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** GenericEventDataSources (Enabled only):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">datsrc</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get Generic Event DataSources, whose displayName contains &#39;my&#39;.</span>\n<span class=\"n\">datsrc</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetGenericEventDataSources</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;displayName&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;my&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** GenericEventDataSources (whose displayName contains &#39;my&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">datsrc</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get Generic Event DataSources, whose name contains &#39;my&#39;.</span>\n<span class=\"n\">datsrc</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetGenericEventDataSources</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;name&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;my&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** GenericEventDataSources (whose name contains &#39;my&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">datsrc</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetGenericEvents", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetGenericEvents", "kind": "function", "doc": "<p>Returns configuration information for one or more Generic Event items.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRGenericEvent items that contain GenericEvent \n  configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any other reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprfilteroperator</span> <span class=\"kn\">import</span> <span class=\"n\">XPRFilterOperator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get generic events, both enabled and disabled.</span>\n<span class=\"n\">evnts</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetGenericEvents</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** GenericEvents (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">evnts</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get generic events, enabled only.</span>\n<span class=\"n\">evnts</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetGenericEvents</span><span class=\"p\">(</span><span class=\"kc\">False</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** GenericEvents (Enabled only):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">evnts</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get generic events, whose displayName contains &#39;my&#39;.</span>\n<span class=\"n\">evnts</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetGenericEvents</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;displayName&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;my&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** GenericEvents (whose displayName contains &#39;my&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">evnts</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get generic events, whose name contains &#39;my&#39;.</span>\n<span class=\"n\">evnts</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetGenericEvents</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;name&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;my&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** GenericEvents (whose name contains &#39;my&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">evnts</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetHardware", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetHardware", "kind": "function", "doc": "<p>Returns configuration information for one or more Hardware devices.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRHardware items that contain hardware\n  configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprfilteroperator</span> <span class=\"kn\">import</span> <span class=\"n\">XPRFilterOperator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get hardware, both enabled and disabled.</span>\n<span class=\"n\">hdwrs</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetHardware</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Hardware (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">hdwrs</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get hardware, enabled only.</span>\n<span class=\"n\">hdwrs</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetHardware</span><span class=\"p\">(</span><span class=\"kc\">False</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Hardware (Enabled only):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">hdwrs</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get hardware, whose model contains &#39;Universal1ChAdv&#39;.</span>\n<span class=\"n\">hdwrs</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetHardware</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;model&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Universal1ChAdv&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Hardware (whose model contains &#39;Universal1ChAdv&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">hdwrs</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get hardware, whose name contains &#39;iPad&#39;.</span>\n<span class=\"n\">hdwrs</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetHardware</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;name&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;iPad&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Hardware (whose name contains &#39;iPad&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">hdwrs</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetInputEventGroups", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetInputEventGroups", "kind": "function", "doc": "<p>Returns configuration information for one or more InputEventGroups.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n<li><strong>parentId (str):</strong>  Parent Group identifier to retrieve child group items of, or null to retrieve top level groups.\nDefault is None.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRDeviceGroup items that contain device group\n  configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any other reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprfilteroperator</span> <span class=\"kn\">import</span> <span class=\"n\">XPRFilterOperator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get inputevent device groups, both enabled and disabled.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetInputEventGroups</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** InputEventGroups (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get inputevent device groups, enabled only.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetInputEventGroups</span><span class=\"p\">(</span><span class=\"kc\">False</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** InputEventGroups (Enabled only):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get inputevent device groups, whose displayName contains &#39;group&#39;.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetInputEventGroups</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;displayName&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;group&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** InputEventGroups (whose displayName contains &#39;group&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get inputevent device groups, whose name contains &#39;group&#39;.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetInputEventGroups</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;name&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;group&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** InputEventGroups (whose name contains &#39;group&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get inputevent device child groups for a designated parent group id.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetInputEventGroups</span><span class=\"p\">(</span><span class=\"n\">parentId</span><span class=\"o\">=</span><span class=\"s2\">&quot;e70188f7-9ae3-4e98-865f-512da8a4c831&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** InputEventGroups (child groups of parent group id):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">parentId</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetInputEvents", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetInputEvents", "kind": "function", "doc": "<p>Returns configuration information for one or more InputEvent devices.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRInputEvent items that contain input event\n  configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprfilteroperator</span> <span class=\"kn\">import</span> <span class=\"n\">XPRFilterOperator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get inputevent devices, both enabled and disabled.</span>\n<span class=\"n\">inps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetInputEvents</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** InputEvents (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">inps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get inputevent devices, enabled only.</span>\n<span class=\"n\">inps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetInputEvents</span><span class=\"p\">(</span><span class=\"kc\">False</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** InputEvents (Enabled only):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">inps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># sort results by name, descending.</span>\n<span class=\"n\">inps</span><span class=\"o\">.</span><span class=\"n\">sort</span><span class=\"p\">(</span><span class=\"n\">reverse</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** InputEvents (Collection Sorted by: Name, descending):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">inps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># sort results by description, ascending.</span>\n<span class=\"n\">inps</span><span class=\"o\">.</span><span class=\"n\">sort</span><span class=\"p\">(</span><span class=\"n\">key</span><span class=\"o\">=</span><span class=\"k\">lambda</span> <span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"n\">x</span><span class=\"o\">.</span><span class=\"n\">Description</span> <span class=\"ow\">or</span> <span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** InputEvents (Collection Sorted by: Description, ascending):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">inps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get inputevent devices, whose displayName property contains &#39;Office&#39;.</span>\n<span class=\"n\">inps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetInputEvents</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;displayName&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Office&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** InputEvents (whose displayName contains &#39;Office&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">inps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get inputevent devices, whose name property contains &#39;iPad&#39;.</span>\n<span class=\"n\">inps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetInputEvents</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;name&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;iPad&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** InputEvents (whose name contains &#39;iPad&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">inps</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetLicenseDetails", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetLicenseDetails", "kind": "function", "doc": "<p>Returns an Detail of all product license information.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRLicenseDetail items that contain license detail\n  configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprfilteroperator</span> <span class=\"kn\">import</span> <span class=\"n\">XPRFilterOperator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get license details.</span>\n<span class=\"n\">licdtls</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetLicenseDetails</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** License Details (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">licdtls</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get license details, whose activated count is greater than 2.</span>\n<span class=\"n\">licdtls</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetLicenseDetails</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;activated&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">gt</span><span class=\"p\">,</span> <span class=\"s2\">&quot;2&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** License Details (whose activated count is greater than 2):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">licdtls</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get license details, whose activated count is less than 1.</span>\n<span class=\"n\">licdtls</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetLicenseDetails</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;activated&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">lt</span><span class=\"p\">,</span> <span class=\"s2\">&quot;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** License Details (whose activated count is less than 1):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">licdtls</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetLicenseInformations", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetLicenseInformations", "kind": "function", "doc": "<p>Returns configuration information for one or more LicenseInformations.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRLicenseInformation items that contain license\n  information configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get license informations.</span>\n<span class=\"n\">licnfos</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetLicenseInformations</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** License Information (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">licnfos</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetLicenseOverviews", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetLicenseOverviews", "kind": "function", "doc": "<p>Returns an overview of all product license information.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRLicenseOverview items that contain license\n  overview configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get license overviews.</span>\n<span class=\"n\">licovrs</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetLicenseOverviews</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** License Overviews (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">licovrs</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetLicenseInstalledProducts", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetLicenseInstalledProducts", "kind": "function", "doc": "<p>Returns detailed information of all installed product licenses.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRLicenseProduct items that contain license\n  product configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get license installed products.</span>\n<span class=\"n\">licprds</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetLicenseInstalledProducts</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** License Installed Products (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">licprds</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetMetadataGroups", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetMetadataGroups", "kind": "function", "doc": "<p>Returns configuration information for one or more MetadataGroups.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n<li><strong>parentId (str):</strong>  Parent Group identifier to retrieve child group items of, or null to retrieve top level groups.\nDefault is None.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRDeviceGroup items that contain device group\n  configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprfilteroperator</span> <span class=\"kn\">import</span> <span class=\"n\">XPRFilterOperator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get metadata device groups, both enabled and disabled.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetMetadataGroups</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** MetadataGroups (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get metadata device groups, enabled only.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetMetadataGroups</span><span class=\"p\">(</span><span class=\"kc\">False</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** MetadataGroups (Enabled only):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get metadata device groups, whose displayName contains &#39;group&#39;.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetMetadataGroups</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;displayName&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;group&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** MetadataGroups (whose displayName contains &#39;group&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get metadata device groups, whose name contains &#39;group&#39;.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetMetadataGroups</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;name&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;group&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** MetadataGroups (whose name contains &#39;group&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get metadata device child groups for a designated parent group id.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetMetadataGroups</span><span class=\"p\">(</span><span class=\"n\">parentId</span><span class=\"o\">=</span><span class=\"s2\">&quot;cede51f0-ae1e-44f6-ad66-461cb0f9c71c&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** MetadataGroups (child groups of parent group id):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">parentId</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetMetadatas", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetMetadatas", "kind": "function", "doc": "<p>Returns configuration information for one or more Metadata devices.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRMetadata items that contain metadata\n  configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprfilteroperator</span> <span class=\"kn\">import</span> <span class=\"n\">XPRFilterOperator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get metadata devices, both enabled and disabled.</span>\n<span class=\"n\">metas</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetMetadatas</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Metadatas (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">metas</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get metadata devices, enabled only.</span>\n<span class=\"n\">metas</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetMetadatas</span><span class=\"p\">(</span><span class=\"kc\">False</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Metadatas (Enabled only):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">metas</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># sort results by name, descending.</span>\n<span class=\"n\">metas</span><span class=\"o\">.</span><span class=\"n\">sort</span><span class=\"p\">(</span><span class=\"n\">reverse</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Metadatas (Collection Sorted by: Name, descending):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">metas</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># sort results by description, ascending.</span>\n<span class=\"n\">metas</span><span class=\"o\">.</span><span class=\"n\">sort</span><span class=\"p\">(</span><span class=\"n\">key</span><span class=\"o\">=</span><span class=\"k\">lambda</span> <span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"n\">x</span><span class=\"o\">.</span><span class=\"n\">Description</span> <span class=\"ow\">or</span> <span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Metadatas (Collection Sorted by: Description, ascending):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">metas</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get metadata devices, whose displayName property contains &#39;Office&#39;.</span>\n<span class=\"n\">metas</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetMetadatas</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;displayName&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Office&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Metadatas (whose displayName contains &#39;Office&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">metas</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get metadata devices, whose name property contains &#39;iPad&#39;.</span>\n<span class=\"n\">metas</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetMetadatas</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;name&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;iPad&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Metadatas (whose name contains &#39;iPad&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">metas</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetMicrophoneGroups", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetMicrophoneGroups", "kind": "function", "doc": "<p>Returns configuration information for one or more MicrophoneGroups.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n<li><strong>parentId (str):</strong>  Parent Group identifier to retrieve child group items of, or null to retrieve top level groups.\nDefault is None.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRDeviceGroup items that contain device group\n  configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprfilteroperator</span> <span class=\"kn\">import</span> <span class=\"n\">XPRFilterOperator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get microphone device groups, both enabled and disabled.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetMicrophoneGroups</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** MicrophoneGroups (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get microphone device groups, enabled only.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetMicrophoneGroups</span><span class=\"p\">(</span><span class=\"kc\">False</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** MicrophoneGroups (Enabled only):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get microphone device groups, whose displayName contains &#39;group&#39;.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetMicrophoneGroups</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;displayName&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;group&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** MicrophoneGroups (whose displayName contains &#39;group&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get microphone device groups, whose name contains &#39;group&#39;.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetMicrophoneGroups</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;name&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;group&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** MicrophoneGroups (whose name contains &#39;group&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get microphone device child groups for a designated parent group id.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetMicrophoneGroups</span><span class=\"p\">(</span><span class=\"n\">parentId</span><span class=\"o\">=</span><span class=\"s2\">&quot;1ad9dc76-2a40-44f3-9cb3-bfa7236e80e6&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** MicrophoneGroups (child groups of parent group id):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">parentId</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetMicrophones", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetMicrophones", "kind": "function", "doc": "<p>Returns configuration information for one or more Microphone devices.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRMicrophone items that contain microphone\n  configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprfilteroperator</span> <span class=\"kn\">import</span> <span class=\"n\">XPRFilterOperator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get microphone devices, both enabled and disabled.</span>\n<span class=\"n\">mics</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetMicrophones</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Microphones (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">mics</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get microphone devices, enabled only.</span>\n<span class=\"n\">mics</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetMicrophones</span><span class=\"p\">(</span><span class=\"kc\">False</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Microphones (Enabled only):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">mics</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># sort results by name, descending.</span>\n<span class=\"n\">mics</span><span class=\"o\">.</span><span class=\"n\">sort</span><span class=\"p\">(</span><span class=\"n\">reverse</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Microphones (Collection Sorted by: Name, descending):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">mics</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># sort results by description, ascending.</span>\n<span class=\"n\">mics</span><span class=\"o\">.</span><span class=\"n\">sort</span><span class=\"p\">(</span><span class=\"n\">key</span><span class=\"o\">=</span><span class=\"k\">lambda</span> <span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"n\">x</span><span class=\"o\">.</span><span class=\"n\">Description</span> <span class=\"ow\">or</span> <span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Microphones (Collection Sorted by: Description, ascending):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">mics</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get microphone devices, whose displayName property contains &#39;Office&#39;.</span>\n<span class=\"n\">mics</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetMicrophones</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;displayName&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Office&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Microphones (whose displayName contains &#39;Office&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">mics</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get microphone devices, whose name property contains &#39;iPad&#39;.</span>\n<span class=\"n\">mics</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetMicrophones</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;name&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;iPad&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Microphones (whose name contains &#39;iPad&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">mics</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetOutputGroups", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetOutputGroups", "kind": "function", "doc": "<p>Returns configuration information for one or more OutputGroups.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n<li><strong>parentId (str):</strong>  Parent Group identifier to retrieve child group items of, or null to retrieve top level groups.\nDefault is None.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRDeviceGroup items that contain device group\n  configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprfilteroperator</span> <span class=\"kn\">import</span> <span class=\"n\">XPRFilterOperator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get output device groups, both enabled and disabled.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetOutputGroups</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** OutputGroups (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get output device groups, enabled only.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetOutputGroups</span><span class=\"p\">(</span><span class=\"kc\">False</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** OutputGroups (Enabled only):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get output device groups, whose displayName contains &#39;group&#39;.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetOutputGroups</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;displayName&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;group&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** OutputGroups (whose displayName contains &#39;group&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get output device groups, whose name contains &#39;group&#39;.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetOutputGroups</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;name&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;group&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** OutputGroups (whose name contains &#39;group&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get output device child groups for a designated parent group id.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetOutputGroups</span><span class=\"p\">(</span><span class=\"n\">parentId</span><span class=\"o\">=</span><span class=\"s2\">&quot;bab66f49-aa6d-472b-afd8-be5f9a649bfc&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** OutputGroups (child groups of parent group id):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">parentId</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetOutputs", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetOutputs", "kind": "function", "doc": "<p>Returns configuration information for one or more Output devices.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPROutput items that contain output\n  configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprfilteroperator</span> <span class=\"kn\">import</span> <span class=\"n\">XPRFilterOperator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get output devices, both enabled and disabled.</span>\n<span class=\"n\">outs</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetOutputs</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Outputs (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">outs</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get output devices, enabled only.</span>\n<span class=\"n\">outs</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetOutputs</span><span class=\"p\">(</span><span class=\"kc\">False</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Outputs (Enabled only):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">outs</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># sort results by name, descending.</span>\n<span class=\"n\">outs</span><span class=\"o\">.</span><span class=\"n\">sort</span><span class=\"p\">(</span><span class=\"n\">reverse</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Outputs (Collection Sorted by: Name, descending):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">outs</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># sort results by description, ascending.</span>\n<span class=\"n\">outs</span><span class=\"o\">.</span><span class=\"n\">sort</span><span class=\"p\">(</span><span class=\"n\">key</span><span class=\"o\">=</span><span class=\"k\">lambda</span> <span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"n\">x</span><span class=\"o\">.</span><span class=\"n\">Description</span> <span class=\"ow\">or</span> <span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Outputs (Collection Sorted by: Description, ascending):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">outs</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get output devices, whose displayName property contains &#39;Office&#39;.</span>\n<span class=\"n\">outs</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetOutputs</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;displayName&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Office&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Outputs (whose displayName contains &#39;Office&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">outs</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get output devices, whose name property contains &#39;iPad&#39;.</span>\n<span class=\"n\">outs</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetOutputs</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;name&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;iPad&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Outputs (whose name contains &#39;iPad&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">outs</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetParentTypeId", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetParentTypeId", "kind": "function", "doc": "<p>Parses a JSON response dictionary for the parent key name, type name, and id value.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>oDict (dict):</strong>  A dictionary object that represents the JSON response.</li>\n<li><strong>parentTypeName (str):</strong>  The parent key name that contains a type and id sub-key (e.g. \"recordingStorage\", etc).</li>\n<li><strong>typeName (str):</strong>  The type name that contains an id value (e.g. \"storages\", etc).</li>\n<li><strong>serviceMethodName (str):</strong>  Name of the service method that was called. <br />\nExample: \"GetCameras\", etc.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The parent type id value if present; otherwise, None.</p>\n</blockquote>\n\n<p>This can be used for any methods that return a type id within a \"parent\" response.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">oDict</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">parentTypeName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">typeName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">serviceMethodName</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetRecordingServers", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetRecordingServers", "kind": "function", "doc": "<p>Returns configuration information for one or more Recording Servers.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRRecordingServer items that contain recording\n  server configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprfilteroperator</span> <span class=\"kn\">import</span> <span class=\"n\">XPRFilterOperator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get recording servers, both enabled and disabled.</span>\n<span class=\"n\">recsrvs</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetRecordingServers</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** RecordingServers (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">recsrvs</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get recording servers, enabled only.</span>\n<span class=\"n\">recsrvs</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetRecordingServers</span><span class=\"p\">(</span><span class=\"kc\">False</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** RecordingServers (Enabled only):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">recsrvs</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get recording servers, whose displayName contains &#39;WIN10VM&#39;.</span>\n<span class=\"n\">recsrvs</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetRecordingServers</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;displayName&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;WIN10VM&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** RecordingServers (whose displayName contains &#39;WIN10VM&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">recsrvs</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get recording servers, whose name contains &#39;WIN10&#39;.</span>\n<span class=\"n\">recsrvs</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetRecordingServers</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;name&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;WIN10&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** RecordingServers (whose name contains &#39;WIN10&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">recsrvs</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetRelationParentTypeId", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetRelationParentTypeId", "kind": "function", "doc": "<p>Parses a JSON response dictionary for the related key name, type name, and id value.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>oDict (dict):</strong>  A dictionary object that represents the JSON response.</li>\n<li><strong>relationKeyName (str):</strong>  The relation key name that contains a type and id sub-key (e.g. \"parent\", \"self\", etc).</li>\n<li><strong>typeName (str):</strong>  The type name that contains an id value (e.g. \"hardware\", \"cameras\", etc).</li>\n<li><strong>serviceMethodName (str):</strong>  Name of the service method that was called. <br />\nExample: \"GetCameras\", etc.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The related type id value if present; otherwise, None.</p>\n</blockquote>\n\n<p>This can be used for any methods that return a type id within a \"relations\" response.</p>\n\n<h6 id=\"for-example\">For example:</h6>\n\n<blockquote>\n  <p>\"relations\": {\n    \"parent\": {\n        \"type\": \"hardware\",\n        \"id\": \"08cf6a24-c7ab-4b50-80e0-5a56cf624c5f\"\n    },\n  }</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">oDict</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">relationKeyName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">typeName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">serviceMethodName</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetRelationParentTypeIdHardware", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetRelationParentTypeIdHardware", "kind": "function", "doc": "<p>Parses a JSON response dictionary for the related parent hardware type id value.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>oDict (dict):</strong>  A dictionary object that represents the JSON response.</li>\n<li><strong>serviceMethodName (str):</strong>  Name of the service method that was called. <br />\nExample: \"GetCameras\", etc.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The related parent hardware type id value if present; otherwise, None.</p>\n</blockquote>\n\n<p>This can be used for any methods that return a hardware id within a \"relations\" response.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">oDict</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>, </span><span class=\"param\"><span class=\"n\">serviceMethodName</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetSiteOwner", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetSiteOwner", "kind": "function", "doc": "<p>Returns site owner information for the specified site id.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>siteId (str):</strong>  Site identifier to retrieve ownership information for.  This can be a main site id, or\na child site id. <br />\nDefault is None, which will retrieve ownership information for the main site.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRSiteOwner class that contains Site ownership details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any reason.  </li>\n</ul>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprsiteowner</span> <span class=\"kn\">import</span> <span class=\"n\">XPRSiteOwner</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get site owner.</span>\n<span class=\"n\">owner</span><span class=\"p\">:</span><span class=\"n\">XPRSiteOwner</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetSiteOwner</span><span class=\"p\">()</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Site Owner:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">owner</span><span class=\"p\">))</span>\n\n<span class=\"n\">owner</span><span class=\"p\">:</span><span class=\"n\">XPRSiteOwner</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetSiteOwner</span><span class=\"p\">(</span><span class=\"s2\">&quot;fc9e48ce-a39b-4327-8b92-32b012688944&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Site Owner (by id, Management Server):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">owner</span><span class=\"p\">))</span>\n\n<span class=\"n\">owner</span><span class=\"p\">:</span><span class=\"n\">XPRSiteOwner</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetSiteOwner</span><span class=\"p\">(</span><span class=\"s2\">&quot;19f94d50-b5ad-4e90-8b3f-9928bb60f9f2&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Site Owner (by id, Recording Server):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">owner</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">siteId</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprsiteowner</span><span class=\"o\">.</span><span class=\"n\">XPRSiteOwner</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetSites", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetSites", "kind": "function", "doc": "<p>Returns configuration information for one or more Sites.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRSite items that contain site\n  configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprfilteroperator</span> <span class=\"kn\">import</span> <span class=\"n\">XPRFilterOperator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get sites, both enabled and disabled.</span>\n<span class=\"n\">sites</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetSites</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Sites (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">sites</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get sites, enabled only.</span>\n<span class=\"n\">sites</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetSites</span><span class=\"p\">(</span><span class=\"kc\">False</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Sites (Enabled only):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">sites</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get sites, whose displayName contains &#39;WIN10VM&#39;.</span>\n<span class=\"n\">sites</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetSites</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;displayName&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;WIN10VM&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Sites (whose displayName contains &#39;WIN10VM&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">sites</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get sites, whose name contains &#39;WIN10&#39;.</span>\n<span class=\"n\">sites</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetSites</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;name&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;WIN10&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Sites (whose name contains &#39;WIN10&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">sites</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetSpeakerGroups", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetSpeakerGroups", "kind": "function", "doc": "<p>Returns configuration information for one or more SpeakerGroups.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n<li><strong>parentId (str):</strong>  Parent Group identifier to retrieve child group items of, or null to retrieve top level groups.\nDefault is None.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRDeviceGroup items that contain device group\n  configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprfilteroperator</span> <span class=\"kn\">import</span> <span class=\"n\">XPRFilterOperator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get speaker device groups, both enabled and disabled.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetSpeakerGroups</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** SpeakerGroups (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get speaker device groups, enabled only.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetSpeakerGroups</span><span class=\"p\">(</span><span class=\"kc\">False</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** SpeakerGroups (Enabled only):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get speaker device groups, whose displayName contains &#39;indoor&#39;.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetSpeakerGroups</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;displayName&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;indoor&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** SpeakerGroups (whose displayName contains &#39;indoor&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get speaker device groups, whose name contains &#39;indoor&#39;.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetSpeakerGroups</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;name&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;indoor&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** SpeakerGroups (whose name contains &#39;indoor&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get speaker device child groups for a designated parent group id.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetSpeakerGroups</span><span class=\"p\">(</span><span class=\"n\">parentId</span><span class=\"o\">=</span><span class=\"s2\">&quot;4325fb90-ad75-4a03-b512-87a11f42b6e0&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** SpeakerGroups (child groups of parent group id):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">parentId</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetSpeakers", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetSpeakers", "kind": "function", "doc": "<p>Returns configuration information for one or more Speaker devices.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRSpeaker items that contain speaker\n  configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprfilteroperator</span> <span class=\"kn\">import</span> <span class=\"n\">XPRFilterOperator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get speaker devices, both enabled and disabled.</span>\n<span class=\"n\">spkrs</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetSpeakers</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Speakers (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">spkrs</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get speaker devices, enabled only.</span>\n<span class=\"n\">spkrs</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetSpeakers</span><span class=\"p\">(</span><span class=\"kc\">False</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Speakers (Enabled only):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">spkrs</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># sort results by name, descending.</span>\n<span class=\"n\">spkrs</span><span class=\"o\">.</span><span class=\"n\">sort</span><span class=\"p\">(</span><span class=\"n\">reverse</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Speakers (Collection Sorted by: Name, descending):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">spkrs</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># sort results by description, ascending.</span>\n<span class=\"n\">spkrs</span><span class=\"o\">.</span><span class=\"n\">sort</span><span class=\"p\">(</span><span class=\"n\">key</span><span class=\"o\">=</span><span class=\"k\">lambda</span> <span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"n\">x</span><span class=\"o\">.</span><span class=\"n\">Description</span> <span class=\"ow\">or</span> <span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Speakers (Collection Sorted by: Description, ascending):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">spkrs</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get speaker devices, whose displayName property contains &#39;Office&#39;.</span>\n<span class=\"n\">spkrs</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetSpeakers</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;displayName&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Office&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Speakers (whose displayName contains &#39;Office&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">spkrs</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get speaker devices, whose name property contains &#39;iPad&#39;.</span>\n<span class=\"n\">spkrs</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetSpeakers</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;name&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;iPad&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Speakers (whose name contains &#39;iPad&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">spkrs</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetStateGroups", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetStateGroups", "kind": "function", "doc": "<p>Returns configuration information for one or more StateGroup items.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRStateGroup items that contain StateGroup \n  configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any other reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprfilteroperator</span> <span class=\"kn\">import</span> <span class=\"n\">XPRFilterOperator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get StateGroups, both enabled and disabled.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetStateGroups</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** StateGroups (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get StateGroups, enabled only.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetStateGroups</span><span class=\"p\">(</span><span class=\"kc\">False</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** StateGroups (Enabled only):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get StateGroups, whose displayName contains &#39;disk&#39;.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetStateGroups</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;displayName&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;disk&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** StateGroups (whose displayName contains &#39;disk&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get StateGroups, whose name contains &#39;disk&#39;.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetStateGroups</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;name&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;disk&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** StateGroups (whose name contains &#39;disk&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservice.XPRRestService.GetUserDefinedEvents", "modulename": "milestonexprotectrestpython.xprrestservice", "qualname": "XPRRestService.GetUserDefinedEvents", "kind": "function", "doc": "<p>Returns configuration information for one or more UserDefinedEvent items.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>includeDisabled (bool):</strong>  True to include disabled items in the returned information; <br />\notherwise False to return only enabled items. <br />\nDefault is True.</li>\n<li><strong>filterName (str):</strong>  Used to filter data returned using a property name (e.g. \"name\", \"description\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.\nDefault value is None.</li>\n<li><strong>filterOperator (str):</strong>  Type of filtering to perform (e.g. contains, equals, lt, etc).  </li>\n<li><strong>filterValue (str):</strong>  Value to search for if filtering returned data (e.g. \"MyName\", \"MyDescription\", etc). <br />\nThe value will be url-encoded, as it is used as part of a querystring.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRCollection class of XPRUserDefinedEvent items that contain UserDefinedEvent \n  configuration details.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any other reason.  </li>\n</ul>\n\n<p>If any of the filter arguments (filterName, filterOperator, filterValue) are specified, then ALL \nof the filter arguments are required.  A filter will not be applied if ANY of the filter arguments \nare missing.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprcollection</span> <span class=\"kn\">import</span> <span class=\"n\">XPRCollection</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprfilteroperator</span> <span class=\"kn\">import</span> <span class=\"n\">XPRFilterOperator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get user-defined events, both enabled and disabled.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetUserDefinedEvents</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** UserDefinedEvents (Enabled and Disabled):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get user-defined events, enabled only.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetUserDefinedEvents</span><span class=\"p\">(</span><span class=\"kc\">False</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** UserDefinedEvents (Enabled only):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get user-defined events, whose displayName contains &#39;audio&#39;.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetUserDefinedEvents</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;displayName&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;audio&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** UserDefinedEvents (whose displayName contains &#39;audio&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n\n<span class=\"c1\"># get user-defined events, whose name contains &#39;recording&#39;.</span>\n<span class=\"n\">grps</span><span class=\"p\">:</span><span class=\"n\">XPRCollection</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">GetUserDefinedEvents</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;name&quot;</span><span class=\"p\">,</span> <span class=\"n\">XPRFilterOperator</span><span class=\"o\">.</span><span class=\"n\">contains</span><span class=\"p\">,</span> <span class=\"s2\">&quot;recording&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** UserDefinedEvents (whose name contains &#39;recording&#39;):</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">grps</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">includeDisabled</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">filterName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterOperator</span><span class=\"p\">:</span> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprfilteroperator</span><span class=\"o\">.</span><span class=\"n\">XPRFilterOperator</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filterValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprcollection</span><span class=\"o\">.</span><span class=\"n\">XPRCollection</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservicebase", "modulename": "milestonexprotectrestpython.xprrestservicebase", "kind": "module", "doc": "<p>Module: xprrestservicebase.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprrestservicebase.XPRRestServiceBase", "modulename": "milestonexprotectrestpython.xprrestservicebase", "qualname": "XPRRestServiceBase", "kind": "class", "doc": "<p>The XPRRestServiceBase class provides properties common to all XProtect REST services.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "milestonexprotectrestpython.xprrestservicebase.XPRRestServiceBase.__init__", "modulename": "milestonexprotectrestpython.xprrestservicebase", "qualname": "XPRRestServiceBase.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>TypeError:</strong>  The loginInfo argument is not of type XPRLoginInfo.</li>\n<li><strong>Exception:</strong>  The method fails for any other reason.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xprrestservicebase.XPRRestServiceBase.ApiGatewayUrlPrefix", "modulename": "milestonexprotectrestpython.xprrestservicebase", "qualname": "XPRRestServiceBase.ApiGatewayUrlPrefix", "kind": "variable", "doc": "<p>URL prefix of the XProtect REST API Gateway server.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ApiGatewayUrlPrefix property value.</p>\n</blockquote>\n\n<p>This url prefix is used to call various REST API services that are hosted by the \nXProtect API Gateway.  </p>\n\n<p>It should only contain the server name (and port number if required) portion of\nthe API Gateway server (e.g. \"https://xprotectapigateway.example.com\", or\n\"https://xprotectapigateway.example.com:443\") url prefix.  </p>\n\n<p>It should NOT contain any of the API Gateway REST version information (e.g. \n\"/api/rest/v1/\") details.</p>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprrestservicebase.XPRRestServiceBase.IsAutoTokenRenewalEnabled", "modulename": "milestonexprotectrestpython.xprrestservicebase", "qualname": "XPRRestServiceBase.IsAutoTokenRenewalEnabled", "kind": "variable", "doc": "<p>Enables / disables the automatic token renewal check logic check that is\nmade prior to making a call to the XProtect REST service.  </p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The IsAutoTokenRenewalEnabled property value.        </p>\n</blockquote>\n\n<p>If True, the LoginInfo.ExpireTime value is checked to see if the XProtect token is\nwithin 1 minute of expiring PRIOR to processing the desired API method (e.g. GetCameras, etc).\nIf the token is about to expire, then it will be automatically renewed via a call to the XProtect\nREST Login method (e.g. LoginBasicUser, LoginBasicWindows) that was previously used to login and\nestablish the authentication token.  The desired API method (e.g. GetCameras, etc) is then\nprocessed as requested.</p>\n\n<p>If False, the desired API method (e.g. GetCameras, etc) is processed normally, though it will\nprobably fail with a XPRLoginTokenExpiredException due to an expired token!</p>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprrestservicebase.XPRRestServiceBase.IsSslVerifyEnabled", "modulename": "milestonexprotectrestpython.xprrestservicebase", "qualname": "XPRRestServiceBase.IsSslVerifyEnabled", "kind": "variable", "doc": "<p>SSL Verify flag used on all request GET / POST method calls.\nDefault Value is True.        </p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The IsSslVerifyEnabled property value.        </p>\n</blockquote>\n\n<p>This setting will be added to all request GET / POST calls made to the XProtect REST services.</p>\n\n<p>If False, it will ignore SSL Certificate warnings (e.g. certificate expired, self-signed certificate, etc).\nIt also makes a call to \"urllib3.disable_warnings(category=InsecureRequestWarning)\" to suppress\nterminal messages.</p>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprrestservicebase.XPRRestServiceBase.LoginInfo", "modulename": "milestonexprotectrestpython.xprrestservicebase", "qualname": "XPRRestServiceBase.LoginInfo", "kind": "variable", "doc": "<p>LoginInfo object that was specified when the class was initialized, or when\na Login method (e.g. LoginBasicUser, LoginWindowsUser) was called successfully.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The LoginInfo property value.</p>\n</blockquote>\n\n<p>This property is read-only.</p>\n", "annotation": ": milestonexprotectrestpython.xprlogininfo.XPRLoginInfo"}, {"fullname": "milestonexprotectrestpython.xprrestservicebase.XPRRestServiceBase.AddDictKeyValueArrayStrings", "modulename": "milestonexprotectrestpython.xprrestservicebase", "qualname": "XPRRestServiceBase.AddDictKeyValueArrayStrings", "kind": "function", "doc": "<p>Checks a dictionary for the specified key name, ensures that it defines a list of strings, \nand then appends them to the arrayListStrings argument list; otherwise, no values are appended\nto the arrayListStrings argument.        </p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>oDict (dict):</strong>  Dictionary to check for the specified key name.</li>\n<li><strong>keyName (str):</strong>  Key name to check for.</li>\n<li><strong>arrayListStrings (str):</strong>  An array list of strings to append found values to.</li>\n<li><strong>raiseExceptionIfNotFound (bool):</strong>  True to raise an Exception if the specified keyName is not found in the dictionary; <br />\notherwise, False. <br />\nDefault value: False</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">oDict</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">keyName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">arrayListStrings</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">raiseExceptionIfNotFound</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservicebase.XPRRestServiceBase.CheckResponseStatusCode", "modulename": "milestonexprotectrestpython.xprrestservicebase", "qualname": "XPRRestServiceBase.CheckResponseStatusCode", "kind": "function", "doc": "<p>Check the REST service HTTP response code for error values (4xx, 5xx, etc).\nAn XPRRestServiceException will be thrown if the HTTP status code does not\nequal 200 or 201.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>serviceMethodName (str):</strong>  Name of the XProtect REST service method that was called.\nExample: \"GetCameras\"</li>\n<li><strong>req (Request):</strong>  HTTP request object that contains the REST server request.</li>\n<li><strong>resp (Response):</strong>  HTTP response object that contains the REST server response.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>If HTTP status is successful (e.g. 200, 201) then the JSON response is\n  returned as a dictionary; otherwise, an XPRRestServiceException is raised.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  Raised if the HTTP status returned indicated failue (e.g. 4xx, 5xx, etc).</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">serviceMethodName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">req</span><span class=\"p\">:</span> <span class=\"n\">requests</span><span class=\"o\">.</span><span class=\"n\">models</span><span class=\"o\">.</span><span class=\"n\">Request</span>,</span><span class=\"param\">\t<span class=\"n\">resp</span><span class=\"p\">:</span> <span class=\"n\">requests</span><span class=\"o\">.</span><span class=\"n\">models</span><span class=\"o\">.</span><span class=\"n\">Response</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservicebase.XPRRestServiceBase.RaiseRestServiceException", "modulename": "milestonexprotectrestpython.xprrestservicebase", "qualname": "XPRRestServiceBase.RaiseRestServiceException", "kind": "function", "doc": "<p>Parses XProtect REST services failed HTTP response and raises the XPRRestServiceException\nto indicate the requested call failed.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>serviceMethodName (str):</strong>  Name of the XProtect REST service method that was called.\nExample: \"GetCameras\"</li>\n<li><strong>req (Request):</strong>  HTTP request object that contains the REST server request.</li>\n<li><strong>resp (Response):</strong>  HTTP response object that contains the REST server response.</li>\n<li><strong>oDict (dict):</strong>  JSON response dictionary of the called REST service method.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  Thrown if XProtext REST service error response details were parsed successfully.</li>\n<li><strong>XPRException:</strong>  Thrown if XProtext REST service error response details could not be parsed successfully.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">serviceMethodName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">req</span><span class=\"p\">:</span> <span class=\"n\">requests</span><span class=\"o\">.</span><span class=\"n\">models</span><span class=\"o\">.</span><span class=\"n\">Request</span>,</span><span class=\"param\">\t<span class=\"n\">resp</span><span class=\"p\">:</span> <span class=\"n\">requests</span><span class=\"o\">.</span><span class=\"n\">models</span><span class=\"o\">.</span><span class=\"n\">Response</span>,</span><span class=\"param\">\t<span class=\"n\">oDict</span><span class=\"p\">:</span> <span class=\"nb\">dict</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservicebase.XPRRestServiceBase.DictHasKey", "modulename": "milestonexprotectrestpython.xprrestservicebase", "qualname": "XPRRestServiceBase.DictHasKey", "kind": "function", "doc": "<p>Checks a dictionary for the specified key name.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>oDict (dict):</strong>  Dictionary to check for the specified key name.</li>\n<li><strong>keyName (str):</strong>  Key name to check for.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>True if the specified key name exists in the dictionary; otherwise, False.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">oDict</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>, </span><span class=\"param\"><span class=\"n\">keyName</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservicebase.XPRRestServiceBase.GetDictItems", "modulename": "milestonexprotectrestpython.xprrestservicebase", "qualname": "XPRRestServiceBase.GetDictItems", "kind": "function", "doc": "<p>Checks a dictionary for the specified item key name, and verifies it contains at \nleast one occurance.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>oDict (dict):</strong>  Dictionary to check for the specified collection key and child item key.</li>\n<li><strong>keyNameItem (str):</strong>  Item Key name to check for that contains a child item.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A dictionary of item key names, or an empty dictionary if none were found.</p>\n</blockquote>\n\n<p>This method is useful for parsing collection responses and their underlying item nodes. <br />\nFor example:  </p>\n\n<p><ServiceInfo> <br />\n  <Name /> <br />\n</ServiceInfo> <br />\n<ServiceInfo> <br />\n  <Name /> <br />\n</ServiceInfo></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">oDict</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>, </span><span class=\"param\"><span class=\"n\">keyNameItem</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservicebase.XPRRestServiceBase.GetDictKeyValueBool", "modulename": "milestonexprotectrestpython.xprrestservicebase", "qualname": "XPRRestServiceBase.GetDictKeyValueBool", "kind": "function", "doc": "<p>Checks a dictionary for the specified key name and returns a boolean value if the\nkey exists and its value can successfully be converted to a boolean object;\notherwise the return value is null, or an exception is raised based upon the \nraiseExceptionIfNotFound argument value.</p>\n\n<pre><code>    Checks a dictionary for the specified key name and returns a boolean value if the\n</code></pre>\n\n<p>key exists; otherwise, null is returned.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>oDict (dict):</strong>  Dictionary to check for the specified key name.</li>\n<li><strong>keyName (str):</strong>  Key name to check for.</li>\n<li><strong>raiseExceptionIfNotFound (bool):</strong>  True to raise an Exception if the specified keyName is not found in the dictionary; <br />\notherwise, False. <br />\nDefault value: False  </li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A boolean value if the key exists and its value can successfully be converted to a \n  boolean object; otherwise the return value is null, or an exception is raised based \n  upon the raiseExceptionIfNotFound argument value.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">oDict</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">keyName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">raiseExceptionIfNotFound</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservicebase.XPRRestServiceBase.GetDictKeyValueDateTime", "modulename": "milestonexprotectrestpython.xprrestservicebase", "qualname": "XPRRestServiceBase.GetDictKeyValueDateTime", "kind": "function", "doc": "<p>Checks a dictionary for the specified key name and returns a datetime value if the\nkey exists and its value can successfully be converted to a datetime object;\notherwise the return value is null, or an exception is raised based upon the \nraiseExceptionIfNotFound argument value.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>oDict (dict):</strong>  Dictionary to check for the specified key name.</li>\n<li><strong>keyName (str):</strong>  Key name to check for.</li>\n<li><strong>raiseExceptionIfNotFound (bool):</strong>  True to raise an Exception if the specified keyName is not found in the dictionary; <br />\notherwise, False. <br />\nDefault value: False  </li>\n<li><strong>excludeMicroseconds (bool):</strong>  If True, only the first 19 characters of the date string will be kept - this\nassumes that the datetime string is in \"YYYY-MM-DDTHH:MM:SS\" format. <br />\nDefault value: False  </li>\n<li><strong>excludeTimeZoneInfo (bool):</strong>  If True, then timezone info (tzinfo) is removed from the datetime value. <br />\nThis can prevent \"can't subtract offset-naive and offset-aware datetimes\" exceptions \nwhen comparing datetimes. <br />\nDefault value: True  </li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A datetime value if the key exists and its value can successfully be converted to a \n  datetime object; otherwise the return value is null, or an exception is raised based \n  upon the raiseExceptionIfNotFound argument value.</p>\n</blockquote>\n\n<p>Supported examples for datetime string are:</p>\n\n<ul>\n<li>\"0001-01-01T00:00:00.0000000\"  </li>\n<li>\"2023-07-24T17:12:31.0210000Z\"  </li>\n<li>\"2023-07-24T17:12:31.0210Z\"  </li>\n<li>\"2023-07-24T17:12:31Z\"</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">oDict</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">keyName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">raiseExceptionIfNotFound</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">excludeMicroseconds</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">excludeTimeZoneInfo</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">datetime</span><span class=\"o\">.</span><span class=\"n\">datetime</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservicebase.XPRRestServiceBase.GetDictKeyValueDict", "modulename": "milestonexprotectrestpython.xprrestservicebase", "qualname": "XPRRestServiceBase.GetDictKeyValueDict", "kind": "function", "doc": "<p>Checks a dictionary for the specified key name and returns a dictionary value if the\nkey exists and its value can successfully be converted to a dictionary object;\notherwise the return value is null, or an exception is raised based upon the \nraiseExceptionIfNotFound argument value.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>oDict (dict):</strong>  Dictionary to check for the specified key name.</li>\n<li><strong>keyName (str):</strong>  Key name to check for.</li>\n<li><strong>raiseExceptionIfNotFound (bool):</strong>  True to raise an Exception if the specified keyName is not found in the dictionary; <br />\notherwise, False. <br />\nDefault value: False  </li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A dictionary value if the key exists and its value can successfully be converted to a \n  dictionary object; otherwise the return value is null, or an exception is raised based \n  upon the raiseExceptionIfNotFound argument value.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">oDict</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">keyName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">raiseExceptionIfNotFound</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservicebase.XPRRestServiceBase.GetDictKeyValueFloat", "modulename": "milestonexprotectrestpython.xprrestservicebase", "qualname": "XPRRestServiceBase.GetDictKeyValueFloat", "kind": "function", "doc": "<p>Checks a dictionary for the specified key name and returns a float value if the\nkey exists and its value can successfully be converted to a float object;\notherwise the return value is null, or an exception is raised based upon the \nraiseExceptionIfNotFound argument value.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>oDict (dict):</strong>  Dictionary to check for the specified key name.</li>\n<li><strong>keyName (str):</strong>  Key name to check for.</li>\n<li><strong>raiseExceptionIfNotFound (bool):</strong>  True to raise an Exception if the specified keyName is not found in the dictionary; <br />\notherwise, False. <br />\nDefault value: False  </li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A float value if the key exists and its value can successfully be converted to a \n  float object; otherwise the return value is null, or an exception is raised based \n  upon the raiseExceptionIfNotFound argument value.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">oDict</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">keyName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">raiseExceptionIfNotFound</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">float</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservicebase.XPRRestServiceBase.GetDictKeyValueInt", "modulename": "milestonexprotectrestpython.xprrestservicebase", "qualname": "XPRRestServiceBase.GetDictKeyValueInt", "kind": "function", "doc": "<p>Checks a dictionary for the specified key name and returns a integer value if the\nkey exists and its value can successfully be converted to a integer object;\notherwise the return value is null, or an exception is raised based upon the \nraiseExceptionIfNotFound argument value.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>oDict (dict):</strong>  Dictionary to check for the specified key name.</li>\n<li><strong>keyName (str):</strong>  Key name to check for.</li>\n<li><strong>raiseExceptionIfNotFound (bool):</strong>  True to raise an Exception if the specified keyName is not found in the dictionary; <br />\notherwise, False. <br />\nDefault value: False  </li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A integer value if the key exists and its value can successfully be converted to a \n  integer object; otherwise the return value is null, or an exception is raised based \n  upon the raiseExceptionIfNotFound argument value.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">oDict</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>, </span><span class=\"param\"><span class=\"n\">keyName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">raiseExceptionIfNotFound</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservicebase.XPRRestServiceBase.GetDictKeyValueString", "modulename": "milestonexprotectrestpython.xprrestservicebase", "qualname": "XPRRestServiceBase.GetDictKeyValueString", "kind": "function", "doc": "<p>Checks a dictionary for the specified key name and returns a string value if the\nkey exists and its value can successfully be converted to a string object;\notherwise the return value is null, or an exception is raised based upon the \nraiseExceptionIfNotFound argument value.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>oDict (dict):</strong>  Dictionary to check for the specified key name.</li>\n<li><strong>keyName (str):</strong>  Key name to check for.</li>\n<li><strong>raiseExceptionIfNotFound (bool):</strong>  True to raise an Exception if the specified keyName is not found in the dictionary; <br />\notherwise, False. <br />\nDefault value: False  </li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A string value if the key exists and its value can successfully be converted to a \n  string object; otherwise the return value is null, or an exception is raised based \n  upon the raiseExceptionIfNotFound argument value.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">oDict</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>, </span><span class=\"param\"><span class=\"n\">keyName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">raiseExceptionIfNotFound</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservicebase.XPRRestServiceBase.LoginBasicUser", "modulename": "milestonexprotectrestpython.xprrestservicebase", "qualname": "XPRRestServiceBase.LoginBasicUser", "kind": "function", "doc": "<p>Authenticates a user with the specified Basic User login account.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>username (str):</strong>  Basic account type User Name to authenticate.</li>\n<li><strong>password (str):</strong>  Basic account type Password for the specified User Name to authenticate.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any reason.  </li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRLoginInfo class that contains Login details.</p>\n</blockquote>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># our package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect basic auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginBasicUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;xpsampleadmin&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">username</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">password</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprlogininfo</span><span class=\"o\">.</span><span class=\"n\">XPRLoginInfo</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestservicebase.XPRRestServiceBase.LoginWindowsUser", "modulename": "milestonexprotectrestpython.xprrestservicebase", "qualname": "XPRRestServiceBase.LoginWindowsUser", "kind": "function", "doc": "<p>Authenticates a user with the specified Windows User login account.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>username (str):</strong>  Windows account type User Name to authenticate.</li>\n<li><strong>password (str):</strong>  Windows account type Password for the specified User Name to authenticate.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>XPRRestServiceException:</strong>  The XProtect REST Server returned a failed response.</li>\n<li><strong>XPRException:</strong>  The method fails for any reason.  </li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An XPRLoginInfo class that contains Login details.</p>\n</blockquote>\n\n<p>Note that the token is retrieved directly from the identity provider as MIP VMS REST API gateway \ndoes not support pass-through of NTLM authentication.</p>\n\n<p><details>\n  <summary>Sample Code</summary><br/></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># our package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprlogininfo</span> <span class=\"kn\">import</span> <span class=\"n\">XPRLoginInfo</span>\n<span class=\"kn\">from</span> <span class=\"nn\">milestonexprotectrestpython.xprrestservice</span> <span class=\"kn\">import</span> <span class=\"n\">XPRRestService</span>\n\n<span class=\"c1\"># create XPRRestService instance and set server prefixes for our environment.</span>\n<span class=\"n\">xsvc</span><span class=\"p\">:</span><span class=\"n\">XPRRestService</span> <span class=\"o\">=</span> <span class=\"n\">XPRRestService</span><span class=\"p\">()</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">ApiGatewayUrlPrefix</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://myapigateway.example.com&quot;</span>\n<span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">IsSslVerifyEnabled</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n\n<span class=\"c1\"># authenticate using xprotect windows auth credentials.</span>\n<span class=\"n\">loginInfo</span><span class=\"p\">:</span><span class=\"n\">XPRLoginInfo</span> <span class=\"o\">=</span> <span class=\"n\">xsvc</span><span class=\"o\">.</span><span class=\"n\">LoginWindowsUser</span><span class=\"p\">(</span><span class=\"s2\">&quot;MYDOMAIN\\XProtectSample&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;MyPassword&amp;1&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;** Login Details:</span><span class=\"se\">\\n</span><span class=\"si\">{0}</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"n\">loginInfo</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">username</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">password</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">milestonexprotectrestpython</span><span class=\"o\">.</span><span class=\"n\">xprlogininfo</span><span class=\"o\">.</span><span class=\"n\">XPRLoginInfo</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprrestserviceexception", "modulename": "milestonexprotectrestpython.xprrestserviceexception", "kind": "module", "doc": "<p>Module: xprrestserviceexception.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprrestserviceexception.XPRRestServiceException", "modulename": "milestonexprotectrestpython.xprrestserviceexception", "qualname": "XPRRestServiceException", "kind": "class", "doc": "<p>Raised when the XProtect REST server returns an error response to a REST service call.</p>\n", "bases": "milestonexprotectrestpython.xprexception.XPRException"}, {"fullname": "milestonexprotectrestpython.xprrestserviceexception.XPRRestServiceException.__init__", "modulename": "milestonexprotectrestpython.xprrestserviceexception", "qualname": "XPRRestServiceException.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>message (str):</strong>  Exception message text.</li>\n<li><strong>errorText (str):</strong>  Error text that describes the error.</li>\n<li><strong>errorTextId (str):</strong>  Error text unique identifier that describes the error.  </li>\n<li><strong>propertyName (str):</strong>  Property name that caused the error.  </li>\n<li><strong>httpCode (str):</strong>  HTTP status code of the error.</li>\n<li><strong>httpReason (str):</strong>  HTTP reason for the error.</li>\n<li><strong>logsi (SISession):</strong>  Trace session object that this exception will be logged to, or null to bypass trace logging.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">message</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">errorText</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">errorTextId</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">propertyName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">httpCode</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">httpReason</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">logsi</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sisession</span><span class=\"o\">.</span><span class=\"n\">SISession</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, {"fullname": "milestonexprotectrestpython.xprrestserviceexception.XPRRestServiceException.MSG_SERVICE_FAILURE", "modulename": "milestonexprotectrestpython.xprrestserviceexception", "qualname": "XPRRestServiceException.MSG_SERVICE_FAILURE", "kind": "variable", "doc": "<p>REST Service failure details message text, in the form of:</p>\n\n<p>XProtect REST Service Failure Details:\nStatus Code: {0} - {1}\nError Text: {2}\nError ID: {3}\nProperty Name: {4}</p>\n", "annotation": ": str", "default_value": "&#x27;\\nXProtect REST Service Failure Details:\\nStatus Code: {0} - {1}\\nError Text: {2}\\nError ID: {3}\\nProperty Name: {4}\\n&#x27;"}, {"fullname": "milestonexprotectrestpython.xprrestserviceexception.XPRRestServiceException.ErrorText", "modulename": "milestonexprotectrestpython.xprrestserviceexception", "qualname": "XPRRestServiceException.ErrorText", "kind": "variable", "doc": "<p>Error text that describes the error.\nThis value is parsed from the XProtext REST response \"errorText\" value.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ErrorText property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprrestserviceexception.XPRRestServiceException.ErrorTextId", "modulename": "milestonexprotectrestpython.xprrestserviceexception", "qualname": "XPRRestServiceException.ErrorTextId", "kind": "variable", "doc": "<p>Error text unique identifier that describes the error. <br />\nThis value is parsed from the XProtext REST response \"errorTextId\" value.\nThis is normally only populated for HTTP status code 400 (Bad Request) errors.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ErrorTextId property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprrestserviceexception.XPRRestServiceException.HttpCode", "modulename": "milestonexprotectrestpython.xprrestserviceexception", "qualname": "XPRRestServiceException.HttpCode", "kind": "variable", "doc": "<p>HTTP status code of the error.\nThis value is copied from the HTTP Response \"status_code\" value.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The HttpCode property value.</p>\n</blockquote>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprrestserviceexception.XPRRestServiceException.HttpReason", "modulename": "milestonexprotectrestpython.xprrestserviceexception", "qualname": "XPRRestServiceException.HttpReason", "kind": "variable", "doc": "<p>HTTP reason for the error.\nThis value is copied from the HTTP Response \"reason\" value.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The HttpReason property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprrestserviceexception.XPRRestServiceException.PropertyName", "modulename": "milestonexprotectrestpython.xprrestserviceexception", "qualname": "XPRRestServiceException.PropertyName", "kind": "variable", "doc": "<p>Property name that caused the error. <br />\nThis value is parsed from the XProtext REST response \"propertyName\" value.\nThis is normally only populated for HTTP status code 400 (Bad Request) errors.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The PropertyName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprrestserviceexception.XPRRestServiceException.FormatServiceFailureDetails", "modulename": "milestonexprotectrestpython.xprrestserviceexception", "qualname": "XPRRestServiceException.FormatServiceFailureDetails", "kind": "function", "doc": "<p>Returns a formatted message that describes the service failure; this\nincludes the error text, error text id, http code, http reason, \nmessage, and property name.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>errorText (str):</strong>  Error text that describes the error.</li>\n<li><strong>errorTextId (str):</strong>  Error text unique identifier that describes the error.  </li>\n<li><strong>propertyName (str):</strong>  Property name that caused the error.  </li>\n<li><strong>httpCode (str):</strong>  HTTP status code of the error.</li>\n<li><strong>httpReason (str):</strong>  HTTP reason for the error.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A formatted string representation of the object.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">errorText</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">errorTextId</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">propertyName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">httpCode</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">httpReason</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprsite", "modulename": "milestonexprotectrestpython.xprsite", "kind": "module", "doc": "<p>Module: xprsite.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprsite.XPRSite", "modulename": "milestonexprotectrestpython.xprsite", "qualname": "XPRSite", "kind": "class", "doc": "<p>Site information.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n\n<p>More information about Site configuration can be found on the\n<a target=\"_blank\" href=\"https://doc.milestonesys.com/2023R2/en-US/feature_flags/ff_federatedsites/mc_federatedsiteproperties.htm\">vendor documentation page</a>.</p>\n"}, {"fullname": "milestonexprotectrestpython.xprsite.XPRSite.__init__", "modulename": "milestonexprotectrestpython.xprsite", "qualname": "XPRSite.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xprsite.XPRSite.ComputerName", "modulename": "milestonexprotectrestpython.xprsite", "qualname": "XPRSite.ComputerName", "kind": "variable", "doc": "<p>Computer name that is hosting the site.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ComputerName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprsite.XPRSite.DateLastStatusHandshake", "modulename": "milestonexprotectrestpython.xprsite", "qualname": "XPRSite.DateLastStatusHandshake", "kind": "variable", "doc": "<p>Date and time (in UTC format) of the last synchronization of the hierarchy.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DateLastStatusHandshake property value.</p>\n</blockquote>\n", "annotation": ": datetime.datetime"}, {"fullname": "milestonexprotectrestpython.xprsite.XPRSite.DateModified", "modulename": "milestonexprotectrestpython.xprsite", "qualname": "XPRSite.DateModified", "kind": "variable", "doc": "<p>Date and time (in UTC format) that the site entry was last modified.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DateModified property value.</p>\n</blockquote>\n", "annotation": ": datetime.datetime"}, {"fullname": "milestonexprotectrestpython.xprsite.XPRSite.Description", "modulename": "milestonexprotectrestpython.xprsite", "qualname": "XPRSite.Description", "kind": "variable", "doc": "<p>A description of the site.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Description property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprsite.XPRSite.DisplayName", "modulename": "milestonexprotectrestpython.xprsite", "qualname": "XPRSite.DisplayName", "kind": "variable", "doc": "<p>User-friendly display name used in various user-interface displays.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DisplayName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprsite.XPRSite.DomainName", "modulename": "milestonexprotectrestpython.xprsite", "qualname": "XPRSite.DomainName", "kind": "variable", "doc": "<p>Domain name of the computer that is hosting the site.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DomainName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprsite.XPRSite.Id", "modulename": "milestonexprotectrestpython.xprsite", "qualname": "XPRSite.Id", "kind": "variable", "doc": "<p>The globally unique identifier of the site.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Id property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprsite.XPRSite.Name", "modulename": "milestonexprotectrestpython.xprsite", "qualname": "XPRSite.Name", "kind": "variable", "doc": "<p>Name of the site.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Name property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprsite.XPRSite.MasterSiteAddress", "modulename": "milestonexprotectrestpython.xprsite", "qualname": "XPRSite.MasterSiteAddress", "kind": "variable", "doc": "<p>URL of the parent site, if this site is defined as a child site. <br />\nValue is an empty string if this is the master site.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The MasterSiteAddress property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprsite.XPRSite.PhysicalMemory", "modulename": "milestonexprotectrestpython.xprsite", "qualname": "XPRSite.PhysicalMemory", "kind": "variable", "doc": "<p>Host computer physical memory amount that the site is limited to using. <br />\nA value of zero indicates no limit.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The PhysicalMemory property value.</p>\n</blockquote>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprsite.XPRSite.Platform", "modulename": "milestonexprotectrestpython.xprsite", "qualname": "XPRSite.Platform", "kind": "variable", "doc": "<p>Host computer platform that the site is running under. <br />\nA \"[Not available]\" value is returned if the platform is unavailable.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Platform property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprsite.XPRSite.Processors", "modulename": "milestonexprotectrestpython.xprsite", "qualname": "XPRSite.Processors", "kind": "variable", "doc": "<p>Host computer number of processors that the site is limited to using. <br />\nA value of zero indicates no limit.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Processors property value.</p>\n</blockquote>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprsite.XPRSite.ServiceAccount", "modulename": "milestonexprotectrestpython.xprsite", "qualname": "XPRSite.ServiceAccount", "kind": "variable", "doc": "<p>Service account under which the management server is running.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ServiceAccount property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprsite.XPRSite.SynchronizationStatus", "modulename": "milestonexprotectrestpython.xprsite", "qualname": "XPRSite.SynchronizationStatus", "kind": "variable", "doc": "<p>Status of the last synchronization of the hierarchy. <br />\nIt can be either Successful (0) or Failed (1).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The SynchronizationStatus property value.</p>\n</blockquote>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprsite.XPRSite.TimeZoneName", "modulename": "milestonexprotectrestpython.xprsite", "qualname": "XPRSite.TimeZoneName", "kind": "variable", "doc": "<p>Time zone of the computer that is hosting the site.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The TimeZoneName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprsite.XPRSite.Version", "modulename": "milestonexprotectrestpython.xprsite", "qualname": "XPRSite.Version", "kind": "variable", "doc": "<p>Version number of the site's management server.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Version property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprsiteowner", "modulename": "milestonexprotectrestpython.xprsiteowner", "kind": "module", "doc": "<p>Module: xprsiteowner.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>AdditionalInformation</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprsiteowner.XPRSiteOwner", "modulename": "milestonexprotectrestpython.xprsiteowner", "qualname": "XPRSiteOwner", "kind": "class", "doc": "<p>Owner information.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n\n<p>More information about site owner configuration can be found on the\n<a target=\"_blank\" href=\"https://doc.milestonesys.com/2023R2/en-US/standard_features/sf_mc/sf_ui/mc_siteinformation_basics.htm\">vendor documentation page</a>.</p>\n"}, {"fullname": "milestonexprotectrestpython.xprsiteowner.XPRSiteOwner.__init__", "modulename": "milestonexprotectrestpython.xprsiteowner", "qualname": "XPRSiteOwner.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xprsiteowner.XPRSiteOwner.AdditionalInformation", "modulename": "milestonexprotectrestpython.xprsiteowner", "qualname": "XPRSiteOwner.AdditionalInformation", "kind": "variable", "doc": "<p>Additional Information details of the site.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The AdditionalInformation property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprsiteowner.XPRSiteOwner.AdminEMail", "modulename": "milestonexprotectrestpython.xprsiteowner", "qualname": "XPRSiteOwner.AdminEMail", "kind": "variable", "doc": "<p>EMail address used to contact the site administrator.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The AdminEMail property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprsiteowner.XPRSiteOwner.AdminName", "modulename": "milestonexprotectrestpython.xprsiteowner", "qualname": "XPRSiteOwner.AdminName", "kind": "variable", "doc": "<p>Name of the site administrator.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The AdminName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprsiteowner.XPRSiteOwner.AdminPhone", "modulename": "milestonexprotectrestpython.xprsiteowner", "qualname": "XPRSiteOwner.AdminPhone", "kind": "variable", "doc": "<p>Phone number used to contact the site administrator.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The AdminPhone property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprsiteowner.XPRSiteOwner.DisplayName", "modulename": "milestonexprotectrestpython.xprsiteowner", "qualname": "XPRSiteOwner.DisplayName", "kind": "variable", "doc": "<p>User-friendly display name used in various user-interface displays.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DisplayName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprsiteowner.XPRSiteOwner.LocationCountry", "modulename": "milestonexprotectrestpython.xprsiteowner", "qualname": "XPRSiteOwner.LocationCountry", "kind": "variable", "doc": "<p>Country portion of the address used to contact the site location.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The LocationCountry property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprsiteowner.XPRSiteOwner.LocationEMail", "modulename": "milestonexprotectrestpython.xprsiteowner", "qualname": "XPRSiteOwner.LocationEMail", "kind": "variable", "doc": "<p>EMail address used to contact the site location.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The LocationEMail property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprsiteowner.XPRSiteOwner.LocationPhone", "modulename": "milestonexprotectrestpython.xprsiteowner", "qualname": "XPRSiteOwner.LocationPhone", "kind": "variable", "doc": "<p>Phone number used to contact the site location.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The LocationPhone property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprsiteowner.XPRSiteOwner.LocationStateProvince", "modulename": "milestonexprotectrestpython.xprsiteowner", "qualname": "XPRSiteOwner.LocationStateProvince", "kind": "variable", "doc": "<p>State or Province portion of the address used to contact the site location.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The LocationStateProvince property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprsiteowner.XPRSiteOwner.LocationStreet", "modulename": "milestonexprotectrestpython.xprsiteowner", "qualname": "XPRSiteOwner.LocationStreet", "kind": "variable", "doc": "<p>Street portion of the address used to contact the site location.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The LocationStreet property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprsiteowner.XPRSiteOwner.LocationZipCode", "modulename": "milestonexprotectrestpython.xprsiteowner", "qualname": "XPRSiteOwner.LocationZipCode", "kind": "variable", "doc": "<p>ZipCode portion of the address used to contact the site location.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The LocationZipCode property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprspeaker", "modulename": "milestonexprotectrestpython.xprspeaker", "kind": "module", "doc": "<p>Module: xprspeaker.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprspeaker.XPRSpeaker", "modulename": "milestonexprotectrestpython.xprspeaker", "qualname": "XPRSpeaker", "kind": "class", "doc": "<p>Speaker device information.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n", "bases": "milestonexprotectrestpython.xprdevice.XPRDevice"}, {"fullname": "milestonexprotectrestpython.xprspeaker.XPRSpeaker.__init__", "modulename": "milestonexprotectrestpython.xprspeaker", "qualname": "XPRSpeaker.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xprspeaker.XPRSpeaker.EdgeStorageEnabled", "modulename": "milestonexprotectrestpython.xprspeaker", "qualname": "XPRSpeaker.EdgeStorageEnabled", "kind": "variable", "doc": "<p>Determines if remote recording is enabled (True) or not (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The EdgeStorageEnabled property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprspeaker.XPRSpeaker.EdgeStoragePlaybackEnabled", "modulename": "milestonexprotectrestpython.xprspeaker", "qualname": "XPRSpeaker.EdgeStoragePlaybackEnabled", "kind": "variable", "doc": "<p>Determines if remote recording playback is enabled (True) or not (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The EdgeStoragePlaybackEnabled property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprspeaker.XPRSpeaker.ManualRecordingTimeoutEnabled", "modulename": "milestonexprotectrestpython.xprspeaker", "qualname": "XPRSpeaker.ManualRecordingTimeoutEnabled", "kind": "variable", "doc": "<p>Determines if manual recording timeout is enabled (True) or not (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ManualRecordingTimeoutEnabled property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprspeaker.XPRSpeaker.ManualRecordingTimeoutMinutes", "modulename": "milestonexprotectrestpython.xprspeaker", "qualname": "XPRSpeaker.ManualRecordingTimeoutMinutes", "kind": "variable", "doc": "<p>Number of minutes to automatically stop all manual recordings started by XProtect Smart \nClient users if manual recording timeout is enabled.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ManualRecordingTimeoutMinutes property value.</p>\n</blockquote>\n\n<p>The number of minutes you specify must be sufficiently large enough to accommodate the \nrequirements of the various manual recordings without overloading the system.</p>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprspeaker.XPRSpeaker.PrebufferEnabled", "modulename": "milestonexprotectrestpython.xprspeaker", "qualname": "XPRSpeaker.PrebufferEnabled", "kind": "variable", "doc": "<p>Determines if pre-buffering is enabled (True) or not (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The PrebufferEnabled property value.</p>\n</blockquote>\n\n<p>Pre-buffering is the ability to record audio and video before the actual triggering event occurs.</p>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprspeaker.XPRSpeaker.PrebufferInMemory", "modulename": "milestonexprotectrestpython.xprspeaker", "qualname": "XPRSpeaker.PrebufferInMemory", "kind": "variable", "doc": "<p>Determines if pre-buffering is stored in-memory (True) or onto disk storage (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The PrebufferInMemory property value.</p>\n</blockquote>\n\n<p>Storage to memory instead of to disk improves system performance, but is only possible for \nshorter pre-buffer periods (usually 15 seconds or less).</p>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprspeaker.XPRSpeaker.PrebufferSeconds", "modulename": "milestonexprotectrestpython.xprspeaker", "qualname": "XPRSpeaker.PrebufferSeconds", "kind": "variable", "doc": "<p>Number of seconds to automatically stop all manual recordings started by XProtect Smart \nClient users if manual recording timeout is enabled.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The PrebufferSeconds property value.</p>\n</blockquote>\n\n<p>The number of seconds you specify must be sufficiently large to accommodate your requirements \nin the various recording rules you define.</p>\n", "annotation": ": int"}, {"fullname": "milestonexprotectrestpython.xprspeaker.XPRSpeaker.RecordingEnabled", "modulename": "milestonexprotectrestpython.xprspeaker", "qualname": "XPRSpeaker.RecordingEnabled", "kind": "variable", "doc": "<p>Determines if recording is enabled (True) or not (False).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The RecordingEnabled property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprspeaker.XPRSpeaker.RecordingStorageId", "modulename": "milestonexprotectrestpython.xprspeaker", "qualname": "XPRSpeaker.RecordingStorageId", "kind": "variable", "doc": "<p>The Storage identifier of where recordings are stored for this device.  </p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The RecordingStorageId property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprstategroup", "modulename": "milestonexprotectrestpython.xprstategroup", "kind": "module", "doc": "<p>Module: xprstategroup.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprstategroup.XPRStateGroup", "modulename": "milestonexprotectrestpython.xprstategroup", "qualname": "XPRStateGroup", "kind": "class", "doc": "<p>State Group information.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "milestonexprotectrestpython.xprstategroup.XPRStateGroup.__init__", "modulename": "milestonexprotectrestpython.xprstategroup", "qualname": "XPRStateGroup.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xprstategroup.XPRStateGroup.DateModified", "modulename": "milestonexprotectrestpython.xprstategroup", "qualname": "XPRStateGroup.DateModified", "kind": "variable", "doc": "<p>Date and time (in UTC format) that the entry was last modified.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DateModified property value.</p>\n</blockquote>\n", "annotation": ": datetime.datetime"}, {"fullname": "milestonexprotectrestpython.xprstategroup.XPRStateGroup.DisplayName", "modulename": "milestonexprotectrestpython.xprstategroup", "qualname": "XPRStateGroup.DisplayName", "kind": "variable", "doc": "<p>User-friendly display name used in various user-interface displays.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DisplayName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprstategroup.XPRStateGroup.Id", "modulename": "milestonexprotectrestpython.xprstategroup", "qualname": "XPRStateGroup.Id", "kind": "variable", "doc": "<p>The globally unique identifier of the item.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Id property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprstategroup.XPRStateGroup.Name", "modulename": "milestonexprotectrestpython.xprstategroup", "qualname": "XPRStateGroup.Name", "kind": "variable", "doc": "<p>Name of the event.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Name property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprstategroup.XPRStateGroup.States", "modulename": "milestonexprotectrestpython.xprstategroup", "qualname": "XPRStateGroup.States", "kind": "variable", "doc": "<p>States the group supports (e.g. \"Normal\", \"Warning\", \"Critical\", etc).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The States property value.</p>\n</blockquote>\n", "annotation": ": list[str]"}, {"fullname": "milestonexprotectrestpython.xprstream", "modulename": "milestonexprotectrestpython.xprstream", "kind": "module", "doc": "<p>Module: xprstream.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprstream.XPRStream", "modulename": "milestonexprotectrestpython.xprstream", "qualname": "XPRStream", "kind": "class", "doc": "<p>Stream information.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n\n<p>More information about camera stream configuration can be found on the\n<a target=\"_blank\" href=\"https://doc.milestonesys.com/2023R2/en-US/standard_features/sf_mc/sf_mcnodes/sf_3devices/mc_addastream_devices.htm\">vendor documentation page</a>.</p>\n"}, {"fullname": "milestonexprotectrestpython.xprstream.XPRStream.__init__", "modulename": "milestonexprotectrestpython.xprstream", "qualname": "XPRStream.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xprstream.XPRStream.DefaultPlayback", "modulename": "milestonexprotectrestpython.xprstream", "qualname": "XPRStream.DefaultPlayback", "kind": "variable", "doc": "<p>If True, this stream will be delivered to the client if adaptive playback is not configured. <br />\notherwise, False.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DefaultPlayback property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprstream.XPRStream.DisplayName", "modulename": "milestonexprotectrestpython.xprstream", "qualname": "XPRStream.DisplayName", "kind": "variable", "doc": "<p>User-friendly display name used in various user-interface displays.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DisplayName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprstream.XPRStream.Id", "modulename": "milestonexprotectrestpython.xprstream", "qualname": "XPRStream.Id", "kind": "variable", "doc": "<p>Globally unique identifier of the stream.  </p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The StreamReferenceId property value.</p>\n</blockquote>\n\n<p>Note that this is a duplicate property of the StreamReferenceId property.  It was\nadded for ease-of-use, as most of the other item classes have an \"Id\" property.</p>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprstream.XPRStream.LiveDefault", "modulename": "milestonexprotectrestpython.xprstream", "qualname": "XPRStream.LiveDefault", "kind": "variable", "doc": "<p>If True, this stream will be used if the client does not request a specific stream and \nadaptive streaming is disabled; otherwise, False.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The LiveDefault property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xprstream.XPRStream.LiveMode", "modulename": "milestonexprotectrestpython.xprstream", "qualname": "XPRStream.LiveMode", "kind": "variable", "doc": "<p>Specifies when live streaming is needed:  </p>\n\n<ul>\n<li>Always: the stream runs even if no XProtect Smart Client users request the stream.  </li>\n<li>Never: the stream is off. Only use this for recording streams, for example, if you want recordings in high quality and need the bandwidth.  </li>\n<li>WhenNeeded: the stream starts when requested by any client or if the stream is set to record.  </li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The LiveMode property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprstream.XPRStream.Name", "modulename": "milestonexprotectrestpython.xprstream", "qualname": "XPRStream.Name", "kind": "variable", "doc": "<p>Name of the stream.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Name property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprstream.XPRStream.ParentId", "modulename": "milestonexprotectrestpython.xprstream", "qualname": "XPRStream.ParentId", "kind": "variable", "doc": "<p>Globally unique identifier of the parent device.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ParentId property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprstream.XPRStream.ParentType", "modulename": "milestonexprotectrestpython.xprstream", "qualname": "XPRStream.ParentType", "kind": "variable", "doc": "<p>Parent device type (\"cameras\", etc).</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The ParentType property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprstream.XPRStream.RecordToId", "modulename": "milestonexprotectrestpython.xprstream", "qualname": "XPRStream.RecordToId", "kind": "variable", "doc": "<p>Globally unique identifier of the stream.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The RecordToId property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprstream.XPRStream.StreamReferenceId", "modulename": "milestonexprotectrestpython.xprstream", "qualname": "XPRStream.StreamReferenceId", "kind": "variable", "doc": "<p>Globally unique identifier of the stream.</p>\n\n<p>For adaptive playback, you need to create a stream of each type. <br />\nThe video that is played back is sourced from the primary video stream and secondary streaming is included when required. <br />\nThere must always be a primary recording. Also, the stream that you configure as Primary is used in different contexts \nsuch as for motion detection and for export from XProtect Smart Client.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The StreamReferenceId property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprstream.XPRStream.UseEdge", "modulename": "milestonexprotectrestpython.xprstream", "qualname": "XPRStream.UseEdge", "kind": "variable", "doc": "<p>True if this stream will use edge recordings; otherwise, False.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The UseEdge property value.</p>\n</blockquote>\n", "annotation": ": bool"}, {"fullname": "milestonexprotectrestpython.xpruserdefinedevent", "modulename": "milestonexprotectrestpython.xpruserdefinedevent", "kind": "module", "doc": "<p>Module: xpruserdefinedevent.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/11</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xpruserdefinedevent.XPRUserDefinedEvent", "modulename": "milestonexprotectrestpython.xpruserdefinedevent", "qualname": "XPRUserDefinedEvent", "kind": "class", "doc": "<p>User Defined Event information.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "milestonexprotectrestpython.xpruserdefinedevent.XPRUserDefinedEvent.__init__", "modulename": "milestonexprotectrestpython.xpruserdefinedevent", "qualname": "XPRUserDefinedEvent.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "milestonexprotectrestpython.xpruserdefinedevent.XPRUserDefinedEvent.DateCreated", "modulename": "milestonexprotectrestpython.xpruserdefinedevent", "qualname": "XPRUserDefinedEvent.DateCreated", "kind": "variable", "doc": "<p>Date and time (in UTC format) that the entry was created.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DateCreated property value.</p>\n</blockquote>\n", "annotation": ": datetime.datetime"}, {"fullname": "milestonexprotectrestpython.xpruserdefinedevent.XPRUserDefinedEvent.DateModified", "modulename": "milestonexprotectrestpython.xpruserdefinedevent", "qualname": "XPRUserDefinedEvent.DateModified", "kind": "variable", "doc": "<p>Date and time (in UTC format) that the entry was last modified.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DateModified property value.</p>\n</blockquote>\n", "annotation": ": datetime.datetime"}, {"fullname": "milestonexprotectrestpython.xpruserdefinedevent.XPRUserDefinedEvent.DisplayName", "modulename": "milestonexprotectrestpython.xpruserdefinedevent", "qualname": "XPRUserDefinedEvent.DisplayName", "kind": "variable", "doc": "<p>User-friendly display name used in various user-interface displays.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The DisplayName property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xpruserdefinedevent.XPRUserDefinedEvent.Id", "modulename": "milestonexprotectrestpython.xpruserdefinedevent", "qualname": "XPRUserDefinedEvent.Id", "kind": "variable", "doc": "<p>The globally unique identifier of the group.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Id property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xpruserdefinedevent.XPRUserDefinedEvent.Name", "modulename": "milestonexprotectrestpython.xpruserdefinedevent", "qualname": "XPRUserDefinedEvent.Name", "kind": "variable", "doc": "<p>Name of the event.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The Name property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xpruserdefinedevent.XPRUserDefinedEvent.SubType", "modulename": "milestonexprotectrestpython.xpruserdefinedevent", "qualname": "XPRUserDefinedEvent.SubType", "kind": "variable", "doc": "<p>SubType of the event.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The SubType property value.</p>\n</blockquote>\n", "annotation": ": str"}, {"fullname": "milestonexprotectrestpython.xprutils", "modulename": "milestonexprotectrestpython.xprutils", "kind": "module", "doc": "<p>Module: xprutils.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/07/07</td>\n  <td>1.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprutils.static_init", "modulename": "milestonexprotectrestpython.xprutils", "qualname": "static_init", "kind": "function", "doc": "<p>Define the decorator used to call an initializer for a class with all static methods.\nThis allows static variables to be initialized one time for the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprutils.export", "modulename": "milestonexprotectrestpython.xprutils", "qualname": "export", "kind": "function", "doc": "<p>Define the decorator used to modify a module's \"__all__\" variable.\nThis avoids us having to manually modify a module's \"__all__\" variable when adding new classes.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">fn</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprutils.Event", "modulename": "milestonexprotectrestpython.xprutils", "qualname": "Event", "kind": "class", "doc": "<p>C# like event processing in Python3.</p>\n\n<p><details>\n    <summary>View Sample Code</summary></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># Define the class that will be raising events:</span>\n<span class=\"k\">class</span> <span class=\"nc\">MyFileWatcher</span><span class=\"p\">:</span>\n    <span class=\"k\">def</span> <span class=\"fm\">__init__</span><span class=\"p\">(</span><span class=\"bp\">self</span><span class=\"p\">):</span>\n        <span class=\"bp\">self</span><span class=\"o\">.</span><span class=\"n\">fileChanged</span> <span class=\"o\">=</span> <span class=\"n\">Event</span><span class=\"p\">()</span>      <span class=\"c1\"># define event</span>\n\n    <span class=\"k\">def</span> <span class=\"nf\">watchFiles</span><span class=\"p\">(</span><span class=\"bp\">self</span><span class=\"p\">):</span>\n        <span class=\"n\">source_path</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;foo&quot;</span>\n        <span class=\"bp\">self</span><span class=\"o\">.</span><span class=\"n\">fileChanged</span><span class=\"p\">(</span><span class=\"n\">source_path</span><span class=\"p\">)</span>   <span class=\"c1\"># fire event</span>\n\n<span class=\"k\">def</span> <span class=\"nf\">log_file_change</span><span class=\"p\">(</span><span class=\"n\">source_path</span><span class=\"p\">):</span>       <span class=\"c1\"># event handler 1</span>\n    <span class=\"nb\">print</span> <span class=\"s2\">&quot;</span><span class=\"si\">%r</span><span class=\"s2\"> changed.&quot;</span> <span class=\"o\">%</span> <span class=\"p\">(</span><span class=\"n\">source_path</span><span class=\"p\">,)</span>\n\n<span class=\"k\">def</span> <span class=\"nf\">log_file_change2</span><span class=\"p\">(</span><span class=\"n\">source_path</span><span class=\"p\">):</span>      <span class=\"c1\"># event handler 2</span>\n    <span class=\"nb\">print</span> <span class=\"s2\">&quot;</span><span class=\"si\">%r</span><span class=\"s2\"> changed!&quot;</span> <span class=\"o\">%</span> <span class=\"p\">(</span><span class=\"n\">source_path</span><span class=\"p\">,)</span>\n\n<span class=\"c1\"># Define the code that will be handling raised events.</span>\n<span class=\"n\">watcher</span>              <span class=\"o\">=</span> <span class=\"n\">MyFileWatcher</span><span class=\"p\">()</span>\n<span class=\"n\">watcher</span><span class=\"o\">.</span><span class=\"n\">fileChanged</span> <span class=\"o\">+=</span> <span class=\"n\">log_file_change2</span>\n<span class=\"n\">watcher</span><span class=\"o\">.</span><span class=\"n\">fileChanged</span> <span class=\"o\">+=</span> <span class=\"n\">log_file_change</span>\n<span class=\"n\">watcher</span><span class=\"o\">.</span><span class=\"n\">fileChanged</span> <span class=\"o\">-=</span> <span class=\"n\">log_file_change2</span>\n<span class=\"n\">watcher</span><span class=\"o\">.</span><span class=\"n\">watchFiles</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<p></details></p>\n"}, {"fullname": "milestonexprotectrestpython.xprutils.Event.__init__", "modulename": "milestonexprotectrestpython.xprutils", "qualname": "Event.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span></span>)</span>"}, {"fullname": "milestonexprotectrestpython.xprutils.Event.handlers", "modulename": "milestonexprotectrestpython.xprutils", "qualname": "Event.handlers", "kind": "variable", "doc": "<p></p>\n"}, {"fullname": "milestonexprotectrestpython.xprutils.Event.fire", "modulename": "milestonexprotectrestpython.xprutils", "qualname": "Event.fire", "kind": "function", "doc": "<p>Calls (i.e. \"fires\") all method handlers defined for this event.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprutils.Event.getHandlerCount", "modulename": "milestonexprotectrestpython.xprutils", "qualname": "Event.getHandlerCount", "kind": "function", "doc": "<p>Returns the number of method handlers defined for this event.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprutils.Event.handle", "modulename": "milestonexprotectrestpython.xprutils", "qualname": "Event.handle", "kind": "function", "doc": "<p>Adds a method handler for this event.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">handler</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprutils.Event.unhandle", "modulename": "milestonexprotectrestpython.xprutils", "qualname": "Event.unhandle", "kind": "function", "doc": "<p>Removes the specified method handler for this event.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>handler (object):</strong>  The method handler to remove.</li>\n</ul>\n\n<p>This method will not throw an exception.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">handler</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "milestonexprotectrestpython.xprutils.Event.unhandle_all", "modulename": "milestonexprotectrestpython.xprutils", "qualname": "Event.unhandle_all", "kind": "function", "doc": "<p>Removes all method handlers (if any) for this event.</p>\n\n<p>This method will not throw an exception.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}];

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();