/*
 * Decompiled with CFR 0.152.
 */
package io.ray.serve.handle;

import io.ray.runtime.metric.Count;
import io.ray.runtime.metric.Metrics;
import io.ray.serve.api.Serve;
import io.ray.serve.context.RequestContext;
import io.ray.serve.deployment.DeploymentId;
import io.ray.serve.generated.RequestMetadata;
import io.ray.serve.handle.DeploymentResponse;
import io.ray.serve.handle.HandleOptions;
import io.ray.serve.metrics.RayServeMetrics;
import io.ray.serve.router.Router;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public class DeploymentHandle
implements Serializable {
    private static final long serialVersionUID = 550701184372753496L;
    private DeploymentId deploymentId;
    private HandleOptions handleOptions;
    private String handleTag;
    private transient Count requestCounter;
    private volatile transient Router router;

    public DeploymentHandle(String deploymentName, String appName) {
        this(deploymentName, appName, null, null);
    }

    public DeploymentHandle(String deploymentName, String appName, HandleOptions handleOptions, Router router) {
        this.deploymentId = new DeploymentId(deploymentName, appName);
        this.handleOptions = handleOptions != null ? handleOptions : new HandleOptions();
        this.handleTag = StringUtils.isBlank(appName) ? deploymentName + "#" + RandomStringUtils.randomAlphabetic(6) : appName + "#" + deploymentName + "#" + RandomStringUtils.randomAlphabetic(6);
        this.router = router;
        this.initMetrics();
    }

    private void initMetrics() {
        HashMap<String, String> metricsTags = new HashMap<String, String>();
        metricsTags.put("handle", this.handleTag);
        metricsTags.put("endpoint", this.deploymentId.getName());
        if (StringUtils.isNotBlank(this.deploymentId.getApp())) {
            metricsTags.put("application", this.deploymentId.getApp());
        }
        RayServeMetrics.execute(() -> {
            this.requestCounter = (Count)((Metrics.CountBuilder)((Metrics.CountBuilder)((Metrics.CountBuilder)((Metrics.CountBuilder)Metrics.count().name(RayServeMetrics.SERVE_HANDLE_REQUEST_COUNTER.name())).description(RayServeMetrics.SERVE_HANDLE_REQUEST_COUNTER.getDescription())).unit("")).tags(metricsTags)).register();
        });
    }

    public DeploymentResponse remote(Object ... parameters) {
        RequestContext requestContext = RequestContext.get();
        RayServeMetrics.execute(() -> this.requestCounter.inc(1.0));
        RequestMetadata.Builder requestMetadata = RequestMetadata.newBuilder();
        requestMetadata.setRequestId(requestContext.getRequestId());
        requestMetadata.setCallMethod(this.handleOptions != null ? this.handleOptions.getMethodName() : "call");
        requestMetadata.setRoute(requestContext.getRoute());
        requestMetadata.setMultiplexedModelId(requestContext.getMultiplexedModelId());
        return new DeploymentResponse(this.getOrCreateRouter().assignRequest(requestMetadata.build(), parameters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Router getOrCreateRouter() {
        if (this.router != null) {
            return this.router;
        }
        Class<DeploymentHandle> clazz = DeploymentHandle.class;
        synchronized (DeploymentHandle.class) {
            if (this.router != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.router;
            }
            this.router = new Router(Serve.getGlobalClient().getController(), this.deploymentId);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.router;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initMetrics();
    }

    public DeploymentHandle method(String methodName) {
        this.handleOptions.setMethodName(methodName);
        return this;
    }

    public Router getRouter() {
        return this.getOrCreateRouter();
    }

    public boolean isPolling() {
        return this.router.getLongPollClient().isRunning();
    }
}

