# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudGuardDataSourceArgs', 'CloudGuardDataSource']

@pulumi.input_type
class CloudGuardDataSourceArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 data_source_feed_provider: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 data_source_details: Optional[pulumi.Input['CloudGuardDataSourceDataSourceDetailsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CloudGuardDataSource resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment OCID of the data source
        :param pulumi.Input[str] data_source_feed_provider: Type of data source feed provider (LoggingQuery)
        :param pulumi.Input[str] display_name: (Updatable) Data source display name
        :param pulumi.Input['CloudGuardDataSourceDataSourceDetailsArgs'] data_source_details: (Updatable) Details specific to the data source type.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[str] status: (Updatable) Enablement status of data source.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "data_source_feed_provider", data_source_feed_provider)
        pulumi.set(__self__, "display_name", display_name)
        if data_source_details is not None:
            pulumi.set(__self__, "data_source_details", data_source_details)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Compartment OCID of the data source
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dataSourceFeedProvider")
    def data_source_feed_provider(self) -> pulumi.Input[str]:
        """
        Type of data source feed provider (LoggingQuery)
        """
        return pulumi.get(self, "data_source_feed_provider")

    @data_source_feed_provider.setter
    def data_source_feed_provider(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_source_feed_provider", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) Data source display name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dataSourceDetails")
    def data_source_details(self) -> Optional[pulumi.Input['CloudGuardDataSourceDataSourceDetailsArgs']]:
        """
        (Updatable) Details specific to the data source type.
        """
        return pulumi.get(self, "data_source_details")

    @data_source_details.setter
    def data_source_details(self, value: Optional[pulumi.Input['CloudGuardDataSourceDataSourceDetailsArgs']]):
        pulumi.set(self, "data_source_details", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`

        Avoid entering confidential information.
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Enablement status of data source.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _CloudGuardDataSourceState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 data_source_details: Optional[pulumi.Input['CloudGuardDataSourceDataSourceDetailsArgs']] = None,
                 data_source_detector_mapping_infos: Optional[pulumi.Input[Sequence[pulumi.Input['CloudGuardDataSourceDataSourceDetectorMappingInfoArgs']]]] = None,
                 data_source_feed_provider: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 region_status_details: Optional[pulumi.Input[Sequence[pulumi.Input['CloudGuardDataSourceRegionStatusDetailArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CloudGuardDataSource resources.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment OCID of the data source
        :param pulumi.Input['CloudGuardDataSourceDataSourceDetailsArgs'] data_source_details: (Updatable) Details specific to the data source type.
        :param pulumi.Input[Sequence[pulumi.Input['CloudGuardDataSourceDataSourceDetectorMappingInfoArgs']]] data_source_detector_mapping_infos: Information about the detector recipe and rule attached
        :param pulumi.Input[str] data_source_feed_provider: Type of data source feed provider (LoggingQuery)
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Data source display name
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input['CloudGuardDataSourceRegionStatusDetailArgs']]] region_status_details: Information about the region and status of query replication
        :param pulumi.Input[str] state: The current lifecycle state of the resource.
        :param pulumi.Input[str] status: (Updatable) Enablement status of data source.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time the Data source was created. Format defined by RFC3339.
        :param pulumi.Input[str] time_updated: The date and time the data source was updated. Format defined by RFC3339.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if data_source_details is not None:
            pulumi.set(__self__, "data_source_details", data_source_details)
        if data_source_detector_mapping_infos is not None:
            pulumi.set(__self__, "data_source_detector_mapping_infos", data_source_detector_mapping_infos)
        if data_source_feed_provider is not None:
            pulumi.set(__self__, "data_source_feed_provider", data_source_feed_provider)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if region_status_details is not None:
            pulumi.set(__self__, "region_status_details", region_status_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Compartment OCID of the data source
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dataSourceDetails")
    def data_source_details(self) -> Optional[pulumi.Input['CloudGuardDataSourceDataSourceDetailsArgs']]:
        """
        (Updatable) Details specific to the data source type.
        """
        return pulumi.get(self, "data_source_details")

    @data_source_details.setter
    def data_source_details(self, value: Optional[pulumi.Input['CloudGuardDataSourceDataSourceDetailsArgs']]):
        pulumi.set(self, "data_source_details", value)

    @property
    @pulumi.getter(name="dataSourceDetectorMappingInfos")
    def data_source_detector_mapping_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudGuardDataSourceDataSourceDetectorMappingInfoArgs']]]]:
        """
        Information about the detector recipe and rule attached
        """
        return pulumi.get(self, "data_source_detector_mapping_infos")

    @data_source_detector_mapping_infos.setter
    def data_source_detector_mapping_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudGuardDataSourceDataSourceDetectorMappingInfoArgs']]]]):
        pulumi.set(self, "data_source_detector_mapping_infos", value)

    @property
    @pulumi.getter(name="dataSourceFeedProvider")
    def data_source_feed_provider(self) -> Optional[pulumi.Input[str]]:
        """
        Type of data source feed provider (LoggingQuery)
        """
        return pulumi.get(self, "data_source_feed_provider")

    @data_source_feed_provider.setter
    def data_source_feed_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_source_feed_provider", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Data source display name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`

        Avoid entering confidential information.
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="regionStatusDetails")
    def region_status_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudGuardDataSourceRegionStatusDetailArgs']]]]:
        """
        Information about the region and status of query replication
        """
        return pulumi.get(self, "region_status_details")

    @region_status_details.setter
    def region_status_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudGuardDataSourceRegionStatusDetailArgs']]]]):
        pulumi.set(self, "region_status_details", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Enablement status of data source.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the Data source was created. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the data source was updated. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class CloudGuardDataSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 data_source_details: Optional[pulumi.Input[pulumi.InputType['CloudGuardDataSourceDataSourceDetailsArgs']]] = None,
                 data_source_feed_provider: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Data Source resource in Oracle Cloud Infrastructure Cloud Guard service.

        Creates a data source (DataSource resource), using parameters passed
        through a CreateDataSourceDetails resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_data_source = oci.cloud_guard.CloudGuardDataSource("test_data_source",
            compartment_id=compartment_id,
            data_source_feed_provider=data_source_data_source_feed_provider,
            display_name=data_source_display_name,
            data_source_details=oci.cloud_guard.CloudGuardDataSourceDataSourceDetailsArgs(
                data_source_feed_provider=data_source_data_source_details_data_source_feed_provider,
                additional_entities_count=data_source_data_source_details_additional_entities_count,
                description=data_source_data_source_details_description,
                interval_in_minutes=data_source_data_source_details_interval_in_minutes,
                interval_in_seconds=data_source_data_source_details_interval_in_seconds,
                logging_query_details=oci.cloud_guard.CloudGuardDataSourceDataSourceDetailsLoggingQueryDetailsArgs(
                    logging_query_type=data_source_data_source_details_logging_query_details_logging_query_type,
                    key_entities_count=data_source_data_source_details_logging_query_details_key_entities_count,
                ),
                logging_query_type=data_source_data_source_details_logging_query_type,
                operator=data_source_data_source_details_operator,
                query=data_source_data_source_details_query,
                query_start_time=oci.cloud_guard.CloudGuardDataSourceDataSourceDetailsQueryStartTimeArgs(
                    start_policy_type=data_source_data_source_details_query_start_time_start_policy_type,
                    query_start_time=data_source_data_source_details_query_start_time_query_start_time,
                ),
                regions=data_source_data_source_details_regions,
                scheduled_query_scope_details=[oci.cloud_guard.CloudGuardDataSourceDataSourceDetailsScheduledQueryScopeDetailArgs(
                    region=data_source_data_source_details_scheduled_query_scope_details_region,
                    resource_ids=data_source_data_source_details_scheduled_query_scope_details_resource_ids,
                    resource_type=data_source_data_source_details_scheduled_query_scope_details_resource_type,
                )],
                threshold=data_source_data_source_details_threshold,
            ),
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            status=data_source_status)
        ```

        ## Import

        DataSources can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CloudGuard/cloudGuardDataSource:CloudGuardDataSource test_data_source "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment OCID of the data source
        :param pulumi.Input[pulumi.InputType['CloudGuardDataSourceDataSourceDetailsArgs']] data_source_details: (Updatable) Details specific to the data source type.
        :param pulumi.Input[str] data_source_feed_provider: Type of data source feed provider (LoggingQuery)
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Data source display name
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[str] status: (Updatable) Enablement status of data source.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudGuardDataSourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Data Source resource in Oracle Cloud Infrastructure Cloud Guard service.

        Creates a data source (DataSource resource), using parameters passed
        through a CreateDataSourceDetails resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_data_source = oci.cloud_guard.CloudGuardDataSource("test_data_source",
            compartment_id=compartment_id,
            data_source_feed_provider=data_source_data_source_feed_provider,
            display_name=data_source_display_name,
            data_source_details=oci.cloud_guard.CloudGuardDataSourceDataSourceDetailsArgs(
                data_source_feed_provider=data_source_data_source_details_data_source_feed_provider,
                additional_entities_count=data_source_data_source_details_additional_entities_count,
                description=data_source_data_source_details_description,
                interval_in_minutes=data_source_data_source_details_interval_in_minutes,
                interval_in_seconds=data_source_data_source_details_interval_in_seconds,
                logging_query_details=oci.cloud_guard.CloudGuardDataSourceDataSourceDetailsLoggingQueryDetailsArgs(
                    logging_query_type=data_source_data_source_details_logging_query_details_logging_query_type,
                    key_entities_count=data_source_data_source_details_logging_query_details_key_entities_count,
                ),
                logging_query_type=data_source_data_source_details_logging_query_type,
                operator=data_source_data_source_details_operator,
                query=data_source_data_source_details_query,
                query_start_time=oci.cloud_guard.CloudGuardDataSourceDataSourceDetailsQueryStartTimeArgs(
                    start_policy_type=data_source_data_source_details_query_start_time_start_policy_type,
                    query_start_time=data_source_data_source_details_query_start_time_query_start_time,
                ),
                regions=data_source_data_source_details_regions,
                scheduled_query_scope_details=[oci.cloud_guard.CloudGuardDataSourceDataSourceDetailsScheduledQueryScopeDetailArgs(
                    region=data_source_data_source_details_scheduled_query_scope_details_region,
                    resource_ids=data_source_data_source_details_scheduled_query_scope_details_resource_ids,
                    resource_type=data_source_data_source_details_scheduled_query_scope_details_resource_type,
                )],
                threshold=data_source_data_source_details_threshold,
            ),
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            status=data_source_status)
        ```

        ## Import

        DataSources can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CloudGuard/cloudGuardDataSource:CloudGuardDataSource test_data_source "id"
        ```

        :param str resource_name: The name of the resource.
        :param CloudGuardDataSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudGuardDataSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 data_source_details: Optional[pulumi.Input[pulumi.InputType['CloudGuardDataSourceDataSourceDetailsArgs']]] = None,
                 data_source_feed_provider: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudGuardDataSourceArgs.__new__(CloudGuardDataSourceArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["data_source_details"] = data_source_details
            if data_source_feed_provider is None and not opts.urn:
                raise TypeError("Missing required property 'data_source_feed_provider'")
            __props__.__dict__["data_source_feed_provider"] = data_source_feed_provider
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["status"] = status
            __props__.__dict__["data_source_detector_mapping_infos"] = None
            __props__.__dict__["region_status_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(CloudGuardDataSource, __self__).__init__(
            'oci:CloudGuard/cloudGuardDataSource:CloudGuardDataSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            data_source_details: Optional[pulumi.Input[pulumi.InputType['CloudGuardDataSourceDataSourceDetailsArgs']]] = None,
            data_source_detector_mapping_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CloudGuardDataSourceDataSourceDetectorMappingInfoArgs']]]]] = None,
            data_source_feed_provider: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            region_status_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CloudGuardDataSourceRegionStatusDetailArgs']]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'CloudGuardDataSource':
        """
        Get an existing CloudGuardDataSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment OCID of the data source
        :param pulumi.Input[pulumi.InputType['CloudGuardDataSourceDataSourceDetailsArgs']] data_source_details: (Updatable) Details specific to the data source type.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CloudGuardDataSourceDataSourceDetectorMappingInfoArgs']]]] data_source_detector_mapping_infos: Information about the detector recipe and rule attached
        :param pulumi.Input[str] data_source_feed_provider: Type of data source feed provider (LoggingQuery)
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Data source display name
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CloudGuardDataSourceRegionStatusDetailArgs']]]] region_status_details: Information about the region and status of query replication
        :param pulumi.Input[str] state: The current lifecycle state of the resource.
        :param pulumi.Input[str] status: (Updatable) Enablement status of data source.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time the Data source was created. Format defined by RFC3339.
        :param pulumi.Input[str] time_updated: The date and time the data source was updated. Format defined by RFC3339.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudGuardDataSourceState.__new__(_CloudGuardDataSourceState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["data_source_details"] = data_source_details
        __props__.__dict__["data_source_detector_mapping_infos"] = data_source_detector_mapping_infos
        __props__.__dict__["data_source_feed_provider"] = data_source_feed_provider
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["region_status_details"] = region_status_details
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return CloudGuardDataSource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Compartment OCID of the data source
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dataSourceDetails")
    def data_source_details(self) -> pulumi.Output['outputs.CloudGuardDataSourceDataSourceDetails']:
        """
        (Updatable) Details specific to the data source type.
        """
        return pulumi.get(self, "data_source_details")

    @property
    @pulumi.getter(name="dataSourceDetectorMappingInfos")
    def data_source_detector_mapping_infos(self) -> pulumi.Output[Sequence['outputs.CloudGuardDataSourceDataSourceDetectorMappingInfo']]:
        """
        Information about the detector recipe and rule attached
        """
        return pulumi.get(self, "data_source_detector_mapping_infos")

    @property
    @pulumi.getter(name="dataSourceFeedProvider")
    def data_source_feed_provider(self) -> pulumi.Output[str]:
        """
        Type of data source feed provider (LoggingQuery)
        """
        return pulumi.get(self, "data_source_feed_provider")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Data source display name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`

        Avoid entering confidential information.
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="regionStatusDetails")
    def region_status_details(self) -> pulumi.Output[Sequence['outputs.CloudGuardDataSourceRegionStatusDetail']]:
        """
        Information about the region and status of query replication
        """
        return pulumi.get(self, "region_status_details")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        (Updatable) Enablement status of data source.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the Data source was created. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the data source was updated. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

