# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDataMaskRulesResult',
    'AwaitableGetDataMaskRulesResult',
    'get_data_mask_rules',
    'get_data_mask_rules_output',
]

@pulumi.output_type
class GetDataMaskRulesResult:
    """
    A collection of values returned by getDataMaskRules.
    """
    def __init__(__self__, access_level=None, compartment_id=None, data_mask_rule_collections=None, data_mask_rule_status=None, display_name=None, filters=None, iam_group_id=None, id=None, state=None, target_id=None, target_type=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if data_mask_rule_collections and not isinstance(data_mask_rule_collections, list):
            raise TypeError("Expected argument 'data_mask_rule_collections' to be a list")
        pulumi.set(__self__, "data_mask_rule_collections", data_mask_rule_collections)
        if data_mask_rule_status and not isinstance(data_mask_rule_status, str):
            raise TypeError("Expected argument 'data_mask_rule_status' to be a str")
        pulumi.set(__self__, "data_mask_rule_status", data_mask_rule_status)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if iam_group_id and not isinstance(iam_group_id, str):
            raise TypeError("Expected argument 'iam_group_id' to be a str")
        pulumi.set(__self__, "iam_group_id", iam_group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if target_type and not isinstance(target_type, str):
            raise TypeError("Expected argument 'target_type' to be a str")
        pulumi.set(__self__, "target_type", target_type)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment OCID where the resource is created
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dataMaskRuleCollections")
    def data_mask_rule_collections(self) -> Sequence['outputs.GetDataMaskRulesDataMaskRuleCollectionResult']:
        """
        The list of data_mask_rule_collection.
        """
        return pulumi.get(self, "data_mask_rule_collections")

    @property
    @pulumi.getter(name="dataMaskRuleStatus")
    def data_mask_rule_status(self) -> Optional[str]:
        """
        The current status of the data mask rule
        """
        return pulumi.get(self, "data_mask_rule_status")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Data mask rule display name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDataMaskRulesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="iamGroupId")
    def iam_group_id(self) -> Optional[str]:
        """
        IAM Group ID associated with the data mask rule
        """
        return pulumi.get(self, "iam_group_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current lifecycle state of the data mask rule
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[str]:
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[str]:
        return pulumi.get(self, "target_type")


class AwaitableGetDataMaskRulesResult(GetDataMaskRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataMaskRulesResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            data_mask_rule_collections=self.data_mask_rule_collections,
            data_mask_rule_status=self.data_mask_rule_status,
            display_name=self.display_name,
            filters=self.filters,
            iam_group_id=self.iam_group_id,
            id=self.id,
            state=self.state,
            target_id=self.target_id,
            target_type=self.target_type)


def get_data_mask_rules(access_level: Optional[str] = None,
                        compartment_id: Optional[str] = None,
                        data_mask_rule_status: Optional[str] = None,
                        display_name: Optional[str] = None,
                        filters: Optional[Sequence[pulumi.InputType['GetDataMaskRulesFilterArgs']]] = None,
                        iam_group_id: Optional[str] = None,
                        state: Optional[str] = None,
                        target_id: Optional[str] = None,
                        target_type: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataMaskRulesResult:
    """
    This data source provides the list of Data Mask Rules in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list of all DataMaskRule resources in the specified compartmentId (OCID) and its subcompartments.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_mask_rules = oci.CloudGuard.get_data_mask_rules(compartment_id=compartment_id,
        access_level=data_mask_rule_access_level,
        data_mask_rule_status=data_mask_rule_data_mask_rule_status,
        display_name=data_mask_rule_display_name,
        iam_group_id=test_group["id"],
        state=data_mask_rule_state,
        target_id=test_target["id"],
        target_type=data_mask_rule_target_type)
    ```


    :param str access_level: Valid values are `RESTRICTED` and `ACCESSIBLE`. Default is `RESTRICTED`. Setting this to `ACCESSIBLE` returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to `RESTRICTED` permissions are checked and no partial results are displayed.
    :param str compartment_id: The OCID of the compartment in which to list resources.
    :param str data_mask_rule_status: The status of the data mask rule
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str iam_group_id: OCID of the IAM group
    :param str state: The field lifecycle state. Only one state can be provided. Default value for state is active. If no value is specified state is active.
    :param str target_id: OCID of the target
    :param str target_type: Type of target
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['dataMaskRuleStatus'] = data_mask_rule_status
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['iamGroupId'] = iam_group_id
    __args__['state'] = state
    __args__['targetId'] = target_id
    __args__['targetType'] = target_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudGuard/getDataMaskRules:getDataMaskRules', __args__, opts=opts, typ=GetDataMaskRulesResult).value

    return AwaitableGetDataMaskRulesResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        data_mask_rule_collections=pulumi.get(__ret__, 'data_mask_rule_collections'),
        data_mask_rule_status=pulumi.get(__ret__, 'data_mask_rule_status'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        iam_group_id=pulumi.get(__ret__, 'iam_group_id'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        target_id=pulumi.get(__ret__, 'target_id'),
        target_type=pulumi.get(__ret__, 'target_type'))


@_utilities.lift_output_func(get_data_mask_rules)
def get_data_mask_rules_output(access_level: Optional[pulumi.Input[Optional[str]]] = None,
                               compartment_id: Optional[pulumi.Input[str]] = None,
                               data_mask_rule_status: Optional[pulumi.Input[Optional[str]]] = None,
                               display_name: Optional[pulumi.Input[Optional[str]]] = None,
                               filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetDataMaskRulesFilterArgs']]]]] = None,
                               iam_group_id: Optional[pulumi.Input[Optional[str]]] = None,
                               state: Optional[pulumi.Input[Optional[str]]] = None,
                               target_id: Optional[pulumi.Input[Optional[str]]] = None,
                               target_type: Optional[pulumi.Input[Optional[str]]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDataMaskRulesResult]:
    """
    This data source provides the list of Data Mask Rules in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list of all DataMaskRule resources in the specified compartmentId (OCID) and its subcompartments.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_mask_rules = oci.CloudGuard.get_data_mask_rules(compartment_id=compartment_id,
        access_level=data_mask_rule_access_level,
        data_mask_rule_status=data_mask_rule_data_mask_rule_status,
        display_name=data_mask_rule_display_name,
        iam_group_id=test_group["id"],
        state=data_mask_rule_state,
        target_id=test_target["id"],
        target_type=data_mask_rule_target_type)
    ```


    :param str access_level: Valid values are `RESTRICTED` and `ACCESSIBLE`. Default is `RESTRICTED`. Setting this to `ACCESSIBLE` returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to `RESTRICTED` permissions are checked and no partial results are displayed.
    :param str compartment_id: The OCID of the compartment in which to list resources.
    :param str data_mask_rule_status: The status of the data mask rule
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str iam_group_id: OCID of the IAM group
    :param str state: The field lifecycle state. Only one state can be provided. Default value for state is active. If no value is specified state is active.
    :param str target_id: OCID of the target
    :param str target_type: Type of target
    """
    ...
