# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMigrationsResult',
    'AwaitableGetMigrationsResult',
    'get_migrations',
    'get_migrations_output',
]

@pulumi.output_type
class GetMigrationsResult:
    """
    A collection of values returned by getMigrations.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, migration_collections=None, migration_id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if migration_collections and not isinstance(migration_collections, list):
            raise TypeError("Expected argument 'migration_collections' to be a list")
        pulumi.set(__self__, "migration_collections", migration_collections)
        if migration_id and not isinstance(migration_id, str):
            raise TypeError("Expected argument 'migration_id' to be a str")
        pulumi.set(__self__, "migration_id", migration_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Migration Identifier that can be renamed
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMigrationsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="migrationCollections")
    def migration_collections(self) -> Sequence['outputs.GetMigrationsMigrationCollectionResult']:
        """
        The list of migration_collection.
        """
        return pulumi.get(self, "migration_collections")

    @property
    @pulumi.getter(name="migrationId")
    def migration_id(self) -> Optional[str]:
        return pulumi.get(self, "migration_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of migration.
        """
        return pulumi.get(self, "state")


class AwaitableGetMigrationsResult(GetMigrationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMigrationsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            migration_collections=self.migration_collections,
            migration_id=self.migration_id,
            state=self.state)


def get_migrations(compartment_id: Optional[str] = None,
                   display_name: Optional[str] = None,
                   filters: Optional[Sequence[pulumi.InputType['GetMigrationsFilterArgs']]] = None,
                   migration_id: Optional[str] = None,
                   state: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMigrationsResult:
    """
    This data source provides the list of Migrations in Oracle Cloud Infrastructure Cloud Migrations service.

    Returns a list of migrations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_migrations = oci.CloudMigrations.get_migrations(compartment_id=compartment_id,
        display_name=migration_display_name,
        migration_id=test_migration["id"],
        state=migration_state)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire given display name.
    :param str migration_id: Unique migration identifier
    :param str state: A filter to return only resources where the resource's lifecycle state matches the given lifecycle state.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['migrationId'] = migration_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudMigrations/getMigrations:getMigrations', __args__, opts=opts, typ=GetMigrationsResult).value

    return AwaitableGetMigrationsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        migration_collections=pulumi.get(__ret__, 'migration_collections'),
        migration_id=pulumi.get(__ret__, 'migration_id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_migrations)
def get_migrations_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                          display_name: Optional[pulumi.Input[Optional[str]]] = None,
                          filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetMigrationsFilterArgs']]]]] = None,
                          migration_id: Optional[pulumi.Input[Optional[str]]] = None,
                          state: Optional[pulumi.Input[Optional[str]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMigrationsResult]:
    """
    This data source provides the list of Migrations in Oracle Cloud Infrastructure Cloud Migrations service.

    Returns a list of migrations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_migrations = oci.CloudMigrations.get_migrations(compartment_id=compartment_id,
        display_name=migration_display_name,
        migration_id=test_migration["id"],
        state=migration_state)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire given display name.
    :param str migration_id: Unique migration identifier
    :param str state: A filter to return only resources where the resource's lifecycle state matches the given lifecycle state.
    """
    ...
